/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.service;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceNameValue;

public class BemServiceValue {
    private static int noOfRoutes = 0;
    private String originator;
    private Hashtable pseudoToAttributeHash = new Hashtable();
    private Vector services = new Vector();
    private ArrayList deprecationWarnings = new ArrayList();

    public BemServiceValue(String string) {
        this.originator = string;
    }

    public BemServiceValue(BemServiceValue bemServiceValue) {
        Vector vector = bemServiceValue.getAllAttributes();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)enumeration.nextElement();
            this.addAttribute(serviceNameValue);
        }
    }

    public String getOriginator() {
        return this.originator;
    }

    public void addValues(String string, Vector vector) {
        this.addAttributes(string, vector);
    }

    public void addAttributes(String string, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)enumeration.nextElement();
            this.addAttribute(string, serviceNameValue);
        }
    }

    public void addAttribute(String string, ServiceNameValue serviceNameValue) {
        this.pseudoToAttributeHash.put(serviceNameValue.getPseudoName(), serviceNameValue);
        if (!this.services.contains(string)) {
            this.services.add(string);
        }
        if (serviceNameValue.getServiceName() == null) {
            serviceNameValue.setServiceName(string);
        }
    }

    public void addAttribute(ServiceNameValue serviceNameValue) {
        String string = serviceNameValue.getServiceName();
        this.addAttribute(string, serviceNameValue);
    }

    public Vector getValues(String string) {
        Vector<ServiceNameValue> vector = new Vector<ServiceNameValue>();
        Enumeration enumeration = this.pseudoToAttributeHash.elements();
        while (enumeration.hasMoreElements()) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)enumeration.nextElement();
            if (!serviceNameValue.getServiceName().equals(string)) continue;
            vector.add(serviceNameValue);
        }
        return vector;
    }

    public Vector getAllAttributes() {
        Vector<ServiceNameValue> vector = new Vector<ServiceNameValue>();
        Enumeration enumeration = this.pseudoToAttributeHash.elements();
        while (enumeration.hasMoreElements()) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)enumeration.nextElement();
            vector.add(serviceNameValue);
        }
        return vector;
    }

    public ServiceNameValue getAttribute(String string) {
        ServiceNameValue serviceNameValue = this.peekAttribute(string);
        return serviceNameValue;
    }

    public ServiceNameValue peekAttribute(String string) {
        return (ServiceNameValue)this.pseudoToAttributeHash.get(string);
    }

    public ServiceNameValue getAttribute(String string, String string2) {
        String string3 = string + string2;
        return this.getAttribute(string3);
    }

    public Vector getAttributesWithPrefix(String string) {
        Vector<ServiceNameValue> vector = new Vector<ServiceNameValue>();
        Enumeration enumeration = this.pseudoToAttributeHash.elements();
        while (enumeration.hasMoreElements()) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)enumeration.nextElement();
            if (!serviceNameValue.getPrefix().equals(string)) continue;
            vector.add(serviceNameValue);
        }
        return vector;
    }

    public Vector getAttributesStartingWith(String string) {
        Vector<ServiceNameValue> vector = new Vector<ServiceNameValue>();
        Enumeration enumeration = this.pseudoToAttributeHash.elements();
        while (enumeration.hasMoreElements()) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)enumeration.nextElement();
            if (!serviceNameValue.getPrefix().startsWith(string)) continue;
            vector.add(serviceNameValue);
        }
        return vector;
    }

    public String[] getPseudoNames() {
        String[] stringArray = new String[]{};
        stringArray = this.pseudoToAttributeHash.keySet().toArray(stringArray);
        return stringArray;
    }

    public void dump() {
        if (this.pseudoToAttributeHash.size() == 0) {
            System.out.println("serviceValue is empty");
            return;
        }
        for (String string : new TreeSet(this.pseudoToAttributeHash.keySet())) {
            String string2 = this.peekValue(string);
            System.out.println("Pseudoname=" + string + ", Value=" + string2);
        }
    }

    public Vector getAllAttributesWithSimpleName(String string) {
        Vector<ServiceNameValue> vector = new Vector<ServiceNameValue>();
        Enumeration enumeration = this.pseudoToAttributeHash.elements();
        while (enumeration.hasMoreElements()) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)enumeration.nextElement();
            if (!serviceNameValue.getSimpleName().equals(string)) continue;
            vector.add(serviceNameValue);
        }
        return vector;
    }

    public static int getNoOfRoutes() {
        return noOfRoutes;
    }

    public static void setNoOfRoutes(int n) {
        noOfRoutes = n;
    }

    public Enumeration getAllServices() {
        return this.services.elements();
    }

    public String getNameValueReport() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = this.getAllAttributes();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)enumeration.nextElement();
            stringBuffer.append(serviceNameValue.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public String getValue(String string) {
        ServiceNameValue serviceNameValue = this.getAttribute(string);
        if (serviceNameValue != null) {
            return serviceNameValue.getValueAsString();
        }
        return null;
    }

    public String peekValue(String string) {
        ServiceNameValue serviceNameValue = this.peekAttribute(string);
        if (serviceNameValue != null) {
            return serviceNameValue.getValueAsString();
        }
        return null;
    }

    public Vector getPrefixsForService(String string) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.pseudoToAttributeHash.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            ServiceNameValue serviceNameValue = (ServiceNameValue)enumeration.nextElement();
            if (!serviceNameValue.getServiceName().equals(string) || vector.contains(string2 = serviceNameValue.getPrefix())) continue;
            vector.add(string2);
        }
        return vector;
    }

    public void addDeprecationWarning(Integer n, String string) {
        this.deprecationWarnings.add("Line " + n + ": " + string);
    }

    public boolean hasDeprecationWarnings() {
        return this.deprecationWarnings.size() > 0;
    }

    public String getDeprecationReport() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.deprecationWarnings.size(); ++i) {
            String string = (String)this.deprecationWarnings.get(i);
            stringBuffer.append(string).append("\n\n");
        }
        return stringBuffer.toString();
    }
}

