/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.trace;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Properties;
import se.ericsson.wcdma.rbs.bem.common.trace.PropertyListener;
import se.ericsson.wcdma.rbs.bem.common.trace.PropertySource;

public class BEMTrace
implements PropertyListener {
    public static boolean ENABLED = false;
    public static final String ACTIVATE = "Trace.activate";
    public static final String LOGFILE = "Trace.logfile";
    public static final String JVM_ACTIVATE = "Trace.jvmActivate";
    public static final String JVM_LOGFILE = "Trace.jvmLogfile";
    public static final String FULL_CLASS_NAME = "Trace.fullClassName";
    public static final String ENTER = "ENTER";
    public static final String CALL = "CALL";
    public static final String MSG = "MSG";
    public static final String ITEM = "ITEM";
    public static final String EXIT = "EXIT";
    public static final String EXCEPTION = "EXCEPTION";
    protected static BEMTrace theTrace;
    protected StringBuffer msgBuf = new StringBuffer();
    protected PrintWriter outWriter = new PrintWriter(System.err, true);
    protected boolean fullClassName = false;

    protected BEMTrace() {
    }

    public void setJVMEnabled(boolean bl) {
        Runtime.getRuntime().traceMethodCalls(bl);
    }

    public void push(String string, PropertySource propertySource) {
        if (string.equals(ACTIVATE)) {
            String string2 = propertySource.getProperty(string);
            boolean bl = Boolean.valueOf(string2);
            BEMTrace.setEnabled(bl);
        } else if (string.equals(LOGFILE)) {
            String string3 = propertySource.getProperty(string);
            this.setLogfile(string3);
        } else if (string.equals(JVM_ACTIVATE)) {
            String string4 = propertySource.getProperty(string);
            boolean bl = Boolean.valueOf(string4);
            Runtime.getRuntime().traceMethodCalls(bl);
        } else if (string.equals(JVM_LOGFILE)) {
            String string5 = propertySource.getProperty(string);
            this.setJVMLogfile(string5);
        } else if (string.equals(FULL_CLASS_NAME)) {
            String string6 = propertySource.getProperty(string);
            Boolean.valueOf(string6).booleanValue();
        }
    }

    public void push(Enumeration enumeration, PropertySource propertySource) {
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.push(string, propertySource);
        }
    }

    public void addPropertySource(PropertySource propertySource) {
        Enumeration enumeration = propertySource.getPropertyNames();
        this.push(enumeration, propertySource);
        propertySource.addPropertyListener(this, ACTIVATE);
        propertySource.addPropertyListener(this, LOGFILE);
        propertySource.addPropertyListener(this, JVM_LOGFILE);
    }

    protected void finalize() {
        if (this.outWriter != null) {
            this.outWriter.flush();
            this.outWriter.close();
            this.outWriter = null;
        }
    }

    public static BEMTrace getInstance() {
        if (theTrace == null) {
            theTrace = new BEMTrace();
        }
        return theTrace;
    }

    public static void init(Properties properties) {
        BEMTrace bEMTrace = BEMTrace.getInstance();
        bEMTrace.set(properties);
    }

    public static void set(BEMTrace bEMTrace) {
        theTrace = bEMTrace;
    }

    public static void setEnabled(boolean bl) {
        ENABLED = bl;
    }

    public static void enter(Class clazz, String string) {
        if (ENABLED) {
            String string2 = clazz.getName();
            BEMTrace.getInstance().traceEnter(string2, string);
        }
    }

    public static void enter(Class clazz, String string, Object object) {
        if (ENABLED) {
            String string2 = clazz.getName();
            BEMTrace.getInstance().traceEnter(string2, string, object);
        }
    }

    public static void enter(Class clazz, String string, Object object, Object object2) {
        if (ENABLED) {
            String string2 = clazz.getName();
            Object[] objectArray = new Object[]{object, object2};
            BEMTrace.getInstance().traceEnter(string2, string, objectArray);
        }
    }

    public static void enter(Class clazz, String string, Object object, Object object2, Object object3) {
        if (ENABLED) {
            String string2 = clazz.getName();
            Object[] objectArray = new Object[]{object, object2, object3};
            BEMTrace.getInstance().traceEnter(string2, string, objectArray);
        }
    }

    public static void enter(Class clazz, String string, Object object, Object object2, Object object3, Object object4) {
        if (ENABLED) {
            String string2 = clazz.getName();
            Object[] objectArray = new Object[]{object, object2, object3, object4};
            BEMTrace.getInstance().traceEnter(string2, string, objectArray);
        }
    }

    public static void enter(Class clazz, String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        if (ENABLED) {
            String string2 = clazz.getName();
            Object[] objectArray = new Object[]{object, object2, object3, object4, object5};
            BEMTrace.getInstance().traceEnter(string2, string, objectArray);
        }
    }

    public static void enter(Class clazz, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        if (ENABLED) {
            String string2 = clazz.getName();
            Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6};
            BEMTrace.getInstance().traceEnter(string2, string, objectArray);
        }
    }

    public static void enter(Class clazz, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        if (ENABLED) {
            String string2 = clazz.getName();
            Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7};
            BEMTrace.getInstance().traceEnter(string2, string, objectArray);
        }
    }

    public static void enter(Class clazz, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        if (ENABLED) {
            String string2 = clazz.getName();
            Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7, object8};
            BEMTrace.getInstance().traceEnter(string2, string, objectArray);
        }
    }

    public static void enter(Class clazz, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        if (ENABLED) {
            String string2 = clazz.getName();
            Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7, object8, object9};
            BEMTrace.getInstance().traceEnter(string2, string, objectArray);
        }
    }

    public static void enter(Class clazz, String string, Object[] objectArray) {
        if (ENABLED) {
            String string2 = clazz.getName();
            BEMTrace.getInstance().traceEnter(string2, string, objectArray);
        }
    }

    public static void call(Class clazz, String string, String string2) {
        if (ENABLED) {
            String string3 = clazz.getName();
            BEMTrace.getInstance().traceCall(string3, string, string2);
        }
    }

    public static void call(Class clazz, String string, String string2, Object object) {
        if (ENABLED) {
            String string3 = clazz.getName();
            BEMTrace.getInstance().traceCall(string3, string, string2, object);
        }
    }

    public static void call(Class clazz, String string, String string2, Object object, Object object2) {
        if (ENABLED) {
            String string3 = clazz.getName();
            Object[] objectArray = new Object[]{object, object2};
            BEMTrace.getInstance().traceCall(string3, string, string2, objectArray);
        }
    }

    public static void call(Class clazz, String string, String string2, Object object, Object object2, Object object3) {
        if (ENABLED) {
            String string3 = clazz.getName();
            Object[] objectArray = new Object[]{object, object2, object3};
            BEMTrace.getInstance().traceCall(string3, string, string2, objectArray);
        }
    }

    public static void call(Class clazz, String string, String string2, Object object, Object object2, Object object3, Object object4) {
        if (ENABLED) {
            String string3 = clazz.getName();
            Object[] objectArray = new Object[]{object, object2, object3, object4};
            BEMTrace.getInstance().traceCall(string3, string, string2, objectArray);
        }
    }

    public static void call(Class clazz, String string, String string2, Object object, Object object2, Object object3, Object object4, Object object5) {
        if (ENABLED) {
            String string3 = clazz.getName();
            Object[] objectArray = new Object[]{object, object2, object3, object4, object5};
            BEMTrace.getInstance().traceCall(string3, string, string2, objectArray);
        }
    }

    public static void call(Class clazz, String string, String string2, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        if (ENABLED) {
            String string3 = clazz.getName();
            Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6};
            BEMTrace.getInstance().traceCall(string3, string, string2, objectArray);
        }
    }

    public static void call(Class clazz, String string, String string2, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        if (ENABLED) {
            String string3 = clazz.getName();
            Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7};
            BEMTrace.getInstance().traceCall(string3, string, string2, objectArray);
        }
    }

    public static void call(Class clazz, String string, String string2, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        if (ENABLED) {
            String string3 = clazz.getName();
            Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7, object8};
            BEMTrace.getInstance().traceCall(string3, string, string2, objectArray);
        }
    }

    public static void call(Class clazz, String string, String string2, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        if (ENABLED) {
            String string3 = clazz.getName();
            Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7, object8, object9};
            BEMTrace.getInstance().traceCall(string3, string, string2, objectArray);
        }
    }

    public static void call(Class clazz, String string, String string2, Object[] objectArray) {
        if (ENABLED) {
            String string3 = clazz.getName();
            BEMTrace.getInstance().traceCall(string3, string, string2, objectArray);
        }
    }

    public static void msg(Class clazz, String string, String string2) {
        if (ENABLED) {
            String string3 = clazz.getName();
            BEMTrace.getInstance().traceMsg(string3, string, string2);
        }
    }

    public static void item(Class clazz, String string, String string2, Object object) {
        if (ENABLED) {
            String string3 = clazz.getName();
            BEMTrace.getInstance().traceItem(string3, string, string2, object);
        }
    }

    public static void exception(Class clazz, String string, Exception exception) {
        if (ENABLED) {
            String string2 = clazz.getName();
            BEMTrace.getInstance().traceException(string2, string, exception);
        }
    }

    public static void exit(Class clazz, String string) {
        if (ENABLED) {
            String string2 = clazz.getName();
            BEMTrace.getInstance().traceExit(string2, string);
        }
    }

    public static void exit(Class clazz, String string, Object object) {
        if (ENABLED) {
            String string2 = clazz.getName();
            BEMTrace.getInstance().traceExit(string2, string, object);
        }
    }

    protected void traceEnter(String string, String string2) {
        String string3 = this.formatEnter(string, string2);
        this.write(string3);
    }

    protected void traceEnter(String string, String string2, Object object) {
        String string3 = this.formatEnter(string, string2, object);
        this.write(string3);
    }

    protected void traceEnter(String string, String string2, Object[] objectArray) {
        String string3 = this.formatEnter(string, string2, objectArray);
        this.write(string3);
    }

    protected void traceCall(String string, String string2, String string3) {
        String string4 = this.formatCall(string, string2, string3);
        this.write(string4);
    }

    protected void traceCall(String string, String string2, String string3, Object object) {
        String string4 = this.formatCall(string, string2, string3, object);
        this.write(string4);
    }

    protected void traceCall(String string, String string2, String string3, Object[] objectArray) {
        String string4 = this.formatCall(string, string2, string3, objectArray);
        this.write(string4);
    }

    protected void traceMsg(String string, String string2, String string3) {
        String string4 = this.formatMsg(string, string2, string3);
        this.write(string4);
    }

    protected void traceItem(String string, String string2, String string3, Object object) {
        String string4 = this.formatItem(string, string2, string3, object);
        this.write(string4);
    }

    protected void traceException(String string, String string2, Exception exception) {
        String string3 = this.formatException(string, string2, exception);
        this.write(string3);
    }

    protected void traceExit(String string, String string2) {
        String string3 = this.formatExit(string, string2);
        this.write(string3);
    }

    protected void traceExit(String string, String string2, Object object) {
        String string3 = this.formatExit(string, string2, object);
        this.write(string3);
    }

    protected String formatEnter(String string, String string2) {
        StringBuffer stringBuffer = this.formatContext(string, string2, ENTER);
        String string3 = stringBuffer.toString();
        return string3;
    }

    protected String formatEnter(String string, String string2, Object object) {
        StringBuffer stringBuffer = this.formatContext(string, string2, ENTER);
        this.formatParameter(stringBuffer, object);
        String string3 = stringBuffer.toString();
        return string3;
    }

    protected String formatEnter(String string, String string2, Object[] objectArray) {
        StringBuffer stringBuffer = this.formatContext(string, string2, ENTER);
        this.formatParameters(stringBuffer, objectArray);
        String string3 = stringBuffer.toString();
        return string3;
    }

    protected String formatCall(String string, String string2, String string3) {
        StringBuffer stringBuffer = this.formatContext(string, string2, CALL);
        this.formatMethod(stringBuffer, string3);
        String string4 = stringBuffer.toString();
        return string4;
    }

    protected String formatCall(String string, String string2, String string3, Object object) {
        StringBuffer stringBuffer = this.formatContext(string, string2, CALL);
        this.formatMethod(stringBuffer, string3);
        this.formatParameter(stringBuffer, object);
        String string4 = stringBuffer.toString();
        return string4;
    }

    protected String formatCall(String string, String string2, String string3, Object[] objectArray) {
        StringBuffer stringBuffer = this.formatContext(string, string2, CALL);
        this.formatMethod(stringBuffer, string3);
        this.formatParameters(stringBuffer, objectArray);
        String string4 = stringBuffer.toString();
        return string4;
    }

    protected String formatMsg(String string, String string2, String string3) {
        StringBuffer stringBuffer = this.formatContext(string, string2, MSG);
        stringBuffer.append(string3);
        String string4 = stringBuffer.toString();
        return string4;
    }

    protected String formatItem(String string, String string2, String string3, Object object) {
        StringBuffer stringBuffer = this.formatContext(string, string2, ITEM);
        stringBuffer.append(string3);
        stringBuffer.append(" = ");
        this.formatValue(stringBuffer, object);
        String string4 = stringBuffer.toString();
        return string4;
    }

    protected String formatException(String string, String string2, Exception exception) {
        StringBuffer stringBuffer = this.formatContext(string, string2, EXCEPTION);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        String string3 = exception.toString();
        stringBuffer.append(string3);
        stringBuffer.append("\nstack trace = ");
        String string4 = stringWriter.toString();
        stringBuffer.append(string4);
        String string5 = stringBuffer.toString();
        return string5;
    }

    protected String formatExit(String string, String string2) {
        StringBuffer stringBuffer = this.formatContext(string, string2, EXIT);
        String string3 = stringBuffer.toString();
        return string3;
    }

    protected String formatExit(String string, String string2, Object object) {
        StringBuffer stringBuffer = this.formatContext(string, string2, EXIT);
        this.formatValue(stringBuffer, object);
        String string3 = stringBuffer.toString();
        return string3;
    }

    protected StringBuffer formatContext(String string, String string2, String string3) {
        String string4 = Thread.currentThread().getName();
        StringBuffer stringBuffer = new StringBuffer(string4);
        stringBuffer.append(" - ");
        this.formatClass(stringBuffer, string);
        stringBuffer.append(": ");
        this.formatMethod(stringBuffer, string2);
        stringBuffer.append(string3);
        stringBuffer.append(" - ");
        return stringBuffer;
    }

    protected void formatClass(StringBuffer stringBuffer, String string) {
        if (!this.fullClassName) {
            int n = string.lastIndexOf(46);
            n = string.lastIndexOf(46, n - 1) + 1;
            string = string.substring(n);
        }
        stringBuffer.append(string);
    }

    protected void formatMethod(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string);
        stringBuffer.append(": ");
    }

    protected void formatParameter(StringBuffer stringBuffer, Object object) {
        stringBuffer.append('(');
        this.formatValue(stringBuffer, object);
        stringBuffer.append(')');
    }

    protected void formatParameters(StringBuffer stringBuffer, Object[] objectArray) {
        stringBuffer.append('(');
        if (objectArray.length > 0) {
            this.formatValue(stringBuffer, objectArray[0]);
        }
        for (int i = 1; i < objectArray.length; ++i) {
            stringBuffer.append(", ");
            this.formatValue(stringBuffer, objectArray[i]);
        }
        stringBuffer.append(')');
    }

    protected void formatValue(StringBuffer stringBuffer, Object object) {
        if (object == null) {
            stringBuffer.append("null");
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            stringBuffer.append("[");
            if (nArray.length > 0) {
                stringBuffer.append(String.valueOf(nArray[0]));
            }
            for (int i = 1; i < nArray.length; ++i) {
                stringBuffer.append(';');
                stringBuffer.append(String.valueOf(nArray[i]));
            }
            stringBuffer.append("]");
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            stringBuffer.append("[");
            if (fArray.length > 0) {
                stringBuffer.append(String.valueOf(fArray[0]));
            }
            for (int i = 1; i < fArray.length; ++i) {
                stringBuffer.append(';');
                stringBuffer.append(String.valueOf(fArray[i]));
            }
            stringBuffer.append("]");
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            stringBuffer.append("[");
            if (objectArray.length > 0) {
                this.formatValue(stringBuffer, objectArray[0]);
            }
            for (int i = 1; i < objectArray.length; ++i) {
                stringBuffer.append(';');
                this.formatValue(stringBuffer, objectArray[i]);
            }
            stringBuffer.append("]");
        } else {
            stringBuffer.append(object.toString());
        }
    }

    protected void set(Properties properties) {
        String string;
        String string2 = properties.getProperty(ACTIVATE);
        boolean bl = Boolean.valueOf(string2);
        BEMTrace.setEnabled(bl);
        String string3 = properties.getProperty(LOGFILE);
        if (string3 != null) {
            this.setLogfile(string3);
        }
        if ((string = properties.getProperty(JVM_LOGFILE)) != null) {
            this.setJVMLogfile(string);
        }
        String string4 = properties.getProperty(JVM_ACTIVATE);
        boolean bl2 = Boolean.valueOf(string4);
        this.setJVMEnabled(bl2);
    }

    protected void setLogfile(String string) {
        try {
            if (this.outWriter != null) {
                this.outWriter.flush();
                this.outWriter.close();
            }
            this.backupFile(string);
            FileWriter fileWriter = new FileWriter(string);
            this.outWriter = new PrintWriter((Writer)fileWriter, true);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
        }
    }

    protected void setJVMLogfile(String string) {
        try {
            this.backupFile(string);
            System.out.flush();
            System.out.close();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream, true);
            System.setOut(printStream);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
        }
    }

    protected void backupFile(String string) throws Exception {
        File file = new File(string);
        if (file.exists()) {
            String string2 = file.getName() + "-" + file.lastModified();
            File file2 = new File(string2);
            file.renameTo(file2);
        }
    }

    protected void write(String string) {
        this.outWriter.println(string);
    }
}

