/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.help;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import se.ericsson.cello.emt.helpservice.AlexInitializer;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.NameValueFactory;
import se.ericsson.cello.neal.cm.OfflineCmUtil;
import se.ericsson.wcdma.rbs.bem.common.util.GitHelper;
import se.ericsson.wcdma.support.gui.guilib.infra.BrowserHelp;

public class RbsBrowserHelp
extends BrowserHelp
implements AlexInitializer {
    static final NameValueFactory nvf = OfflineCmUtil.getNameValueFactory();
    private static final String BROWSER_HELP_MAPPING_PATH = "/resources/help/BrowserHelpMapping_ext.properties";
    private static final String ALEX_BOOK_SUFFIX = "_ALEX_BOOK";
    private static final String NODE_PRODUCT_NAMES = "NODE_PRODUCT_NAMES";
    private static final String DEFAULT_NODE = "RBS3202";
    private static final String MANAGED_ELEMENT_DATA_DOC_LIB_SETTABLE = "docLibSystemSettable";
    private Properties prop = null;
    private Mo managedElementMo;
    private Mo managedElementDataMo;
    private static final String LOGGER_NAME_BEMHELP = "se.ericsson.wcdma.rbs.bem.help";
    private static final Logger logger = Logger.getLogger("se.ericsson.wcdma.rbs.bem.help");

    public RbsBrowserHelp() {
        LogManager.getLogManager().addLogger(logger);
    }

    public void initAlex(Mo mo, Mo mo2) {
        logger.entering(this.getClass().getName(), "initAlex");
        this.managedElementMo = mo;
        this.managedElementDataMo = mo2;
        this.fixDocumentServer();
        this.setDocLibSystemLibrary();
    }

    private void fixDocumentServer() {
        logger.entering(this.getClass().getName(), "initAlex");
        NameValue nameValue = this.managedElementDataMo.getAttribute("documentServerAddress", null);
        String string = (String)nameValue.getValue();
        if (!string.equals("")) {
            String string2 = string;
            if (!string.endsWith("alexserv")) {
                if (!string.endsWith("/")) {
                    string2 = string2 + "/";
                }
                string2 = string2 + "alexserv";
                logger.info("RbsBrowserHelp.fixDocumentServer() " + string2);
                nameValue = nvf.create("documentServerAddress", string2);
                this.managedElementDataMo.setAttribute(nameValue, null);
            }
        }
    }

    private void setDocLibSystemLibrary() {
        String string;
        if (this.managedElementMo != null && !(string = this.getDocLibSystemSettable()).equals("")) {
            logger.info("RbsBrowserHelp.setDocLibSystemLibrary() alexBook = " + string);
            NameValue nameValue = nvf.create(MANAGED_ELEMENT_DATA_DOC_LIB_SETTABLE, string);
            this.managedElementDataMo.setAttribute(nameValue, null);
        }
    }

    private String getDocLibSystemSettable() {
        String string = null;
        this.loadProperties();
        if (this.prop != null) {
            String string2 = this.getProductName();
            if (string2 != null) {
                String string3 = string2 + ALEX_BOOK_SUFFIX;
                string = this.prop.getProperty(string3);
            }
            if (string == null) {
                string = this.getDefaultAlexBook(this.prop);
            }
        }
        if (string == null) {
            string = "";
        }
        logger.info("getAlexBook() alexBook = " + string);
        return string;
    }

    private String getProductName() {
        String string = null;
        try {
            NameValue nameValue = this.managedElementMo.getAttribute("productName", null);
            String string2 = (String)nameValue.getValue();
            if (string2 != null) {
                string = this.getTrimedStr(string2);
            }
        }
        catch (Exception exception) {
            System.out.println(this.getClass().getName() + ", Could not get product name\n" + exception.getMessage());
        }
        return string;
    }

    private String getDefaultAlexBook(Properties properties) {
        String string;
        String string2 = "RBS3202_ALEX_BOOK";
        String string3 = properties.getProperty(string2);
        if (string3 == null && (string = properties.getProperty(NODE_PRODUCT_NAMES)) != null) {
            String string4;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens() && (string3 = properties.getProperty(string2 = (string4 = stringTokenizer.nextToken()) + ALEX_BOOK_SUFFIX)) == null) {
            }
        }
        if (string3 == null) {
            string3 = "";
        }
        logger.info("getDefaultAlexBook() alexBook = " + string3);
        return string3;
    }

    private String getTrimedStr(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " ");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    public String convertTitle(String string) {
        this.loadProperties();
        String string2 = string;
        int n = string.indexOf("_");
        if (n != -1) {
            String string3 = null;
            if (this.prop != null) {
                string3 = this.prop.getProperty(string);
            }
            string2 = string3 != null ? string3 : string.substring(n + 1);
        }
        return string2;
    }

    private void loadProperties() {
        if (this.prop == null) {
            InputStream inputStream = this.getBrowserHelpMappingInputStream();
            try {
                if (inputStream != null) {
                    this.prop = new Properties();
                    this.prop.load(inputStream);
                }
            }
            catch (IOException iOException) {
                System.out.println(this.getClass().getName() + ": Could not get browser help mapping properties\n" + iOException.getMessage());
            }
        }
    }

    private InputStream getBrowserHelpMappingInputStream() {
        InputStream inputStream = null;
        try {
            inputStream = RbsBrowserHelp.class.getResourceAsStream(BROWSER_HELP_MAPPING_PATH);
        }
        catch (Exception exception) {
            System.out.println(this.getClass().getName() + ", Exception when reading browser help mapping file with the classloader: " + BROWSER_HELP_MAPPING_PATH + "\n" + exception.getMessage());
            inputStream = null;
        }
        if (inputStream == null) {
            String string = GitHelper.getGitPath() + "rbs/sw/bsmss_1/bem/bemclientmisc/bemhlp/src";
            System.out.println(this.getClass().getName() + "Classloader could not load the browser help mapping file. Attempting to read from VOB instead: " + string + BROWSER_HELP_MAPPING_PATH);
            File file = null;
            try {
                file = new File(string + BROWSER_HELP_MAPPING_PATH);
                inputStream = new FileInputStream(file);
            }
            catch (IOException iOException) {
                System.out.println(this.getClass().getName() + ", Could not read the browser help mapping file from the VOB location\n" + iOException.getMessage());
            }
        }
        return inputStream;
    }
}

