/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.control;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.configurationversion.ConfigurationVersionCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.ViewRefresh;
import se.ericsson.wcdma.rbs.bem.common.log.BemLogAndScriptUtil;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.control.EmasWorkarounder;
import se.ericsson.wcdma.rbs.bem.wizard.control.ReconnectingPostProgressDlgController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.AbstractWizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardCommon;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardHelper;

public abstract class AbstractFlexFinishController
extends BemWizardGuiController
implements EmasWorkarounder {
    private final AbstractWizardCIModel model;
    private final Rbs rbs;
    private WizardCIModel flexModel = null;

    protected AbstractFlexFinishController(AbstractWizardCIModel abstractWizardCIModel, WizardHelper wizardHelper) {
        this.model = abstractWizardCIModel;
        this.rbs = abstractWizardCIModel.getRbs();
        this.wizardHelp = wizardHelper;
    }

    protected void init() {
        this.setWindowTitle();
    }

    protected void afterVisible() {
        boolean bl = this.flexModel.getUseFileInput();
        boolean bl2 = this.flexModel.getUseWizard();
        if (bl && !bl2) {
            super.setPreviousEnabled(false);
        }
    }

    protected abstract void setWindowTitle();

    protected boolean finish() {
        this.setFinishEnabled(false);
        this.setPreviousEnabled(false);
        ViewRefresh.setViewRefreshEnabled(false);
        return false;
    }

    public void reportInstallerComplete(StringBuffer stringBuffer) {
        this.getApplication().stopApplicationNoCheck();
    }

    public void reportInstallerError(WizardException wizardException) {
        this.setFinishEnabled(true);
        this.setCancelEnabled(true);
        this.rollbackToCancelCv(true);
        this.getApplication().stopApplicationNoCheck();
    }

    public void reportInstallerCancelled() {
        this.setFinishEnabled(true);
        this.setCancelEnabled(true);
        this.rollbackToCancelCv(false);
        this.getApplication().stopApplicationNoCheck();
    }

    protected boolean checkSyntax() {
        return true;
    }

    protected boolean updateModel() {
        return true;
    }

    protected void confirmNodeRestart() {
        try {
            boolean bl = this.displayConfirmDialog("\n It is needed to restart the RBS in order to activate the IP\n configuration or changing to/from STM-1/OC3. The connection to the RBS will then be lost.\n\n Do you want to make an automatic restart at the end of the configuration?");
            if (bl) {
                this.rbs.setCustomerParameter("nodeRestart", "YES");
            } else {
                this.displayWarningMessage(" The IP configuration will be activated\n next time the node is restarted.");
                this.rbs.setCustomerParameter("nodeRestart", "NO");
            }
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException("AbstractFlexFinishController", "finish()", null, "Performing finish action", exception);
            this.displayError(wizardException);
        }
    }

    protected void rollbackToCancelCv(boolean bl) {
        try {
            ConfigurationVersionCI configurationVersionCI = (ConfigurationVersionCI)this.rbs.getConfigItem("Configuration Version CI");
            configurationVersionCI.setRollBackCvAsStartable();
            this.restartNode(bl);
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException("AbstractFlexFinishController", "finish()", null, "Performing finish action", exception);
            this.displayError(wizardException);
        }
    }

    protected void restartNode(boolean bl) {
        try {
            MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
            boolean bl2 = true;
            if (bl) {
                bl2 = this.displayConfirmDialog("\n The node is in an un-defined state. It is needed to perform a rollback.\n The rollback requires that the node is restarted. The Element Manager will\n be closed at node restart\n\n Do you want to perform the rollback?");
            } else {
                this.displayWarningMessage("\n The node is in an un-defined state. It is needed to perform a rollback.\n The rollback requires that the node is restarted. The Element Manager will\n be closed at node restart");
            }
            if (bl2) {
                BemMo bemMo = moHandlerImpl.getMo(WizardCommon.WIZARD_LDN_MANAGEDELEMENT);
                NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("restartRank", 1), Nal.getFactory().getNameValue("restartReason", 3), Nal.getFactory().getNameValue("restartInfo", this.getWizardName() + " configuration failed rollback to previous configuration")};
                moHandlerImpl.action(bemMo, "manualRestart", nalNameValueArray);
                System.exit(0);
            }
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException("AbstractFlexFinishController", "finish()", null, "Performing finish action", exception);
            this.displayError(wizardException);
        }
    }

    protected abstract String getWizardName();

    protected void setFlexModel(WizardCIModel wizardCIModel) {
        this.flexModel = wizardCIModel;
    }

    protected WizardCIModel getFlexModel() {
        return this.flexModel;
    }

    protected boolean finishReconnecting(String string, String string2, Class clazz, Class clazz2) {
        try {
            boolean bl = this.checkIpConfiguration();
            this.informSectorPosChange();
            if (bl) {
                BemLogAndScriptUtil.getInstance().logStartConfigurationProcedure(string);
                this.startDialog(false, string2, null, clazz, clazz2);
                this.setCancelEnabled(false);
            } else {
                this.setFinishEnabled(true);
                this.setPreviousEnabled(true);
            }
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException("FinishController", "finish()", null, "Performing finish action", exception);
            this.displayError(wizardException);
        }
        return false;
    }

    private boolean checkIpConfiguration() {
        boolean bl = true;
        String string = null;
        String string2 = null;
        try {
            Object object;
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.rbs.isParameterSupported("OamIpHost_configurationMode")) {
                object = this.rbs.getCustomerParameter("OamIpHost_configurationMode");
                if ("DHCP".equals(object)) {
                    bl3 = true;
                } else {
                    bl2 = this.isIpAdressChanged();
                }
            }
            object = this.rbs.getCustomerParameterObject("IPoverGigabitEthernet_transportOption");
            String string3 = object.getValue();
            boolean bl4 = string3.equals("ipV4");
            boolean bl5 = string3.equals("atm");
            boolean bl6 = object.hasValueChanged();
            boolean bl7 = this.isCorbaSecurityActive();
            if (bl3 || bl2 || bl6) {
                String string4;
                String string5;
                boolean bl8;
                String string6 = "";
                if (bl2 || bl3) {
                    string6 = "IP address / subnetmask";
                }
                if (bl2 && bl6) {
                    string6 = string6 + " and ";
                }
                if (bl6 && !bl3) {
                    string6 = string6 + "IP transport";
                }
                boolean bl9 = bl8 = bl5 && bl6;
                if (bl4 || bl8) {
                    string5 = this.rbs.getCustomerParameter("OamIpHost_oamIpAddress");
                    string4 = this.rbs.getCustomerParameter("OamIpHost_oamSubnetMask");
                } else {
                    string5 = this.rbs.getCustomerParameter("ipAddress");
                    string4 = this.rbs.getCustomerParameter("subnetMask");
                }
                String string7 = bl7 ? "will lose " : (bl6 && bl4 ? "will lose " : "may lose ");
                string = "";
                string2 = "";
                if (bl4) {
                    string = string + "You are about to configure the RBS for IPv4.\n\n";
                }
                if (bl3) {
                    string = string + "The " + string6 + " for the RBS will be automatically set at the end of this DHCP configuration.";
                } else {
                    string = string + "The " + string6 + " for the RBS will be changed at the end of this configuration." + "\n\nThe Element Manager " + string7 + "the connection to the RBS." + "\n\nYou may then need to take the following action:";
                    int n = 1;
                    string2 = string2 + String.format("\n\n%d. Update the IP address / subnetmask of your client (laptop) to reflect the changes in the RBS:\n", n++) + String.format("\n         New RBS IpAddress: %s", string5) + String.format("\n         New RBS Subnetmask: %s", string4);
                    if (bl4) {
                        if (!DuwUtil.hasDuw()) {
                            string2 = string2 + String.format("\n\n%d. Connenct the ethernet cable from the client (laptop) to the ETMFX", n++);
                        }
                    } else {
                        string2 = string2 + String.format("\n\n%d. Set default gateway of your client (laptop) to: %s", n++, string5);
                    }
                    string2 = string2 + String.format("\n\n%d. Start the Element Manager again and connect to the new RBS IP address.", n++) + String.format("\n\n%d. Create a configuration version with the Element Manager", n++);
                    string = string + string2;
                }
                bl = this.displayConfirmOkCancelDialog(string);
            }
        }
        catch (Exception exception) {
            BemException bemException = new BemException("Failed performing finish action checkIpConfiguration", (Throwable)exception);
            this.getEasyPopUp().displayError(bemException);
            bl = false;
        }
        this.model.setHowToReconnectText(string2);
        this.model.setEthernetChangedText(string);
        return bl;
    }

    private void informSectorPosChange() {
        if (this.flexModel.getRbs().getPositionChangeFlag()) {
            String string = "The slot position of the radio units may change after this configuration.";
            this.displayInfoMessage(string);
        }
    }

    protected boolean isIpAdressChanged() throws BemException {
        CustomerParameter customerParameter;
        boolean bl = false;
        CustomerParameter customerParameter2 = this.rbs.getCustomerParameterObject("IPoverGigabitEthernet_transportOption");
        String string = customerParameter2.getValue();
        if (string.equals("ipV4")) {
            customerParameter = this.rbs.getCustomerParameterObject("OamIpHost_oamIpAddress");
            bl = customerParameter.hasValueChanged();
        }
        customerParameter = this.rbs.getCustomerParameterObject("ipAddress");
        CustomerParameter customerParameter3 = this.rbs.getCustomerParameterObject("subnetMask");
        boolean bl2 = customerParameter.hasValueChanged();
        boolean bl3 = customerParameter3.hasValueChanged();
        if (bl2 || bl3) {
            bl = true;
        }
        return bl;
    }

    public boolean isCorbaSecurityActive() {
        return ReconnectingPostProgressDlgController.isCorbaSecurityActive();
    }
}

