/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.control;

import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterViewer;
import se.ericsson.wcdma.rbs.bem.wizard.control.GuiLogic;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardHelper;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLaunchChecker;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractWizardController;

public abstract class BemWizardGuiController
extends AbstractWizardController {
    protected final String currentClassName = this.getClass().getName();
    protected WizardHelper wizardHelp = null;
    private GuiLogic logic = null;
    protected static final int DEFAULT_PROGRESS_STEP_SIZE = 1;

    protected boolean next() {
        boolean bl = false;
        try {
            bl = this.verifyInput();
            if (bl) {
                bl = this.updateModel();
            }
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.currentClassName, "next()", null, "verifying user input for scrolling", exception);
            this.displayError(wizardException);
            bl = false;
        }
        return bl;
    }

    protected boolean previous() {
        boolean bl = false;
        try {
            bl = this.verifyInput();
            if (bl) {
                bl = this.updateModel();
            }
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.currentClassName, "previous()", null, "verifying user input for scrolling", exception);
            this.displayError(wizardException);
            bl = false;
        }
        return bl;
    }

    protected boolean cancel() {
        this.wizardHelp.destroyTheInstance();
        WizardLaunchChecker.wizardStopped();
        this.getApplication().stopApplicationNoCheck();
        return false;
    }

    protected void viewClosing() {
        this.cancel();
    }

    protected boolean checkSyntax() {
        boolean bl = false;
        try {
            bl = this.logic.checkSyntax("GUI", null);
        }
        catch (WizardException wizardException) {
            this.displayError(wizardException);
        }
        return bl;
    }

    protected boolean updateModel() throws WizardException {
        return this.logic.updateModel("GUI");
    }

    protected boolean verifyInput() {
        boolean bl = this.checkSyntax();
        return bl;
    }

    public String getPageSubTitle() {
        String string = this.wizardHelp == null ? "" : this.wizardHelp.getPageSubTitle(this.currentClassName);
        return string;
    }

    protected void displayInfoMessage(String string) {
        this.getEasyPopUp().displayInfoMessage(string);
    }

    protected void displayWarningMessage(String string) {
        this.getEasyPopUp().displayWarningMessage(string);
    }

    protected void displayDetailedWarningOkDialog(String string, String string2) {
        this.getEasyPopUp().displayDetailedWarningOkDialog(string, string2);
    }

    protected void displayErrorMessage(String string) {
        this.getEasyPopUp().displayErrorMessage(string);
    }

    protected void displayError(Throwable throwable) {
        this.getEasyPopUp().displayError(throwable);
    }

    protected void displayNextError(CustomerParameterViewer customerParameterViewer, Throwable throwable) {
        if (throwable instanceof CustomerParameterException) {
            CustomerParameterException customerParameterException = (CustomerParameterException)throwable;
            CustomerParameter customerParameter = customerParameterException.getParameter();
            String string = customerParameter.getName();
            String string2 = customerParameterViewer.getGuiNameForCustomerParameter(string);
            customerParameterException.setUnlessEmpty("CustomerParameter name", string2);
            customerParameterException.setUnlessEmpty("CustomerParameter view name", string2);
            this.displayError(customerParameterException);
            customerParameterViewer.setFocusOnCustomerParameterComponent(string);
        } else if (throwable instanceof BemException) {
            this.displayError(throwable);
        } else {
            WizardException wizardException = new WizardException(this.getClass().getName(), "next()", null, "verifying user input for scrolling", throwable);
            this.displayError(wizardException);
        }
    }

    protected boolean displayConfirmDialog(String string) {
        boolean bl = this.getEasyPopUp().displayConfirmDialog(string);
        return bl;
    }

    protected boolean displayConfirmOkCancelDialog(String string) {
        boolean bl = this.getEasyPopUp().displayConfirmOkCancelDialog(string);
        return bl;
    }

    public Class getNextControllerClass() {
        Class clazz = this.wizardHelp.getNextPageController(this.currentClassName);
        return clazz;
    }

    public Class getNextViewClass() {
        Class clazz = this.wizardHelp.getNextPageView(this.currentClassName);
        return clazz;
    }

    public Class getPreviousControllerClass() {
        Class clazz = this.wizardHelp.getPreviousPageController(this.currentClassName);
        return clazz;
    }

    public Class getPreviousViewClass() {
        Class clazz = this.wizardHelp.getPreviousPageView(this.currentClassName);
        return clazz;
    }

    public String getHelpId() {
        return this.wizardHelp.getHelpId();
    }

    protected GuiLogic getLogic() {
        return this.logic;
    }

    protected void setLogic(GuiLogic guiLogic) {
        this.logic = guiLogic;
    }
}

