/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.control;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.gui.ProgressReporter;
import se.ericsson.wcdma.rbs.bem.common.util.SilentModeManager;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.util.InstallController;
import se.ericsson.wcdma.rbs.bem.wizard.view.NodeResultViewer;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.util.WizardHelp;

public class NodeResultFlexController
extends BemWizardGuiController
implements ProgressReporter {
    private static String NCONF_PAGE_HEADER = "Cabinet Equipment Configuration page {0}({1})";
    private NodeResultViewer myView = null;
    private String currentProgressDescription = "Not started";
    private int currentProgressReported = 0;
    private int noProgressToReport = 0;
    private InstallController installController = null;

    protected void init() {
        this.myView = (NodeResultViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.setWindowTitle();
    }

    protected void afterVisible() {
        if (super.getPreviousControllerClass() == null) {
            super.setPreviousEnabled(false);
            super.setPreviousVisible(false);
        }
        super.setNextEnabled(false);
        try {
            this.installController = this.createInstallController();
            this.noProgressToReport = this.installController.initiate();
            if (this.noProgressToReport == 0) {
                this.noProgressToReport = 1;
            }
            this.myView.setProgressMax(this.noProgressToReport);
            this.myView.setProgressMin(1);
            this.myView.setProgressCurrentValue(1);
            this.myView.setCurrentStatusText("Reading Cabinet configuration from the RBS");
            this.installController.start();
        }
        catch (Exception exception) {
            String string = exception.toString();
            this.myView.setResultText(string);
            this.installController = null;
        }
    }

    protected boolean checkSyntax() {
        return true;
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = NCONF_PAGE_HEADER;
        String string3 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string4 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format(string2, string3, string4));
    }

    protected void stop() {
        if (this.installController != null) {
            this.installController.stopExecution();
        }
    }

    protected boolean updateModel() {
        return true;
    }

    public void reportComplete(StringBuffer stringBuffer) {
        this.setNextEnabled(true);
        this.myView.setProgressCurrentValue(this.noProgressToReport);
        this.myView.setCurrentStatusText(" ");
        String string = "Current configuration successfully loaded from Radio Base Station!";
        if (stringBuffer != null) {
            string = string + "\n" + stringBuffer.toString();
        }
        this.myView.setResultText(string);
        this.installController = null;
    }

    public void reportError(BemException bemException) {
        ExceptionProperties exceptionProperties = bemException.getProperties();
        exceptionProperties.setProperty("Progress", this.currentProgressDescription);
        String string = exceptionProperties.getPopUpMessge();
        SilentModeManager.isSilentMode(string, true);
        this.myView.setResultText(string);
    }

    public void reportProgress(String string, String string2) {
        this.reportProgress(string, string2, 1);
    }

    public void reportProgress(String string, String string2, int n) {
        this.currentProgressReported += n;
        this.currentProgressDescription = string2;
        if (this.currentProgressReported <= this.noProgressToReport) {
            this.myView.setProgressCurrentValue(this.currentProgressReported);
        }
        this.myView.setCurrentStatusText(string2);
    }

    public String getReportedProgress() {
        return this.currentProgressDescription;
    }

    public InstallController createInstallController() {
        Class[] classArray = this.wizardHelp.getAllPreControllerClasses();
        return new InstallController(this, classArray);
    }

    public String toString() {
        return this.currentProgressDescription;
    }
}

