/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.postcontrol;

import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.phase.Phase;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.TransactionHelper;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.util.ExceptionUtil;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.util.SubInstaller;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.model.ModifyModel;

public class InstallationPostController
implements SubInstaller,
Observer {
    private int totalNumberOfProgressReports = 50;
    private final Installer theInstaller;
    private final String theName;
    private int myProgressReports = 0;
    private String theDescription = "Install according to choises";
    private static final String INSTALLING_RBS = "Install - Updating RBS with chosen configuration data";
    private static final String PREFIX_DESCRIPTION = "Currently handling ";
    private final ModifyModel model;
    private final Rbs rbs;
    private final Phase[] installationPhases;
    private static final int totalExpectedProgressReports = 0;
    private int progressReportsReceived = 0;

    public InstallationPostController(Installer installer) {
        this.theInstaller = installer;
        this.theName = this.getClass().getName();
        this.model = ModifyModel.getInstance();
        this.rbs = this.model.getRbs();
        this.installationPhases = this.rbs.getInstallationPhases();
        int n = this.installationPhases.length;
        int n2 = this.rbs.getAllConfigItems().keySet().size();
        this.myProgressReports = this.totalNumberOfProgressReports = n + n2 + 6;
    }

    public boolean install() throws BemException {
        this.theInstaller.reportProgress(this.theName, this.theDescription);
        --this.myProgressReports;
        if (this.theInstaller.isInterrupted()) {
            return false;
        }
        MoHandler moHandler = this.rbs.getMoHandler();
        TransactionHelper transactionHelper = TransactionHelper.getInstance(moHandler);
        moHandler.setUseLargeTransactions(true);
        transactionHelper.addObserver(this);
        this.rbs.addObserver(this);
        try {
            this.theDescription = "Reading resources to install";
            this.theInstaller.reportProgress(this.theName, this.theDescription);
            --this.myProgressReports;
            ArrayList arrayList = this.rbs.getRIsToInstall();
            this.theDescription = "Starting installation";
            this.theInstaller.reportProgress(this.theName, this.theDescription);
            --this.myProgressReports;
            for (Phase object : this.installationPhases) {
                boolean bl;
                try {
                    bl = transactionHelper.setPhase(object.getName());
                }
                catch (MoHandlerException moHandlerException) {
                    if (ExceptionUtil.isCausedByCorbaConnectionLost(moHandlerException)) {
                        bl = true;
                        Nal.getLog().nalTrace(6, this.getClass(), "Connection lost during commit of transaction (timing related, expected behaviour when changing nodeInterfaceName).");
                    }
                    throw moHandlerException;
                }
                if (bl) continue;
                String moHandlerException = object.getName();
                String string = this.removePhaseFromName(moHandlerException);
                this.theDescription = PREFIX_DESCRIPTION + string;
                this.theInstaller.reportProgress(this.theName, this.theDescription);
                --this.myProgressReports;
                String string2 = this.theDescription;
                for (ResourceItem resourceItem : arrayList) {
                    this.theDescription = string2 + " " + resourceItem.getDisplayName();
                    resourceItem.install(moHandlerException);
                    if (!this.theInstaller.isInterrupted()) continue;
                    boolean bl2 = false;
                    return bl2;
                }
            }
            this.theDescription = INSTALLING_RBS;
            this.theInstaller.reportProgress(this.theName, this.theDescription);
            --this.myProgressReports;
        }
        catch (Exception exception) {
            String string;
            Phase[] phaseArray;
            block16: {
                phaseArray = "commit failed, rollback to previous configuration.";
                string = "Operation failed";
                try {
                    transactionHelper.rollbackAlloperations(exception);
                }
                catch (Exception exception2) {
                    BemException bemException;
                    if (!(exception2 instanceof BemException) || !"ROLLBACK_TRANSACTION".equals((bemException = (BemException)exception2).getAction())) break block16;
                    string = bemException.getAction();
                }
            }
            BemLog.exceptionRaised((String)phaseArray, exception);
            BemException bemException = new BemException("Installing data on node " + (String)phaseArray, string, "", "", exception);
            throw bemException;
        }
        finally {
            moHandler.setUseLargeTransactions(false);
        }
        while (this.myProgressReports > 0) {
            this.theInstaller.reportProgress(this.theName, this.theDescription);
            --this.myProgressReports;
        }
        return true;
    }

    public int getTotalNoOfProgressReports() {
        return this.totalNumberOfProgressReports;
    }

    public String getTheName() {
        return this.theName;
    }

    public String getTheDescription() {
        return this.theDescription;
    }

    private String removePhaseFromName(String string) {
        String string2 = string;
        if (string.endsWith("Phase")) {
            int n = string.lastIndexOf("Phase");
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        ++this.progressReportsReceived;
        --this.myProgressReports;
        this.theInstaller.reportProgress(this.theName, this.theDescription);
        BemLog.log(7, "Progress: " + this.progressReportsReceived + " (" + 0 + ") : " + string);
    }
}

