/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.EtbSlotParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.PhysicalLineParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.ReqNoOfLinksParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationParameterList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationTypeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TimeSlotsInFractionParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.AtmPortProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.DynamicCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComboBox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTableModel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control.AtmPortController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.model.OamCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.AddAtmPortDialogView;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractDialogController;

public class AddAtmPortDialogController
extends AbstractDialogController {
    public static final String ERROR_MESSAGE_IMA = "At least one ETB line must be selected in IMA configuration";
    public static final String ERROR_MESSAGE_REQ_NO_OF_LINKS = "Required number of links can not be larger than number of selected ETB lines";
    public static final String ERROR_MESSAGE_FRACTIONAL = "At least one Time Slot must be selected in a Fractional Configuration";
    private AddAtmPortDialogView myView = null;
    private AtmPortController theParent = null;
    private Rbs rbs = null;
    private DynamicCustomerParameterProvider dynamicCPProvider = null;
    private AtmPortProvider atmPortProvider = null;
    private WizardCIModel wizardCiModel;
    private List listOfCP = null;
    private EtbSlotParameter slotParameter = null;
    private PhysicalLineParameter lineParameter = null;
    private ReqNoOfLinksParameter reqNoOfLinksParameter = null;
    private TerminationTypeParameter terminationTypeParameter = null;
    private TimeSlotsInFractionParameter timeSlotsParameter = null;
    private CustomerParameterTableModel imaLinesTableModel = null;
    private boolean isListenerEnabled = false;
    private boolean isIma = false;
    private boolean isFractional = false;

    protected void init() {
        this.isListenerEnabled = false;
        this.wizardCiModel = OamCIModel.getInstance();
        this.rbs = this.wizardCiModel.getRbs();
        this.dynamicCPProvider = (DynamicCustomerParameterProvider)((Object)this.rbs.getConfigItem("AtmAndPtCI"));
        this.atmPortProvider = (AtmPortProvider)((Object)this.rbs.getConfigItem("AtmAndPtCI"));
    }

    protected void afterVisible() {
        this.createCP();
        this.theParent = (AtmPortController)this.getParentController();
        this.myView = (AddAtmPortDialogView)this.getView();
        this.myView.getAddButton().addActionListener(new AddButtonActionListener());
        this.myView.getCancelButton().addActionListener(new CancelButtonActionListener());
        this.myView.setEtbSlotParameter(this.slotParameter);
        this.myView.setTerminationTypeParameter(this.terminationTypeParameter);
        this.myView.setPhysicalLineParameter(this.lineParameter);
        this.myView.setPhysicalLineParameterForIma(this.lineParameter);
        this.myView.setTimeSlotsInFractionParameter(this.timeSlotsParameter);
        this.myView.setReqNumberOfLinksParameter(this.reqNoOfLinksParameter);
        this.myView.getEtbSlotComboBox().addActionListener(new EtbSlotListener());
        this.myView.getTerminationTypeComboBox().addActionListener(new TermTypeListener());
        this.myView.getPhysicalLinesComboBox().addActionListener(new LineListener());
        this.myView.getRequiredNumberOfLinksComponent().addKeyListener(new ReqNoOfLinkKeyListener());
        this.imaLinesTableModel = this.myView.getImaLinesTableModel();
        this.imaLinesTableModel.addTableModelListener(new ImaTableModelListener());
        this.isListenerEnabled = true;
        try {
            this.initiateCustomerParameters();
        }
        catch (Exception exception) {
            this.displayError(exception);
        }
    }

    private void createCP() {
        try {
            this.listOfCP = this.dynamicCPProvider.createCP("AtmPort");
        }
        catch (BemException bemException) {
            BemLog.log(2, this.getClass() + " failed createCP()");
        }
        TerminationParameterList terminationParameterList = (TerminationParameterList)this.listOfCP.get(0);
        this.slotParameter = terminationParameterList.getSlotParameter();
        this.terminationTypeParameter = terminationParameterList.getTerminationTypeParameter();
        this.lineParameter = terminationParameterList.getLineParameter();
        this.timeSlotsParameter = terminationParameterList.getTimeSlotsInFractionParameter();
        this.reqNoOfLinksParameter = terminationParameterList.getRequiredNumberOfLinksParameter();
    }

    private void setViewVisibility() {
        try {
            String string = this.myView.getSelectedSlot();
            String string2 = this.myView.getSelectedTerminationType();
            this.isIma = this.atmPortProvider.isIma(string, string2);
            this.myView.showEtbLineComponent(!this.isIma);
            this.myView.showImaEtbLinesComponent(this.isIma);
            this.isFractional = this.atmPortProvider.isFractional(string, string2);
            this.myView.showTimeSlotsComponent(this.isFractional);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Exception=" + exception.toString(), "setViewVisibility", 0);
        }
    }

    private void initiateCustomerParameters() throws BemException {
        String string = this.myView.getSelectedSlot();
        if (string != null) {
            this.slotParameter.setValue(string);
        } else {
            String[] stringArray = this.atmPortProvider.getAvailableSlots();
            if (stringArray != null && stringArray.length >= 1) {
                this.slotParameter.setValue(stringArray[0]);
                String[] stringArray2 = this.atmPortProvider.getAvailableLines(stringArray[0]);
                if (stringArray2 != null && stringArray2.length >= 1) {
                    this.slotParameter.setValue(stringArray2[0]);
                }
            }
        }
    }

    private boolean checkSyntax() {
        boolean bl = true;
        try {
            String[] stringArray;
            String string = this.myView.getSelectedSlot();
            String string2 = this.myView.getSelectedTerminationType();
            boolean bl2 = this.atmPortProvider.isIma(string, string2);
            boolean bl3 = this.atmPortProvider.isFractional(string, string2);
            if (bl2) {
                String[] stringArray2 = this.myView.getImaLinesTableModel().getSelectedItemsInRows();
                if (stringArray2 == null || stringArray2 != null && stringArray2.length < 1) {
                    JOptionPane.showMessageDialog(null, ERROR_MESSAGE_IMA, "", 0);
                } else {
                    int n = stringArray2.length;
                    String string3 = this.reqNoOfLinksParameter.getValue();
                    int n2 = Integer.parseInt(string3);
                    if (n2 > n) {
                        bl = false;
                        JOptionPane.showMessageDialog(null, ERROR_MESSAGE_REQ_NO_OF_LINKS, "", 0);
                    }
                }
            } else if (bl3 && (stringArray = this.myView.getTimeSlotsFractionModel().getSelectedItemsInRows()) != null && stringArray.length < 1) {
                bl = false;
                JOptionPane.showMessageDialog(null, ERROR_MESSAGE_FRACTIONAL, "", 0);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Exception=" + exception.toString(), "Checking input", 0);
            bl = false;
        }
        return bl;
    }

    protected void displayError(Throwable throwable) {
        this.getEasyPopUp().displayError(throwable);
    }

    private class ReqNoOfLinkKeyListener
    extends KeyAdapter {
        private ReqNoOfLinkKeyListener() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            String string;
            CustomerParameterTextField customerParameterTextField = (CustomerParameterTextField)keyEvent.getSource();
            if (AddAtmPortDialogController.this.isListenerEnabled && (string = customerParameterTextField.getText()) != null && !string.equals(AddAtmPortDialogController.this.reqNoOfLinksParameter.getValue())) {
                AddAtmPortDialogController.this.reqNoOfLinksParameter.setValue(string);
                AddAtmPortDialogController.this.setViewVisibility();
            }
        }
    }

    private class ImaTableModelListener
    implements TableModelListener {
        private ImaTableModelListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 0) {
                if (!AddAtmPortDialogController.this.isIma) {
                    return;
                }
                String[] stringArray = AddAtmPortDialogController.this.imaLinesTableModel.getSelectedItemsInRows();
                int n = stringArray.length;
                if (n > 0) {
                    IntegerRange integerRange = new IntegerRange(1, n);
                    AddAtmPortDialogController.this.reqNoOfLinksParameter.getRestriction().setRange(integerRange, true);
                    AddAtmPortDialogController.this.lineParameter.setValue(stringArray);
                }
                AddAtmPortDialogController.this.setViewVisibility();
            }
        }
    }

    private class LineListener
    implements ActionListener {
        private LineListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CustomerParameterComboBox customerParameterComboBox = (CustomerParameterComboBox)actionEvent.getSource();
            String string = AddAtmPortDialogController.this.myView.getSelectedSlot();
            String string2 = AddAtmPortDialogController.this.myView.getSelectedTerminationType();
            if (AddAtmPortDialogController.this.isListenerEnabled) {
                try {
                    AddAtmPortDialogController.this.isIma = AddAtmPortDialogController.this.atmPortProvider.isIma(string, string2);
                }
                catch (BemException bemException) {
                    bemException.printStackTrace();
                }
                if (AddAtmPortDialogController.this.isIma) {
                    AddAtmPortDialogController.this.terminationTypeParameter.setValue(string2);
                    return;
                }
                String string3 = (String)customerParameterComboBox.getSelectedItem();
                if (string3 != null && !string3.equals("-") && !string3.equals(AddAtmPortDialogController.this.lineParameter.getValue())) {
                    AddAtmPortDialogController.this.lineParameter.setValue(string3);
                    AddAtmPortDialogController.this.setViewVisibility();
                }
            }
        }
    }

    private class TermTypeListener
    implements ActionListener {
        private TermTypeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CustomerParameterComboBox customerParameterComboBox = (CustomerParameterComboBox)actionEvent.getSource();
            String string = AddAtmPortDialogController.this.myView.getSelectedSlot();
            String string2 = AddAtmPortDialogController.this.myView.getSelectedTerminationType();
            if (AddAtmPortDialogController.this.isListenerEnabled) {
                try {
                    AddAtmPortDialogController.this.isIma = AddAtmPortDialogController.this.atmPortProvider.isIma(string, string2);
                }
                catch (BemException bemException) {
                    bemException.printStackTrace();
                }
                if (AddAtmPortDialogController.this.isIma) {
                    return;
                }
                String string3 = (String)customerParameterComboBox.getSelectedItem();
                if (string3 != null && !string3.equals("-")) {
                    AddAtmPortDialogController.this.setViewVisibility();
                    AddAtmPortDialogController.this.terminationTypeParameter.setValue(string3);
                }
            }
        }
    }

    private class EtbSlotListener
    implements ActionListener {
        private EtbSlotListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            CustomerParameterComboBox customerParameterComboBox = (CustomerParameterComboBox)actionEvent.getSource();
            if (AddAtmPortDialogController.this.isListenerEnabled && (string = (String)customerParameterComboBox.getSelectedItem()) != null && !string.equals("-") && !string.equals(AddAtmPortDialogController.this.slotParameter.getValue())) {
                AddAtmPortDialogController.this.slotParameter.setValue(string);
                AddAtmPortDialogController.this.setViewVisibility();
            }
        }
    }

    private class CancelButtonActionListener
    implements ActionListener {
        private CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                AddAtmPortDialogController.this.dynamicCPProvider.removeCP(AddAtmPortDialogController.this.listOfCP);
            }
            catch (BemException bemException) {
                BemLog.log(2, this.getClass() + " failed actionPerformed()");
            }
            AddAtmPortDialogController.this.stopDialog();
        }
    }

    private class AddButtonActionListener
    implements ActionListener {
        private AddButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (AddAtmPortDialogController.this.checkSyntax()) {
                    AddAtmPortDialogController.this.isListenerEnabled = false;
                    String string = AddAtmPortDialogController.this.myView.getSelectedSlot();
                    String string2 = AddAtmPortDialogController.this.myView.getSelectedTerminationType();
                    boolean bl = AddAtmPortDialogController.this.atmPortProvider.isIma(string, string2);
                    boolean bl2 = AddAtmPortDialogController.this.atmPortProvider.isFractional(string, string2);
                    if (bl) {
                        String[] stringArray = AddAtmPortDialogController.this.myView.getImaLinesTableModel().getSelectedItemsInRows();
                        AddAtmPortDialogController.this.lineParameter.setValue(stringArray);
                        AddAtmPortDialogController.this.timeSlotsParameter.setValue("##UNDEFINED");
                        AddAtmPortDialogController.this.timeSlotsParameter.getRestriction().setAccessLevel(1);
                    } else if (bl2) {
                        String[] stringArray = AddAtmPortDialogController.this.myView.getTimeSlotsFractionModel().getSelectedItemsInRows();
                        AddAtmPortDialogController.this.timeSlotsParameter.setValue(stringArray);
                        AddAtmPortDialogController.this.reqNoOfLinksParameter.setValue("##UNDEFINED");
                        AddAtmPortDialogController.this.reqNoOfLinksParameter.getRestriction().setAccessLevel(1);
                    } else {
                        AddAtmPortDialogController.this.reqNoOfLinksParameter.setValue("##UNDEFINED");
                        AddAtmPortDialogController.this.reqNoOfLinksParameter.getRestriction().setAccessLevel(1);
                        AddAtmPortDialogController.this.timeSlotsParameter.setValue("##UNDEFINED");
                        AddAtmPortDialogController.this.timeSlotsParameter.getRestriction().setAccessLevel(1);
                    }
                    AddAtmPortDialogController.this.theParent.addOneAtmPort(AddAtmPortDialogController.this.listOfCP);
                    AddAtmPortDialogController.this.stopDialog();
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Exception=" + exception.toString(), "Handle add button", 0);
            }
        }
    }
}

