/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.LocationParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.LocationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.AtmIpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.AtmSubnetMaskParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.ServiceCategoryParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VciParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VpMcrParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VpPcrParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VpiParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.provider.IpOverAtmInfoTextProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.provider.RedundancyChangeProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.model.OamCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.IpAtmConfigurationView;

public class IpAtmConfigurationController
extends BemWizardGuiController {
    private static String NCONF_OAM_PAGE_HEADER = "O&M Access Configuration page {0}({1})";
    private IpAtmConfigurationView view;
    private OamCIModel model;
    private Rbs rbs;
    private IpOverAtmInfoTextProvider infoTextyProvider;
    private RedundancyChangeProvider redundancyProvider;
    private LocationProvider locationProvider;
    private LocationParameter location;

    protected void init() {
        this.wizardHelp = WizardHelp.getTheInstance();
        this.view = (IpAtmConfigurationView)this.getView();
        this.model = OamCIModel.getInstance();
        this.rbs = this.model.getRbs();
        this.redundancyProvider = (RedundancyChangeProvider)((Object)this.rbs.getConfigItem("IpOverAtmCI"));
        this.infoTextyProvider = (IpOverAtmInfoTextProvider)((Object)this.rbs.getConfigItem("IpOverAtmCI"));
        this.locationProvider = (LocationProvider)((Object)this.rbs.getConfigItem("AtmAndPtCI"));
        this.location = this.locationProvider.getLocationParameter();
        this.setWindowTitle();
        try {
            this.updateCustomerParameter();
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.getClass().getName(), "beforeVisible()", null, "Setting up window for input", exception);
            BemLog.exceptionRaised("An error has occurred while reading from the model", wizardException);
            super.displayError(wizardException);
        }
    }

    private void updateCustomerParameter() throws Exception {
        VpiParameter vpiParameter = (VpiParameter)this.rbs.getCustomerParameterObject("firstOAMatm_externalVpi");
        VpiParameter vpiParameter2 = (VpiParameter)this.rbs.getCustomerParameterObject("secondOAMatm_externalVpi");
        this.view.setVpi(vpiParameter, vpiParameter2);
        VpPcrParameter vpPcrParameter = (VpPcrParameter)this.rbs.getCustomerParameterObject("firstOAMatm_vpPeakCellRate");
        VpPcrParameter vpPcrParameter2 = (VpPcrParameter)this.rbs.getCustomerParameterObject("secondOAMatm_vpPeakCellRate");
        this.view.setPcr(vpPcrParameter, vpPcrParameter2);
        VpMcrParameter vpMcrParameter = (VpMcrParameter)this.rbs.getCustomerParameterObject("firstOAMatm_vpMinimumCellRate");
        VpMcrParameter vpMcrParameter2 = (VpMcrParameter)this.rbs.getCustomerParameterObject("secondOAMatm_vpMinimumCellRate");
        this.view.setMcr(vpMcrParameter, vpMcrParameter2);
        ServiceCategoryParameter serviceCategoryParameter = (ServiceCategoryParameter)this.rbs.getCustomerParameterObject("firstOAMatm_vpServiceCategory");
        ServiceCategoryParameter serviceCategoryParameter2 = (ServiceCategoryParameter)this.rbs.getCustomerParameterObject("secondOAMatm_vpServiceCategory");
        this.view.setVpServiceCategory(serviceCategoryParameter, serviceCategoryParameter2);
        VciParameter vciParameter = (VciParameter)this.rbs.getCustomerParameterObject("firstOAMatm_externalVci");
        VciParameter vciParameter2 = (VciParameter)this.rbs.getCustomerParameterObject("secondOAMatm_externalVci");
        this.view.setVci(vciParameter, vciParameter2);
        ServiceCategoryParameter serviceCategoryParameter3 = (ServiceCategoryParameter)this.rbs.getCustomerParameterObject("firstOAMatm_vcServiceCategory");
        ServiceCategoryParameter serviceCategoryParameter4 = (ServiceCategoryParameter)this.rbs.getCustomerParameterObject("secondOAMatm_vcServiceCategory");
        this.view.setVcServiceCategory(serviceCategoryParameter3, serviceCategoryParameter4);
        AtmIpAddressParameter atmIpAddressParameter = (AtmIpAddressParameter)this.rbs.getCustomerParameterObject("firstOAMatm_atmIpAddress");
        AtmIpAddressParameter atmIpAddressParameter2 = (AtmIpAddressParameter)this.rbs.getCustomerParameterObject("secondOAMatm_atmIpAddress");
        this.view.setIpAddress(atmIpAddressParameter, atmIpAddressParameter2);
        AtmSubnetMaskParameter atmSubnetMaskParameter = (AtmSubnetMaskParameter)this.rbs.getCustomerParameterObject("firstOAMatm_atmSubnetMask");
        AtmSubnetMaskParameter atmSubnetMaskParameter2 = (AtmSubnetMaskParameter)this.rbs.getCustomerParameterObject("secondOAMatm_atmSubnetMask");
        this.view.setSubnetMask(atmSubnetMaskParameter, atmSubnetMaskParameter2);
    }

    protected void beforeVisible() {
        try {
            if (super.getPreviousControllerClass() == null) {
                super.setPreviousEnabled(false);
            }
            this.view.updateGui();
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.getClass().getName(), "beforeVisible()", null, "Setting up window for input", exception);
            BemLog.exceptionRaised("An error has occurred while reading from the model", wizardException);
            super.displayError(wizardException);
        }
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = NCONF_OAM_PAGE_HEADER;
        String string3 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string4 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.view.setHeaderText(MessageFormat.format(string2, string3, string4));
    }

    private void checkIfRedundancyLinkChangeNeeded() throws BemException {
        if (!this.redundancyProvider.isChangeOfRedundantLinkPossible() || this.redundancyProvider.isChangeOfRedundantLinkSetToYes()) {
            return;
        }
        if (this.location.isOnSite()) {
            return;
        }
        String string = this.redundancyProvider.getQuestionForRedundantLink();
        boolean bl = this.displayConfirmDialog(string);
        if (bl) {
            String string2 = this.redundancyProvider.getWarningMessageIfYes();
            this.displayWarningMessage(string2);
            this.redundancyProvider.setChangeOfRedundantLinkAnswer(true);
        } else {
            String string3 = this.redundancyProvider.getWarningMessageIfNo();
            this.displayWarningMessage(string3);
            this.redundancyProvider.setChangeOfRedundantLinkAnswer(false);
        }
    }

    private void updateInformativeTextMsg() throws BemException {
        String string = this.infoTextyProvider.getIpAddressOrSubnetMaskChangedMsg();
        this.model.setIpOverAtmLinkChangedText(string);
    }

    protected boolean next() {
        boolean bl = true;
        try {
            this.rbs.checkConsistency("IpOverAtmCI");
            this.checkIfRedundancyLinkChangeNeeded();
            this.updateInformativeTextMsg();
        }
        catch (Exception exception) {
            this.displayNextError(this.view, exception);
            bl = false;
        }
        return bl;
    }

    protected boolean previous() {
        return true;
    }
}

