/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JPanel;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.TransportOptionParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.AutoNegotiationParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.ConfiguredSpeedDuplexParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.MasterModeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.networksync.NetworkSyncCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EthernetProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterCheckbox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComboBox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.model.OamCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.IpOamViewer;

public class IpOamController
extends BemWizardGuiController {
    private static String NCONF_OAM_PAGE_HEADER = "O&M Access Configuration page {0}({1})";
    private IpOamViewer myView;
    private WizardCIModel oamCIModel;
    private Rbs rbs;
    private Hashtable allCPs = null;
    private String[] allCPNames;
    private JPanel[] guiComponents = null;
    private IpAddressParameter ipAddressPara = null;
    private IpAddressParameter subnetMaskPara = null;
    private TransportOptionParameter transportOptionPara = null;
    private YesNoCustomerParameter gigabitEthernetPortCreatePara = null;
    private Enumeration portNo;
    private AutoNegotiationParameter autoNegotiation;
    private MasterModeParameter masterMode;
    private ConfiguredSpeedDuplexParameter configuredSpeedDuplex;
    private CustomerParameterTextField ipAddressField = null;
    private CustomerParameterTextField subnetMaskField = null;
    private CustomerParameterComboBox transportOptionField = null;
    private CustomerParameterComboBox portNoField;
    private CustomerParameterComboBox autoNegotiationField;
    private CustomerParameterComboBox masterModeField;
    private CustomerParameterComboBox configuredSpeedDuplexField;
    private boolean areGUIComponentsCreated = false;
    private CustomerParameterCheckbox gigabitEthernetPortCreateField = null;
    private YesNoCustomerParameter gigaBitEthernetEsmcSupport;
    private Enumeration useReceivedQl;
    private Enumeration adminQuality;
    private CustomerParameterCheckbox gigaBitEthernetEsmcSupportField;
    private CustomerParameterComboBox useReceivedQlField;
    private CustomerParameterComboBox adminQualityField;
    private CustomerParameter ipsecEnable = null;
    private CustomerParameterComboBox ipsecEnableComboBox = null;

    protected void init() {
        this.myView = (IpOamViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.oamCIModel = OamCIModel.getInstance();
        this.rbs = this.oamCIModel.getRbs();
        this.setWindowTitle();
    }

    protected void beforeVisible() {
        super.setPreviousEnabled(false);
        super.setPreviousVisible(false);
    }

    protected void afterVisible() {
        try {
            if (super.getPreviousControllerClass() == null) {
                super.setPreviousEnabled(false);
            }
            if (!this.areGUIComponentsCreated) {
                this.allCPNames = new String[]{"ipAddress", "subnetMask", "IPoverGigabitEthernet_transportOption", "gigaBitEthernetPort", "gigaBitEthernetPortCreate", "autoNegotiation", "masterMode", "configuredSpeedDuplex", "emscSupport", "useReceivedQl", "adminQuality"};
                this.getAllCPs(this.allCPNames);
                this.transportOptionPara = (TransportOptionParameter)this.allCPs.get("IPoverGigabitEthernet_transportOption");
                this.ipAddressPara = (IpAddressParameter)this.allCPs.get("ipAddress");
                this.subnetMaskPara = (IpAddressParameter)this.allCPs.get("subnetMask");
                if (this.rbs.isParameterSupported("gigaBitEthernetPort") && DuwUtil.hasDuw()) {
                    this.portNo = (Enumeration)this.allCPs.get("gigaBitEthernetPort");
                    this.gigabitEthernetPortCreatePara = (YesNoCustomerParameter)this.allCPs.get("gigaBitEthernetPortCreate");
                    this.autoNegotiation = (AutoNegotiationParameter)this.allCPs.get("autoNegotiation");
                    this.masterMode = (MasterModeParameter)this.allCPs.get("masterMode");
                    this.configuredSpeedDuplex = (ConfiguredSpeedDuplexParameter)this.allCPs.get("configuredSpeedDuplex");
                    this.gigaBitEthernetEsmcSupport = (YesNoCustomerParameter)this.allCPs.get("emscSupport");
                    this.useReceivedQl = (Enumeration)this.allCPs.get("useReceivedQl");
                    this.adminQuality = (Enumeration)this.allCPs.get("adminQuality");
                }
                this.guiComponents = this.createGuiComponents();
                if (this.ipsecEnable.getValue().equals("NON_IPSEC")) {
                    this.myView.setBemComponents(this.guiComponents, false);
                } else {
                    this.myView.setBemComponents(this.guiComponents, true);
                }
                this.areGUIComponentsCreated = true;
            }
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException("IpOamController", "afterVisible()", null, "Setting up window for input", exception);
            this.displayError(wizardException);
            return;
        }
    }

    private void getAllCPs(String[] stringArray) throws BemException {
        this.allCPs = new Hashtable();
        for (String string : stringArray) {
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
            this.allCPs.put(string, customerParameter);
        }
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = NCONF_OAM_PAGE_HEADER;
        String string3 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string4 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format(string2, string3, string4));
    }

    private JPanel[] createGuiComponents() throws BemException {
        JPanel[] jPanelArray = new JPanel[12];
        this.transportOptionField = new CustomerParameterComboBox(this.transportOptionPara);
        CustomerParameterPanel customerParameterPanel = new CustomerParameterPanel("Transport option:", this.transportOptionField);
        jPanelArray[0] = customerParameterPanel;
        this.ipAddressField = new CustomerParameterTextField(this.ipAddressPara);
        CustomerParameterPanel customerParameterPanel2 = new CustomerParameterPanel("IP address:", this.ipAddressField, false);
        jPanelArray[1] = customerParameterPanel2;
        this.subnetMaskField = new CustomerParameterTextField(this.subnetMaskPara);
        customerParameterPanel2 = new CustomerParameterPanel("Subnet mask:", this.subnetMaskField, false);
        jPanelArray[2] = customerParameterPanel2;
        if (DuwUtil.hasDuw()) {
            this.portNoField = new CustomerParameterComboBox(this.portNo);
            customerParameterPanel2 = new CustomerParameterPanel("Port:", this.portNoField, false);
            jPanelArray[3] = customerParameterPanel2;
            this.gigabitEthernetPortCreateField = new CustomerParameterCheckbox("", this.gigabitEthernetPortCreatePara);
            CustomerParameterPanel customerParameterPanel3 = new CustomerParameterPanel("Use GigaBit ethernet:", this.gigabitEthernetPortCreateField, false);
            jPanelArray[4] = customerParameterPanel3;
            this.autoNegotiationField = new CustomerParameterComboBox(this.autoNegotiation);
            CustomerParameterPanel customerParameterPanel4 = new CustomerParameterPanel("AutoNegotiation:", this.autoNegotiationField, false);
            jPanelArray[5] = customerParameterPanel4;
            this.masterModeField = new CustomerParameterComboBox(this.masterMode);
            CustomerParameterPanel customerParameterPanel5 = new CustomerParameterPanel("MasterMode:", this.masterModeField, false);
            jPanelArray[6] = customerParameterPanel5;
            this.configuredSpeedDuplexField = new CustomerParameterComboBox(this.configuredSpeedDuplex);
            CustomerParameterPanel customerParameterPanel6 = new CustomerParameterPanel("ConfiguredSpeedDuplex:", this.configuredSpeedDuplexField, false);
            jPanelArray[7] = customerParameterPanel6;
            this.gigaBitEthernetEsmcSupportField = new CustomerParameterCheckbox("", this.gigaBitEthernetEsmcSupport);
            CustomerParameterPanel customerParameterPanel7 = new CustomerParameterPanel("Use ESMC:", this.gigaBitEthernetEsmcSupportField, false);
            jPanelArray[8] = customerParameterPanel7;
            this.useReceivedQlField = new CustomerParameterComboBox(this.useReceivedQl);
            CustomerParameterPanel customerParameterPanel8 = new CustomerParameterPanel("UseReceivedQL:", this.useReceivedQlField, false);
            jPanelArray[9] = customerParameterPanel8;
            this.adminQualityField = new CustomerParameterComboBox(this.adminQuality);
            CustomerParameterPanel customerParameterPanel9 = new CustomerParameterPanel("AdminQuality:", this.adminQualityField, false);
            jPanelArray[10] = customerParameterPanel9;
            this.ipsecEnable = this.rbs.getCustomerParameterObject("IpSec_configType");
            if (!this.ipsecEnable.getValue().equals("NON_IPSEC")) {
                this.ipsecEnableComboBox = new CustomerParameterComboBox((Enumeration)this.ipsecEnable);
                CustomerParameterPanel customerParameterPanel10 = new CustomerParameterPanel("IPsec:", this.ipsecEnableComboBox, false);
                this.ipsecEnableComboBox.setEnabled(false);
                jPanelArray[11] = customerParameterPanel10;
            }
        }
        return jPanelArray;
    }

    private List createAllCpNamesList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.allCPNames) {
            arrayList.add(string);
        }
        return arrayList;
    }

    protected boolean next() {
        boolean bl = true;
        try {
            List list = this.createAllCpNamesList();
            this.rbs.checkConsistency("IpOamCI", list);
            String string = (String)this.transportOptionField.getSelectedItem();
            this.transportOptionPara.setValue(string);
            if (string.equals("ipV4")) {
                this.wizardHelp.excludeSlides("IpAtmPhysicalController", "IpAtmConfigurationController");
                this.wizardHelp.excludeSlides("AtmPortController", "AtmPortController");
                EthernetProvider ethernetProvider = (EthernetProvider)((Object)this.rbs.getConfigItem("EthernetSwitchCI"));
                if (!ethernetProvider.hasEthernetSwitch()) {
                    this.wizardHelp.excludeSlides("EthernetSwitchController", "EthernetSwitchController");
                }
                if (DuwUtil.hasDuw()) {
                    this.processOfSyncERef();
                    this.validateEsmcQulityLevel();
                }
            } else {
                this.wizardHelp.excludeSlides("IpHostLinkConfigurationController", "IpHostLinkConfigurationController");
                this.wizardHelp.excludeSlides("EthernetSwitchController", "EthernetSwitchController");
                this.wizardHelp.excludeSlides("IpSyncConfigurationController", "IpSyncConfigurationController");
            }
        }
        catch (CustomerParameterException customerParameterException) {
            CustomerParameter customerParameter = customerParameterException.getParameter();
            String string = customerParameter.getName();
            this.displayError(customerParameterException);
            this.setFocusOnComponent(string);
            bl = false;
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.currentClassName, "next()", null, "verifying user input for scrolling", exception);
            this.displayError(wizardException);
            bl = false;
        }
        return bl;
    }

    private void processOfSyncERef() throws BemException {
        if (this.gigabitEthernetPortCreatePara.getBooleanValue()) {
            NetworkSyncCI networkSyncCI = (NetworkSyncCI)this.rbs.getConfigItem("NetworkSyncCI");
            networkSyncCI.refreshCI();
        }
    }

    private void validateEsmcQulityLevel() throws CustomerParameterException {
        boolean bl = "Yes".equalsIgnoreCase(this.gigaBitEthernetEsmcSupport.getValue());
        if (bl) {
            int n = (Integer)this.rbs.getMoHandler().getMo("ManagedElement=1,TransportNetwork=1,Synchronization=1").getAttribute("telecomStandard");
            int n2 = (Integer)this.adminQuality.getValueMom();
            switch (n) {
                case 0: {
                    boolean bl2;
                    boolean bl3 = bl2 = n2 >= 0 && n2 <= 3;
                    if (bl2) break;
                    throw new CustomerParameterException("AdminQuality - The selected admin quality is not support by ETSI telecom standard", this.adminQuality);
                }
                case 1: {
                    boolean bl4;
                    boolean bl5 = bl4 = n2 >= 5 && n2 <= 11;
                    if (bl4) break;
                    throw new CustomerParameterException("AdminQuality - The selected admin quality is not support by ANSI telecom standard", this.adminQuality);
                }
                case 2: {
                    boolean bl6;
                    boolean bl7 = bl6 = n2 >= 14 && n2 <= 15;
                    if (bl6) break;
                    throw new CustomerParameterException("AdminQuality - The selected admin quality is not support by TTC telecom standard", this.adminQuality);
                }
            }
        }
    }

    protected boolean previous() {
        return true;
    }

    private void setFocusOnComponent(String string) {
        for (int i = 1; i < this.guiComponents.length; ++i) {
            CustomerParameterPanel customerParameterPanel = (CustomerParameterPanel)this.guiComponents[i];
            if (customerParameterPanel == null || !customerParameterPanel.containCustomerParameter(string)) continue;
            customerParameterPanel.requestFocus();
        }
    }
}

