/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTextField;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.networksync.NetworkSyncCI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComponent;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterList;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.model.OamCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.OamCustomerParameterComboBox;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.OamGuiComponentErrorManager;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.NetworkSynchRefViewer;

public class NetworkSynchRefController
extends BemWizardGuiController
implements OamGuiComponentErrorManager,
CustomerParameterListener {
    private static String NCONF_OAM_PAGE_HEADER = "O&M Access Configuration page {0}({1})";
    private NetworkSynchRefViewer myView = null;
    private WizardCIModel oamCIModel;
    private Rbs rbs;
    private CustomerParameterPanel[][] guiComponents = null;
    boolean isBemGuiComponentsCreated = false;
    private YesNoCustomerParameter configureCpriBasedSyncParameter = null;
    private AddButtonListener addSyncRiPortListener = null;
    private DeleteButtonListener deleteSyncRiPortListener = null;
    private Enumeration administrativeStateParam;
    private Enumeration syncNodePriorityParam;
    private Enumeration selectionMode;
    private CustomerParameter syncRiPortCandidateParam;

    protected void init() {
        this.myView = (NetworkSynchRefViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.oamCIModel = OamCIModel.getInstance();
        this.rbs = this.oamCIModel.getRbs();
        this.addSyncRiPortListener = new AddButtonListener();
        this.deleteSyncRiPortListener = new DeleteButtonListener();
        this.setWindowTitle();
    }

    protected void afterVisible() {
        try {
            if (super.getPreviousControllerClass() == null) {
                super.setPreviousEnabled(false);
            }
            NetworkSyncCI networkSyncCI = (NetworkSyncCI)this.rbs.getConfigItem("NetworkSyncCI");
            networkSyncCI.refreshCI();
            if (!this.isBemGuiComponentsCreated) {
                this.guiComponents = this.createGuiComponents();
                this.configureCpriBasedSyncParameter = (YesNoCustomerParameter)this.rbs.getCustomerParameterObject("configureCpriBasedSync");
                this.configureCpriBasedSyncParameter.addCustomerParameterListener(this);
                this.myView.setCpriBasedSyncConfigCheckBox(this.configureCpriBasedSyncParameter);
                if (this.configureCpriBasedSyncParameter.getValue().equals("YES")) {
                    this.administrativeStateParam = (Enumeration)this.rbs.getCustomerParameterObject("administrativeState");
                    this.selectionMode = (Enumeration)this.rbs.getCustomerParameterObject("selectionMode");
                    this.syncNodePriorityParam = (Enumeration)this.rbs.getCustomerParameterObject("syncNodePriority");
                    this.syncRiPortCandidateParam = this.rbs.getCustomerParameterObject("syncRiPortCandidate");
                    this.myView.setCpriBasedSyncConfigPanel(this.rbs, true, this.administrativeStateParam, this.selectionMode, this.syncNodePriorityParam, this.syncRiPortCandidateParam);
                    this.myView.getAddButton().addActionListener(this.addSyncRiPortListener);
                    this.myView.getDeleteButton().addActionListener(this.deleteSyncRiPortListener);
                }
                this.isBemGuiComponentsCreated = true;
                this.myView.setBemComponents(this.guiComponents);
            }
            this.addListeners();
            this.getWizardPresenter().sniff(this.getView());
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.getClass().getName(), "afterVisible()", null, "Setting up window for input", exception);
            super.displayError(wizardException);
        }
    }

    private CustomerParameterPanel[][] createGuiComponents() throws BemException {
        CustomerParameterPanel[][] customerParameterPanelArray = new CustomerParameterPanel[8][4];
        Integer n = null;
        String string = null;
        for (int i = 0; i < NetworkSyncCI.getNumberOfSyncs(); ++i) {
            CustomerParameterPanel customerParameterPanel;
            n = i + 1;
            string = MessageFormat.format("Y_{0}_", n);
            String string2 = string + "synchPriority";
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string2);
            JComponent jComponent = new CustomerParameterTextField(customerParameter);
            customerParameterPanelArray[i][0] = customerParameterPanel = new CustomerParameterPanel("", (CustomerParameterComponent)((Object)jComponent), false);
            string2 = string + "synchSlot";
            customerParameter = this.rbs.getCustomerParameterObject(string2);
            jComponent = new OamCustomerParameterComboBox((Enumeration)customerParameter, this);
            customerParameterPanelArray[i][1] = customerParameterPanel = new CustomerParameterPanel("", (CustomerParameterComponent)((Object)jComponent), false);
            string2 = string + "synchGuiBoard";
            customerParameter = this.rbs.getCustomerParameterObject(string2);
            jComponent = new CustomerParameterTextField(customerParameter);
            ((JTextField)jComponent).setColumns(5);
            customerParameterPanelArray[i][2] = customerParameterPanel = new CustomerParameterPanel("", (CustomerParameterComponent)((Object)jComponent), false);
            string2 = string + "synchPort";
            customerParameter = this.rbs.getCustomerParameterObject(string2);
            jComponent = new OamCustomerParameterComboBox((Enumeration)customerParameter, this);
            customerParameterPanelArray[i][3] = customerParameterPanel = new CustomerParameterPanel("", (CustomerParameterComponent)((Object)jComponent), false);
        }
        return customerParameterPanelArray;
    }

    private void setValueForSyncRiPortCandidateParam(CustomerParameterList customerParameterList) {
        try {
            String string = "syncRiPortCandidate";
            this.syncRiPortCandidateParam = this.rbs.getCustomerParameterObject(string);
            int n = customerParameterList.getNumberOfValues();
            StringBuffer stringBuffer = new StringBuffer(2 * n);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(customerParameterList.getELementAt(i).toString());
                if (i + 1 >= n) continue;
                stringBuffer.append(",");
            }
            String string2 = stringBuffer.toString();
            this.syncRiPortCandidateParam.setValue(string2);
        }
        catch (BemException bemException) {
            this.displayError(bemException);
        }
    }

    private void addListeners() {
        for (int i = 0; i < NetworkSyncCI.getNumberOfSyncs(); ++i) {
            CustomerParameterPanel customerParameterPanel = this.guiComponents[i][1];
            OamCustomerParameterComboBox oamCustomerParameterComboBox = (OamCustomerParameterComboBox)customerParameterPanel.getCustomerParameterComponent();
            oamCustomerParameterComboBox.addListener();
            CustomerParameterPanel customerParameterPanel2 = this.guiComponents[i][3];
            OamCustomerParameterComboBox oamCustomerParameterComboBox2 = (OamCustomerParameterComboBox)customerParameterPanel2.getCustomerParameterComponent();
            oamCustomerParameterComboBox2.addListener();
        }
    }

    private void removeListeners() {
        for (int i = 0; i < NetworkSyncCI.getNumberOfSyncs(); ++i) {
            CustomerParameterPanel customerParameterPanel = this.guiComponents[i][1];
            OamCustomerParameterComboBox oamCustomerParameterComboBox = (OamCustomerParameterComboBox)customerParameterPanel.getCustomerParameterComponent();
            oamCustomerParameterComboBox.removeListener();
            CustomerParameterPanel customerParameterPanel2 = this.guiComponents[i][3];
            OamCustomerParameterComboBox oamCustomerParameterComboBox2 = (OamCustomerParameterComboBox)customerParameterPanel2.getCustomerParameterComponent();
            oamCustomerParameterComboBox2.removeListener();
        }
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = NCONF_OAM_PAGE_HEADER;
        String string3 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string4 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format(string2, string3, string4));
    }

    protected boolean next() {
        boolean bl = true;
        try {
            this.rbs.checkConsistency("NetworkSyncCI");
            this.removeListeners();
        }
        catch (CustomerParameterException customerParameterException) {
            this.displayError(customerParameterException);
            bl = false;
        }
        catch (BemException bemException) {
            this.displayError(bemException);
            bl = false;
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.currentClassName, "next()", null, "verifying user input for scrolling", exception);
            this.displayError(wizardException);
            bl = false;
        }
        return bl;
    }

    protected boolean previous() {
        this.removeListeners();
        return true;
    }

    protected boolean cancel() {
        this.removeListeners();
        return super.cancel();
    }

    public void handleSetError(Exception exception) {
        this.displayError(exception);
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (parameterEvent.isValueChanged()) {
            String string = customerParameter.getName();
            try {
                this.administrativeStateParam = (Enumeration)this.rbs.getCustomerParameterObject("administrativeState");
                this.selectionMode = (Enumeration)this.rbs.getCustomerParameterObject("selectionMode");
                this.syncNodePriorityParam = (Enumeration)this.rbs.getCustomerParameterObject("syncNodePriority");
                this.syncRiPortCandidateParam = this.rbs.getCustomerParameterObject("syncRiPortCandidate");
                if (string.equalsIgnoreCase(this.configureCpriBasedSyncParameter.getName())) {
                    if (this.configureCpriBasedSyncParameter.getValue().equals("YES")) {
                        this.myView.setCpriBasedSyncConfigPanel(this.rbs, true, this.administrativeStateParam, this.selectionMode, this.syncNodePriorityParam, this.syncRiPortCandidateParam);
                        this.myView.getAddButton().addActionListener(this.addSyncRiPortListener);
                        this.myView.getDeleteButton().addActionListener(this.deleteSyncRiPortListener);
                    } else if (this.myView.cpriBasedSyncPanelIsSet()) {
                        this.myView.getAddButton().removeActionListener(this.addSyncRiPortListener);
                        this.myView.getDeleteButton().removeActionListener(this.deleteSyncRiPortListener);
                        this.myView.setCpriBasedSyncConfigPanel(this.rbs, false, this.administrativeStateParam, this.selectionMode, this.syncNodePriorityParam, this.syncRiPortCandidateParam);
                    }
                }
            }
            catch (BemException bemException) {
                this.displayError(bemException);
            }
        }
    }

    class DeleteButtonListener
    implements ActionListener {
        DeleteButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            CustomerParameterList customerParameterList = (CustomerParameterList)NetworkSynchRefController.this.myView.getRiPortLeftComponent();
            CustomerParameterList customerParameterList2 = (CustomerParameterList)NetworkSynchRefController.this.myView.getRiPortRightComponent();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n2 = customerParameterList.getNumberOfValues();
            for (n = 0; n < n2; ++n) {
                arrayList.add(customerParameterList.getELementAt(n));
            }
            if (customerParameterList2.getSelectedValue() != null) {
                arrayList.add(customerParameterList2.getSelectedValue());
                customerParameterList2.removeElement(customerParameterList2.getSelectedValue());
                this.sort(arrayList);
                customerParameterList.cleanList();
                for (n = 0; n < arrayList.size(); ++n) {
                    customerParameterList.addElement(arrayList.get(n));
                }
                if (customerParameterList2.getNumberOfValues() == 0) {
                    NetworkSynchRefController.this.myView.getDeleteButton().setEnabled(false);
                }
                if (customerParameterList.getNumberOfValues() > 0) {
                    NetworkSynchRefController.this.myView.getAddButton().setEnabled(true);
                }
                NetworkSynchRefController.this.setValueForSyncRiPortCandidateParam(customerParameterList2);
            }
        }

        private void sort(ArrayList arrayList) {
            String string = "";
            String string2 = "";
            int n = arrayList.size();
            for (int i = 0; i < arrayList.size() - 1; ++i) {
                for (int j = 0; j < n - 1; ++j) {
                    string = arrayList.get(j).toString();
                    int n2 = string.compareToIgnoreCase(string2 = arrayList.get(j + 1).toString());
                    if (n2 < 0) continue;
                    arrayList.set(j, string2);
                    arrayList.set(j + 1, string);
                }
                --n;
            }
        }
    }

    class AddButtonListener
    implements ActionListener {
        AddButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CustomerParameterList customerParameterList = (CustomerParameterList)NetworkSynchRefController.this.myView.getRiPortLeftComponent();
            CustomerParameterList customerParameterList2 = (CustomerParameterList)NetworkSynchRefController.this.myView.getRiPortRightComponent();
            if (customerParameterList.getSelectedValue() != null) {
                customerParameterList2.addElement(customerParameterList.getSelectedValue());
                customerParameterList.removeElement(customerParameterList.getSelectedValue());
                if (customerParameterList.getNumberOfValues() == 0) {
                    NetworkSynchRefController.this.myView.getAddButton().setEnabled(false);
                }
                if (customerParameterList2.getNumberOfValues() > 0) {
                    NetworkSynchRefController.this.myView.getDeleteButton().setEnabled(true);
                }
                NetworkSynchRefController.this.setValueForSyncRiPortCandidateParam(customerParameterList2);
            }
        }
    }
}

