/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JPanel;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.EtbSlotParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.PhysicalLineParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationTypeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TimeSlotsInFractionParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComboBox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTable;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTableModel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLanguageHelp;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractDialogView;

public class AddAtmPortDialogView
extends AbstractDialogView {
    public static final String LABEL_ETB_IN_SLOT = "ETB in slot:";
    public static final String LABEL_ETB_LINE = "ETB line:";
    public static final String LABEL_TERMINATION_TYPE = "Termination type:";
    public static final String LABEL_ETB_LINES_IMA = "ETB lines (IMA):";
    public static final String LABEL_REQ_NO_OF_LINKS = "Required number of links:";
    public static final String LABEL_SLOTS_IN_FRACTION = "Time slots in fraction:";
    protected static final String[] COLUMN_NAMES_FOR_IMA_LINES = new String[]{"ETB line", "Used"};
    protected static final String[] COLUMN_NAMES_FOR_SLOTS_IN_FRACTION = new String[]{"Time slot", "Active"};
    private final JButton addButton = new JButton();
    private final JButton cancelButton = new JButton();
    private final JPanel mainPanel = new JPanel();
    private final JPanel atmGroupBox = new JPanel();
    private final JPanel buttonPanel = new JPanel();
    private CustomerParameterPanel availableSlotsPanel = null;
    private CustomerParameterComboBox availableSlotsCombo = null;
    private CustomerParameterPanel terminationTypesPanel = null;
    private CustomerParameterComboBox terminationTypesCombo = null;
    private CustomerParameterPanel linesPanel = null;
    private CustomerParameterComboBox linesCombo = null;
    private CustomerParameterTableModel imaLinesTableModel = null;
    private CustomerParameterPanel imaLinesPanel = null;
    private CustomerParameterTable imaLinesTable = null;
    private CustomerParameterPanel requiredNumberOfLinksPanel = null;
    private CustomerParameterTextField requiredNumberOfLinksComponent = null;
    private CustomerParameterTableModel timeSlotsFractionModel = null;
    private CustomerParameterPanel timeSlotsFractionPanel = null;
    private CustomerParameterTable timeSlotsFractionTable = null;

    protected void init() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(370, 260));
        this.mainPanel.setLayout(new GridBagLayout());
        this.atmGroupBox.setLayout(new GridBagLayout());
        this.initButtons();
        this.mainPanel.add((Component)this.atmGroupBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 14, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
    }

    private void initButtons() {
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.addButton.setText(WizardLanguageHelp.getTranslation("NCONF_OAM_ATMPORT_ADD_BUTTONLABEL"));
        this.cancelButton.setText(WizardLanguageHelp.getTranslation("GSL_CANCEL"));
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(this.cancelButton);
    }

    public void setEtbSlotParameter(EtbSlotParameter etbSlotParameter) {
        this.availableSlotsCombo = new CustomerParameterComboBox(etbSlotParameter);
        this.availableSlotsPanel = new CustomerParameterPanel(LABEL_ETB_IN_SLOT, this.availableSlotsCombo, false);
        this.setBemComponent(this.availableSlotsPanel, 0);
    }

    public void setTerminationTypeParameter(TerminationTypeParameter terminationTypeParameter) {
        this.terminationTypesCombo = new CustomerParameterComboBox(terminationTypeParameter);
        this.terminationTypesPanel = new CustomerParameterPanel(LABEL_TERMINATION_TYPE, this.terminationTypesCombo, false);
        this.setBemComponent(this.terminationTypesPanel, 1);
    }

    public void setPhysicalLineParameter(PhysicalLineParameter physicalLineParameter) {
        this.linesCombo = new CustomerParameterComboBox(physicalLineParameter);
        this.linesPanel = new CustomerParameterPanel(LABEL_ETB_LINE, this.linesCombo, false);
        this.setBemComponent(this.linesPanel, 2);
    }

    public void setPhysicalLineParameterForIma(PhysicalLineParameter physicalLineParameter) {
        if (this.imaLinesTableModel != null) {
            this.imaLinesTableModel.deleteAllRows();
        }
        this.imaLinesTableModel = new CustomerParameterTableModel(physicalLineParameter, COLUMN_NAMES_FOR_IMA_LINES);
        this.imaLinesTableModel.setEditableColumn(0, false);
        this.imaLinesTable = new CustomerParameterTable(this.imaLinesTableModel);
        int n = this.imaLinesTableModel.getRowCount();
        if (n >= 5) {
            this.imaLinesTable.setPreferredScrollableViewportSize(this.imaLinesTable.calculatePreferredScrollableViewportSize(5));
        } else {
            this.imaLinesTable.setPreferredScrollableViewportSize(this.imaLinesTable.calculatePreferredScrollableViewportSize(n));
        }
        this.imaLinesTable.setRowSelectionAllowed(true);
        this.imaLinesTable.setSelectionMode(0);
        this.imaLinesPanel = new CustomerParameterPanel(LABEL_ETB_LINES_IMA, this.imaLinesTable, false);
        this.setBemComponent(this.imaLinesPanel, 3);
    }

    public void setReqNumberOfLinksParameter(IntegerParameter integerParameter) {
        this.requiredNumberOfLinksComponent = new CustomerParameterTextField(integerParameter);
        this.requiredNumberOfLinksComponent.setColumns(3);
        this.requiredNumberOfLinksPanel = new CustomerParameterPanel(LABEL_REQ_NO_OF_LINKS, this.requiredNumberOfLinksComponent, false);
        this.setBemComponent(this.requiredNumberOfLinksPanel, 4);
    }

    public void setTimeSlotsInFractionParameter(TimeSlotsInFractionParameter timeSlotsInFractionParameter) {
        if (this.timeSlotsFractionModel != null) {
            this.timeSlotsFractionModel.deleteAllRows();
        }
        this.timeSlotsFractionModel = new CustomerParameterTableModel(timeSlotsInFractionParameter, COLUMN_NAMES_FOR_SLOTS_IN_FRACTION);
        this.timeSlotsFractionModel.setEditableColumn(0, false);
        this.timeSlotsFractionTable = new CustomerParameterTable(this.timeSlotsFractionModel);
        this.timeSlotsFractionTable.setPreferredScrollableViewportSize(this.imaLinesTable.calculatePreferredScrollableViewportSize(5));
        this.timeSlotsFractionTable.setRowSelectionAllowed(true);
        this.imaLinesTable.setSelectionMode(0);
        this.timeSlotsFractionPanel = new CustomerParameterPanel(LABEL_SLOTS_IN_FRACTION, this.timeSlotsFractionTable, false);
        this.setBemComponent(this.timeSlotsFractionPanel, 5);
    }

    private void setBemComponent(CustomerParameterPanel customerParameterPanel, int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 5, 0, 0);
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 0;
        this.atmGroupBox.add((Component)customerParameterPanel.getLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.atmGroupBox.add((Component)customerParameterPanel, gridBagConstraints);
    }

    public CustomerParameterComboBox getEtbSlotComboBox() {
        return this.availableSlotsCombo;
    }

    public CustomerParameterComboBox getTerminationTypeComboBox() {
        return this.terminationTypesCombo;
    }

    public CustomerParameterComboBox getPhysicalLinesComboBox() {
        return this.linesCombo;
    }

    public CustomerParameterTextField getRequiredNumberOfLinksComponent() {
        return this.requiredNumberOfLinksComponent;
    }

    public void showEtbLineComponent(boolean bl) {
        this.linesPanel.setVisible(bl);
        this.linesPanel.getLabel().setVisible(bl);
    }

    public void showImaEtbLinesComponent(boolean bl) {
        this.imaLinesPanel.setVisible(bl);
        this.imaLinesPanel.getLabel().setVisible(bl);
        this.requiredNumberOfLinksPanel.setVisible(bl);
        this.requiredNumberOfLinksPanel.getLabel().setVisible(bl);
    }

    public void showTimeSlotsComponent(boolean bl) {
        this.timeSlotsFractionPanel.setVisible(bl);
        this.timeSlotsFractionPanel.getLabel().setVisible(bl);
    }

    public String getSelectedSlot() {
        return (String)this.availableSlotsCombo.getSelectedItem();
    }

    public String getSelectedTerminationType() {
        return (String)this.terminationTypesCombo.getSelectedItem();
    }

    public String getSelectedLine() {
        return (String)this.linesCombo.getSelectedItem();
    }

    public CustomerParameterTableModel getImaLinesTableModel() {
        return this.imaLinesTableModel;
    }

    public CustomerParameterTableModel getTimeSlotsFractionModel() {
        return this.timeSlotsFractionModel;
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void editingStopped() {
    }
}

