/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterList;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemCheckBoxSingle;
import se.ericsson.wcdma.rbs.bem.common.util.BemLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.control.AbstractFlexFileInputController;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.util.BemFileFilter;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.FileInputSiteViewer;

public class FileInputSiteController
extends AbstractFlexFileInputController {
    private String myControllerClassName;
    private FileInputSiteViewer view;
    private ButtonAddTmfFileListener buttonAddTmfFileListener;
    private ButtonRemoveTmfFileListener buttonRemoveTmfFileListener;
    private static final String tmfFileNameError = "TMF data files have to use the naming convention\nTmfData_S<sectorNumber>_V<versionNumber>.bin";

    protected void init() {
        super.setErrorTitle("NCONF_ERROR_WINDOW_TITLE");
        super.setFlexModel(SiteCIModel.getInstance());
        this.wizardHelp = WizardHelp.getTheInstance();
        super.init();
        this.wizardControllerClassName = this.myControllerClassName = this.getClass().getName();
        super.setWindowTitle("Site Equipment Configuration page {0}({1})");
        this.view = (FileInputSiteViewer)((Object)this.getView());
        this.buttonAddTmfFileListener = new ButtonAddTmfFileListener();
        this.buttonRemoveTmfFileListener = new ButtonRemoveTmfFileListener();
        ((BemCheckBoxSingle)this.view.getCheckBoxAddTmfFileComponent()).setActionListener(new CheckBoxAddTmfFilesListener(), null);
    }

    protected void beforeVisible() {
        if (super.getPreviousControllerClass() == null) {
            super.setPreviousEnabled(false);
            super.setPreviousVisible(false);
        }
    }

    protected boolean next() {
        boolean bl = true;
        try {
            bl = super.next();
            WizardCIModel wizardCIModel = super.getFlexModel();
            boolean bl2 = wizardCIModel.getUseWizard();
            boolean bl3 = wizardCIModel.getUseFileInput();
            if (bl3 && !bl2) {
                this.wizardHelp.useInputFileWithoutWizard();
            }
            if (!bl3 || bl2) {
                this.wizardHelp.restoreSlideOrder();
            }
            if (bl && bl3) {
                bl = super.parseXML();
            }
            CustomerParameterList customerParameterList = (CustomerParameterList)this.view.getTmfFilesComponent();
            String string = "";
            if (customerParameterList != null) {
                int n = customerParameterList.getNumberOfValues();
                StringBuffer stringBuffer = new StringBuffer(2 * n);
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(customerParameterList.getELementAt(i).toString());
                    stringBuffer.append("\n");
                }
                string = stringBuffer.toString();
            }
            SiteCIModel.getInstance().setTmfFiles(string);
            if (string.equals("")) {
                SiteCIModel.getInstance().setTmfFilesToAdd(false);
            } else {
                SiteCIModel.getInstance().setTmfFilesToAdd(true);
            }
        }
        catch (Exception exception) {
            super.displayErrorMessage("Error message: " + exception.getMessage());
            bl = false;
        }
        return bl;
    }

    protected boolean cancel() {
        boolean bl = super.cancel();
        FileInputSiteViewer fileInputSiteViewer = (FileInputSiteViewer)((Object)this.getView());
        if (fileInputSiteViewer != null && fileInputSiteViewer.tmfPanelIsSet()) {
            ((JButton)fileInputSiteViewer.getButtonAddTmfFileComponent()).removeActionListener(this.getButtonAddTmfFileListener());
            ((JButton)fileInputSiteViewer.getButtonRemoveTmfFileComponent()).removeActionListener(this.getButtonRemoveTmfFileListener());
            fileInputSiteViewer.setTmfPanel(false);
            SiteCIModel.getInstance().setTmfFiles("");
            SiteCIModel.getInstance().setTmfFilesToAdd(false);
        }
        return bl;
    }

    private boolean checkInputConsistency(String string) {
        String string2 = System.getProperty("file.separator");
        String[] stringArray = (string = string.substring(string.lastIndexOf(string2) + 1)).split("_");
        if (stringArray.length != 3) {
            this.displayErrorMessage(tmfFileNameError);
            return false;
        }
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        String string5 = stringArray[2];
        if (!(string3.equals("TmfData") && string4.startsWith("S") && string5.startsWith("V"))) {
            this.displayErrorMessage(tmfFileNameError);
            return false;
        }
        return true;
    }

    public ButtonAddTmfFileListener getButtonAddTmfFileListener() {
        return this.buttonAddTmfFileListener;
    }

    public ButtonRemoveTmfFileListener getButtonRemoveTmfFileListener() {
        return this.buttonRemoveTmfFileListener;
    }

    class ButtonRemoveTmfFileListener
    implements ActionListener {
        ButtonRemoveTmfFileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CustomerParameterList customerParameterList = (CustomerParameterList)FileInputSiteController.this.view.getTmfFilesComponent();
            customerParameterList.removeElement(customerParameterList.getSelectedValue());
            FileInputSiteController.this.view.getButtonAddTmfFileComponent().setEnabled(true);
            if (customerParameterList.getNumberOfValues() == 0) {
                FileInputSiteController.this.view.getButtonRemoveTmfFileComponent().setEnabled(false);
            }
        }
    }

    class ButtonAddTmfFileListener
    implements ActionListener {
        ButtonAddTmfFileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Properties properties = System.getProperties();
            String string = (String)properties.get(BemLanguageHelp.getTranslation("USER_HOME"));
            JFileChooser jFileChooser = new JFileChooser(string);
            BemFileFilter bemFileFilter = new BemFileFilter("bin", "BIN files");
            jFileChooser.setFileFilter(bemFileFilter);
            jFileChooser.setDialogTitle("Open Configuration File");
            int n = jFileChooser.showDialog((JButton)actionEvent.getSource(), "Open");
            if (n == 0) {
                String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                if (!FileInputSiteController.this.checkInputConsistency(string2)) {
                    return;
                }
                CustomerParameterList customerParameterList = (CustomerParameterList)FileInputSiteController.this.view.getTmfFilesComponent();
                if (!customerParameterList.checkObjectContains(string2)) {
                    if (customerParameterList.getNumberOfValues() < 3) {
                        customerParameterList.addElement(string2);
                        FileInputSiteController.this.view.getButtonRemoveTmfFileComponent().setEnabled(true);
                        if (customerParameterList.getNumberOfValues() == 3) {
                            FileInputSiteController.this.view.getButtonAddTmfFileComponent().setEnabled(false);
                        }
                    } else {
                        FileInputSiteController.this.displayErrorMessage("At most 3 TMF files can be added at the same time!");
                    }
                } else {
                    FileInputSiteController.this.displayErrorMessage("File already added into TMF file List!");
                }
            }
        }
    }

    class CheckBoxAddTmfFilesListener
    implements ActionListener {
        CheckBoxAddTmfFilesListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileInputSiteViewer fileInputSiteViewer = (FileInputSiteViewer)((Object)FileInputSiteController.this.getView());
            Boolean bl = fileInputSiteViewer.isTmfFileToAdd();
            SiteCIModel.getInstance().setTmfFilesToAdd(bl);
            if (bl.booleanValue()) {
                fileInputSiteViewer.setTmfPanel(true);
                ((JButton)fileInputSiteViewer.getButtonAddTmfFileComponent()).addActionListener(FileInputSiteController.this.getButtonAddTmfFileListener());
                ((JButton)fileInputSiteViewer.getButtonRemoveTmfFileComponent()).addActionListener(FileInputSiteController.this.getButtonRemoveTmfFileListener());
            } else if (fileInputSiteViewer.tmfPanelIsSet()) {
                ((JButton)fileInputSiteViewer.getButtonAddTmfFileComponent()).removeActionListener(FileInputSiteController.this.getButtonAddTmfFileListener());
                ((JButton)fileInputSiteViewer.getButtonRemoveTmfFileComponent()).removeActionListener(FileInputSiteController.this.getButtonRemoveTmfFileListener());
                fileInputSiteViewer.setTmfPanel(false);
            }
        }
    }
}

