/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.HsdpaResourcesProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.HsdpaAndEulViewer;

public class HsdpaAndEulController
extends BemWizardGuiController {
    private HsdpaAndEulViewer myView;
    private WizardCIModel siteCIModel = SiteCIModel.getInstance();
    private final List cpNamesHsResource = new ArrayList();
    private final List cpNamesEulResource = new ArrayList();
    private final List cpNamesHsResourceId = new ArrayList();
    private Rbs rbs;
    private static final String SECTOR_COLUMN_HEADER = "Sector={0}";
    private static final String HS_CODE_RESOURCE_ID_HEADER = "Carrier {0} HS code resource ID:";
    private RadioEquipmentProvider[] radioEquipmentProvider = new RadioEquipmentProvider[2];
    private HsdpaResourcesProvider[] hspaProvider = new HsdpaResourcesProvider[2];

    protected void init() {
        this.myView = (HsdpaAndEulViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.siteCIModel = SiteCIModel.getInstance();
        this.rbs = this.siteCIModel.getRbs();
        this.radioEquipmentProvider[0] = (RadioEquipmentProvider)this.rbs.getProvider(RadioEquipmentProvider.class);
        this.hspaProvider[0] = (HsdpaResourcesProvider)this.rbs.getProvider(HsdpaResourcesProvider.class);
        if (this.rbs.isPantherHybridRbs()) {
            this.radioEquipmentProvider[1] = (RadioEquipmentProvider)this.rbs.getProvider(RadioEquipmentProvider.class, 1);
            this.hspaProvider[1] = (HsdpaResourcesProvider)this.rbs.getProvider(HsdpaResourcesProvider.class, 1);
        }
        this.setWindowTitle();
    }

    protected void afterVisible() {
        try {
            if (this.radioEquipmentProvider[0] instanceof RadioEquipmentProviderWithRbb) {
                this.myView.initiateMainPanel();
            }
            int n = this.radioEquipmentProvider[0].getNumberOfDuwSlots();
            if (this.rbs.isPantherHybridRbs()) {
                if (!(this.radioEquipmentProvider[0] instanceof RadioEquipmentProviderWithRbb) && this.radioEquipmentProvider[1] instanceof RadioEquipmentProviderWithRbb) {
                    this.myView.initiateMainPanel();
                }
                n += this.radioEquipmentProvider[1].getNumberOfDuwSlots();
            }
            this.myView.setNumberOfDuwSlots(n);
            for (int i = 0; i < n; ++i) {
                String[] stringArray = this.getTxBSlots(i);
                if (stringArray == null || stringArray.length == 0) {
                    this.myView.displayNoSlotsForHsdpa(i);
                    continue;
                }
                this.setNumHsCodeAndNumEulResourceTableElements(i);
                this.setHsCodeResourceIdTableElements(i);
                if (!this.rbs.isPantherHybridRbs() && this.hspaProvider[0].isTxbStaticallyLoaded(i) || this.rbs.isPantherHybridRbs() && i == 0 && this.hspaProvider[0].isTxbStaticallyLoaded(i) || this.rbs.isPantherHybridRbs() && i == 1 && this.hspaProvider[1].isTxbStaticallyLoaded(i)) {
                    this.myView.displayStaticLoading(i);
                } else {
                    this.setSteeredHsAllocation();
                }
                this.myView.setFocusFixListeners(i);
            }
        }
        catch (BemException bemException) {
            WizardException wizardException = new WizardException(this.getClass().getName(), "hsdpa and Eul Controlller afterVisible()", null, "Setting up GUI. ", bemException);
            this.displayError(wizardException);
        }
    }

    private void setSteeredHsAllocation() throws BemException {
        TrueFalseCustomerParameter trueFalseCustomerParameter = (TrueFalseCustomerParameter)this.rbs.getCustomerParameterObject("steeredHsAllocation");
        this.myView.setSteeredHSAllocation(trueFalseCustomerParameter);
    }

    private void setHsCodeResourceIdTableElements(int n) throws BemException {
        this.rbs = this.siteCIModel.getRbs();
        RadioEquipmentProvider radioEquipmentProvider = null;
        radioEquipmentProvider = this.rbs.isPantherHybridRbs() && n == 1 ? this.radioEquipmentProvider[1] : this.radioEquipmentProvider[0];
        int[] nArray = radioEquipmentProvider.getEquippedSectors(n);
        int n2 = nArray.length;
        int n3 = this.rbs.getMaxNumberOfCarriers();
        Object[][] objectArray = new Object[n3][n2];
        String[] stringArray = new String[n3];
        for (int i = 1; i <= n3; ++i) {
            stringArray[i - 1] = MessageFormat.format(HS_CODE_RESOURCE_ID_HEADER, String.valueOf(i));
        }
        String[] stringArray2 = new String[n2 + 1];
        stringArray2[0] = "";
        for (int i = 0; i < n2; ++i) {
            String string = String.valueOf(nArray[i]);
            stringArray2[i + 1] = MessageFormat.format(SECTOR_COLUMN_HEADER, string);
            for (int j = 0; j < n3; ++j) {
                Object object;
                String string2 = MessageFormat.format("S{0}_", string);
                String string3 = MessageFormat.format("C{0}_", String.valueOf(j + 1));
                String string4 = string2 + string3;
                String string5 = string4 + "hsCodeResourceId";
                boolean bl = this.rbs.isParameterSupported(string5);
                if (bl) {
                    object = radioEquipmentProvider.getCarriersInSector(n, nArray[i]);
                    boolean bl2 = false;
                    if (object != null) {
                        for (int k = 0; k < ((int[])object).length; ++k) {
                            if (object[k] != j + 1) continue;
                            bl2 = true;
                            break;
                        }
                    }
                    bl = bl2;
                }
                if (bl) {
                    object = this.rbs.getCustomerParameterObject(string5);
                    objectArray[j][i] = object;
                    this.cpNamesHsResourceId.add(string5);
                    continue;
                }
                object = new CustomerParameterImpl("Dummy Customer Parameter", new StringRange(0, 0));
                ParameterRestriction parameterRestriction = new ParameterRestriction("Dummy Parameter Restriction");
                parameterRestriction.setAccessLevel(1);
                ((CustomerParameterImpl)object).addRestriction(parameterRestriction);
                objectArray[j][i] = object;
            }
        }
        this.myView.setHsCodeResourceIdTableParameters(n, objectArray, stringArray, stringArray2);
    }

    private String[] getTxBSlots(int n) {
        String[] stringArray = this.rbs.isPantherHybridRbs() && n == 1 ? this.radioEquipmentProvider[1].getSlotArrayForTxDevices(n) : this.radioEquipmentProvider[0].getSlotArrayForTxDevices(n);
        return stringArray;
    }

    private void setNumHsCodeAndNumEulResourceTableElements(int n) {
        try {
            String[] stringArray = new String[]{"Num HS code resources:", "Num EUL resources:"};
            String[] stringArray2 = this.getTxBSlots(n);
            int n2 = stringArray2.length;
            if (n2 > 0) {
                Object[][] objectArray = new Object[2][n2];
                String[] stringArray3 = new String[n2 + 1];
                stringArray3[0] = " ";
                String string = "TXB on slot {0}";
                if (DuwUtil.hasDuw()) {
                    string = "DUW on slot {0}";
                }
                for (int i = 0; i < n2; ++i) {
                    String string2 = "";
                    String string3 = "";
                    String string4 = stringArray2[i];
                    stringArray3[i + 1] = MessageFormat.format(string, string4);
                    String string5 = MessageFormat.format("hsSlot{0}_", string4);
                    String string6 = MessageFormat.format("eulSlot{0}_", string4);
                    if (!this.rbs.isPantherHybridRbs() && this.hspaProvider[0].isTxbStaticallyLoaded(n) || this.rbs.isPantherHybridRbs() && this.hspaProvider[n].isTxbStaticallyLoaded(n)) {
                        string2 = string5 + "staticNumHsCodeResources";
                        string3 = string6 + "staticNumEulResources";
                    } else {
                        string2 = string5 + "numHsCodeResources";
                        string3 = string6 + "numEulResources";
                    }
                    CustomerParameterImpl customerParameterImpl = (CustomerParameterImpl)this.rbs.getCustomerParameterObject(string2);
                    objectArray[0][i] = customerParameterImpl;
                    this.cpNamesHsResource.add(string2);
                    CustomerParameterImpl customerParameterImpl2 = (CustomerParameterImpl)this.rbs.getCustomerParameterObject(string3);
                    objectArray[1][i] = customerParameterImpl2;
                    this.cpNamesEulResource.add(string3);
                }
                this.myView.setNumHsCodeAndNumEulResourceTableParameters(n, objectArray, stringArray, stringArray3);
            }
        }
        catch (Exception exception) {
            this.displayError(exception);
        }
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format("Site Equipment Configuration page {0}({1})", string2, string3));
    }

    protected boolean next() {
        boolean bl = true;
        try {
            int n = this.radioEquipmentProvider[0].getNumberOfDuwSlots();
            if (this.rbs.isPantherHybridRbs()) {
                n += this.radioEquipmentProvider[1].getNumberOfDuwSlots();
            }
            boolean bl2 = false;
            for (int i = 0; i < n; ++i) {
                String[] stringArray = this.getTxBSlots(i);
                if (stringArray == null || stringArray.length == 0) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return bl;
            }
            this.myView.editingStopped();
            this.rbs = this.siteCIModel.getRbs();
            this.rbs.checkConsistency("RadioEquipmentCI", this.cpNamesHsResource);
            this.rbs.checkConsistency("RadioEquipmentCI", this.cpNamesEulResource);
            this.rbs.checkConsistency("CellAndCarrierCI", this.cpNamesHsResourceId);
        }
        catch (CustomerParameterException customerParameterException) {
            CustomerParameter customerParameter = customerParameterException.getParameter();
            String string = customerParameter.getName();
            String string2 = this.myView.getGuiNameForCustomerParameter(string);
            this.displayErrorMessage(string2 + "\n" + customerParameterException.getReason());
            this.myView.setFocusOnCustomerParameterComponent(string);
            bl = false;
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.currentClassName, "next()", null, "verifying user input for scrolling", exception);
            this.displayError(wizardException);
            bl = false;
        }
        return bl;
    }

    protected boolean previous() {
        return true;
    }
}

