/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTable;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterViewer;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;

public class SectorOptionsDuwView
extends BemWizardGuiView
implements CustomerParameterViewer {
    private static final String SECTOR_COLUMN_NAME = "Sector";
    private static final String LINERATE_COLUMN_NAME = "Line rate";
    private static final String RBB_COLUMN_NAME = "Radio building block";
    private static final String PRIMARY_COLUMN_NAME = "Primary port id";
    private static final String SECONDARY_COLUMN_NAME = "Secondary port id";
    private static final String SEQUENCE_COLUMN_NAME = "Sector sequence";
    private static final String AU_UNIT_TYPE_COLUMN_NAME = "Unit type";
    private static final String RADIO_SHARE_COLUMN_NAME = "Radio shared by";
    private static final String[] COLUMN_NAMES = new String[]{"Sector", "Radio building block", "Line rate", "Primary port id", "Secondary port id", "Sector sequence", "Unit type"};
    private static final String[] COLUMN_NAMES_WITH_RADIOSHAREDBY = new String[]{"Sector", "Radio building block", "Line rate", "Primary port id", "Secondary port id", "Sector sequence", "Unit type", "Radio shared by"};
    private static final int TABLE_COLUMNS = COLUMN_NAMES.length;
    private static final String[] COLUMN_NAMES_HYBRIDBBP1 = new String[]{"Sector", "Radio building block"};
    private Enumeration[] radioBuildingBlockParameters;
    private Enumeration[] sectorSequenceParameters;
    private Enumeration[] primaryPortIdParameters;
    private Enumeration[] secondaryPortIdParameters;
    private Enumeration[] lineRateParameters;
    private Enumeration[] auUnitTypeParameters;
    private Enumeration[] radioSharedBySectorParameters;
    private CustomerParameterTable sectorOptionstableTable;
    private int numberOfSectors;

    protected void init() {
        super.init();
    }

    public void setRadioBuildingBlock(Enumeration[] enumerationArray) {
        this.radioBuildingBlockParameters = enumerationArray;
    }

    public void setSectorSequence(Enumeration[] enumerationArray) {
        this.sectorSequenceParameters = enumerationArray;
    }

    public void setPrimaryPortId(Enumeration[] enumerationArray) {
        this.primaryPortIdParameters = enumerationArray;
    }

    public void setSecondaryPortId(Enumeration[] enumerationArray) {
        this.secondaryPortIdParameters = enumerationArray;
    }

    public void setLineRate(Enumeration[] enumerationArray) {
        this.lineRateParameters = enumerationArray;
    }

    public void setRadioSharedBySector(Enumeration[] enumerationArray) {
        this.radioSharedBySectorParameters = enumerationArray;
    }

    public void setAuUnitType(Enumeration[] enumerationArray) {
        this.auUnitTypeParameters = enumerationArray;
    }

    public void setNumberOfSectors(int n) {
        this.numberOfSectors = n;
    }

    public String getGuiNameForCustomerParameter(String string) {
        String string2 = null;
        if (this.sectorOptionstableTable != null && this.sectorOptionstableTable.isParameterInTable(string)) {
            string2 = this.sectorOptionstableTable.getRowAndColumnName(string);
        }
        return string2;
    }

    public void setFocusOnCustomerParameterComponent(String string) {
        if (this.sectorOptionstableTable != null && this.sectorOptionstableTable.isParameterInTable(string)) {
            this.sectorOptionstableTable.setFocusOnCell(string);
        }
    }

    public void updateGui() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        try {
            if (DuwUtil.isPantherHybridRbs()) {
                jPanel.add((Component)this.createPantherHybridSectorOptionsPanel(), gridBagConstraints);
            } else {
                jPanel.add((Component)this.createSectorOptionsPanel(), gridBagConstraints);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        this.addMainPanel(jPanel);
    }

    private JPanel createPantherHybridSectorOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Sector options"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = this.numberOfSectors / 2;
        Object[][] objectArray = new Object[n][2];
        for (int i = 0; i < n; ++i) {
            objectArray[i][0] = this.radioBuildingBlockParameters[i].getLoadedValue().equals("") ? "-" : this.radioBuildingBlockParameters[i].getValue();
        }
        this.sectorOptionstableTable = new CustomerParameterTable(objectArray, this.getRowNames(this.numberOfSectors / 2), COLUMN_NAMES_HYBRIDBBP1);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.gridy = -1;
        jPanel.add((Component)new JScrollPane(this.sectorOptionstableTable), gridBagConstraints);
        Object[][] objectArray2 = new Enumeration[n][TABLE_COLUMNS];
        for (int i = 0; i < n; ++i) {
            objectArray2[i][0] = this.radioBuildingBlockParameters[i + n];
            objectArray2[i][1] = this.lineRateParameters[i + n];
            objectArray2[i][2] = this.primaryPortIdParameters[i + n];
            objectArray2[i][3] = this.secondaryPortIdParameters[i + n];
            objectArray2[i][4] = this.sectorSequenceParameters[i + n];
            objectArray2[i][5] = this.auUnitTypeParameters[i + n];
        }
        this.sectorOptionstableTable = new CustomerParameterTable(objectArray2, this.getRowNames(this.numberOfSectors / 2, 7), COLUMN_NAMES);
        this.adjustColumnWidths(COLUMN_NAMES.length);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.gridy = -1;
        jPanel.add((Component)new JScrollPane(this.sectorOptionstableTable), gridBagConstraints);
        return jPanel;
    }

    private JPanel createSectorOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Sector options"));
        int n = this.getNumberOfRows();
        Object[][] objectArray = new Enumeration[n][COLUMN_NAMES_WITH_RADIOSHAREDBY.length];
        for (int i = 0; i < n; ++i) {
            objectArray[i][0] = this.radioBuildingBlockParameters[i];
            objectArray[i][1] = this.lineRateParameters[i];
            objectArray[i][2] = this.primaryPortIdParameters[i];
            objectArray[i][3] = this.secondaryPortIdParameters[i];
            objectArray[i][4] = this.sectorSequenceParameters[i];
            objectArray[i][5] = this.auUnitTypeParameters[i];
            objectArray[i][6] = this.radioSharedBySectorParameters[i];
        }
        this.sectorOptionstableTable = new CustomerParameterTable(objectArray, this.getRowNames(n), COLUMN_NAMES_WITH_RADIOSHAREDBY);
        this.adjustColumnWidths(COLUMN_NAMES_WITH_RADIOSHAREDBY.length);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 10.0;
        jPanel.add((Component)new JScrollPane(this.sectorOptionstableTable), gridBagConstraints);
        return jPanel;
    }

    private int getNumberOfRows() {
        int n = 0;
        for (int i = 0; i < this.radioBuildingBlockParameters.length; ++i) {
            EnumeratedRange enumeratedRange;
            List list;
            if (this.radioBuildingBlockParameters[i] == null || (list = (enumeratedRange = (EnumeratedRange)this.radioBuildingBlockParameters[i].getEnabledValueRange()).getRangeValues()).size() == 0 || list.size() == 1 && list.get(0).equals("")) continue;
            ++n;
        }
        return n;
    }

    private void adjustColumnWidths(int n) {
        TableColumn tableColumn = this.sectorOptionstableTable.getColumn(SECTOR_COLUMN_NAME);
        int n2 = tableColumn.getWidth();
        int n3 = n * n2;
        int n4 = SECTOR_COLUMN_NAME.length() + LINERATE_COLUMN_NAME.length() + RBB_COLUMN_NAME.length() + PRIMARY_COLUMN_NAME.length() + SECONDARY_COLUMN_NAME.length() + SEQUENCE_COLUMN_NAME.length() + AU_UNIT_TYPE_COLUMN_NAME.length();
        if (n == COLUMN_NAMES_WITH_RADIOSHAREDBY.length) {
            n4 += RADIO_SHARE_COLUMN_NAME.length();
        }
        int n5 = n3 / n4;
        this.setColumnWidth(SECTOR_COLUMN_NAME, n5);
        this.setColumnWidth(LINERATE_COLUMN_NAME, n5);
        this.setColumnWidth(RBB_COLUMN_NAME, n5);
        this.setColumnWidth(PRIMARY_COLUMN_NAME, n5);
        this.setColumnWidth(SECONDARY_COLUMN_NAME, n5);
        this.setColumnWidth(SEQUENCE_COLUMN_NAME, n5);
        this.setColumnWidth(AU_UNIT_TYPE_COLUMN_NAME, n5);
        if (n == COLUMN_NAMES_WITH_RADIOSHAREDBY.length) {
            this.setColumnWidth(RADIO_SHARE_COLUMN_NAME, n5);
        }
        this.sectorOptionstableTable.doLayout();
    }

    private void setColumnWidth(String string, int n) {
        TableColumn tableColumn = this.sectorOptionstableTable.getColumn(string);
        int n2 = string.length() * n;
        tableColumn.setPreferredWidth(n2);
    }

    private String[] getRowNames(int n) {
        return this.getRowNames(n, 1);
    }

    private String[] getRowNames(int n, int n2) {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            Integer n3 = SectorUtil.getSectorNumberFromSectorIndex(i, n2);
            stringArray[i] = n3.toString();
        }
        return stringArray;
    }
}

