/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import javax.swing.Icon;
import javax.swing.JPanel;
import se.ericsson.wcdma.support.gui.guilib.comp.IconHelper;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractPresenter;

public abstract class AbstractView
extends JPanel {
    private AbstractPresenter presenter;

    void init(AbstractPresenter abstractPresenter) {
        this.presenter = abstractPresenter;
        this.putClientProperty("HELP_KEY", "GSL_DEFAULTMENU_HELPMENU_ONWINDOW");
    }

    AbstractPresenter getPresenter() {
        return this.presenter;
    }

    protected abstract void init();

    void dispose() {
        this.presenter = null;
        this.removeComponents(this);
    }

    private void removeComponents(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            Component[] componentArray = container.getComponents();
            container.removeAll();
            for (int i = 0; i < componentArray.length; ++i) {
                this.removeComponents(componentArray[i]);
            }
        }
    }

    public AbstractApplication getApplication() {
        return this.presenter.getApplication();
    }

    public void setCursor(Cursor cursor) {
        this.presenter.setCursor(cursor, false);
    }

    public void setEnabled(boolean bl) {
        this.presenter.setEnabled(bl, false);
    }

    public boolean isEnabled() {
        return this.presenter.isEnabled();
    }

    public String getProperty(String string) {
        return this.presenter.getApplication().getEnvironment().getProperty(string);
    }

    public Icon createIcon(String string) {
        return IconHelper.createIcon(string);
    }

    public boolean isResizable() {
        return true;
    }

    public void setHorizontalScrollBarPolicy(int n) {
        this.presenter.getViewContainer().setHorizontalScrollBarPolicy(n);
    }

    public void setVerticalScrollBarPolicy(int n) {
        this.presenter.getViewContainer().setVerticalScrollBarPolicy(n);
    }
}

