/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.extethswitch;

import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.extethswitch.EthernetPortMo;
import se.ericsson.cello.extethswitch.EthernetPortMoGen;
import se.ericsson.cello.extethswitch.ExtethswitchUtil;
import se.ericsson.cello.extethswitch.LagMo;
import se.ericsson.cello.extethswitch.LagMoImpl;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.MoNotPossibleToReserveException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.sync.EthernetPortRef;
import se.ericsson.cello.sync.SyncReservable;
import se.ericsson.cello.transaction.Coordinator;

public class EthernetPortMoImpl
extends EthernetPortMoGen
implements SyncReservable,
EthernetPortRef {
    static int PORT_NUMBER_CAX_UNIT = 13;

    public EthernetPortMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public EthernetPortMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    public void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        setRequestContext.setVariable((Object)"isCreate", (Object)Boolean.TRUE);
        this.checkAllowedPortNosDuringCreateOrSet(setRequestContext);
        int n = PiuUtils.findPiuParentFroId((ManagedObject)this);
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("piu_fro_id", n));
    }

    public void checkAllowedPortNosDuringCreateOrSet(SetRequestContext setRequestContext) throws MoAccessException {
        Coordinator coordinator = setRequestContext.getCoordinator();
        if (ExtethswitchUtil.isSMXB(coordinator)) {
            int n = 0;
            ManagedObject managedObject = this.getParent();
            MoIterator moIterator = managedObject.getChildren();
            while (moIterator != null && moIterator.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator.nextMo();
                if (managedObject2 == this || !(managedObject2 instanceof EthernetPortMo)) continue;
                int n2 = ((EthernetPortMo)managedObject2).getPortNo(coordinator);
                Struct struct = ((EthernetPortMo)managedObject2).getOperatingMode(coordinator);
                int n3 = 7;
                if (struct != null) {
                    n3 = (Integer)struct.getValue("configuredSpeedDuplex");
                }
                if (setRequestContext.getVariable((Object)"isCreate").equals(Boolean.TRUE)) {
                    n = (Integer)setRequestContext.getAttributeFromRequest("portNo");
                    if (n2 == 6 && n3 == 8 && n >= 7 && n <= 9) {
                        throw new IllegalAttributeValueException("portNo=6 is configured as ETH_40_GB_FULL,hence creation of ports with port Numbers 7 to 9 is not allowed.", "portNo", "EthernetPort");
                    }
                    if (n2 == 10 && n3 == 8 && n >= 11 && n <= 13) {
                        throw new IllegalAttributeValueException("portNo=10 is configured as ETH_40_GB_FULL,hence creation of ports with port Numbers 11 to 13 is not allowed.", "portNo", "EthernetPort");
                    }
                }
                if (!setRequestContext.isIncludedInRequest("operatingMode")) continue;
                struct = (Struct)setRequestContext.getAttributeFromRequest("operatingMode");
                if (struct != null) {
                    n3 = (Integer)struct.getValue("configuredSpeedDuplex");
                }
                if (n3 != 8) continue;
                if (setRequestContext.getVariable((Object)"isCreate").equals(Boolean.FALSE)) {
                    n = this.getPortNo(coordinator);
                }
                if (n2 >= 7 && n2 <= 9 && n == 6) {
                    throw new IllegalAttributeValueException("ports in range 7-9 is existing so port with portNo=6 cannot be configured as ETH_40_GB_FULL.", "portNo", "EthernetPort");
                }
                if (n2 < 11 || n2 > 13 || n != 10) continue;
                throw new IllegalAttributeValueException("ports in range 11-13 is existing so port with portNo=10 cannot be configured as ETH_40_GB_FULL.", "portNo", "EthernetPort");
            }
        }
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n;
        ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
        int n2 = managedObjectArray.length;
        for (n = 0; n < n2; ++n) {
            if ((managedObjectArray[n].getType().equalsIgnoreCase("Lag") || managedObjectArray[n].getType().equalsIgnoreCase("EthernetBridgePort")) && (managedObject.getType().equalsIgnoreCase("VlanPort") || managedObject.getType().equalsIgnoreCase("InterfaceIpv4") || managedObject.getType().equalsIgnoreCase("EthernetBridgePort") || managedObject.getType().equalsIgnoreCase("Lag"))) {
                throw new MoNotPossibleToReserveException("This MO is already reserved by" + managedObjectArray[n].getType() + " MO.", "EthernetPort");
            }
            if (managedObjectArray[n].getType().equalsIgnoreCase("Synchronization") || managedObjectArray[n].getType().equalsIgnoreCase("SyncEthEgress")) {
                throw new MoNotPossibleToReserveException("This MO is already reserved by" + managedObjectArray[n].getType() + " MO.", "EthernetPort");
            }
            if (!managedObjectArray[n].getType().equalsIgnoreCase("InterfaceIpv4") && !managedObjectArray[n].getType().equalsIgnoreCase("VlanPort") || managedObject.getType().equalsIgnoreCase("VlanPort") || managedObject.getType().equalsIgnoreCase("InterfaceIpv4") || managedObject.getType().equalsIgnoreCase("SyncEthEgress") || managedObject.getType().equalsIgnoreCase("Synchronization")) continue;
            throw new MoNotPossibleToReserveException(" This MO already reserved by " + managedObjectArray[n].getType() + " MO.", "EthernetPort");
        }
        if (managedObject.getType().equalsIgnoreCase("Synchronization") || managedObject.getType().equalsIgnoreCase("SyncEthEgress")) {
            if (ExtethswitchUtil.isCaxPlugInUnit(this.getParent(), coordinator)) {
                n = this.getPortNo(coordinator);
                if (ExtethswitchUtil.isOnCCIBPiu(this)) {
                    if (n != 3 && n != 4 && n != 5 && n != 6 && n != 9 && n != 10 && n != 11 && n != 12) {
                        throw new MoNotPossibleToReserveException("Invalid portNo when parent PIU is CCIB", "EthernetPort");
                    }
                } else if (n != 9 && n != 10 && n != 11) {
                    throw new MoNotPossibleToReserveException("Invalid portNo when parent PIU is CMXB", "EthernetPort");
                }
            } else {
                throw new MoNotPossibleToReserveException("Referred EthernetPort Mo is not valid as parent PIU is not CCIB or CMXB", "EthernetPort");
            }
        }
        super.reserve(managedObject, coordinator);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
        int n = managedObjectArray.length;
        for (int i = 0; i < n; ++i) {
            if (managedObjectArray[i].getType().equalsIgnoreCase("SyncEthEgress") || managedObjectArray[i].getType().equalsIgnoreCase("Synchronization")) {
                if (managedObject.getType().equalsIgnoreCase("EthernetBridgePort") || managedObject.getType().equalsIgnoreCase("Lag") || managedObject.getType().equalsIgnoreCase("VlanPort") || managedObject.getType().equalsIgnoreCase("InterfaceIpv4")) {
                    throw new OperationNotAllowedException(managedObject.getType() + " can't release EthernetPort unless it is released from " + managedObjectArray[i].getType() + " first ", "EthernetPort");
                }
                super.release(managedObject, coordinator);
                continue;
            }
            super.release(managedObject, coordinator);
        }
    }

    public void syncReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reserve(managedObject, coordinator);
    }

    public void syncRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.release(managedObject, coordinator);
    }

    public void validatePortNo(int n, SetRequestContext setRequestContext) throws MoAccessException {
        ManagedObject managedObject = this.getParent();
        MoIterator moIterator = managedObject.getChildren();
        while (moIterator != null && moIterator.hasMoreElements()) {
            Object object = moIterator.nextElement();
            if (object == this || !(object instanceof EthernetPortMo) || ((EthernetPortMo)object).getPortNo(setRequestContext.getCoordinator()) != n) continue;
            throw new AttrValueNotUniqueException("portNo = " + n + " is not unique.", "EthernetPort");
        }
    }

    public void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
        Object object;
        Coordinator coordinator = setRequestContext.getCoordinator();
        if (setRequestContext.isIncludedInRequest("operatingMode")) {
            object = this.getReservedBy(coordinator);
            for (int i = 0; i < ((ManagedObject[])object).length; ++i) {
                if (!(object[i] instanceof LagMo)) continue;
                throw new OperationNotAllowedException("Set OperatingMode is not allowed if referenced by Lag", "EthernetPort");
            }
        }
        if (setRequestContext.isIncludedInRequest("administrativeState")) {
            object = setRequestContext.getAttributeFromRequest("administrativeState");
            this.checkAndSetMasterPortAtrribute("administrativeState", object, coordinator);
        }
        setRequestContext.setVariable((Object)"isCreate", (Object)Boolean.FALSE);
        this.checkAllowedPortNosDuringCreateOrSet(setRequestContext);
    }

    private void checkAndSetMasterPortAtrribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (!(managedObjectArray[i] instanceof LagMo)) continue;
            if (this == ((LagMoImpl)managedObjectArray[i]).getMasterPort(coordinator)) {
                ManagedObject[] managedObjectArray2 = ((LagMoImpl)managedObjectArray[i]).getEthernetPortRef(null);
                for (int j = 0; j < managedObjectArray2.length; ++j) {
                    if (managedObjectArray2[j] == this) continue;
                    ((EthernetPortMoImpl)managedObjectArray2[j]).setMasterPortAtrribute(string, object, coordinator);
                }
                continue;
            }
            throw new OperationNotAllowedException("Set administrativeState is not allowed as this is referenced by LAG mo but not masterPort", "EthernetPort");
        }
    }

    private void setMasterPortAtrribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setMasterPortAttributes(stringArray, objectArray, coordinator);
    }

    private void setMasterPortAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(stringArray, objectArray, coordinator);
        String string = null;
        Object object = null;
        setRequestContextImpl.assertNoDuplicateAttributes("EthernetPort");
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            object = objectArray[i];
            if (string.equalsIgnoreCase("administrativeState")) {
                int n = (Integer)object;
                setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("administrativeState", n));
                setRequestContextImpl.addAvcNotification(string, object);
            }
            setRequestContextImpl.sendSetRequest(this.froProxy, this.getFroId(coordinator));
            setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
        }
    }

    public int getFroType() throws MoAccessException {
        return Integer.parseInt("D0C", 16);
    }

    public static void checkPortNumber(ManagedObject managedObject, Coordinator coordinator, String string, String string2) throws MoAccessException {
        int n;
        if (ExtethswitchUtil.isControlEthernetPort(managedObject, coordinator) && (n = ((Integer)managedObject.getAttribute("portNo", coordinator)).intValue()) == PORT_NUMBER_CAX_UNIT) {
            throw new ConfigurationMismatchException("EthernetPortRef cannot be operated for EthernetPort MO that has port number 13 under cax configuration", string, string2);
        }
    }
}

