/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.extethswitch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.extethswitch.EthernetSwitchMo;
import se.ericsson.cello.extethswitch.SwitchStpMo;
import se.ericsson.cello.extethswitch.SwitchStpMoFactory;
import se.ericsson.cello.extethswitch.SwitchStpMoImpl;
import se.ericsson.cello.extethswitch.exs_ethernet_switch_exh;
import se.ericsson.cello.extethswitch.mom.EnumLinkSelectionMethod1;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class EthernetSwitchMoImpl
extends CelloMao
implements EthernetSwitchMo {
    private static final boolean ENABLE_VLAN_DEFAULT = false;
    private static final boolean ENABLE_VLAN_TRUE = true;
    private static final boolean ENABLE_VLAN_FALSE = false;
    private static final int PBIT_0_DEFAULT = 0;
    private static final int PBIT_1_DEFAULT = 1;
    private static final int PBIT_2_DEFAULT = 2;
    private static final int PBIT_3_DEFAULT = 3;
    private static final int PBIT_4_DEFAULT = 4;
    private static final int PBIT_5_DEFAULT = 5;
    private static final int PBIT_6_DEFAULT = 6;
    private static final int PBIT_7_DEFAULT = 7;
    private static final int PBIT_MIN = 0;
    private static final int PBIT_MAX = 7;
    private static final int QUEUE_0_DEFAULT = 0;
    private static final int QUEUE_1_DEFAULT = 1;
    private static final int QUEUE_2_DEFAULT = 2;
    private static final int QUEUE_3_DEFAULT = 3;
    private static final int QUEUE_MIN = 0;
    private static final int QUEUE_MAX = 3;
    private static final int LENGTH_PBIT_QUEUE_MAP = 8;
    private static final boolean EGRESS_UNTAG_DEFAULT = false;
    private static final boolean EGRESS_UNTAG_TRUE = true;
    private static final boolean EGRESS_UNTAG_FALSE = false;
    private static final int VID_DEFAULT = 0;
    private static final int VID_MIN = 0;
    private static final int VID_MAX = 4095;
    private static final int MAX_LENGTH_VLAN_MEMBERSHIP = 8;
    private static final int UNTAGGED_INGRESS_PRIORITY_DEFAULT = 0;
    private static final int UNTAGGED_INGRESS_PRIORITY_MAX = 7;
    private static final int UNTAGGED_INGRESS_PRIORITY_MIN = 0;
    private static final int UNTAGGED_INGRESS_VID_DEFAULT = 1;
    private static final int UNTAGGED_INGRESS_VID_MAX = 4095;
    private static final int UNTAGGED_INGRESS_VID_MIN = 1;
    private static final String SWITCH_STP_IDENTITY = "1";
    private static final String BH_FRO_ID = "bhFroId";
    private static final String PIU_FRO_ID = "piuFroId";
    private MoData data;
    private static final int MO_DATA_REVISION_6 = 6000;
    private static final int MO_DATA_REVISION_6_MOD = 6001;
    private static final int MO_DATA_REVISION_LATEST = 6001;
    private static final int MAX_NO_ETHERNET_SWITCH = 1;
    private FroProxy ethernetSwitchProxy = null;
    private MaoFroIndicationHandler indicationHandler = null;
    private static TagNameDictionary tnd = TagNameDictionaries.get((ResourceBundle)ResourceBundle.getBundle(exs_ethernet_switch_exh.class.getName()));
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, SwitchStpMoFactory switchStpMoFactory, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"EthernetSwitch", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"ExchangeTerminalIp");
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"EthernetSwitch", (int)1);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"EthernetSwitch", (int)128, (int)0);
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"enableVlan", (AttrList)attrList, (boolean)false, (boolean)false, (String)"EthernetSwitch");
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"untaggedIngressPriority", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)7, (String)"EthernetSwitch");
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"untaggedIngressVid", (AttrList)attrList, (boolean)false, (int)1, (int)1, (int)4095, (String)"EthernetSwitch");
        int n3 = MoAttributeValidator.checkAndGetEnumAttribute((String)"linkAggLinkSelection", (AttrList)attrList, (boolean)false, (int)2, (int[])EnumLinkSelectionMethod1.VALUES_ARRAY, (String)"EthernetSwitch");
        boolean bl2 = false;
        if (n2 != 1) {
            bl2 = true;
        }
        Struct[] structArray = EthernetSwitchMoImpl.checkAndGetVlanMembership(attrList, bl2);
        if (n2 != 1) {
            EthernetSwitchMoImpl.checkUntaggedIngressVidIsWithinVlanMembership(structArray, n2);
        }
        Struct[] structArray2 = EthernetSwitchMoImpl.checkAndGetPbitQueueMap(attrList);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"EthernetSwitch");
        SignedIntParameter signedIntParameter = new SignedIntParameter("enableVlan", bl);
        arrayList.add(signedIntParameter);
        SignedIntParameter signedIntParameter2 = new SignedIntParameter("untaggedIngressPriority", n);
        arrayList.add(signedIntParameter2);
        SignedIntParameter signedIntParameter3 = new SignedIntParameter("untaggedIngressVid", n2);
        arrayList.add(signedIntParameter3);
        SignedIntParameter signedIntParameter4 = new SignedIntParameter("linkAggLinkSelection", n3);
        arrayList.add(signedIntParameter4);
        ArrayParameter arrayParameter = EthernetSwitchMoImpl.makeArrayParameter(structArray2, "pbitQueueMap", "pbitQueuePair", "pbit", "queue");
        arrayList.add(arrayParameter);
        ArrayParameter arrayParameter2 = EthernetSwitchMoImpl.makeArrayParameter(structArray, "vlanMembership", "vidInformationPair", "egressUntag", "vid");
        arrayList.add(arrayParameter2);
        int n4 = ((FroInfo)managedObject).getFroId(coordinator);
        SignedIntParameter signedIntParameter5 = new SignedIntParameter(BH_FRO_ID, n4);
        arrayList.add(signedIntParameter5);
        int n5 = PiuUtils.findPiuParentFroId((ManagedObject)managedObject);
        SignedIntParameter signedIntParameter6 = new SignedIntParameter(PIU_FRO_ID, n5);
        arrayList.add(signedIntParameter6);
        return new EthernetSwitchMoImpl(managedObject, string, string2, arrayList, coordinator, froProxy, switchStpMoFactory, maoFroIndicationHandler);
    }

    private EthernetSwitchMoImpl(ManagedObject managedObject, String string, String string2, ArrayList arrayList, Coordinator coordinator, FroProxy froProxy, SwitchStpMoFactory switchStpMoFactory, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "EthernetSwitch", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.ethernetSwitchProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        FroData froData = this.ethernetSwitchProxy.create(coordinator, (Collection)arrayList);
        int n = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        switchStpMoFactory.autoCreateMo(this, SWITCH_STP_IDENTITY, coordinator);
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, this.getFroId(coordinator));
        this.data.setRevision(6001);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public EthernetSwitchMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.ethernetSwitchProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(6001);
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException("EthernetSwitch");
        }
        this.deleteSwitchStpChildMo(coordinator);
        this.ethernetSwitchProxy.delete(coordinator, this.getFroId(coordinator), null);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getMacAddress(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("macAddress", coordinator);
    }

    public Struct[] getPbitQueueMap(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("pbitQueueMap", coordinator);
    }

    public void setPbitQueueMap(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("pbitQueueMap", structArray, coordinator);
    }

    public int getUntaggedIngressPriority(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("untaggedIngressPriority", coordinator);
    }

    public void setUntaggedIngressPriority(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("untaggedIngressPriority", new Integer(n), coordinator);
    }

    public int getUntaggedIngressVid(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("untaggedIngressVid", coordinator);
    }

    public void setUntaggedIngressVid(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("untaggedIngressVid", new Integer(n), coordinator);
    }

    public int getLinkAggLinkSelection(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("linkAggLinkSelection", coordinator);
    }

    public void setLinkAggLinkSelection(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("linkAggLinkSelection", new Integer(n), coordinator);
    }

    public Struct[] getVlanMembership(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("vlanMembership", coordinator);
    }

    public void setVlanMembership(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("vlanMembership", structArray, coordinator);
    }

    public boolean getEnableVlan(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("enableVlan", coordinator);
    }

    public void setEnableVlan(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("enableVlan", bl, coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getEthernetSwitchId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("EthernetSwitchId", coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("enableVlan")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("enableVlan");
                objectArray[i] = signedIntParameter.getBoolean();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pbitQueueMap")) {
                map = this.getAttrFromRes(map, coordinator);
                objectArray[i] = this.convertArray2Struct((ArrayParameter)map.get("pbitQueueMap"), "pbitQueueMap", "pbit", "queue");
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("macAddress")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (StringParameter)map.get("macAddress");
                objectArray[i] = signedIntParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("untaggedIngressPriority")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("untaggedIngressPriority");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("untaggedIngressVid")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("untaggedIngressVid");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("linkAggLinkSelection")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("linkAggLinkSelection");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vlanMembership")) {
                map = this.getAttrFromRes(map, coordinator);
                objectArray[i] = this.convertArray2Struct((ArrayParameter)map.get("vlanMembership"), "vlanMembership", "egressUntag", "vid");
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "EthernetSwitch");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        int n;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n2 = 0;
        Object var6_6 = null;
        int n3 = -1;
        Struct[] structArray = null;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equalsIgnoreCase("untaggedIngressVid")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? EthernetSwitchMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("untaggedIngressVid", "EthernetSwitch");
                }
                n3 = (Integer)objectArray[n];
                continue;
            }
            if (!stringArray[n].equalsIgnoreCase("vlanMembership")) continue;
            if (!(objectArray[n] instanceof Struct[])) {
                throw new WrongAttributeTypeException("vlanMembership", "EthernetSwitch");
            }
            structArray = (Struct[])objectArray[n];
            EthernetSwitchMoImpl.checkVlanMembershipRanges(structArray);
        }
        for (n = 0; n < stringArray.length; ++n) {
            ArrayParameter arrayParameter;
            if (stringArray[n].equalsIgnoreCase("userLabel")) {
                if (!objectArray[n].getClass().equals(class$java$lang$String == null ? EthernetSwitchMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "EthernetSwitch");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[n]), (String)"userLabel", (String)"EthernetSwitch", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[n]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("enableVlan")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Boolean == null ? EthernetSwitchMoImpl.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    throw new WrongAttributeTypeException("enableVlan", "EthernetSwitch");
                }
                boolean bl = (Boolean)objectArray[n];
                hashtable.put("enableVlan", new SignedIntParameter("enableVlan", bl));
                this.sendNotification("enableVlan", bl, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("untaggedIngressPriority")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? EthernetSwitchMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("untaggedIngressPriority", "EthernetSwitch");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"untaggedIngressPriority", (int)n2, (int)0, (int)7, (String)"EthernetSwitch");
                hashtable.put("untaggedIngressPriority", new SignedIntParameter("untaggedIngressPriority", n2));
                this.sendNotification("untaggedIngressPriority", new Integer(n2), coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("untaggedIngressVid")) {
                MoAttributeValidator.checkIntegerAttribute((String)"untaggedIngressVid", (int)n3, (int)1, (int)4095, (String)"EthernetSwitch");
                if (n3 != 1) {
                    if (structArray == null) {
                        arrayParameter = (ArrayParameter)this.getAttribute("vlanMembership", coordinator);
                        EthernetSwitchMoImpl.checkUntaggedIngressVidIsWithinVlanMembership((Struct[])arrayParameter, n3);
                    } else {
                        EthernetSwitchMoImpl.checkVlanMembershipRanges(structArray);
                        EthernetSwitchMoImpl.checkUntaggedIngressVidIsWithinVlanMembership(structArray, n3);
                    }
                }
                hashtable.put("untaggedIngressVid", new SignedIntParameter("untaggedIngressVid", n3));
                this.sendNotification("untaggedIngressVid", new Integer(n3), coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("linkAggLinkSelection")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? EthernetSwitchMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("linkAggLinkSelection", "EthernetSwitch");
                }
                n2 = (Integer)objectArray[n];
                if (!MoAttributeValidator.isWithinEnum((int)n2, (int[])EnumLinkSelectionMethod1.VALUES_ARRAY)) {
                    throw new ValueOutOfRangeException("linkAggLinkSelection", "EthernetSwitch");
                }
                hashtable.put("linkAggLinkSelection", new SignedIntParameter("linkAggLinkSelection", n2));
                this.sendNotification("linkAggLinkSelection", new Integer(n2), coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("pbitQueueMap")) {
                if (!(objectArray[n] instanceof Struct[])) {
                    throw new WrongAttributeTypeException("pbitQueueMap", "EthernetSwitch");
                }
                arrayParameter = (Struct[])objectArray[n];
                EthernetSwitchMoImpl.checkPbitQueueMapRanges((Struct[])arrayParameter);
                ArrayParameter arrayParameter2 = EthernetSwitchMoImpl.makeArrayParameter((Struct[])arrayParameter, "pbitQueueMap", "pbitQueuePair", "pbit", "queue");
                hashtable.put("pbitQueueMap", arrayParameter2);
                this.sendNotification("pbitQueueMap", arrayParameter, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("vlanMembership")) {
                if (n3 == -1) {
                    int n4 = (Integer)this.getAttribute("untaggedIngressVid", coordinator);
                    if (n4 != 1) {
                        EthernetSwitchMoImpl.checkUntaggedIngressVidIsWithinVlanMembership(structArray, n4);
                    }
                } else if (n3 != 1) {
                    EthernetSwitchMoImpl.checkUntaggedIngressVidIsWithinVlanMembership(structArray, n3);
                }
                arrayParameter = EthernetSwitchMoImpl.makeArrayParameter(structArray, "vlanMembership", "vidInformationPair", "egressUntag", "vid");
                hashtable.put("vlanMembership", arrayParameter);
                this.sendNotification("vlanMembership", structArray, coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[n], "EthernetSwitch");
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashtable.values());
        if (arrayList != null) {
            this.ethernetSwitchProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    public void actionSetPbitQueue(int n, int n2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n < 0 || n > 7) {
            throw new ValueOutOfRangeException("pbit", "EthernetSwitch");
        }
        if (n2 < 0 || n2 > 3) {
            throw new ValueOutOfRangeException("queue", "EthernetSwitch");
        }
        Struct[] structArray = this.getPbitQueueMap(coordinator);
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        int n3 = structArray.length;
        for (int i = 0; i < n3; ++i) {
            hashMap.put(structArray[i].getValue("pbit"), structArray[i].getValue("queue"));
        }
        hashMap.put(new Integer(n), new Integer(n2));
        Struct[] structArray2 = EthernetSwitchMoImpl.convertHashMap2StructArr(hashMap);
        EthernetSwitchMoImpl.checkPbitQueueMapRanges(structArray2);
        ArrayList<ArrayParameter> arrayList = new ArrayList<ArrayParameter>();
        arrayList.add(EthernetSwitchMoImpl.makeArrayParameter(structArray2, "pbitQueueMap", "pbitQueuePair", "pbit", "queue"));
        this.ethernetSwitchProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        this.sendNotification("pbitQueueMap", structArray2, coordinator);
    }

    public String getType() {
        return "EthernetSwitch";
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(tnd);
            StringParameter stringParameter = (StringParameter)map.get("macAddress");
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (stringParameter != null) {
                arrayList.add("macAddress");
                arrayList2.add(stringParameter.getValue());
            }
            if (arrayList.size() == 0) {
                MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
                return;
            }
            NotificationSender.instance().pushAVC((ManagedObject)this, arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray());
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute not in property file");
        }
    }

    private static Struct[] checkAndGetPbitQueueMap(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("pbitQueueMap");
        if (n == -1) {
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            hashMap.clear();
            block5: for (int i = 0; i < 8; ++i) {
                switch (i) {
                    case 0: 
                    case 2: 
                    case 3: {
                        hashMap.put(new Integer(i), new Integer(1));
                        continue block5;
                    }
                    case 4: 
                    case 5: {
                        hashMap.put(new Integer(i), new Integer(2));
                        continue block5;
                    }
                    case 6: 
                    case 7: {
                        hashMap.put(new Integer(i), new Integer(3));
                        continue block5;
                    }
                    default: {
                        hashMap.put(new Integer(i), new Integer(0));
                    }
                }
            }
            return EthernetSwitchMoImpl.convertHashMap2StructArr(hashMap);
        }
        if (!(attrList.getValue(n) instanceof Struct[])) {
            throw new WrongAttributeTypeException("pbitQueueMap", "EthernetSwitch");
        }
        Struct[] structArray = (Struct[])attrList.getValue(n);
        EthernetSwitchMoImpl.checkPbitQueueMapRanges(structArray);
        attrList.removeElementAt(n);
        return structArray;
    }

    private static Struct[] convertHashMap2StructArr(Map map) throws MoAccessException {
        Struct[] structArray = new Struct[8];
        String[] stringArray = new String[]{"pbit", "queue"};
        for (int i = 0; i < 8; ++i) {
            Integer n = new Integer(i);
            Object[] objectArray = new Object[]{new Integer(i), map.get(n)};
            StructImpl structImpl = new StructImpl(stringArray, objectArray);
            structArray[i] = structImpl;
        }
        return structArray;
    }

    private static void checkPbitQueueMapRanges(Struct[] structArray) throws MoAccessException {
        int n;
        int n2 = structArray.length;
        if (n2 != 8) {
            throw new AttrMissingAtCreateException("pbitQueueMap", "EthernetSwitch");
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.clear();
        for (n = 0; n < n2; ++n) {
            if (!(structArray[n].getValue("queue") instanceof Integer)) {
                throw new WrongAttributeTypeException("queue", "EthernetSwitch");
            }
            if (!(structArray[n].getValue("pbit") instanceof Integer)) {
                throw new WrongAttributeTypeException("pbit", "EthernetSwitch");
            }
            if ((Integer)structArray[n].getValue("pbit") != n) {
                throw new ValueOutOfRangeException("pbit", "EthernetSwitch");
            }
            hashMap.put(structArray[n].getValue("pbit"), structArray[n].getValue("queue"));
        }
        n2 = hashMap.size();
        for (n = 0; n < n2; ++n) {
            Integer n3 = new Integer(n);
            if (!hashMap.containsKey(n3)) {
                throw new ValueOutOfRangeException("pbit", "EthernetSwitch");
            }
            if ((Integer)hashMap.get(n3) >= 0 && (Integer)hashMap.get(n3) <= 3) continue;
            throw new ValueOutOfRangeException("queue", "EthernetSwitch");
        }
    }

    private Struct[] convertArray2Struct(ArrayParameter arrayParameter, String string, String string2, String string3) throws MoAccessException {
        if (string.equals("vlanMembership")) {
            int n = arrayParameter.size();
            Struct[] structArray = new Struct[n];
            String[] stringArray = new String[]{string2, string3};
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = new Object[2];
                StructParameter structParameter = (StructParameter)arrayParameter.get(i);
                int n3 = ((SignedIntParameter)structParameter.get(string2)).getValue();
                if (n3 != -1) {
                    boolean bl = MaoFroTypeConverter.int2boolean((int)n3);
                    objectArray[0] = bl;
                }
                objectArray[1] = new Integer(((SignedIntParameter)structParameter.get(string3)).getValue());
                if (n3 == -1 || (Integer)objectArray[1] == -1) continue;
                StructImpl structImpl = new StructImpl(stringArray, objectArray);
                structArray[i] = structImpl;
                ++n2;
            }
            Struct[] structArray2 = new Struct[n2];
            for (int i = 0; i < n2; ++i) {
                if ((Integer)structArray[i].getValue(string3) == -1) continue;
                structArray2[i] = structArray[i];
            }
            return structArray2;
        }
        Struct[] structArray = new Struct[arrayParameter.size()];
        String[] stringArray = new String[]{string2, string3};
        for (int i = 0; i < arrayParameter.size(); ++i) {
            Object[] objectArray = new Object[2];
            StructParameter structParameter = (StructParameter)arrayParameter.get(i);
            objectArray[0] = new Integer(((SignedIntParameter)structParameter.get(string2)).getValue());
            objectArray[1] = new Integer(((SignedIntParameter)structParameter.get(string3)).getValue());
            StructImpl structImpl = new StructImpl(stringArray, objectArray);
            structArray[i] = structImpl;
        }
        return structArray;
    }

    private static Struct[] checkAndGetVlanMembership(AttrList attrList, boolean bl) throws MoAccessException {
        int n = attrList.indexOf("vlanMembership");
        if (n == -1 && bl) {
            throw new AttrMissingAtCreateException("vlanMembership If untaggedIngessVid hasn't value 1, then it must be a member of vlanMembership.", "EthernetSwitch");
        }
        if (n == -1 && !bl) {
            Struct[] structArray = new Struct[1];
            String[] stringArray = new String[]{"egressUntag", "vid"};
            Object[] objectArray = new Object[]{false, new Integer(0)};
            StructImpl structImpl = new StructImpl(stringArray, objectArray);
            structArray[0] = structImpl;
            return structArray;
        }
        if (!(attrList.getValue(n) instanceof Struct[])) {
            throw new WrongAttributeTypeException("vlanMembership", "EthernetSwitch");
        }
        Struct[] structArray = (Struct[])attrList.getValue(n);
        EthernetSwitchMoImpl.checkVlanMembershipRanges(structArray);
        attrList.removeElementAt(n);
        return structArray;
    }

    private static void checkVlanMembershipRanges(Struct[] structArray) throws MoAccessException {
        int n = structArray.length;
        if (n > 8) {
            throw new ValueOutOfRangeException("vlanMembership", "EthernetSwitch");
        }
        for (int i = 0; i < n; ++i) {
            if (!(structArray[i].getValue("egressUntag") instanceof Boolean)) {
                throw new WrongAttributeTypeException("egressUntag", "EthernetSwitch");
            }
            if (!(structArray[i].getValue("vid") instanceof Integer)) {
                throw new WrongAttributeTypeException("vid", "EthernetSwitch");
            }
            int n2 = (Integer)structArray[i].getValue("vid");
            if (n2 >= 0 && n2 <= 4095) continue;
            throw new ValueOutOfRangeException("vid", "EthernetSwitch");
        }
    }

    private static ArrayParameter makeArrayParameter(Struct[] structArray, String string, String string2, String string3, String string4) throws MoAccessException {
        StructParameter structParameter;
        int n;
        ArrayParameter arrayParameter = new ArrayParameter(string);
        for (n = 0; n < structArray.length; ++n) {
            structParameter = new StructParameter(string2);
            if (structArray[n].getValue(string3) instanceof Boolean) {
                int n2 = MaoFroTypeConverter.boolean2int((boolean)((Boolean)structArray[n].getValue(string3)));
                structParameter.add((Parameter)new SignedIntParameter(string3, n2));
            } else {
                structParameter.add((Parameter)new SignedIntParameter(string3, ((Integer)structArray[n].getValue(string3)).intValue()));
            }
            structParameter.add((Parameter)new SignedIntParameter(string4, ((Integer)structArray[n].getValue(string4)).intValue()));
            arrayParameter.add((Parameter)structParameter);
        }
        if (string.equalsIgnoreCase("vlanMembership")) {
            for (n = structArray.length; n < 8; ++n) {
                structParameter = new StructParameter(string2);
                structParameter.add((Parameter)new SignedIntParameter(string3, -1));
                structParameter.add((Parameter)new SignedIntParameter(string4, -1));
                arrayParameter.add((Parameter)structParameter);
            }
        }
        return arrayParameter;
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public int getFroType() throws MoAccessException {
        return Integer.parseInt("D00", 16);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.ethernetSwitchProxy.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    private void deleteSwitchStpChildMo(Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            Object object = moIterator.nextElement();
            if (!(object instanceof SwitchStpMo)) continue;
            ((SwitchStpMoImpl)object).deleteMo(coordinator);
        }
    }

    private static void checkUntaggedIngressVidIsWithinVlanMembership(Struct[] structArray, int n) throws MoAccessException {
        boolean bl = false;
        for (int i = 0; i < structArray.length; ++i) {
            if ((Integer)structArray[i].getValue("vid") != n) continue;
            bl = true;
        }
        if (!bl) {
            throw new OperationNotAllowedException("UntaggedIngressVid is not part of vlanMembership.", "EthernetSwitch");
        }
    }
}

