/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.extethswitch;

import java.util.Arrays;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.extethswitch.EthernetBridgePortMoImpl;
import se.ericsson.cello.extethswitch.EthernetPortMo;
import se.ericsson.cello.extethswitch.EthernetPortMoImpl;
import se.ericsson.cello.extethswitch.EthernetSwitchMo;
import se.ericsson.cello.extethswitch.EthernetSwitchMoImpl;
import se.ericsson.cello.extethswitch.EthernetSwitchModuleMo;
import se.ericsson.cello.extethswitch.EthernetSwitchModuleMoImpl;
import se.ericsson.cello.extethswitch.EthernetSwitchModulePortMo;
import se.ericsson.cello.extethswitch.EthernetSwitchModulePortMoImpl;
import se.ericsson.cello.extethswitch.EthernetSwitchPortMo;
import se.ericsson.cello.extethswitch.EthernetSwitchPortMoImpl;
import se.ericsson.cello.extethswitch.ExtethswitchUtil;
import se.ericsson.cello.extethswitch.LagMoGen;
import se.ericsson.cello.extethswitch.SwitchPortStpMo;
import se.ericsson.cello.extethswitch.SwitchPortStpMoFactory;
import se.ericsson.cello.extethswitch.SwitchPortStpMoImpl;
import se.ericsson.cello.extethswitch.mom.EnumLacpMode;
import se.ericsson.cello.extethswitch.mom.EnumLinkSelection;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MoCanNotBeDeletedException;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.MoNotPossibleToReserveException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;

public class LagMoImpl
extends LagMoGen {
    SignedIntParameter parentFroType = null;
    SignedIntParameter parentFroId = null;
    public static final String SMXB_LAG_RDN = "Lag=CrossLinkLag1";
    public static final String PARENT_FROTYPE = "parentFroType";
    public static final String PARENT_FROID = "parentFroId";
    private static final int MAX_NO_OF_EP = 12;
    private boolean isSMXBNode = false;
    private boolean isCalledFromESM = false;
    private static final String SWITCH_PORT_STP_ID = "1";

    public LagMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public LagMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, SwitchPortStpMoFactory switchPortStpMoFactory) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
        if (managedObject instanceof EthernetSwitchMo || managedObject instanceof EthernetSwitchModuleMo) {
            switchPortStpMoFactory.autoCreateMo(this, SWITCH_PORT_STP_ID, coordinator);
        }
    }

    public LagMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        if (!setRequestContext.isIncludedInRequest("ethernetPortRef")) {
            ArrayParameter arrayParameter = null;
            arrayParameter = new ArrayParameter("ethernetPortRef");
            SignedIntParameter signedIntParameter = null;
            int n = 0;
            signedIntParameter = new SignedIntParameter("ethernetPortRef_member", n);
            arrayParameter.add((Parameter)signedIntParameter);
            setRequestContext.addParameter(this.froProxy, (Parameter)arrayParameter);
        }
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter(PARENT_FROTYPE, this.parentFroType.getValue()));
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter(PARENT_FROID, this.parentFroId.getValue()));
    }

    private static void checkPhysicalTypeOfEps(ManagedObject managedObject, ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (ExtethswitchUtil.isCaxPlugInUnit(managedObject, coordinator) && LagMoImpl.isOnCCIBPiu(managedObjectArray)) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                int n = ((EthernetPortMo)managedObjectArray[i]).getPortNo(coordinator);
                if (n >= 1 && n <= 12) {
                    if (n == 1 || n == 2) {
                        bl = true;
                    } else if (n == 7 && n == 8) {
                        bl3 = true;
                    } else {
                        bl2 = true;
                    }
                }
                if (!(bl && bl2 || bl && bl3) && (!bl2 || !bl3)) continue;
                throw new OperationNotAllowedException("The portNo attributes of EthernetPorts in ethernetPortRef are not of same physical type.", "Lag");
            }
        }
    }

    private static boolean isOnCCIBPiu(ManagedObject[] managedObjectArray) throws MoAccessException {
        boolean bl = true;
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (ExtethswitchUtil.isOnCCIBPiu(managedObjectArray[i])) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static void checkEqualityOfEps(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        Struct struct = null;
        struct = ((EthernetPortMoImpl)managedObjectArray[0]).getOperatingMode(coordinator);
        int n2 = ((EthernetPortMoImpl)managedObjectArray[0]).getAdministrativeState(coordinator);
        if (struct != null) {
            bl2 = (Boolean)struct.getValue("autoNegotiation");
            n = (Integer)struct.getValue("configuredSpeedDuplex");
        }
        for (int i = 1; i < managedObjectArray.length; ++i) {
            Struct struct2 = ((EthernetPortMoImpl)managedObjectArray[i]).getOperatingMode(coordinator);
            int n3 = ((EthernetPortMoImpl)managedObjectArray[i]).getAdministrativeState(coordinator);
            if (n2 != n3) {
                bl = true;
            } else if (struct != null && struct2 != null) {
                boolean bl3 = (Boolean)struct2.getValue("autoNegotiation");
                int n4 = (Integer)struct2.getValue("configuredSpeedDuplex");
                if (bl2 != bl3 || n != n4) {
                    bl = true;
                }
            } else if (struct != null || struct2 != null) {
                bl = true;
            }
            if (!bl) continue;
            throw new OperationNotAllowedException("The attributes of Ethernetports (operatingMode or administrativeState) in ethernetPortRef attribute of Lag are  not identical.", "EthernetPort");
        }
    }

    private static void checkParentAndLag(ManagedObject[] managedObjectArray, String string) throws MoAccessException {
        if (managedObjectArray != null && !Arrays.equals(managedObjectArray, ETHERNET_PORT_REF_DEFAULT)) {
            int n = managedObjectArray.length;
            StringBuffer stringBuffer = new StringBuffer();
            if (n != 0) {
                stringBuffer.append(managedObjectArray[0].getParent().getLocalDistinguishedName());
            }
            for (int i = 0; i < n; ++i) {
                String string2 = managedObjectArray[i].getParent().getLocalDistinguishedName();
                if (!stringBuffer.toString().equalsIgnoreCase(string2)) {
                    throw new InvalidReferenceException("Lag", (Object)managedObjectArray[i]);
                }
                LagMoImpl.checkIfSameCaxUnit(string, string2);
                ManagedObject[] managedObjectArray2 = ((EthernetPortMo)managedObjectArray[i]).getReservedBy(null);
                int n2 = managedObjectArray2.length;
                for (int j = 0; j < n2; ++j) {
                    String string3 = managedObjectArray2[j].getType();
                    String string4 = managedObjectArray2[j].getLocalDistinguishedName();
                    if (!string3.equals("Lag") || string4.equalsIgnoreCase(string)) continue;
                    throw new MoNotPossibleToReserveException("All referenced EthernetPorts must belong to the same Lag.", "Lag");
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateReservedMos(ManagedObject[] managedObjectArray, ManagedObject[] managedObjectArray2, Coordinator coordinator, String string) throws MoAccessException {
        if (string.equals("ethernetPortRef")) {
            if (managedObjectArray2.length < this.getRequiredNumberOfLinks(coordinator)) throw new OperationNotAllowedException("Set not allowed, set the ethernet links to 'equal to' or 'greater' than the requiredNumberoflinks", "Lag");
            super.updateReservedMos(managedObjectArray, managedObjectArray2, coordinator, string);
            return;
        } else {
            super.updateReservedMos(managedObjectArray, managedObjectArray2, coordinator, string);
        }
    }

    private static void checkIfSameCaxUnit(String string, String string2) throws ConfigurationMismatchException {
        if (string.indexOf("Slot=3") != -1) {
            if (string2.indexOf("Slot=3") == -1 && string2.indexOf("Slot=1") == -1) {
                throw new ConfigurationMismatchException("For LAG on Slot=3, EthernetPort must be on Slot=3 or Slot=1.");
            }
        } else if (string.indexOf("Slot=6") != -1 && string2.indexOf("Slot=6") == -1 && string2.indexOf("Slot=4") == -1) {
            throw new ConfigurationMismatchException("For LAG on Slot=6, EthernetPort must be on Slot=6 or Slot=4.");
        }
    }

    public void checkIfCaxConfigOrSMXBNode(ManagedObject[] managedObjectArray, ManagedObject managedObject, Coordinator coordinator, SetRequestContext setRequestContext) throws MoAccessException {
        this.isSMXBNode = ExtethswitchUtil.isSMXB(coordinator);
        if (managedObjectArray != null && !Arrays.equals(managedObjectArray, ETHERNET_PORT_REF_DEFAULT)) {
            if (managedObject.getType().equals("PlugInUnit")) {
                if (!this.isSMXBNode && !ExtethswitchUtil.isCaxPlugInUnit(managedObject, coordinator)) {
                    throw new ConfigurationMismatchException("ethernetPortRef can only be set when Lag MO is configured on the CAX configuration or when the Lag Mo  is not cross connected between SMXB", "Lag", "ethernetPortRef");
                }
            } else if (!this.isSMXBNode) {
                throw new ConfigurationMismatchException("ethernetPortRef can only be set when Lag MO is configured on the CAX configuration or when the Lag Mo is not cross connected between SMXB", "Lag", "ethernetPortRef");
            }
            for (int i = 0; i < managedObjectArray.length; ++i) {
                EthernetPortMoImpl.checkPortNumber(managedObjectArray[i], coordinator, "Lag", "ethernetPortRef");
            }
        }
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
        ManagedObject managedObject = this.getParent();
        Coordinator coordinator = setRequestContext.getCoordinator();
        if (setRequestContext.isIncludedInRequest("ethernetPortRef")) {
            ManagedObject[] managedObjectArray = (ManagedObject[])setRequestContext.getAttributeFromRequest("ethernetPortRef");
            ManagedObject[] managedObjectArray2 = this.getEthernetPortRef(coordinator);
            if (managedObject.getType().equals("PlugInUnit")) {
                String string = this.getRelativeDistinguishedName();
                if (this.isSMXBNode && string.equalsIgnoreCase(SMXB_LAG_RDN)) {
                    this.updateReservedMos(managedObjectArray, managedObjectArray2, coordinator, "ethernetPortRef");
                    throw new ConfigurationMismatchException("ethernetPortRef can only be set when Lag MO is configured on the CAX configuration or when the Lag Mo  is not cross connected between SMXB", "Lag", "ethernetPortRef");
                }
            }
        }
    }

    private static void checkMaxNrEps(ManagedObject[] managedObjectArray) throws ValueOutOfRangeException {
        if (managedObjectArray != null && managedObjectArray.length > 12) {
            throw new ValueOutOfRangeException("ethernetPortRef", "Max number of references is 12.");
        }
    }

    protected void validateLinkSelection(int n, SetRequestContext setRequestContext) throws MoAccessException {
        ManagedObject managedObject = this.getParent();
        if (managedObject instanceof EthernetSwitchMo) {
            int[] nArray = new int[]{0};
            MoGenUtil.checkEnumAttribute((String)"linkSelection", (int)n, (int[])nArray, (String)"Lag");
        } else {
            MoGenUtil.checkEnumAttribute((String)"linkSelection", (int)n, (int[])EnumLinkSelection.VALUES_ARRAY, (String)"Lag");
        }
    }

    protected void validateLacpMode(int n, SetRequestContext setRequestContext) throws MoAccessException {
        ManagedObject managedObject = this.getParent();
        if (managedObject instanceof EthernetSwitchMo) {
            int[] nArray = new int[]{0};
            MoGenUtil.checkEnumAttribute((String)"lacpMode", (int)n, (int[])nArray, (String)"Lag");
            this.parentFroType = new SignedIntParameter(PARENT_FROTYPE, ((EthernetSwitchMoImpl)managedObject).getFroType());
            this.parentFroId = new SignedIntParameter(PARENT_FROID, ((EthernetSwitchMoImpl)managedObject).getFroId(setRequestContext.getCoordinator()));
        } else if (managedObject instanceof EthernetSwitchModuleMo) {
            MoGenUtil.checkEnumAttribute((String)"lacpMode", (int)n, (int[])EnumLacpMode.VALUES_ARRAY, (String)"Lag");
            this.parentFroType = new SignedIntParameter(PARENT_FROTYPE, ((EthernetSwitchModuleMoImpl)managedObject).getFroType());
            this.parentFroId = new SignedIntParameter(PARENT_FROID, ((EthernetSwitchModuleMoImpl)managedObject).getFroId(setRequestContext.getCoordinator()));
        } else if (managedObject instanceof PlugInUnitMo) {
            MoGenUtil.checkEnumAttribute((String)"lacpMode", (int)n, (int[])EnumLacpMode.VALUES_ARRAY, (String)"Lag");
            this.parentFroType = new SignedIntParameter(PARENT_FROTYPE, Integer.parseInt("604", 16));
            this.parentFroId = new SignedIntParameter(PARENT_FROID, ((PlugInUnitMo)managedObject).getFroId(setRequestContext.getCoordinator()));
        }
    }

    public ManagedObject fetchMasterPort(SignedIntParameter signedIntParameter, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = this.getParent();
        ManagedObject managedObject2 = null;
        int n = 0;
        if (ExtethswitchUtil.isCaxPlugInUnit(managedObject, coordinator)) {
            managedObject2 = this.getMasterPortInCAXorSMXB(n, signedIntParameter, coordinator);
        } else {
            ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                ManagedObject managedObject3 = managedObjectArray[i];
                if (managedObject3 instanceof EthernetSwitchPortMoImpl) {
                    n = ((EthernetSwitchPortMoImpl)managedObject3).getFroId(coordinator);
                } else if (managedObject3 instanceof EthernetSwitchModulePortMoImpl) {
                    n = ((EthernetSwitchModulePortMoImpl)managedObject3).getFroId(coordinator);
                } else if (managedObject3 instanceof EthernetBridgePortMoImpl) {
                    n = ((EthernetBridgePortMoImpl)managedObject3).getFroId(coordinator);
                }
                if (n != signedIntParameter.getValue()) continue;
                managedObject2 = managedObject3;
                break;
            }
            if (managedObject2 == null) {
                managedObject2 = this.getMasterPortInCAXorSMXB(n, signedIntParameter, coordinator);
            }
        }
        return managedObject2;
    }

    private ManagedObject getMasterPortInCAXorSMXB(int n, SignedIntParameter signedIntParameter, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        ManagedObject[] managedObjectArray = this.getEthernetPortRef(coordinator);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            ManagedObject managedObject2 = managedObjectArray[i];
            if (managedObject2 != null) {
                n = ((EthernetPortMoImpl)managedObject2).getFroId(coordinator);
            }
            if (n != signedIntParameter.getValue()) continue;
            managedObject = managedObject2;
            break;
        }
        return managedObject;
    }

    public boolean isConfigAllowed(Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
        int n = this.getRequiredNumberOfLinks(coordinator);
        int n2 = 0;
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (!(managedObjectArray[i] instanceof EthernetSwitchModulePortMo) && !(managedObjectArray[i] instanceof EthernetSwitchPortMo)) continue;
            ++n2;
        }
        return n2 != n;
    }

    protected void validateEthernetPortRef(ManagedObject[] managedObjectArray, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateEthernetPortRef(managedObjectArray, setRequestContext);
        LagMoImpl.checkMaxNrEps(managedObjectArray);
        this.checkIfCaxConfigOrSMXBNode(managedObjectArray, this.getParent(), setRequestContext.getCoordinator(), setRequestContext);
        LagMoImpl.checkParentAndLag(managedObjectArray, this.getLocalDistinguishedName());
        if (managedObjectArray != null && managedObjectArray.length > 1) {
            LagMoImpl.checkEqualityOfEps(managedObjectArray, setRequestContext.getCoordinator());
            LagMoImpl.checkPhysicalTypeOfEps(this.getParent(), managedObjectArray, setRequestContext.getCoordinator());
        }
    }

    protected void onDelete(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = this.getParent();
        String string = this.getRelativeDistinguishedName();
        boolean bl = ExtethswitchUtil.isSMXB(coordinator);
        if (managedObject.getType().equals("PlugInUnit") && bl && !this.isCalledFromESM && string.equalsIgnoreCase(SMXB_LAG_RDN)) {
            throw new MoCanNotBeDeletedException("LAG for cross connection between SMXB cannot be deleted");
        }
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            Object object = moIterator.nextElement();
            if (!(object instanceof SwitchPortStpMo)) continue;
            ((SwitchPortStpMoImpl)object).deleteMo(coordinator);
        }
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
        int n = managedObjectArray.length;
        if (!(managedObject.getType().equals("EthernetSwitchPort") || managedObject.getType().equals("EthernetSwitchModulePort") || managedObject.getType().equals("EthernetBridgePort") || managedObject.getType().equals("InterfaceIpv4") || managedObject.getType().equals("VlanPort"))) {
            throw new MoNotPossibleToReserveException("Reserving Mo not of type EthernetSwitchPort or EthernetSwitchModulePort or EthernetBridgePort or VlanPort or InterfaceIpv4", "Lag");
        }
        for (int i = 0; i < n; ++i) {
            if (managedObjectArray[i].getType().equalsIgnoreCase("Lag")) {
                throw new MoNotPossibleToReserveException("This MO is already reserved by Lag MO.", "Lag");
            }
            if (managedObjectArray[i].getType().equalsIgnoreCase("EthernetBridgePort")) {
                throw new MoNotPossibleToReserveException("This MO is already reserved by EthernetBridgePort MO.", "Lag");
            }
            if (managedObjectArray[i].getType().equalsIgnoreCase("VlanPort") && !managedObject.getType().equalsIgnoreCase("VlanPort") && !managedObject.getType().equalsIgnoreCase("InterfaceIpv4")) {
                throw new MoNotPossibleToReserveException(" This MO already reserved by VlanPort MO.", "Lag");
            }
            if (!managedObjectArray[i].getType().equalsIgnoreCase("InterfaceIpv4") || managedObject.getType().equalsIgnoreCase("VlanPort") || managedObject.getType().equalsIgnoreCase("InterfaceIpv4")) continue;
            throw new MoNotPossibleToReserveException(" This MO already reserved by InterfaceIpv4 MO.", "Lag");
        }
        super.reserve(managedObject, coordinator);
    }

    public int getFroType() throws MoAccessException {
        return Integer.parseInt("D07", 16);
    }

    public void deleteAutocreatedCrossLink(Coordinator coordinator, boolean bl) throws MoAccessException {
        this.isCalledFromESM = bl;
        super.delete(coordinator);
    }
}

