/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam;

import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.ipoam.DhcpMoFactory;
import se.ericsson.cello.ipoam.EthernetLinkMoFactory;
import se.ericsson.cello.ipoam.FroAlarmMappings;
import se.ericsson.cello.ipoam.GeneratedAlarmDefinitions;
import se.ericsson.cello.ipoam.IpAtmLinkMoFactory;
import se.ericsson.cello.ipoam.IpHostLinkMoFactory;
import se.ericsson.cello.ipoam.IpMoFactory;
import se.ericsson.cello.ipoam.IpOamMoFactory;
import se.ericsson.cello.ipoam.IpOamMoImpl;
import se.ericsson.cello.ipoam.IpRoutingTableMoFactory;
import se.ericsson.cello.ipoam.OamSupervisionMoFactory;
import se.ericsson.cello.ipoam.OspfAreaMoFactory;
import se.ericsson.cello.ipoam.OspfInterfaceMoFactory;
import se.ericsson.cello.ipoam.OspfMoFactory;
import se.ericsson.cello.ipoam.fropxy.OsaDhcprFroMgmntProxy;
import se.ericsson.cello.ipoam.fropxy.OsaIpFroMgmntProxy;
import se.ericsson.cello.ipoam.fropxy.OsaIpLinkMgmntProxy;
import se.ericsson.cello.ipoam.fropxy.OsaIpSystemMgmntProxy;
import se.ericsson.cello.ipoam.fropxy.OsaOspfAreaMgmntProxy;
import se.ericsson.cello.ipoam.fropxy.OsaOspfInterfaceMgmntProxy;
import se.ericsson.cello.ipoam.fropxy.OsaOspfMgmntProxy;
import se.ericsson.cello.ipoam.ipom_dhcpmi;
import se.ericsson.cello.ipoam.ipom_dnsclient_mi;
import se.ericsson.cello.ipoam.ipom_ethlink_mi;
import se.ericsson.cello.ipoam.ipom_iphostlinkmi;
import se.ericsson.cello.ipoam.ipom_iprouting_table_mi;
import se.ericsson.cello.ipoam.ipom_supervision_mi;
import se.ericsson.cello.mao.MaRevisionWriter;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.proxy.FroProxyFactoryImpl;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.Mopplet;
import se.ericsson.cello.pmapp.PmAppPortal;
import se.ericsson.cello.pmapp.PmAppPortalImpl;
import se.ericsson.cello.support.debug.MessageLog;

public class IpMgr
implements Mopplet {
    private FroProxy dhcpProxy = null;
    private DhcpMoFactory dhcpFactory = null;
    private FroProxy ipHostLinkProxy = null;
    private IpHostLinkMoFactory ipHostLinkFactory = null;
    private FroProxy ethernetLinkProxy = null;
    private EthernetLinkMoFactory ethernetLinkMoFactory = null;
    private FroProxy ipRoutingTableProxy = null;
    private IpRoutingTableMoFactory ipRoutingTableFactory = null;
    private FroProxy dnsClientProxy = null;
    private FroProxy oamSupervisionProxy = null;
    private static final String IF_PM_IPOM_IPHOSTLINK = "se.ericsson.cello.ipoam.ipom_ip_host_link";
    private static final String IF_PM_IPOM_ETHERNETLINK = "se.ericsson.cello.ipoam.ipom_ethernet_link";

    public void init() {
        this.dhcpProxy = FroProxyFactoryImpl.getProxy((Class)ipom_dhcpmi.class, (String)"Dhcp");
        this.dhcpFactory = new DhcpMoFactory(this.dhcpProxy);
        this.dhcpFactory.registerFactory();
        this.ipHostLinkProxy = FroProxyFactoryImpl.getProxy((Class)ipom_iphostlinkmi.class, (String)"IpHostLink");
        this.ipHostLinkFactory = new IpHostLinkMoFactory(this.ipHostLinkProxy);
        this.ipHostLinkFactory.registerFactory();
        this.ipRoutingTableProxy = FroProxyFactoryImpl.getProxy((Class)ipom_iprouting_table_mi.class, (String)"IpRoutingTable");
        this.ipRoutingTableFactory = new IpRoutingTableMoFactory(this.ipRoutingTableProxy);
        this.ipRoutingTableFactory.registerFactory();
        this.ethernetLinkProxy = FroProxyFactoryImpl.getProxy((Class)ipom_ethlink_mi.class, (String)"EthernetLink");
        this.ethernetLinkMoFactory = new EthernetLinkMoFactory(this.ethernetLinkProxy);
        this.ethernetLinkMoFactory.registerFactory();
        this.dnsClientProxy = FroProxyFactoryImpl.getProxy((Class)ipom_dnsclient_mi.class, (String)"Ip");
        IpOamMoFactory.instance().registerFactory();
        IpMoFactory.instance(this.ipHostLinkProxy, this.dnsClientProxy);
        IpAtmLinkMoFactory.instance();
        OspfMoFactory.instance().registerFactory();
        OspfAreaMoFactory.instance().registerFactory();
        OspfInterfaceMoFactory.instance().registerFactory();
        if (System.getProperty("is.using.nat", "false").equalsIgnoreCase("true")) {
            this.oamSupervisionProxy = FroProxyFactoryImpl.getProxy((Class)ipom_supervision_mi.class, (String)"OamSupervision");
            new OamSupervisionMoFactory(this.oamSupervisionProxy).registerFactory();
        }
        IpOamMoImpl.instance();
        GeneratedAlarmDefinitions.init(AlarmManager.getDefinitionRepository());
        FroAlarmMappings.initiate();
        PmAppPortal pmAppPortal = PmAppPortalImpl.create();
        pmAppPortal.startProxy("IpHostLink", new String[]{IF_PM_IPOM_IPHOSTLINK});
        pmAppPortal.startProxy("EthernetLink", new String[]{IF_PM_IPOM_ETHERNETLINK});
    }

    public void start() {
        MaRevisionWriter.writeRevision((Object)this);
        IpOamMoImpl.instance().registerData();
        if (MoRepository.instance().lookupType("Dhcp") == null) {
            try {
                this.dhcpFactory.createInitialMo(this.dhcpProxy);
            }
            catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
                MessageLog.traceError(this.getClass(), (String)"Create instance of Dhcp MO failed", (Throwable)moNameAlreadyTakenException);
            }
        }
        this.dhcpProxy.subscribeService();
        OsaIpFroMgmntProxy.instance().subscribeService();
        OsaOspfMgmntProxy.instance().subscribeService();
        OsaIpLinkMgmntProxy.getInstance().subscribeService();
        OsaIpSystemMgmntProxy.instance().subscribeService();
        OsaOspfAreaMgmntProxy.instance().subscribeService();
        OsaOspfInterfaceMgmntProxy.instance().subscribeService();
        OsaDhcprFroMgmntProxy.instance().subscribeService();
        this.ipHostLinkProxy.subscribeService();
        this.ipRoutingTableProxy.subscribeService();
        this.ethernetLinkProxy.subscribeService();
        this.dnsClientProxy.subscribeService();
        if (System.getProperty("is.using.nat", "false").equalsIgnoreCase("true")) {
            this.oamSupervisionProxy.subscribeService();
        }
    }
}

