/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;

public class PersistentReservationHelper {
    private ManagedObject mo = null;
    private SequenceAttribute reservedBy = null;

    public PersistentReservationHelper(ManagedObject managedObject, MoData moData, String string) {
        this.reservedBy = this.validateAttr(moData, string);
        this.mo = this.validateMo(managedObject);
    }

    private SequenceAttribute validateAttr(MoData moData, String string) {
        Attribute attribute = moData.getAttribute(string);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute " + string + " doesn't exist!");
        }
        if (!(attribute instanceof SequenceAttribute)) {
            throw new IllegalArgumentException("Attribute " + string + " must be a sequence!");
        }
        return (SequenceAttribute)attribute;
    }

    private ManagedObject validateMo(ManagedObject managedObject) {
        if (managedObject == null) {
            throw new NullPointerException();
        }
        return managedObject;
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        Attribute[] attributeArray = this.reservedBy.getValue(coordinator);
        ManagedObject[] managedObjectArray = new ManagedObject[attributeArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            managedObjectArray[i] = ((ReferenceAttribute)attributeArray[i]).getValue(coordinator);
        }
        return managedObjectArray;
    }

    public void handleDelete(Coordinator coordinator) throws MoAccessException {
        if (this.reservedBy.size() > 0) {
            throw new MoReservedNotDeletableException(this.mo);
        }
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, NullPointerException {
        if (managedObject == null) {
            throw new NullPointerException("mo was NULL");
        }
        ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (managedObjectArray[i] != managedObject) continue;
            return;
        }
        this.reservedBy.addElement((Attribute)new ReferenceAttribute("", false, managedObject));
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        Attribute[] attributeArray = this.reservedBy.getValue(coordinator);
        for (int i = 0; i < attributeArray.length; ++i) {
            if (((ReferenceAttribute)attributeArray[i]).getValue(coordinator) != managedObject) continue;
            this.reservedBy.removeElement(attributeArray[i]);
            break;
        }
    }
}

