/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pmapp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.pmapp.CelloScanner;
import se.ericsson.cello.pmapp.PmAppPortal;
import se.ericsson.cello.pmapp.PmAppPortalImpl;
import se.ericsson.cello.pms.generic.BasicScanner;
import se.ericsson.cello.pms.generic.BasicScannerFactory;
import se.ericsson.cello.pms.generic.BasicScannerFactoryExt;
import se.ericsson.cello.pms.generic.DataConsumer;
import se.ericsson.cello.pms.generic.GranularityAndAttributeActivationException;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.GranularityPeriodNotSupportedException;
import se.ericsson.cello.pms.generic.NumberOfCountersExceededException;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.ParameterNotAcceptedException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.pms.generic.PmsPortalImpl;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.transaction.Coordinator;

public class CelloScannerFactory
implements BasicScannerFactory,
BasicScannerFactoryExt,
ActionListener {
    private List myScanners = new ArrayList();
    private PmAppPortal myPmAppPortal;
    private static CelloScannerFactory instance;

    public BasicScanner create(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray, GranularityPeriod granularityPeriod, PerformanceMonitoringState performanceMonitoringState, DataConsumer dataConsumer, String string, Coordinator coordinator) throws GranularityPeriodNotSupportedException, NumberOfCountersExceededException, GranularityAndAttributeActivationException, OverloadException, ParameterNotAcceptedException {
        CelloScanner celloScanner = new CelloScanner(observationClassArray, observationObjectArray, granularityPeriod, performanceMonitoringState, dataConsumer, string, coordinator, this.myPmAppPortal);
        return celloScanner;
    }

    public BasicScanner createExt(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray, GranularityPeriod granularityPeriod, PerformanceMonitoringState performanceMonitoringState, DataConsumer dataConsumer, String string, Coordinator coordinator, Map map) throws OverloadException, GranularityAndAttributeActivationException {
        boolean bl = map.containsKey(BasicScannerFactoryExt.KPI_EXTENSION);
        CelloScanner celloScanner = new CelloScanner(observationClassArray, observationObjectArray, granularityPeriod, performanceMonitoringState, dataConsumer, string, coordinator, this.myPmAppPortal, bl);
        return celloScanner;
    }

    public static synchronized CelloScannerFactory getInstance() {
        if (instance == null) {
            instance = new CelloScannerFactory(PmAppPortalImpl.create());
        }
        return instance;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MessageLog.trace((int)5, this.getClass(), (String)("actionPerformed(): event.getID() = " + actionEvent.getID()));
        try {
            if (actionEvent.getID() == 107) {
                this.send2AllScanners(actionEvent);
            } else if (actionEvent.getID() == 108) {
                this.send2AllScanners(actionEvent);
            } else if (actionEvent.getID() == 111 || actionEvent.getID() == 112) {
                PmsPortalImpl.getPortal().getLoadControl().triggerPmLoadControl();
                this.send2AllScanners(actionEvent);
            } else if (actionEvent.getID() == 113 || actionEvent.getID() == 114) {
                PmsPortalImpl.getPortal().getLoadControl().triggerPmLoadControl();
                this.send2AllScanners(actionEvent);
            } else if (actionEvent.getID() == 101) {
                this.scannerCreated((CelloScanner)((Object)actionEvent.getSource()));
            } else if (actionEvent.getID() == 103) {
                this.scannerDeleted((CelloScanner)((Object)actionEvent.getSource()));
            } else if (actionEvent.getID() == 102) {
                MessageLog.info(this.getClass(), (String)"SCANNER_CREATED_ROLLBACK_EVENT_ID");
            } else {
                MessageLog.traceError(this.getClass(), (String)("Unknown event.getID(): " + actionEvent.getID()));
            }
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)("actionPerformed() generated runtime exception for event.getID()=" + actionEvent.getID()), (Throwable)runtimeException);
        }
    }

    public Iterator getScanners() {
        return this.myScanners.iterator();
    }

    public Iterator getActiveScanners() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.myScanners.size(); ++i) {
            if (!((CelloScanner)((Object)this.myScanners.get(i))).getScannerState().equals(PerformanceMonitoringState.ACTIVE)) continue;
            arrayList.add(this.myScanners.get(i));
        }
        return arrayList.iterator();
    }

    public int getScannerCount() {
        return this.myScanners.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scannerCreated(CelloScanner celloScanner) {
        List list = this.myScanners;
        synchronized (list) {
            this.myScanners.add(celloScanner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scannerDeleted(CelloScanner celloScanner) {
        List list = this.myScanners;
        synchronized (list) {
            this.myScanners.remove((Object)celloScanner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send2AllScanners(ActionEvent actionEvent) {
        MessageLog.trace((int)5, this.getClass(), (String)("Sending event to " + this.myScanners.size() + " scanners."));
        List list = this.myScanners;
        synchronized (list) {
            Iterator iterator = this.getScanners();
            while (iterator.hasNext()) {
                ActionListener actionListener = (ActionListener)iterator.next();
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    private CelloScannerFactory(PmAppPortal pmAppPortal) {
        this.myPmAppPortal = pmAppPortal;
    }
}

