/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.internaltransport.fropxy;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import se.ericsson.cello.common.fropxy.CmaPortManager;
import se.ericsson.cello.common.fropxy.CmaSignalPort;
import se.ericsson.cello.common.fropxy.FroEmptySignal;
import se.ericsson.cello.common.fropxy.FroProxy;
import se.ericsson.cello.common.fropxy.FroReqU32U32;
import se.ericsson.cello.common.fropxy.FroReqU32U32U16;
import se.ericsson.cello.common.fropxy.FroSignalHandling;
import se.ericsson.cello.internaltransport.SwitchUnitInterface;
import se.ericsson.cello.internaltransport.fropxy.SpasSiliFroCreateReq;
import se.ericsson.cello.internaltransport.fropxy.SpasSiliFroCreateRsp;
import se.ericsson.cello.internaltransport.fropxy.SpasSiliFroDeleteRsp;
import se.ericsson.cello.internaltransport.fropxy.SpasSiliFroFaultCeasedInd;
import se.ericsson.cello.internaltransport.fropxy.SpasSiliFroFaultInd;
import se.ericsson.cello.internaltransport.fropxy.SpasSiliFroResourceCeasedInd;
import se.ericsson.cello.internaltransport.fropxy.SpasSiliFroResourceInd;
import se.ericsson.cello.internaltransport.fropxy.SpasSiliFroSetAdmStateRsp;
import se.ericsson.cello.internaltransport.fropxy.SpasSiliGetAttrRsp;
import se.ericsson.cello.mao.TransactionHelperImpl;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.session.NameServerWrapper;
import se.ericsson.cello.session.ServiceSubscriber;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SignalObserver;
import se.ericsson.cello.support.sigutil.SignalPort;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;

public class SpasSiliFroProxy
extends FroProxy {
    private OseProcess op = null;
    public static final int SPAS_RESULT_OK = 1;
    public static final int SPAS_RESULT_NOT_OK = 2;
    public static final int SPAS_PORTSTATUS_ACTIVE = 1;
    public static final int SPAS_PORTSTATUS_PASSIVE = 2;
    public static final int SPAS_PORTSTATUS_NOT_CONNECTED = 3;
    public static final int SPAS_PORTSTATUS_LOCKED = 4;
    public static final int SPAS_PORTSTATUS_NOT_INSTALLED = 5;
    private static final int TX_TIMEOUT = 3600;
    private static final int RETRY_INTERVAL_TRANSACTION_CREATE = 500;
    private static final int MAX_NO_OF_RETRIES_TRANSACTION_CREATE = 20;
    private static BlockingQueue bQueue = new BlockingQueue();
    public static final int SPAS_NOFROID = 255;
    private SignalPort signalPort = PortManager.instance();
    private CmaSignalPort cmaSignalPort = CmaPortManager.instance();
    private static String SILI_FRO_TYPE_NAME = "SRI_SERVICE";
    private static SpasSiliFroProxy instance = null;

    public SpasSiliFroCreateRsp sendSpasSiliFroCreateReq(long l, int n, int n2, int n3) {
        if (this.op == null && !this.init()) {
            return null;
        }
        SpasSiliFroCreateReq spasSiliFroCreateReq = new SpasSiliFroCreateReq(l, n, n2, n3);
        SpasSiliFroCreateRsp spasSiliFroCreateRsp = (SpasSiliFroCreateRsp)SignalHelper.sendAndReceive((OseProcess)this.op, (Signal)spasSiliFroCreateReq, (Class)SpasSiliFroCreateRsp.class);
        return spasSiliFroCreateRsp;
    }

    public SpasSiliFroDeleteRsp sendSpasSiliFroDeleteReq(long l, long l2) {
        if (this.op == null && !this.init()) {
            return null;
        }
        FroReqU32U32 froReqU32U32 = new FroReqU32U32(232194, (int)l, (int)l2);
        SpasSiliFroDeleteRsp spasSiliFroDeleteRsp = (SpasSiliFroDeleteRsp)SignalHelper.sendAndReceive((OseProcess)this.op, (Signal)froReqU32U32, (Class)SpasSiliFroDeleteRsp.class);
        return spasSiliFroDeleteRsp;
    }

    public SpasSiliFroSetAdmStateRsp sendSpasSiliFroSetAdmStateReq(long l, long l2, int n) {
        if (this.op == null && !this.init()) {
            return null;
        }
        FroReqU32U32U16 froReqU32U32U16 = new FroReqU32U32U16(232196, (int)l, (int)l2, n);
        SpasSiliFroSetAdmStateRsp spasSiliFroSetAdmStateRsp = (SpasSiliFroSetAdmStateRsp)SignalHelper.sendAndReceive((OseProcess)this.op, (Signal)froReqU32U32U16, (Class)SpasSiliFroSetAdmStateRsp.class);
        return spasSiliFroSetAdmStateRsp;
    }

    public SpasSiliGetAttrRsp sendSpasSiliGetAttrReq(long l, long l2) {
        if (this.op == null && !this.init()) {
            return null;
        }
        FroReqU32U32 froReqU32U32 = new FroReqU32U32(232198, (int)l, (int)l2);
        SpasSiliGetAttrRsp spasSiliGetAttrRsp = (SpasSiliGetAttrRsp)SignalHelper.sendAndReceive((OseProcess)this.op, (Signal)froReqU32U32, (Class)SpasSiliGetAttrRsp.class);
        return spasSiliGetAttrRsp;
    }

    public void sendSpasSiliFroNotifSubscribeReq() {
        FroEmptySignal froEmptySignal = new FroEmptySignal(232200);
        OseProcess oseProcess = this.signalPort.getOseProcess();
        if (!this.init()) {
            return;
        }
        SignalHelper.sendWithSender((OseProcess)this.op, (OseProcess)oseProcess, (Signal)froEmptySignal);
    }

    public void signalReceived(InSignal inSignal) {
        if (inSignal instanceof SpasSiliFroResourceInd || inSignal instanceof SpasSiliFroResourceCeasedInd) {
            if (inSignal instanceof SpasSiliFroResourceInd) {
                MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)(" >> enqueue >> SpasSiliFroResourceInd - portNumber = " + ((SpasSiliFroResourceInd)inSignal).getPortNumber()));
            }
            if (inSignal instanceof SpasSiliFroResourceCeasedInd) {
                MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)(" >> enqueue >> SpasSiliFroResourceCeasedInd - portNumber = " + ((SpasSiliFroResourceCeasedInd)inSignal).getPortNumber()));
            }
            bQueue.enqueue((Object)inSignal);
        } else {
            FroSignalHandling.run((InSignal)inSignal, (Hashtable)this.subscriptions, ((Object)((Object)this)).getClass());
        }
    }

    public void deleteSwitchInternalLinkPort(SpasSiliFroResourceCeasedInd spasSiliFroResourceCeasedInd) {
        int n = 0;
        int n2 = 0;
        Control control = null;
        try {
            n2 = spasSiliFroResourceCeasedInd.getParentFroId();
            n = spasSiliFroResourceCeasedInd.getPortNumber();
            control = TransactionHelperImpl.instance().createTransactionWithTimeOut(500, 20, 3600);
            Coordinator coordinator = control.getCoordinator();
            ManagedObject managedObject = null;
            managedObject = (ManagedObject)this.subscriptions.get(new Integer(n2));
            if (managedObject == null) {
                MessageLog.info(((Object)((Object)this)).getClass(), (String)("Mo with froid= " + n2 + " could not be found in subscriptions"));
            } else if (managedObject instanceof SwitchUnitInterface) {
                ((SwitchUnitInterface)managedObject).deleteSILP(n, coordinator);
            } else {
                throw new IllegalParameterValueException(" matching parentMo not found to delete SwitchInternalLinkPort Mo, parentFroId = " + n2);
            }
            if (control != null) {
                control.getTerminator().commit();
            }
        }
        catch (TransactionRequiredException transactionRequiredException) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)" TransactionRequiredException - SwitchInternalLinkPort deletion failed", (Throwable)transactionRequiredException);
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)" TransactionRolledBackException - SwitchInternalLinkPort deletion failed", (Throwable)transactionRolledBackException);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)" InactiveTransactionException - SwitchInternalLinkPort deletion failed", (Throwable)inactiveTransactionException);
        }
        catch (IllegalParameterValueException illegalParameterValueException) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)(" deletion of SwitchInternalLinkPortMo Failed - matching parentMo not found, parentFroId = " + n2), (Throwable)illegalParameterValueException);
            this.rollbackTransaction(control);
        }
        catch (FroRequestFailedException froRequestFailedException) {
            MessageLog.info(((Object)((Object)this)).getClass(), (String)(" FroRequestFailed - deletion of SwitchInternalLinkPortMo Failed " + (Object)((Object)froRequestFailedException)));
            this.rollbackTransaction(control);
        }
        catch (Exception exception) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)" deletion of SwitchInternalLinkPortMo Failed", (Throwable)exception);
            this.rollbackTransaction(control);
        }
    }

    public void createSwitchInternalLinkPort(SpasSiliFroResourceInd spasSiliFroResourceInd) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Control control = null;
        try {
            n = spasSiliFroResourceInd.getSmn();
            n2 = spasSiliFroResourceInd.getApn();
            n3 = spasSiliFroResourceInd.getPortNumber();
            boolean bl = false;
            control = TransactionHelperImpl.instance().createTransactionWithTimeOut(500, 20, 3600);
            Coordinator coordinator = control.getCoordinator();
            SwitchUnitInterface switchUnitInterface = null;
            MoIterator moIterator = MoRepository.instance().lookupType("SwitchExtensionUnit");
            MoIterator moIterator2 = MoRepository.instance().lookupType("SwitchCoreUnit");
            ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>();
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    arrayList.add(moIterator.nextMo());
                }
            }
            if (moIterator2 != null) {
                while (moIterator2.hasMoreElements()) {
                    arrayList.add(moIterator2.nextMo());
                }
            }
            if (arrayList != null && arrayList.size() > 0) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    switchUnitInterface = (SwitchUnitInterface)iterator.next();
                    int n4 = switchUnitInterface.getAsciPortNumber(coordinator);
                    int n5 = switchUnitInterface.getSwitchModuleNumber(coordinator);
                    if (n4 != n2 || n5 != n) continue;
                    bl = true;
                    switchUnitInterface.createSILP(n3, coordinator);
                }
            }
            if (!bl) {
                throw new IllegalParameterValueException("smn / apn did not match - smn= " + n + ", apn= " + n2);
            }
            if (control != null) {
                control.getTerminator().commit();
            }
        }
        catch (TransactionRequiredException transactionRequiredException) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)" TransactionRequiredException - SwitchInternalLinkPort creation failed", (Throwable)transactionRequiredException);
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)" TransactionRolledBackException - SwitchInternalLinkPort creation failed", (Throwable)transactionRolledBackException);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)" InactiveTransactionException - SwitchInternalLinkPort creation failed", (Throwable)inactiveTransactionException);
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            MessageLog.info(((Object)((Object)this)).getClass(), (String)(" MoNameAlreadyTaken : ignoring create request for smn/apn/portNumber, MO already exists - smn= " + n + ", apn= " + n2 + ", portNumber= " + n3));
            this.rollbackTransaction(control);
        }
        catch (IllegalParameterValueException illegalParameterValueException) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)(" Creation of SwitchInternalLinkPortMo Failed -  smn:apn pair did not match, smn= " + n + ", apn= " + n2), (Throwable)illegalParameterValueException);
            this.rollbackTransaction(control);
        }
        catch (FroRequestFailedException froRequestFailedException) {
            MessageLog.info(((Object)((Object)this)).getClass(), (String)(" FroRequestFailed - Creation of SwitchInternalLinkPortMo Failed " + (Object)((Object)froRequestFailedException)));
            this.rollbackTransaction(control);
        }
        catch (Exception exception) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)" Creation of SwitchInternalLinkPortMo Failed", (Throwable)exception);
            this.rollbackTransaction(control);
        }
    }

    private void rollbackTransaction(Control control) {
        try {
            if (control != null) {
                control.getTerminator().rollback();
            }
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.info(((Object)((Object)this)).getClass(), (String)("rollback failed - Inactive Transaction " + (Object)((Object)inactiveTransactionException)));
        }
    }

    public BlockingQueue getBQueue() {
        return bQueue;
    }

    public void serviceAdded() {
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("serviceAdded(), serviceTag: " + SILI_FRO_TYPE_NAME));
        this.sendSpasSiliFroNotifSubscribeReq();
    }

    public String getSpasPortStatusMsg(long l) {
        String string;
        switch ((int)l) {
            case 1: {
                string = "SPAS_PORTSTATUS_ACTIVE";
                break;
            }
            case 2: {
                string = "SPAS_PORTSTATUS_PASSIVE";
                break;
            }
            case 3: {
                string = "SPAS_PORTSTATUS_NOT_CONNECTED";
                break;
            }
            case 4: {
                string = "SPAS_PORTSTATUS_LOCKED";
                break;
            }
            case 5: {
                string = "SPAS_PORTSTATUS_NOT_INSTALLED";
                break;
            }
            default: {
                string = "UNKNOWN RESULT CODE: " + l;
            }
        }
        return string;
    }

    public String getFroIDMsg(long l) {
        String string;
        switch ((int)l) {
            case 255: {
                string = "SPAS_NOFROID";
                break;
            }
            default: {
                string = "UNKNOWN RESULT CODE: " + l;
            }
        }
        return string;
    }

    public String getResultMsg(long l) {
        String string;
        switch ((int)l) {
            case 1: {
                string = "SPAS_RESULT_OK";
                break;
            }
            case 2: {
                string = "SPAS_RESULT_NOT_OK";
                break;
            }
            default: {
                string = "UNKNOWN RESULT CODE: " + l;
            }
        }
        return string;
    }

    private SpasSiliFroProxy() {
        this.cmaSignalPort.addSignalObserver((SignalObserver)this, SpasSiliFroFaultInd.class);
        this.cmaSignalPort.addSignalObserver((SignalObserver)this, SpasSiliFroFaultCeasedInd.class);
        this.cmaSignalPort.addSignalObserver((SignalObserver)this, SpasSiliFroResourceInd.class);
        this.cmaSignalPort.addSignalObserver((SignalObserver)this, SpasSiliFroResourceCeasedInd.class);
    }

    public void subscribeService() {
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)"subscribeService() ");
        new NameServerWrapper(SILI_FRO_TYPE_NAME, (ServiceSubscriber)this);
    }

    public static SpasSiliFroProxy instance() {
        if (instance == null) {
            instance = new SpasSiliFroProxy();
        }
        return instance;
    }

    public void serviceRemoved() {
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("serviceRemoved(), serviceTag: " + SILI_FRO_TYPE_NAME));
        this.op = null;
        super.serviceRemoved(SILI_FRO_TYPE_NAME);
    }

    private boolean init() {
        this.op = OseNameServer.lookup((String)SILI_FRO_TYPE_NAME);
        if (this.op == null) {
            MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)"init() , op = null ");
            return false;
        }
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("init() , op: " + this.op.getPID()));
        return true;
    }
}

