/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam;

import [Lse.ericsson.cello.moframework.Struct;;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.ipoam.EthIpv6AddressInfo;
import se.ericsson.cello.ipoam.EthernetLinkMo;
import se.ericsson.cello.ipoam.EthernetLinkMoImpl;
import se.ericsson.cello.ipoam.IpMo;
import se.ericsson.cello.ipoam.IpMoImpl;
import se.ericsson.cello.ipoam.Ipv4AddressInfo;
import se.ericsson.cello.ipoam.NetworkMask;
import se.ericsson.cello.ipoam.ipom_ethlink_mi;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AttrListMoGenImpl;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.IpAddressValidation;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.MoCanNotBeDeletedException;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public abstract class EthernetLinkMoGen
extends CelloMao
implements EthernetLinkMo {
    private static String[] ATTRIBUTE_NAMES = new String[]{"ipAddress", "subnetMask", "broadcastAddress", "mtuSize", "metric", "ipv4Addresses", "ipv6Addresses", "userLabel"};
    private static boolean[] MANDATORY = new boolean[]{false, false, false, false, false, false, false, false};
    protected FroProxy froProxy = null;
    protected MoData data;
    protected static final TagNameDictionary DICTIONARY = TagNameDictionaries.create((ResourceBundle)new ipom_ethlink_mi());
    private static final String ETHERNET_FRO_ID = "ethernetFroId";
    protected MaoFroIndicationHandler indHandler;
    private static final int MO_DATA_REVISION_50 = 5000;
    private static final int MO_DATA_REVISION_LATEST = 5000;
    private static final String EMPTY_STRING = "";

    protected EthernetLinkMoGen(Coordinator coordinator, ManagedObject managedObject, String string, FroProxy froProxy, AttrList attrList, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "EthernetLink", string, coordinator);
        FroData froData;
        String string2;
        Struct[] structArray;
        this.froProxy = froProxy;
        this.indHandler = maoFroIndicationHandler;
        MoGenUtil.checkAttributesDuringCreate((String[])ATTRIBUTE_NAMES, (boolean[])MANDATORY, (AttrList)attrList, (String)"EthernetLink");
        String string3 = (String)MoGenUtil.checkAndGetAttributeType((String)"ipAddress", (AttrList)attrList, (Class)String.class, (String)"EthernetLink");
        this.validateIpAddress(attrList, string3, coordinator);
        String string4 = (String)MoGenUtil.checkAndGetAttributeType((String)"subnetMask", (AttrList)attrList, (Class)String.class, (String)"EthernetLink");
        this.validateSubnetMask(attrList, string4, coordinator);
        String string5 = (String)MoGenUtil.checkAndGetAttributeType((String)"broadcastAddress", (AttrList)attrList, (Class)String.class, (String)"EthernetLink");
        this.validateBroadcastAddress(attrList, string5, coordinator);
        Integer n = (Integer)MoGenUtil.checkAndGetAttributeType((String)"mtuSize", (AttrList)attrList, (Class)Integer.class, (String)"EthernetLink");
        int n2 = 1500;
        if (n != null) {
            n2 = n;
        }
        this.validateMtuSize(attrList, n2, coordinator);
        Integer n3 = (Integer)MoGenUtil.checkAndGetAttributeType((String)"metric", (AttrList)attrList, (Class)Integer.class, (String)"EthernetLink");
        int n4 = 1;
        if (n3 != null) {
            n4 = n3;
        }
        this.validateMetric(attrList, n4, coordinator);
        Struct[] structArray2 = (Struct[])MoGenUtil.checkAndGetAttributeType((String)"ipv4Addresses", (AttrList)attrList, (Class)Struct;.class, (String)"EthernetLink");
        if (structArray2 != null && (string3 != null || string5 != null || string4 != null)) {
            throw new ConfigurationMismatchException("Cannot create EthernetLink with ipv4Addresses and ( ipAddress or broadcastAddress or subnetMask) at the same time ", "EthernetLink");
        }
        if (structArray2 != null) {
            this.validateIpv4Addresses(attrList, structArray2, coordinator);
        }
        if ((structArray = (Struct[])MoGenUtil.checkAndGetAttributeType((String)"ipv6Addresses", (AttrList)attrList, (Class)Struct;.class, (String)"EthernetLink")) != null) {
            this.validateIpv6Addresses(attrList, structArray, coordinator);
        }
        if ((string2 = (String)MoGenUtil.checkAndGetAttributeType((String)"userLabel", (AttrList)attrList, (Class)String.class, (String)"EthernetLink")) == null) {
            string2 = EMPTY_STRING;
        }
        this.validateUserLabel(attrList, string2, coordinator);
        if (structArray2 == null && (string3 != null || string5 != null || string4 != null)) {
            int n5 = 0;
            if (string4 == null) {
                string4 = EMPTY_STRING;
            } else {
                n5 = NetworkMask.calculateIpV4Prefix(string4);
            }
            MoGenUtil.checkIntegerAttribute((String)"subnetMask", (int)n5, (int)0, (int)30, (String)"EthernetLink");
            if (string3 == null) {
                string3 = EMPTY_STRING;
            }
            if (string5 == null) {
                string5 = EMPTY_STRING;
            } else if (Ipv4AddressValidation.isIpv4((String)string5)) {
                Ipv4AddressValidation.validateIpv4((String)string5);
            } else {
                throw new IpFormatException("The address " + string5 + " is not a valid IPv4 address");
            }
            if (!string3.equals(EMPTY_STRING) && !string5.equals(EMPTY_STRING) && (string3.equals(string5) || IpAddressValidation.isMultiCastIpAddress((String)string3))) {
                throw new IllegalAttributeValueException("ipaddress must not be broadcast address or multicast address", "EthernetLink");
            }
            if (!string3.equals(EMPTY_STRING) && !string5.equals(EMPTY_STRING)) {
                EthernetLinkMoImpl.validateIpAddresses(n5, new IpAddress(string3), new IpAddress(string5));
            }
            froData = Ipv4AddressInfo.createMomStruct(string3, n5, string5);
            structArray2 = new Struct[]{froData};
            if (!string3.equals(EMPTY_STRING) && !string5.equals(EMPTY_STRING)) {
                this.validateIpv4Addresses(attrList, structArray2, coordinator);
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new SignedIntParameter("mtuSize", n2));
        arrayList.add(new SignedIntParameter("metric", n4));
        if (structArray2 != null) {
            arrayList.add(Ipv4AddressInfo.createArrayParameter(structArray2, "EthernetLink", "ipv4Addresses", 5));
        }
        if (structArray != null) {
            arrayList.add(EthIpv6AddressInfo.createArrayParameter(structArray, "EthernetLink", "ipv6Addresses", 5));
        }
        froData = this.froProxy.create(coordinator, arrayList);
        int n6 = froData.getFroId();
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(ETHERNET_FRO_ID, false, n6));
        maoFroIndicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, this.getFroId(coordinator));
        this.data.setRevision(5000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public EthernetLinkMoGen(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.froProxy = froProxy;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(5000);
        moDataRecoveryHelper.assertAttribute(ETHERNET_FRO_ID);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.indHandler = maoFroIndicationHandler;
        maoFroIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(ETHERNET_FRO_ID)).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (((ManagedObject[])this.getAttribute("reservedBy", coordinator)).length != 0) {
            throw new MoReservedNotDeletableException("EthernetLink");
        }
        this.checkNodeIpAddressAtDelete(coordinator);
        this.froProxy.delete(coordinator, this.getFroId(coordinator), null);
        this.indHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    private void checkNodeIpAddressAtDelete(Coordinator coordinator) throws MoAccessException {
        String string = ((IpMoImpl)this.getParent()).getNodeInterfaceName(coordinator);
        String string2 = ((IpMoImpl)this.getParent()).getNodeIpv6InterfaceName(coordinator);
        String string3 = this.getInterfaceName(coordinator);
        if (string3.equals(string) || string3.equals(string2)) {
            String string4 = ((IpMo)this.getParent()).getNodeIpAddress(coordinator);
            String string5 = ((IpMo)this.getParent()).getNodeIpv6Address(coordinator);
            Struct[] structArray = (Struct[])this.getAttribute("ipv6Addresses", coordinator);
            String string6 = EMPTY_STRING;
            if (structArray.length > 0) {
                string6 = (String)structArray[0].getValue("ipAddress");
            }
            if (!this.getIpAddress(coordinator).equals(EMPTY_STRING) && this.getIpAddress(coordinator).equals(string4)) {
                throw new MoCanNotBeDeletedException(this + " cannot be deleted when its ipAddress is used as nodeIpAddress, nodeIpAddress: " + string4);
            }
            if (!string6.equals(EMPTY_STRING) && string6.equals(string5)) {
                throw new MoCanNotBeDeletedException(this + " cannot be deleted when its ipAddress is used as nodeIpv6Address, nodeIpv6Address: " + string5);
            }
        }
    }

    public String getInterfaceName(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("interfaceName", coordinator);
    }

    public String getIpAddress(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("ipAddress", coordinator);
    }

    public String getSubnetMask(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("subnetMask", coordinator);
    }

    public void setBroadcastAddress(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("broadcastAddress", string, coordinator);
    }

    public String getBroadcastAddress(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("broadcastAddress", coordinator);
    }

    public void setMtuSize(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("mtuSize", new Integer(n), coordinator);
    }

    public int getMtuSize(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("mtuSize", coordinator);
    }

    public void setMetric(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("metric", new Integer(n), coordinator);
    }

    public int getMetric(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("metric", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public String getMacAddress(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("macAddress", coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public ManagedObject getActiveMau(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("activeMau", coordinator);
    }

    public abstract ManagedObject fetchActiveMau(SignedIntParameter var1, Coordinator var2) throws MoAccessException;

    public ManagedObject[] getAvailableMaus(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("availableMaus", coordinator);
    }

    public abstract ManagedObject[] fetchAvailableMaus(ArrayParameter var1, Coordinator var2) throws MoAccessException;

    public void setIpv4Addresses(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipv4Addresses", structArray, coordinator);
    }

    public Struct[] getIpv4Addresses(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("ipv4Addresses", coordinator);
    }

    public void setIpv6Addresses(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipv6Addresses", structArray, coordinator);
    }

    public Struct[] getIpv6Addresses(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("ipv6Addresses", coordinator);
    }

    public String getEthernetLinkId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("EthernetLinkId", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public int getPmNoOfIfInUcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmNoOfIfInUcastPkts", coordinator);
    }

    public int getPmNoOfIfInNUcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmNoOfIfInNUcastPkts", coordinator);
    }

    public int getPmNoOfIfOutUcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmNoOfIfOutUcastPkts", coordinator);
    }

    public int getPmNoOfIfInErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmNoOfIfInErrors", coordinator);
    }

    public int getPmNoOfIfInDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmNoOfIfInDiscards", coordinator);
    }

    public int getPmNoOfIfOutNUcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmNoOfIfOutNUcastPkts", coordinator);
    }

    public int getPmNoOfIfOutDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmNoOfIfOutDiscards", coordinator);
    }

    public int getPmIpIfStatsInReceives(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsInReceives", coordinator);
    }

    public int getPmIpIfStatsInOctets(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsInOctets", coordinator);
    }

    public int getPmIpIfStatsInHdrErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsInHdrErrors", coordinator);
    }

    public int getPmIpIfStatsInAddrErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsInAddrErrors", coordinator);
    }

    public int getPmIpIfStatsInUnknownProtos(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsInUnknownProtos", coordinator);
    }

    public int getPmIpIfStatsReasmReqds(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsReasmReqds", coordinator);
    }

    public int getPmIpIfStatsReasmFails(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsReasmFails", coordinator);
    }

    public int getPmIpIfStatsInDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsInDiscards", coordinator);
    }

    public int getPmIpIfStatsOutDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsOutDiscards", coordinator);
    }

    public int getPmIpIfStatsOutFragCreates(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsOutFragCreates", coordinator);
    }

    public int getPmIpIfStatsOutTransmits(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsOutTransmits", coordinator);
    }

    public int getPmIpIfStatsOutOctets(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsOutOctets", coordinator);
    }

    public String getType() {
        return "EthernetLink";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(ETHERNET_FRO_ID)).getValue(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            StringParameter stringParameter;
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("interfaceName")) {
                map = this.getFroAttributes(map, coordinator);
                stringParameter = (StringParameter)map.get("interfaceName");
                objectArray[i] = stringParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAddress")) {
                map = this.getFroAttributes(map, coordinator);
                objectArray[i] = this.handleGetIpAddress(map, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("subnetMask")) {
                map = this.getFroAttributes(map, coordinator);
                objectArray[i] = this.handleGetSubnetMask(map, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("broadcastAddress")) {
                map = this.getFroAttributes(map, coordinator);
                objectArray[i] = this.handleGetBroadcastAddress(map, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("mtuSize")) {
                map = this.getFroAttributes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("mtuSize");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("metric")) {
                map = this.getFroAttributes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("metric");
                if (System.getProperty("is.using.nat", "false").equalsIgnoreCase("true")) {
                    objectArray[i] = new Integer(1);
                    continue;
                }
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getFroAttributes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("macAddress")) {
                map = this.getFroAttributes(map, coordinator);
                stringParameter = (StringParameter)map.get("macAddress");
                objectArray[i] = stringParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getFroAttributes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("activeMau")) {
                map = this.getFroAttributes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("activeMau");
                objectArray[i] = this.fetchActiveMau((SignedIntParameter)stringParameter, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availableMaus")) {
                map = this.getFroAttributes(map, coordinator);
                stringParameter = (ArrayParameter)map.get("availableMaus");
                objectArray[i] = this.fetchAvailableMaus((ArrayParameter)stringParameter, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipv4Addresses")) {
                map = this.getFroAttributes(map, coordinator);
                stringParameter = (ArrayParameter)map.get("ipv4Addresses");
                objectArray[i] = Ipv4AddressInfo.toMomStructs((ArrayParameter)stringParameter);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipv6Addresses")) {
                map = this.getFroAttributes(map, coordinator);
                stringParameter = (ArrayParameter)map.get("ipv6Addresses");
                objectArray[i] = EthIpv6AddressInfo.toMomStructs((ArrayParameter)stringParameter);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                stringParameter = (SequenceAttribute)this.data.getAttribute("reservedBy");
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)stringParameter, (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfIfInUcastPkts")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmNoOfIfInUcastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfIfInNUcastPkts")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmNoOfIfInNUcastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfIfOutUcastPkts")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmNoOfIfOutUcastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfIfInErrors")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmNoOfIfInErrors", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfIfInDiscards")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmNoOfIfInDiscards", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfIfOutNUcastPkts")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmNoOfIfOutNUcastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfIfOutDiscards")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmNoOfIfOutDiscards", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsInReceives")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsInReceives", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsInOctets")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsInOctets", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsInHdrErrors")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsInHdrErrors", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsInAddrErrors")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsInAddrErrors", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsInUnknownProtos")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsInUnknownProtos", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsReasmReqds")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsReasmReqds", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsReasmFails")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsReasmFails", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsInDiscards")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsInDiscards", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsOutDiscards")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsOutDiscards", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsOutFragCreates")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsOutFragCreates", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsOutTransmits")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsOutTransmits", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsOutOctets")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsOutOctets", coordinator));
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "EthernetLink");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        AttrListMoGenImpl attrListMoGenImpl = new AttrListMoGenImpl(stringArray, objectArray);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("broadcastAddress")) {
                this.handleSetBroadcastAddress(i, objectArray, arrayList, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("mtuSize")) {
                if (!(objectArray[i] instanceof Integer)) {
                    throw new WrongAttributeTypeException("mtuSize", "EthernetLink");
                }
                int n = (Integer)objectArray[i];
                n = this.validateMtuSize((AttrList)attrListMoGenImpl, n, coordinator);
                arrayList.add(new SignedIntParameter("mtuSize", n));
                this.sendNotification("mtuSize", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("metric")) {
                if (System.getProperty("is.using.nat", "false").equalsIgnoreCase("true")) {
                    throw new OperationNotAllowedException("Cannot perform set operation as metric attribute is not applicable for 8300", "EthernetLink");
                }
                if (!(objectArray[i] instanceof Integer)) {
                    throw new WrongAttributeTypeException("metric", "EthernetLink");
                }
                int n = (Integer)objectArray[i];
                n = this.validateMetric((AttrList)attrListMoGenImpl, n, coordinator);
                arrayList.add(new SignedIntParameter("metric", n));
                this.sendNotification("metric", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipv4Addresses")) {
                if (!(objectArray[i] instanceof Struct[])) {
                    throw new WrongAttributeTypeException("ipv4Addresses", "EthernetLink");
                }
                Struct[] structArray = (Struct[])objectArray[i];
                this.validateIpv4AddressesWithNodeInterfaceName(structArray, coordinator);
                this.validateIpv4Addresses((AttrList)attrListMoGenImpl, structArray, coordinator);
                arrayList.add(Ipv4AddressInfo.createArrayParameter(structArray, "EthernetLink", "ipv4Addresses", 5));
                this.sendNotification("ipv4Addresses", structArray, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipv6Addresses")) {
                if (!(objectArray[i] instanceof Struct[])) {
                    throw new WrongAttributeTypeException("ipv6Addresses", "EthernetLink");
                }
                Struct[] structArray = (Struct[])objectArray[i];
                this.validateIpv6Addresses((AttrList)attrListMoGenImpl, structArray, coordinator);
                arrayList.add(EthIpv6AddressInfo.createArrayParameter(structArray, "EthernetLink", "ipv6Addresses", 5));
                this.sendNotification("ipv6Addresses", structArray, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!(objectArray[i] instanceof String)) {
                    throw new WrongAttributeTypeException("userLabel", "EthernetLink");
                }
                String string = (String)objectArray[i];
                string = this.validateUserLabel((AttrList)attrListMoGenImpl, string, coordinator);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "EthernetLink");
        }
        if (arrayList.size() > 0) {
            this.froProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private Map getFroAttributes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.froProxy.getAttributes(coordinator, this.getFroId(coordinator));
        }
        return map;
    }

    protected void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    protected void sendNotification(String string, Object object) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
    }

    protected String validateIpAddress(AttrList attrList, String string, Coordinator coordinator) throws MoAccessException {
        return string;
    }

    protected String validateSubnetMask(AttrList attrList, String string, Coordinator coordinator) throws MoAccessException {
        return string;
    }

    protected String validateBroadcastAddress(AttrList attrList, String string, Coordinator coordinator) throws MoAccessException {
        return string;
    }

    protected int validateMtuSize(AttrList attrList, int n, Coordinator coordinator) throws MoAccessException {
        MoGenUtil.checkIntegerAttribute((String)"mtuSize", (int)n, (int)576, (int)9000, (String)"EthernetLink");
        return n;
    }

    protected int validateMetric(AttrList attrList, int n, Coordinator coordinator) throws MoAccessException {
        MoGenUtil.checkIntegerAttribute((String)"metric", (int)n, (int)1, (int)Short.MAX_VALUE, (String)"EthernetLink");
        return n;
    }

    protected abstract void validateIpv4Addresses(AttrList var1, Struct[] var2, Coordinator var3) throws MoAccessException;

    protected abstract void validateIpv4AddressesWithNodeInterfaceName(Struct[] var1, Coordinator var2) throws MoAccessException;

    protected abstract void validateIpv6Addresses(AttrList var1, Struct[] var2, Coordinator var3) throws MoAccessException;

    protected String validateUserLabel(AttrList attrList, String string, Coordinator coordinator) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"userLabel", (int)128, (int)0, (String)"EthernetLink");
        return string;
    }

    protected abstract Object handleGetIpAddress(Map var1, Coordinator var2) throws MoAccessException;

    protected abstract Object handleGetSubnetMask(Map var1, Coordinator var2) throws MoAccessException;

    protected abstract Object handleGetBroadcastAddress(Map var1, Coordinator var2) throws MoAccessException;

    protected abstract void handleSetBroadcastAddress(int var1, Object[] var2, ArrayList var3, Coordinator var4) throws MoAccessException;
}

