/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam.fropxy;

import enea.ose.io.SignalInputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.cello.support.debug.MessageLog;

public class OsaIpFroGetRsp
extends UnlinkedSignal {
    public static final int SIGNO = 66311;
    private int result;
    private int workingMode;
    private int operationalState;
    private int defaultRouter;
    private int numberOfLinks;
    private int availabilityStatus;
    private int udpChecksumState;
    private int dscp;
    private int connectionAttemptTimer;
    private int maxRetransmissionAttempts;
    private int icmpRedirect;
    private int nodeIpAddress;
    private byte[] nodeInterfaceName;
    private byte[] nodeIpv6Address;
    private byte[] nodeIpv6InterfaceName;
    private int pmNoOfIpInReceives;
    private int pmNoOfHdrErrors;
    private int pmNoOfIpAddrErrors;
    private int pmNoOfIpForwDatagrams;
    private int pmNoOfIpInDiscards;
    private int pmNoOfIpOutDiscards;
    private int pmNoOfIpReasmReqds;
    private int pmNoOfIpReasmOKs;

    public OsaIpFroGetRsp() {
        super(66311);
    }

    public int getResult() {
        return this.result;
    }

    public int getSignalNumber() {
        return 66311;
    }

    public void initReceive() {
        SignalInputStream signalInputStream = this.getSignalInputStream();
        try {
            this.result = (int)signalInputStream.readU32();
            int n = signalInputStream.readS32();
            for (int i = 0; n != 0 && i < 21; ++i) {
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.workingMode = (int)signalInputStream.readU32();
                        break;
                    }
                    case 2: {
                        this.defaultRouter = (int)signalInputStream.readU32();
                        break;
                    }
                    case 3: {
                        this.numberOfLinks = (int)signalInputStream.readU32();
                        break;
                    }
                    case 4: {
                        this.operationalState = (int)signalInputStream.readU32();
                        break;
                    }
                    case 5: {
                        this.availabilityStatus = (int)signalInputStream.readU32();
                        break;
                    }
                    case 14: {
                        this.udpChecksumState = (int)signalInputStream.readU32();
                        break;
                    }
                    case 15: {
                        this.dscp = (int)signalInputStream.readU32();
                        break;
                    }
                    case 16: {
                        this.connectionAttemptTimer = (int)signalInputStream.readU32();
                        break;
                    }
                    case 17: {
                        this.maxRetransmissionAttempts = (int)signalInputStream.readU32();
                        break;
                    }
                    case 6: {
                        this.pmNoOfIpInReceives = (int)signalInputStream.readU32();
                        break;
                    }
                    case 7: {
                        this.pmNoOfHdrErrors = (int)signalInputStream.readU32();
                        break;
                    }
                    case 8: {
                        this.pmNoOfIpAddrErrors = (int)signalInputStream.readU32();
                        break;
                    }
                    case 9: {
                        this.pmNoOfIpForwDatagrams = (int)signalInputStream.readU32();
                        break;
                    }
                    case 10: {
                        this.pmNoOfIpInDiscards = (int)signalInputStream.readU32();
                        break;
                    }
                    case 11: {
                        this.pmNoOfIpOutDiscards = (int)signalInputStream.readU32();
                        break;
                    }
                    case 12: {
                        this.pmNoOfIpReasmReqds = (int)signalInputStream.readU32();
                        break;
                    }
                    case 13: {
                        this.pmNoOfIpReasmOKs = (int)signalInputStream.readU32();
                        break;
                    }
                    case 18: {
                        this.icmpRedirect = (int)signalInputStream.readU32();
                        break;
                    }
                    case 20: {
                        this.nodeIpAddress = (int)signalInputStream.readU32();
                        break;
                    }
                    case 19: {
                        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)"Read nodeInterfaceName");
                        this.nodeInterfaceName = this.readString(signalInputStream);
                        break;
                    }
                    case 22: {
                        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)"Read nodeIpv6Address");
                        this.nodeIpv6Address = this.readString(signalInputStream);
                        break;
                    }
                    case 21: {
                        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)"Read nodeIpv6InterfaceName");
                        this.nodeIpv6InterfaceName = this.readString(signalInputStream);
                    }
                }
                n = (int)signalInputStream.readU32();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private byte[] readString(SignalInputStream signalInputStream) throws IOException {
        int n = (int)signalInputStream.readU32();
        int n2 = n * 4;
        byte[] byArray = signalInputStream.readS8Array(n2);
        boolean bl = false;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) {
                MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("0x00 found at idx " + i + " length = " + byArray.length));
                bl = true;
            }
            if (!bl) continue;
            byArray[i] = 0;
        }
        return byArray;
    }

    public void initSend() {
    }

    public int getWorkingMode() {
        return this.workingMode;
    }

    public int getDefaultRouter() {
        return this.defaultRouter;
    }

    public int getNumberOfLinks() {
        return this.numberOfLinks;
    }

    public int getUdpChecksumState() {
        return this.udpChecksumState;
    }

    public int getDscp() {
        return this.dscp;
    }

    public int getConnectionAttemptTimer() {
        return this.connectionAttemptTimer;
    }

    public int getMaxRetransmissionAttempts() {
        return this.maxRetransmissionAttempts;
    }

    public int getIcmpRedirect() {
        return this.icmpRedirect;
    }

    public int getOperationalState() {
        return this.operationalState;
    }

    public int getAvailabilityStatus() {
        return this.availabilityStatus;
    }

    public int getNodeIpAddress() {
        return this.nodeIpAddress;
    }

    public byte[] getNodeInterfaceName() {
        return this.nodeInterfaceName;
    }

    public byte[] getNodeIpv6Address() {
        return this.nodeIpv6Address;
    }

    public byte[] getNodeIpv6InterfaceName() {
        return this.nodeIpv6InterfaceName;
    }

    public int getPmNoOfIpInReceives() {
        return this.pmNoOfIpInReceives;
    }

    public int getPmNoOfHdrErrors() {
        return this.pmNoOfHdrErrors;
    }

    public int getPmNoOfIpAddrErrors() {
        return this.pmNoOfIpAddrErrors;
    }

    public int getPmNoOfIpForwDatagrams() {
        return this.pmNoOfIpForwDatagrams;
    }

    public int getPmNoOfIpInDiscards() {
        return this.pmNoOfIpInDiscards;
    }

    public int getPmNoOfIpOutDiscards() {
        return this.pmNoOfIpOutDiscards;
    }

    public int getPmNoOfIpReasmReqds() {
        return this.pmNoOfIpReasmReqds;
    }

    public int getPmNoOfIpReasmOKs() {
        return this.pmNoOfIpReasmOKs;
    }

    public void setPmCountersUnavailable() {
        this.pmNoOfIpInReceives = -1;
        this.pmNoOfHdrErrors = -1;
        this.pmNoOfIpAddrErrors = -1;
        this.pmNoOfIpForwDatagrams = -1;
        this.pmNoOfIpInDiscards = -1;
        this.pmNoOfIpOutDiscards = -1;
        this.pmNoOfIpReasmReqds = -1;
        this.pmNoOfIpReasmOKs = -1;
    }
}

