/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.iptransport.GigaBitEthernetMoGen;
import se.ericsson.cello.iptransport.GigaBitEthernetMoImplInterface;
import se.ericsson.cello.iptransport.StructDscpPbitImpl;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.PmRequestContextImpl;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericEventInd;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.sync.GigabitEthernetRef;
import se.ericsson.cello.sync.SyncReservable;
import se.ericsson.cello.transaction.Coordinator;

public class GigaBitEthernetMoImpl
extends GigaBitEthernetMoGen
implements GigaBitEthernetMoImplInterface,
SyncReservable,
GigabitEthernetRef {
    protected static final int IEEE_802_3_LLC_SNAP = 1;
    private static final int NUMBER_OF_ELEMENTS = 64;

    public GigaBitEthernetMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public GigaBitEthernetMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    public void actionSetDscpPbit(int n, int n2, Coordinator coordinator) throws MoAccessException {
        Object object;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        MoAttributeValidator.checkIntegerAttribute((String)"dscp", (int)n, (int)0, (int)63, (String)"GigaBitEthernet");
        MoAttributeValidator.checkIntegerAttribute((String)"pbit", (int)n2, (int)0, (int)7, (String)"GigaBitEthernet");
        Hashtable hashtable = this.prepareSetFroAttr(coordinator);
        ArrayParameter arrayParameter = (ArrayParameter)hashtable.get("dscpPbitMap");
        Struct[] structArray = StructDscpPbitImpl.toStructArray(arrayParameter);
        for (int i = 0; i < structArray.length; ++i) {
            object = structArray[i];
            if ((Integer)object.getValue("dscp") != n) continue;
            object = new StructImpl(StructDscpPbitImpl.ELEMENT_NAMES, new Object[]{new Integer(n), new Integer(n2)});
            structArray[i] = object;
            break;
        }
        hashtable.put("dscpPbitMap", StructDscpPbitImpl.toArrayParameter(structArray, "GigaBitEthernet", "dscpPbitMap", 64));
        ArrayList arrayList = new ArrayList();
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            arrayList.add(hashtable.get(object.nextElement()));
        }
        this.froProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        String[] stringArray = new String[]{"dscp"};
        Object[] objectArray = new Object[]{structArray};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public void syncReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reserve(managedObject, coordinator);
    }

    public void syncRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.release(managedObject, coordinator);
    }

    private Hashtable prepareSetFroAttr(Coordinator coordinator) throws MoAccessException {
        Hashtable hashtable = new Hashtable();
        Map map = this.froProxy.getAttributes(coordinator, this.getFroId(coordinator), null);
        for (int i = 0; i < this.NON_READONLY_MOM_ATTRIBUTES.length; ++i) {
            if (this.NON_READONLY_MOM_ATTRIBUTES[i].equalsIgnoreCase("userLabel") || this.NON_READONLY_MOM_ATTRIBUTES[i].equalsIgnoreCase("GigaBitEthernetId") || this.NON_READONLY_MOM_ATTRIBUTES[i].equalsIgnoreCase("linkType") || this.NON_READONLY_MOM_ATTRIBUTES[i].equalsIgnoreCase("portNo")) continue;
            hashtable.put(this.NON_READONLY_MOM_ATTRIBUTES[i], map.get(this.NON_READONLY_MOM_ATTRIBUTES[i]));
        }
        return hashtable;
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        ManagedObject managedObject = this.getParent();
        int n = ((FroInfo)managedObject).getFroId(setRequestContext.getCoordinator());
        SignedIntParameter signedIntParameter = new SignedIntParameter("bhId", n);
        setRequestContext.addParameter(this.froProxy, (Parameter)signedIntParameter);
        int n2 = PiuUtils.findPiuParentFroId((ManagedObject)managedObject);
        SignedIntParameter signedIntParameter2 = new SignedIntParameter("piuId", n2);
        setRequestContext.addParameter(this.froProxy, (Parameter)signedIntParameter2);
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
        int n;
        Coordinator coordinator = setRequestContext.getCoordinator();
        Map map = this.froProxy.getAttributes(coordinator, this.getFroId(coordinator), null);
        if (setRequestContext.isIncludedInRequest("frameFormat") && (n = ((Integer)setRequestContext.getAttributeFromRequest("frameFormat")).intValue()) == 1) {
            int n2 = 0;
            ManagedObject managedObject = null;
            MoIterator moIterator = this.getChildren();
            while (moIterator != null && moIterator.hasMoreElements()) {
                managedObject = moIterator.nextMo();
                if (!managedObject.getType().equals("IpInterface") || (n2 = ((Integer)managedObject.getAttribute("mtu", setRequestContext.getCoordinator())).intValue()) <= 1492) continue;
                throw new ValueOutOfRangeException("mtu in IpInterface is set to " + n2 + ". The value on " + "mtu" + " can not exceed " + 1492 + " when changing " + "frameFormat" + " to " + n, "GigaBitEthernet");
            }
            ManagedObject[] managedObjectArray = this.getReservedBy(setRequestContext.getCoordinator());
            for (int i = 0; i < managedObjectArray.length; ++i) {
                managedObject = managedObjectArray[i];
                if (!managedObjectArray[i].getType().equals("Ipv6Interface") || (n2 = ((Integer)managedObject.getAttribute("mtu", setRequestContext.getCoordinator())).intValue()) <= 1492) continue;
                throw new ValueOutOfRangeException("mtu in Ipv6Interface is set to " + n2 + ". The value on " + "mtu" + " can not exceed " + 1492 + " when changing " + "frameFormat" + " to " + n, "GigaBitEthernet");
            }
        }
        for (n = 0; n < this.NON_READONLY_MOM_ATTRIBUTES.length; ++n) {
            if (this.NON_READONLY_MOM_ATTRIBUTES[n].equalsIgnoreCase("userLabel") || this.NON_READONLY_MOM_ATTRIBUTES[n].equalsIgnoreCase("GigaBitEthernetId") || this.NON_READONLY_MOM_ATTRIBUTES[n].equalsIgnoreCase("linkType") || this.NON_READONLY_MOM_ATTRIBUTES[n].equalsIgnoreCase("portNo") || setRequestContext.isIncludedInRequest(this.NON_READONLY_MOM_ATTRIBUTES[n])) continue;
            setRequestContext.addParameter(this.froProxy, (Parameter)map.get(this.NON_READONLY_MOM_ATTRIBUTES[n]));
        }
    }

    static Struct[] createDefaultDscp() {
        Struct[] structArray = new Struct[64];
        block7: for (int i = 0; i < 64; ++i) {
            switch (i) {
                case 10: 
                case 12: 
                case 14: {
                    structArray[i] = new StructImpl(StructDscpPbitImpl.ELEMENT_NAMES, new Object[]{new Integer(i), new Integer(1)});
                    continue block7;
                }
                case 18: 
                case 20: 
                case 22: {
                    structArray[i] = new StructImpl(StructDscpPbitImpl.ELEMENT_NAMES, new Object[]{new Integer(i), new Integer(3)});
                    continue block7;
                }
                case 26: 
                case 28: 
                case 30: {
                    structArray[i] = new StructImpl(StructDscpPbitImpl.ELEMENT_NAMES, new Object[]{new Integer(i), new Integer(4)});
                    continue block7;
                }
                case 34: 
                case 36: 
                case 38: {
                    structArray[i] = new StructImpl(StructDscpPbitImpl.ELEMENT_NAMES, new Object[]{new Integer(i), new Integer(5)});
                    continue block7;
                }
                case 46: {
                    structArray[i] = new StructImpl(StructDscpPbitImpl.ELEMENT_NAMES, new Object[]{new Integer(i), new Integer(6)});
                    continue block7;
                }
                default: {
                    structArray[i] = new StructImpl(StructDscpPbitImpl.ELEMENT_NAMES, new Object[]{new Integer(i), new Integer(0)});
                }
            }
        }
        return structArray;
    }

    protected Object handleGetDscpPbitMap(GetRequestContext getRequestContext) throws MoAccessException {
        ArrayParameter arrayParameter = (ArrayParameter)getRequestContext.getParameter("dscpPbitMap");
        if (arrayParameter == null) {
            throw new FroRequestFailedException("GigaBitEthernet", "Missing parameter from FRO: dscpPbitMap", "getAttributes", -1);
        }
        return StructDscpPbitImpl.toStructArray(arrayParameter);
    }

    protected void handleSetDscpPbitMap(Struct[] structArray, SetRequestContext setRequestContext) throws MoAccessException {
        if (Arrays.equals(structArray, DSCP_PBIT_MAP_DEFAULT)) {
            structArray = GigaBitEthernetMoImpl.createDefaultDscp();
        }
        setRequestContext.addParameter(this.froProxy, (Parameter)StructDscpPbitImpl.toArrayParameter(structArray, "GigaBitEthernet", "dscpPbitMap", 64));
    }

    protected Object handleGetCurrentPmRegister(GetRequestContext getRequestContext) throws MoAccessException {
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, getRequestContext.getCoordinator());
        return pmRequestContextImpl.getCurrentPmRegister();
    }

    protected void handleSetCurrentPmRegister(String[] stringArray, SetRequestContext setRequestContext) throws MoAccessException {
    }

    public void eventRaised(MaoFroGenericEventInd maoFroGenericEventInd) {
        try {
            int n;
            Map map = maoFroGenericEventInd.getParameters(DICTIONARY);
            StringParameter stringParameter = (StringParameter)map.get("additionalText");
            String string = "";
            if (stringParameter != null) {
                string = stringParameter.getValue();
            }
            if ((n = maoFroGenericEventInd.getSpecificEvent()) != 23) {
                MessageLog.traceError(this.getClass(), (String)("Unknown event sent to GigaBitEthernetMoImpl :" + n));
                return;
            }
            AlarmManager.getReporter().reportEvent(23, (ManagedObject)this, "", string, null);
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag  not in property file");
        }
    }
}

