/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Map;
import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.iptransport.DnsResolverMo;
import se.ericsson.cello.iptransport.IpAccessHostEtMaoi;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpAccessHostEtMoGen;
import se.ericsson.cello.iptransport.IpInterfaceGroupMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.IpInterfaceMoImpl;
import se.ericsson.cello.iptransport.IpMuxMo;
import se.ericsson.cello.iptransport.IpValidator;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMoImpl;
import se.ericsson.cello.iptransport.VpnInterfaceBuildIF;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.FroNotLockedException;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.HostIpAddress;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.IpAddressValidation;
import se.ericsson.cello.mao.IpException;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.Ipv6AddressValidation;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.MoNotPossibleToReserveException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.PmRequestContextImpl;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class IpAccessHostEtMoImpl
extends IpAccessHostEtMoGen
implements IpAccessHostEtMaoi {
    private int thePiuFroId;
    static final int CONF_MODE_MANUAL = 0;
    static final int CONF_MODE_IKE = 1;
    private static final int IP_INTERFACE_REF_TYPE = 1;
    private static final int IP_INTERFACE_GROUP_REF_TYPE = 2;
    private static final int IPv6_INTERFACE_REF_TYPE = 10;
    private static final int VPN_INTERFACE_REF_TYPE = 11;
    private static final int MIN_INTERFACE_REF_THAT_ALLOW_IPV6 = 10;
    private static final int MAX_NUMBER_OF_VPN_RESERVED = 2;

    public IpAccessHostEtMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public IpAccessHostEtMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        ManagedObject managedObject;
        ManagedObject managedObject2;
        int n;
        ManagedObject managedObject3 = (ManagedObject)setRequestContext.getAttributeFromRequest("ipInterfaceMoRef");
        Coordinator coordinator = setRequestContext.getCoordinator();
        String string = "";
        int n2 = this.getConfModeFromIpInterfaceMoRef(managedObject3, coordinator);
        if (n2 == 0) {
            if (!setRequestContext.isIncludedInRequest("ipAddress")) {
                throw new AttrMissingAtCreateException("ipAddress", "IpAccessHostEt");
            }
            string = (String)setRequestContext.getAttributeFromRequest("ipAddress");
        } else if (n2 == 1) {
            string = "";
            if (setRequestContext.isIncludedInRequest("ipAddress")) {
                throw new IllegalAttributeValueException("For DHCP/IKE configurations, ipAddress should not be supplied in create request. ", "IpAccessHostEt");
            }
        }
        setRequestContext.replaceParameter(this.froProxy, (Parameter)new StringParameter("ipAddress", string, 47));
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("confMode", n2));
        int n3 = this.getIpVersionFromIpInterfaceMoRef(managedObject3, coordinator);
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ipVersion", n3));
        if (managedObject3 instanceof VpnInterfaceBuildIF && (n = ((VpnInterfaceBuildIF)managedObject3).getIpVersion(coordinator)) == 1) {
            MoIterator moIterator = MoRepository.instance().lookupType("IpAccessHostEt");
            managedObject2 = null;
            while (moIterator != null && moIterator.hasMoreElements()) {
                managedObject2 = moIterator.nextMo();
                if (managedObject2.equals(this) || (managedObject = (ManagedObject)managedObject2.getAttribute("ipInterfaceMoRef", coordinator)).getLocalDistinguishedName().equals(managedObject3.getLocalDistinguishedName()) || !(managedObject instanceof VpnInterfaceBuildIF) || (n = ((VpnInterfaceBuildIF)managedObject).getIpVersion(coordinator)) != 1) continue;
                throw new MoCanNotBeCreatedException("Only one IpAccessHostEt MO can refer to an VpnInterface MO in the node. ");
            }
        }
        n = Ipv6AddressValidation.isProperIPv6Address((String)string);
        int n4 = 64;
        if (n != 0) {
            Ipv6AddressValidation.validateIpv6((String)string);
            if (setRequestContext.isIncludedInRequest("networkPrefixLength")) {
                n4 = (Integer)setRequestContext.getAttributeFromRequest("networkPrefixLength");
            }
        } else {
            setRequestContext.replaceParameter(this.froProxy, (Parameter)new SignedIntParameter("networkPrefixLength", 64));
        }
        this.validateIpAddress(coordinator, string, managedObject3, n4);
        this.checkIFRelationships(n != 0, managedObject3, coordinator);
        managedObject2 = null;
        managedObject = null;
        if (this.isVpnInterface(managedObject3)) {
            IpAccessHostEtMo ipAccessHostEtMo = (IpAccessHostEtMo)((VpnInterfaceBuildIF)managedObject3).getIpAccessHostEtRef(coordinator);
            managedObject2 = ipAccessHostEtMo.getIpInterfaceMoRef(coordinator);
            if (managedObject2 instanceof Ipv6InterfaceMo) {
                managedObject2 = ((Ipv6InterfaceMo)managedObject2).getEthernetRef(coordinator);
            }
        } else if (this.isIpInterfaceGroup(managedObject3)) {
            managedObject2 = ((IpInterfaceGroupMo)managedObject3).getPrimaryIpInterfaceRef(coordinator);
            managedObject = ((IpInterfaceGroupMo)managedObject3).getSecondaryIpInterfaceRef(coordinator);
        } else if (managedObject3 instanceof IpInterfaceMo) {
            managedObject2 = managedObject3;
        } else if (managedObject3 instanceof Ipv6InterfaceMo) {
            managedObject2 = ((Ipv6InterfaceMo)managedObject3).getEthernetRef(coordinator);
        } else {
            throw new InvalidReferenceException(this.getType(), (Object)managedObject3);
        }
        int n5 = this.thePiuFroId = PiuUtils.findPiuParentFroId((ManagedObject)managedObject2);
        if (managedObject != null) {
            n5 = PiuUtils.findPiuParentFroId((ManagedObject)managedObject);
        }
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("piuFroId", this.thePiuFroId));
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("secondaryLocation", n5));
        IpValidator.checkCombinedHostCardinality(this.getParent(), "IpAccessHostEt");
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
        Coordinator coordinator = setRequestContext.getCoordinator();
        if (setRequestContext.isIncludedInRequest("ipAddress")) {
            if (this.getAdministrativeState(coordinator) != 0) {
                throw new FroNotLockedException("IpAccessHostEt", "AdministrativeState need to be locked when setting ip address");
            }
            String string = (String)setRequestContext.getAttributeFromRequest("ipAddress");
            this.validateIpAddress(coordinator, string, this.getIpInterfaceMoRef(coordinator), this.getNetworkPrefixLength(coordinator));
            int n = this.getConfModeFromIpInterfaceMoRef(this.getIpInterfaceMoRef(coordinator), coordinator);
            if (n == 1) {
                throw new OperationNotAllowedException("Set ipAddress when configurationMode is DHCP/IKE is not allowed.", "IpAccessHostEt");
            }
            setRequestContext.replaceParameter(this.froProxy, (Parameter)new StringParameter("ipAddress", string, 47));
        }
    }

    protected void onDelete(Coordinator coordinator) throws MoAccessException {
        if (this.getAdministrativeState(coordinator) != 0) {
            throw new FroNotLockedException(this.getType(), "The MO can not be deleted when unlocked");
        }
    }

    public String actionPing(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        boolean bl = Ipv6AddressValidation.isProperIPv6Address((String)string);
        if (!bl) {
            new IpAddress(string);
        } else {
            IpAddressValidation.validate((String)string);
        }
        int n = this.getIpVersionFromIpInterfaceMoRef(this.getIpInterfaceMoRef(coordinator), coordinator);
        if (n == 0) {
            if (Ipv6AddressValidation.isIpv6((String)string)) {
                throw new IllegalAttributeValueException("Called host must have the same IP version as this MO.", "IpAccessHostEt");
            }
        } else if (Ipv4AddressValidation.isIpv4((String)string)) {
            throw new IllegalAttributeValueException("Called host must have the same IP version as this MO. ", "IpAccessHostEt");
        }
        ArrayList<StringParameter> arrayList = new ArrayList<StringParameter>();
        StringParameter stringParameter = new StringParameter("ipAddress", string, 47);
        arrayList.add(stringParameter);
        Map map = this.froProxy.actionWithCfm(null, this.getFroId(coordinator), 2001, arrayList);
        StringParameter stringParameter2 = (StringParameter)map.get("actionPing");
        String string2 = "";
        if (stringParameter2 == null) {
            throw new FroRequestFailedException("IpAccessHostEt", "Missing parameter from FRO: actionPing", "actionPing", -1);
        }
        string2 = stringParameter2.getValue();
        return string2;
    }

    public int getPmIpReasmOKs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpReasmOks", coordinator);
    }

    public int getPmIpReasmOks(Coordinator coordinator) throws MoAccessException {
        return super.getPmIpReasmOks(coordinator);
    }

    public int getPmIpFragOKs(Coordinator coordinator) throws MoAccessException {
        return super.getPmIpFragOks(coordinator);
    }

    protected Object handleGetCurrentPmRegister(GetRequestContext getRequestContext) throws MoAccessException {
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, getRequestContext.getCoordinator());
        return pmRequestContextImpl.getCurrentPmRegister();
    }

    protected void handleSetCurrentPmRegister(String[] stringArray, SetRequestContext setRequestContext) throws MoAccessException {
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject == null) {
            throw new InvalidReferenceException("IpAccessHostEt", "null");
        }
        ManagedObject[] managedObjectArray = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
        int n = 1;
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (this.isVpnInterface(managedObjectArray[i])) {
                ++n;
            }
            if (managedObject instanceof IpMuxMo && managedObjectArray[i] instanceof IpMuxMo) {
                throw new MoNotPossibleToReserveException("Only one IpMux instance is allowed to reserve IpAccessHostEt, Already reserved by: " + managedObjectArray[i], "IpAccessHostEt");
            }
            if (n > 2 && managedObject instanceof VpnInterfaceBuildIF) {
                throw new MoNotPossibleToReserveException("Only two VpnInterface instances are allowed to reserve IpAccessHostEt, Already reserved by: " + managedObjectArray[0] + " and " + managedObjectArray[1], "IpAccessHostEt");
            }
            if (!(managedObject instanceof DnsResolverMo) || !(managedObjectArray[i] instanceof DnsResolverMo)) continue;
            throw new MoNotPossibleToReserveException("Only one DnsResolver instance is allowed to reserve IpAccessHostEt, Already reserved by: " + managedObjectArray[i], "IpAccessHostEt");
        }
        super.reserve(managedObject, coordinator);
    }

    public ManagedObject fetchIpInterfaceMoRef(SignedIntParameter signedIntParameter, Coordinator coordinator) throws MoAccessException {
        CelloMao celloMao = null;
        int n = signedIntParameter.getValue();
        celloMao = IpInterfaceMoImpl.lookupInstance(signedIntParameter.getValue(), coordinator);
        if (celloMao == null) {
            celloMao = this.findMo("IpInterfaceGroup", n, coordinator);
        }
        if (celloMao == null) {
            celloMao = Ipv6InterfaceMoImpl.lookupInstance(n, coordinator);
        }
        if (celloMao == null) {
            celloMao = this.findMo("VpnInterface", n, coordinator);
        }
        if (celloMao == null) {
            throw new ConfigurationMismatchException("Failed to fetch reference ", "IpAccessHostEt", "ipInterfaceMoRef");
        }
        return celloMao;
    }

    public int getPiuFroid(Coordinator coordinator) throws MoAccessException {
        return this.thePiuFroId;
    }

    public int getHostFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("ipacHostEtFroId")).getValue(coordinator);
    }

    public int getPlugInUnitHostId(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = this.getIpInterfaceMoRef(coordinator);
        IpAccessHostEtMo ipAccessHostEtMo = null;
        ipAccessHostEtMo = managedObject instanceof VpnInterfaceBuildIF ? (IpAccessHostEtMo)((VpnInterfaceBuildIF)managedObject).getIpAccessHostEtRef(coordinator) : this;
        int n = PiuUtils.findPiuParentFroId((ManagedObject)ipAccessHostEtMo.getIpInterfaceMoRef(coordinator));
        return n;
    }

    protected void validateNetworkPrefixLength(int n, SetRequestContext setRequestContext) throws MoAccessException {
        String string = "";
        if (setRequestContext.isIncludedInRequest("ipAddress")) {
            string = (String)setRequestContext.getAttributeFromRequest("ipAddress");
        }
        if (!Ipv4AddressValidation.isIpv4((String)string)) {
            super.validateNetworkPrefixLength(n, setRequestContext);
        }
    }

    protected void validateIpInterfaceMoRef(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateIpInterfaceMoRef(managedObject, setRequestContext);
        String[] stringArray = new String[]{"IpInterface", "Ipv6Interface", "VpnInterface", "IpInterfaceGroup"};
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!managedObject.getType().equals(stringArray[i])) continue;
            bl = true;
        }
        if (!bl) {
            throw new WrongAttributeTypeException("ipInterfaceMoRef", "IpAccessHostEt");
        }
    }

    protected void validateNtpServerMode(int n, SetRequestContext setRequestContext) throws MoAccessException {
        StringParameter stringParameter;
        String string = "";
        ManagedObject managedObject = null;
        super.validateNtpServerMode(n, setRequestContext);
        string = setRequestContext.isIncludedInRequest("ipAddress") ? (String)setRequestContext.getAttributeFromRequest("ipAddress") : ((stringParameter = (StringParameter)setRequestContext.getParameter(this.froProxy, "ipAddress")) == null ? this.getIpAddress(setRequestContext.getCoordinator()) : stringParameter.getValue());
        managedObject = setRequestContext.isIncludedInRequest("ipInterfaceMoRef") ? (ManagedObject)setRequestContext.getAttributeFromRequest("ipInterfaceMoRef") : this.getIpInterfaceMoRef(setRequestContext.getCoordinator());
        if (!(n != 1 || (stringParameter = MoRepository.instance().lookupType("IpSyncRef")) == null && Ipv4AddressValidation.isIpv4((String)string))) {
            throw new IllegalAttributeValueException("ntpServerMode cannot be set to ENABLED, if there are any IpSyncRef MOs in the node or IpAddress is not Ipv4", "IpAccessHostEt");
        }
        if (n == 1) {
            this.checkNtpServerMode(managedObject, setRequestContext.getCoordinator());
        }
    }

    private ManagedObject findMo(String string, int n, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = MoRepository.instance().lookupType(string);
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (n != ((FroInfo)managedObject).getFroId(coordinator)) continue;
            return managedObject;
        }
        return null;
    }

    private void checkNtpServerMode(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (this.isVpnInterface(managedObject)) {
            return;
        }
        if (this.isIpInterfaceGroup(managedObject)) {
            MoIterator moIterator = MoRepository.instance().lookupType("IpAccessHostEt");
            IpInterfaceMo ipInterfaceMo = null;
            ipInterfaceMo = (IpInterfaceMo)((IpInterfaceGroupMo)managedObject).getPrimaryIpInterfaceRef(coordinator);
            ManagedObject managedObject2 = ipInterfaceMo.getParent().getParent();
            this.performNtpServerModeCheck(moIterator, managedObject2, coordinator);
            ipInterfaceMo = (IpInterfaceMo)((IpInterfaceGroupMo)managedObject).getSecondaryIpInterfaceRef(coordinator);
            ManagedObject managedObject3 = ipInterfaceMo.getParent().getParent();
            this.performNtpServerModeCheck(moIterator, managedObject3, coordinator);
        } else {
            MoIterator moIterator = MoRepository.instance().lookupType("IpAccessHostEt");
            ManagedObject managedObject4 = managedObject.getParent().getParent();
            this.performNtpServerModeCheck(moIterator, managedObject4, coordinator);
        }
    }

    private void performNtpServerModeCheck(MoIterator moIterator, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject2 = null;
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject2 = moIterator.nextMo();
            if (managedObject2.equals(this) || ((IpAccessHostEtMo)managedObject2).getNtpServerMode(coordinator) != 1 || !((IpAccessHostEtMo)managedObject2).getIpInterfaceMoRef(coordinator).getParent().getParent().getLocalDistinguishedName().equals(managedObject.getLocalDistinguishedName())) continue;
            throw new IllegalAttributeValueException("Of all instancies of IpAccessHostEt that are connected to a EtMfg, only one can have the ntpServerMode set to ENABLE", "IpAccessHostEt");
        }
    }

    private void checkIFRelationships(boolean bl, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n = this.getInterfaceType(managedObject);
        ManagedObject[] managedObjectArray = null;
        switch (n) {
            case 11: {
                this.validateVpnIpVersion(managedObject, bl, coordinator);
                managedObjectArray = ((VpnInterfaceBuildIF)managedObject).getReservedBy(coordinator);
                break;
            }
            case 2: {
                managedObjectArray = ((IpInterfaceGroupMo)managedObject).getReservedBy(coordinator);
                break;
            }
            case 10: {
                managedObjectArray = ((Ipv6InterfaceMo)managedObject).getReservedBy(coordinator);
            }
        }
        if (managedObjectArray != null) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (!managedObjectArray[i].getType().equals("IpAccessHostEt")) continue;
                throw new MaxNumberExceededException("Only one instance of IpAccessHostEt MO can refer to a VpnInterface MO, an IpInterfaceGroup MO or an Ipv6Interface MO", "IpAccessHostEt");
            }
        }
    }

    private int getIpVersionFromIpInterfaceMoRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject.getType().equalsIgnoreCase("IpInterface")) {
            return 0;
        }
        if (managedObject.getType().equalsIgnoreCase("Ipv6Interface")) {
            return 1;
        }
        if (managedObject.getType().equalsIgnoreCase("VpnInterface")) {
            return ((VpnInterfaceBuildIF)managedObject).getIpVersion(coordinator);
        }
        return 0;
    }

    private int getConfModeFromIpInterfaceMoRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject.getType().equalsIgnoreCase("IpInterface")) {
            return ((IpInterfaceMoImpl)managedObject).getConfigurationMode(coordinator);
        }
        if (managedObject.getType().equalsIgnoreCase("VpnInterface")) {
            return ((VpnInterfaceBuildIF)managedObject).getConfigurationMode(coordinator);
        }
        return 0;
    }

    private void validateIpAddress(Coordinator coordinator, String string, ManagedObject managedObject, int n) throws IpFormatException, MoAccessException, IpException, NoSuchAttributeException, OperationNotAllowedException, IllegalAttributeValueException {
        if (!string.equals("")) {
            IpAddressValidation.validate((String)string);
        }
        boolean bl = Ipv6AddressValidation.isIpv6((String)string);
        if (this.isAttachedToVpnIf(managedObject)) {
            if (this.isConfModeIKE(((VpnInterfaceBuildIF)managedObject).getConfigurationMode(coordinator))) {
                if (!string.equals("")) {
                    throw new OperationNotAllowedException("Setting an  ipAddress is only allowed when IpAccessHostEt refers to a VpnInterface with configurationMode MANUAL", "IpAccessHostEt");
                }
                return;
            }
            if (this.getInterfaceType(managedObject) == 11) {
                this.validateVpnIpVersion(managedObject, bl, coordinator);
            }
        }
        this.validateIpVersionAndInterfaceType(bl, managedObject);
        int n2 = this.getConfModeFromIpInterfaceMoRef(managedObject, coordinator);
        if (bl) {
            this.validateIpv6Address(string, n, managedObject, coordinator);
            this.checkIpAddressWithIpHostLink(string, bl, coordinator);
        } else if (n2 == 0) {
            this.ipv4Validations(coordinator, string, managedObject);
            this.checkIpAddressWithIpHostLink(string, bl, coordinator);
        }
    }

    private void validateIpVersionAndInterfaceType(boolean bl, ManagedObject managedObject) throws MoAccessException {
        int n = this.getInterfaceType(managedObject);
        if (n > -1) {
            if (n < 10 && bl) {
                throw new IllegalAttributeValueException("ipInterfaceMoRef must refer to Ipv6Interface or VpnInterface for ipv6 addresses", "IpAccessHostEt");
            }
            if (n == 10 && !bl) {
                throw new IllegalAttributeValueException("ipInterfaceMoRef can not refer to Ipv6Interface for ipv4 addresses", "IpAccessHostEt");
            }
        }
    }

    private void validateVpnIpVersion(ManagedObject managedObject, boolean bl, Coordinator coordinator) throws MoAccessException {
        int n = 0;
        int n2 = 0;
        n = ((VpnInterfaceBuildIF)managedObject).getConfigurationMode(coordinator);
        n2 = ((VpnInterfaceBuildIF)managedObject).getIpVersion(coordinator);
        if (n == 0 && (bl && n2 == 0 || !bl && n2 == 1)) {
            throw new IllegalAttributeValueException("Ip addresses must match the referenced VpnInterface ipVersion (ipv4/ipv6) when VpnInterface configurationMode is MANUAL ", "IpAccessHostEt");
        }
    }

    private boolean isAttachedToVpnIf(ManagedObject managedObject) throws MoAccessException {
        return managedObject instanceof VpnInterfaceBuildIF;
    }

    private boolean isConfModeIKE(int n) throws MoAccessException {
        return n == 1;
    }

    private int getInterfaceType(ManagedObject managedObject) {
        int n = -1;
        if (managedObject.getType().equals("IpInterface")) {
            n = 1;
        }
        if (managedObject.getType().equals("IpInterfaceGroup")) {
            n = 2;
        }
        if (managedObject.getType().equals("Ipv6Interface")) {
            n = 10;
        }
        if (managedObject.getType().equals("VpnInterface")) {
            n = 11;
        }
        return n;
    }

    private void ipv4Validations(Coordinator coordinator, String string, ManagedObject managedObject) throws MoAccessException, IpFormatException, IpException, OperationNotAllowedException {
        int n = 0;
        if (managedObject instanceof IpInterfaceMo) {
            n = ((IpInterfaceMo)managedObject).getNetworkPrefixLength(coordinator);
            new HostIpAddress(string, n);
        } else if (managedObject instanceof VpnInterfaceBuildIF) {
            n = ((VpnInterfaceBuildIF)managedObject).getNetworkPrefixLength(coordinator);
            new IpAddress(string);
        } else if (managedObject instanceof IpInterfaceGroupMo) {
            n = ((IpInterfaceMo)((IpInterfaceGroupMo)managedObject).getPrimaryIpInterfaceRef(coordinator)).getNetworkPrefixLength(coordinator);
            new HostIpAddress(string, n);
        }
        this.ipv4subnetValidations(coordinator, string, managedObject);
    }

    private void ipv4subnetValidations(Coordinator coordinator, String string, ManagedObject managedObject) throws MoAccessException, OperationNotAllowedException {
        IpValidator.checkIfIpv4AddrIsUniqueAmongIpInt(string, managedObject, coordinator, "IpAccessHostEt");
        if (managedObject instanceof IpInterfaceGroupMo) {
            IpInterfaceMo ipInterfaceMo = (IpInterfaceMo)((IpInterfaceGroupMo)managedObject).getPrimaryIpInterfaceRef(coordinator);
            IpValidator.validateAddressTowardsInterface(string, ipInterfaceMo, "IpAccessHostEt", coordinator);
        } else if (!managedObject.getType().equals("Ipv6Interface")) {
            IpValidator.validateAddressTowardsInterface(string, managedObject, "IpAccessHostEt", coordinator);
        }
    }

    private void validateIpv6Address(String string, int n, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.validateIpv6Format(string);
        this.validateIpv6Type(string);
        this.validateNetPrefix(string, n, managedObject, coordinator);
    }

    private void validateIpv6Format(String string) throws IpFormatException {
        if (!Ipv6AddressValidation.isValidIpv6Addres((String)string)) {
            throw new IpFormatException("Wrong Ipv6 address format for ipAddress");
        }
    }

    private void validateIpv6Type(String string) throws IpFormatException, IllegalAttributeValueException {
        boolean bl = Ipv6AddressValidation.isGlobalUnicastIpv6((String)string);
        if (!Ipv6AddressValidation.isLinkLocalIpv6((String)string) && !bl) {
            throw new IllegalAttributeValueException("The address type must be global unicast for ipAddress", "IpAccessHostEt");
        }
    }

    private boolean isVpnInterface(ManagedObject managedObject) {
        return managedObject instanceof VpnInterfaceBuildIF;
    }

    private boolean isIpInterfaceGroup(ManagedObject managedObject) {
        return managedObject instanceof IpInterfaceGroupMo;
    }

    private void validateNetPrefix(String string, int n, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        boolean bl = false;
        bl = this.validateAgainstPathSupervision(string, n, managedObject, coordinator);
        if (!bl) {
            this.validateAgainstDefaultRouter(string, n, managedObject, coordinator);
        }
    }

    private void validateAgainstDefaultRouter(String string, int n, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException, IpFormatException, IllegalAttributeValueException {
        if (managedObject instanceof Ipv6InterfaceMo) {
            MoIterator moIterator = managedObject.getChildren();
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator.nextMo();
                if (!managedObject2.getType().equals("DefaultRouter")) continue;
                String string2 = (String)managedObject2.getAttribute("nextHopIpAddr", coordinator);
                this.validateIsUnique(string, string2);
                if (!Ipv6AddressValidation.isGlobalUnicastIpv6((String)string2) || Ipv6AddressValidation.compareNetPrefix((String)string, (String)string2, (int)n)) continue;
                throw new IllegalAttributeValueException("The network prefix of ipAddress and DefaultRouter MO(s)nextHopIpAddr for the same Ipv6Interface MO must be the same ", "IpAccessHostEt");
            }
        }
    }

    private boolean validateAgainstPathSupervision(String string, int n, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException, IpFormatException, IllegalAttributeValueException {
        boolean bl = false;
        if (managedObject instanceof Ipv6InterfaceMo) {
            MoIterator moIterator = managedObject.getChildren();
            while (moIterator.hasMoreElements()) {
                String string2;
                String string3;
                ManagedObject managedObject2 = moIterator.nextMo();
                if (!managedObject2.getType().equals("PathSupervision")) continue;
                bl = true;
                String string4 = (String)managedObject2.getAttribute("ownIpAddress", coordinator);
                if (Ipv6AddressValidation.isUnspecifiedIpv6((String)string4)) continue;
                int n2 = (Integer)managedObject2.getAttribute("networkPrefixLength", coordinator);
                int n3 = (Integer)managedObject2.getAttribute("linkSide", coordinator);
                String string5 = Ipv6AddressValidation.getNetworkPrefix((String)string, (int)n);
                String string6 = Ipv6AddressValidation.getNetworkPrefix((String)string4, (int)n2);
                if (n != n2 || !string5.equalsIgnoreCase(string6)) {
                    throw new IllegalAttributeValueException("The network prefix of IpAccessHostEt MO ipaddress and PathSupervison MO ownIpAddress for the same Ipv6Interface MO must be the same ", "IpAccessHostEt");
                }
                if (n3 != 1 || !(string3 = Ipv6AddressValidation.getIpv6Addres((String)string).getHostAddress()).equalsIgnoreCase(string2 = Ipv6AddressValidation.getIpv6Addres((String)string4).getHostAddress())) continue;
                throw new IllegalAttributeValueException("ipAddress can only be shared with PathSupervision MO ownIpAddress for the active link, PathSupervision MO linkSide=ACTIVE ", "IpAccessHostEt");
            }
        }
        return bl;
    }

    private void checkIpAddressWithIpHostLink(String string, boolean bl, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = MoRepository.instance().lookupType("IpHostLink");
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            String string2 = "";
            if (bl) {
                Struct[] structArray = ((IpHostLinkMo)managedObject).getIpv6Addresses(coordinator);
                if (structArray != null && structArray.length > 0) {
                    string2 = (String)structArray[0].getValue("ipAddress");
                }
            } else {
                string2 = ((IpHostLinkMo)managedObject).getIpAddress(coordinator);
            }
            if (!IpAddressValidation.getIpAddress((String)string).equals(IpAddressValidation.getIpAddress((String)string2))) continue;
            throw new IllegalAttributeValueException("The IpAddress " + string + " is already using by IpHostLink MO,choose other value for IpAddress", "IpAccessHostEt");
        }
    }

    private void validateIsUnique(String string, String string2) throws IpFormatException, AttrValueNotUniqueException {
        if (Ipv6AddressValidation.getIpv6Addres((String)string).equals(Ipv6AddressValidation.getIpv6Addres((String)string2))) {
            throw new AttrValueNotUniqueException("ipAddress must be unique", "IpAccessHostEt");
        }
    }
}

