/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.ipoam.IpHostLinkIpInterfaceBuildIF;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.ipoam.IpInterfaceBuildIF;
import se.ericsson.cello.iptransport.AccessControlListMo;
import se.ericsson.cello.iptransport.AccessControlListMoImpl;
import se.ericsson.cello.iptransport.GigaBitEthernetMo;
import se.ericsson.cello.iptransport.GigaBitEthernetMoImpl;
import se.ericsson.cello.iptransport.GigaBitEthernetMoImplInterface;
import se.ericsson.cello.iptransport.InternalEthernetPortMoImpl;
import se.ericsson.cello.iptransport.IpInterface;
import se.ericsson.cello.iptransport.IpInterfaceGroupMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.TrafficSchedulerMo;
import se.ericsson.cello.iptransport.TrafficSchedulerMoImpl;
import se.ericsson.cello.iptransport.VlanBuildIF;
import se.ericsson.cello.iptransport.VlanInfo;
import se.ericsson.cello.iptransport.ipi_ip_interface_mi;
import se.ericsson.cello.iptransport.mom.EnumIpTrafficType;
import se.ericsson.cello.iptransport.mom.StructDhcpClientIdentifier;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConcurrentTransactionHandler;
import se.ericsson.cello.mao.GenPmMaoHandler;
import se.ericsson.cello.mao.HostIpAddress;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.MaoPmStrategyForReqContext;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoNotPossibleToReserveException;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.NetworkAddress;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.PmRequestContextImpl;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.mao.TransactionHandler;
import se.ericsson.cello.mao.TransactionalFroIdMap;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericEventInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.MoTypeFilter;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.mom.commondefinitions.EnumStateVals;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class IpInterfaceMoImpl
extends CelloMao
implements IpInterfaceMo,
IpInterface,
Reservable,
IpInterfaceBuildIF,
IpHostLinkIpInterfaceBuildIF {
    private static TransactionalFroIdMap froIds = new TransactionalFroIdMap((TransactionHandler)new ConcurrentTransactionHandler());
    private MoData data;
    protected static final String LH_FROID = "lhFroId";
    protected static final String PIU_FROID = "piuFroId";
    private static final boolean RPS_DEFAULT = true;
    private static final int TRAFFIC_TYPE_DEFAULT = 0;
    protected static final int MTU_IEEE_802_3_LLC_SNAP_MAX = 1492;
    protected static final int MTU_FOR_NON_BACLPLANE_PORTS_MAX = 1500;
    private static final String DEFAULT_IP_ADDRESS = "0.0.0.0";
    private static final String IPACCESSHOSTGPB_CLASSNAME = "se.ericsson.cello.iptransport.IpAccessHostGpbMoImpl";
    private static final String IPACCESSHOSTSPB_CLASSNAME = "se.ericsson.cello.iptransport.IpAccessHostSpbMoImpl";
    private static final String IPACCESSHOSTET_CLASSNAME = "se.ericsson.cello.iptransport.IpAccessHostEtMoImpl";
    private static final String IPHOSTLINK_CLASSNAME = "se.ericsson.cello.ipoam.IpHostLinkMoImpl";
    private static final int MAX_NO_IP_INTERFACE = 16;
    private static final int MAX_NO_OF_RESERVERS = 64;
    private static final int MAX_NO_OF_ETHOST_RESERVERS = 2;
    private static final int MAX_NO_OF_IPHOSTLINK_RESERVERS = 1;
    private static final int MAX_NO_OF_HOST_CONNECTIONS = 128;
    private static final int IP_INTERFACE_DH_NO_DEFAULTROUTER_REACHABLE = 1;
    private static final int IP_INTERFACE_DH_NO_DEFAULTROUTER_REACHABLE_CEASED = 2;
    private static final int IP_INTERFACE_DH_DEFAULTROUTER_SWITCH = 3;
    private static Class[] accessControlListClass = new Class[]{AccessControlListMo.class};
    private static Class[] trafficSchedulerClass = new Class[]{TrafficSchedulerMo.class};
    private static final int MO_DATA_REVISION_5 = 5100;
    private static final int MO_DATA_REVISION_6 = 6000;
    private static final int MO_DATA_REVISION_7 = 7000;
    private static final int MO_DATA_REVISION_8 = 8000;
    private static final int MO_DATA_REVISION_9 = 9000;
    private static final int MO_DATA_REVISION_LATEST = 9000;
    private Map myPmProxyFroIdMap = new HashMap(3);
    private FroProxy ipInterfaceProxy = null;
    private MaoFroIndicationHandler indicationHandler = null;
    private static final TagNameDictionary DICTIONARY = TagNameDictionaries.create((ResourceBundle)new ipi_ip_interface_mi());
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, InitialMaoContext initialMaoContext) throws MoAccessException {
        int n;
        int n2;
        Object object;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"IpInterface", (String)string);
        String[] stringArray = new String[]{"GigaBitEthernet", "InternalEthernetPort"};
        MoAttributeValidator.checkParents((ManagedObject)managedObject, (String[])stringArray);
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"IpInterface", (int)16);
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"accessControlListRef", (AttrList)attrList, (boolean)false, (Class[])accessControlListClass, (String)"IpInterface");
        ManagedObject managedObject4 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"trafficSchedulerRef", (AttrList)attrList, (boolean)false, (Class[])trafficSchedulerClass, (String)"IpInterface");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"IpInterface", (int)128, (int)0);
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"rps", (AttrList)attrList, (boolean)false, (boolean)true, (String)"IpInterface");
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"configurationMode", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)1, (String)"IpInterface");
        if (n3 == 1 && (attrList.indexOf("defaultRouter0") != -1 || attrList.indexOf("defaultRouter1") != -1 || attrList.indexOf("defaultRouter2") != -1 || attrList.indexOf("networkPrefixLength") != -1 || attrList.indexOf("ownIpAddressActive") != -1)) {
            throw new IllegalAttributeValueException("For configurationMode=DHCP, these attributes are ReadOnly and should not be supplied in create request. defaultRouter0, defaultRouter1, defaultRouter2, networkPrefixLength and ownIpAddressActive.", "IpInterface");
        }
        int n4 = 24;
        String string3 = DEFAULT_IP_ADDRESS;
        String string4 = DEFAULT_IP_ADDRESS;
        String string5 = DEFAULT_IP_ADDRESS;
        String string6 = DEFAULT_IP_ADDRESS;
        HostIpAddress hostIpAddress = null;
        HostIpAddress hostIpAddress2 = new HostIpAddress(string4, n4);
        HostIpAddress hostIpAddress3 = new HostIpAddress(string5, n4);
        HostIpAddress hostIpAddress4 = null;
        if (n3 == 0) {
            n4 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"networkPrefixLength", (AttrList)attrList, (boolean)true, (int)24, (int)8, (int)30, (String)"IpInterface");
            string3 = MoAttributeValidator.checkAndGetStringAttribute((String)"defaultRouter0", (AttrList)attrList, (boolean)true, (String)DEFAULT_IP_ADDRESS, (String)"IpInterface");
            hostIpAddress = new HostIpAddress(string3, n4);
            if (string3.equals(DEFAULT_IP_ADDRESS)) {
                throw new ValueOutOfRangeException("defaultRouter0", "IpInterface", "defaultRouter0 can not be set to '0.0.0.0', must have a valid ip address.");
            }
            string4 = MoAttributeValidator.checkAndGetStringAttribute((String)"defaultRouter1", (AttrList)attrList, (boolean)false, (String)DEFAULT_IP_ADDRESS, (String)"IpInterface");
            hostIpAddress2 = new HostIpAddress(string4, n4);
            string5 = MoAttributeValidator.checkAndGetStringAttribute((String)"defaultRouter2", (AttrList)attrList, (boolean)false, (String)DEFAULT_IP_ADDRESS, (String)"IpInterface");
            hostIpAddress3 = new HostIpAddress(string5, n4);
        }
        int n5 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"defaultRouterPingInterval", (AttrList)attrList, (boolean)false, (int)4, (int)3, (int)100, (String)"IpInterface");
        int n6 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"maxWaitForPingReply", (AttrList)attrList, (boolean)false, (int)3, (int)3, (int)100, (String)"IpInterface");
        IpInterfaceMoImpl.checkDefRouterPingInterval(n5, n6);
        int n7 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"maxNoOfFailedPings", (AttrList)attrList, (boolean)false, (int)2, (int)1, (int)10, (String)"IpInterface");
        int n8 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"noOfPingsBeforeOk", (AttrList)attrList, (boolean)false, (int)2, (int)1, (int)10, (String)"IpInterface");
        int n9 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"switchBackTimer", (AttrList)attrList, (boolean)false, (int)180, (int)1, (int)3600, (String)"IpInterface");
        int n10 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"mtu", (AttrList)attrList, (boolean)false, (int)1500, (int)576, (int)2018, (String)"IpInterface");
        IpInterfaceMoImpl.checkMtu(n10, managedObject, coordinator);
        String string7 = MoAttributeValidator.checkAndGetStringAttribute((String)"ownIpAddressPassive", (AttrList)attrList, (boolean)false, (String)DEFAULT_IP_ADDRESS, (String)"IpInterface");
        HostIpAddress hostIpAddress5 = new HostIpAddress(string7, n4);
        if (n3 == 0) {
            if (bl) {
                string6 = MoAttributeValidator.checkAndGetStringAttribute((String)"ownIpAddressActive", (AttrList)attrList, (boolean)true, (String)DEFAULT_IP_ADDRESS, (String)"IpInterface");
                if (string6.equals(DEFAULT_IP_ADDRESS)) {
                    throw new ValueOutOfRangeException("ownIpAddressActive must have a valid IP Address when rps is set to true.", "IpInterface");
                }
                IpInterfaceMoImpl.checkOwnIpAddressIsUnique(string6, coordinator);
            } else {
                string6 = MoAttributeValidator.checkAndGetStringAttribute((String)"ownIpAddressActive", (AttrList)attrList, (boolean)false, (String)DEFAULT_IP_ADDRESS, (String)"IpInterface");
            }
            hostIpAddress4 = new HostIpAddress(string6, n4);
            IpAddress[] ipAddressArray = new IpAddress[]{hostIpAddress2, hostIpAddress3, hostIpAddress4, hostIpAddress5};
            IpInterfaceMoImpl.validateIpAddresses(n4, (IpAddress)hostIpAddress, ipAddressArray);
            object = new ArrayList();
            ((ArrayList)object).add(string3);
            ((ArrayList)object).add(string4);
            ((ArrayList)object).add(string5);
            ((ArrayList)object).add(string6);
            ((ArrayList)object).add(string7);
            IpInterfaceMoImpl.checkIfIpAddressesIsUnique((ArrayList)object);
        }
        if (managedObject.getType().equals("GigaBitEthernet") && bl && !string7.equals(DEFAULT_IP_ADDRESS)) {
            IpInterfaceMoImpl.checkOwnIpAddressIsUnique(string7, coordinator);
        }
        int n11 = MoAttributeValidator.checkAndGetEnumAttribute((String)"trafficType", (AttrList)attrList, (boolean)false, (int)0, (int[])EnumIpTrafficType.VALUES_ARRAY, (String)"IpInterface");
        object = IpInterfaceMoImpl.analyzeVlanInfo(attrList, managedObject, coordinator);
        int n12 = MoAttributeValidator.checkAndGetEnumAttribute((String)"logging", (AttrList)attrList, (boolean)false, (int)0, (int[])EnumStateVals.VALUES_ARRAY, (String)"IpInterface");
        Struct struct = MoAttributeValidator.checkAndGetStructAttribute((String)"dhcpClientIdentifier", (AttrList)attrList, (boolean)false, (String)"IpInterface");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"IpInterface");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (managedObject.getType().equals("GigaBitEthernet")) {
            n2 = ((GigaBitEthernetMoImplInterface)managedObject).getFroId(coordinator);
            n = ((GigaBitEthernetMoImpl)managedObject).getLinkType(coordinator);
        } else {
            n2 = ((InternalEthernetPortMoImpl)managedObject).getFroId(coordinator);
            n = 0;
        }
        arrayList.add(new SignedIntParameter("linkType", n));
        arrayList.add(new SignedIntParameter(LH_FROID, n2));
        int n13 = PiuUtils.findPiuParentFroId((ManagedObject)managedObject);
        arrayList.add(new SignedIntParameter(PIU_FROID, n13));
        arrayList.add(new SignedIntParameter("rps", bl));
        arrayList.add(new SignedIntParameter("networkPrefixLength", n4));
        arrayList.add(new SignedIntParameter("configurationMode", n3));
        arrayList.add(new StringParameter("defaultRouter0", string3));
        arrayList.add(new StringParameter("defaultRouter1", string4));
        arrayList.add(new StringParameter("defaultRouter2", string5));
        arrayList.add(new SignedIntParameter("defaultRouterPingInterval", n5));
        arrayList.add(new SignedIntParameter("maxWaitForPingReply", n6));
        arrayList.add(new SignedIntParameter("maxNoOfFailedPings", n7));
        arrayList.add(new SignedIntParameter("noOfPingsBeforeOk", n8));
        arrayList.add(new SignedIntParameter("switchBackTimer", n9));
        arrayList.add(new StringParameter("ownIpAddressActive", string6));
        arrayList.add(new StringParameter("ownIpAddressPassive", string7));
        arrayList.add(new SignedIntParameter("mtu", n10));
        ManagedObject managedObject5 = ((VlanInfo)object).getVlanRef();
        arrayList.addAll(((VlanInfo)object).packVlanInfo(coordinator).values());
        int n14 = 0;
        if (managedObject3 != null) {
            IpInterfaceMoImpl.checkAccessControlListConfiguration(managedObject3, coordinator);
            n14 = ((AccessControlListMoImpl)managedObject3).getFroId(coordinator);
        }
        int n15 = 0;
        if (managedObject4 != null) {
            n15 = ((TrafficSchedulerMoImpl)managedObject4).getFroId(coordinator);
        }
        arrayList.add(new UnsignedIntParameter("accessControlListRef", (long)n14));
        arrayList.add(new UnsignedIntParameter("trafficSchedulerRef", (long)n15));
        arrayList.add(new SignedIntParameter("logging", n12));
        arrayList.add(new StringParameter("IpInterfaceId", "IpInterface=" + string));
        if (struct != null) {
            arrayList.add(IpInterfaceMoImpl.validateAndCreateStructParameter("dhcpClientIdentifier", struct, coordinator));
        } else {
            arrayList.add(IpInterfaceMoImpl.validateAndCreateStructParameter("dhcpClientIdentifier", StructDhcpClientIdentifier.createStruct("", 0), coordinator));
        }
        return new IpInterfaceMoImpl(managedObject, string, string2, n11, managedObject5, managedObject3, managedObject4, arrayList, string7, coordinator, froProxy, maoFroIndicationHandler, initialMaoContext, n3, (VlanInfo)object);
    }

    private void checkVid(int n, VlanInfo vlanInfo, Coordinator coordinator) throws MoAccessException {
        MoRepository moRepository = MoRepository.instance();
        MoIterator moIterator = moRepository.lookupType("IpInterface");
        if (moIterator == null) {
            return;
        }
        int n2 = vlanInfo.getVid();
        boolean bl = vlanInfo.getVlan();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (managedObject == this) continue;
            int n3 = (Integer)managedObject.getAttribute("vid", coordinator);
            int n4 = (Integer)managedObject.getAttribute("configurationMode", coordinator);
            boolean bl2 = (Boolean)managedObject.getAttribute("vLan", coordinator);
            if (n == 0 && n4 == 0) continue;
            if (n == 0 && !bl && !bl2) {
                throw new AttrValueNotUniqueException(" Not possible to create/set MANUAL IpInterface.", "IpInterface");
            }
            if (n == 0 && bl && bl2 && n2 == n3) {
                throw new AttrValueNotUniqueException(" Not possible to create/set MANUAL IpInterface. Vid not unique.", "IpInterface");
            }
            if (n == 1 && !bl && !bl2) {
                throw new AttrValueNotUniqueException(" Not possible to create/set DHCP IpInterface.", "IpInterface");
            }
            if (n != 1 || !bl || !bl2 || n2 != n3) continue;
            throw new AttrValueNotUniqueException(" Not possible to create/set DHCP IpInterface. Vid not unique.", "IpInterface");
        }
    }

    private IpInterfaceMoImpl(ManagedObject managedObject, String string, String string2, int n, ManagedObject managedObject2, ManagedObject managedObject3, ManagedObject managedObject4, ArrayList arrayList, String string3, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, InitialMaoContext initialMaoContext, int n2, VlanInfo vlanInfo) throws MoAccessException {
        super(managedObject, "IpInterface", string, coordinator, initialMaoContext);
        super.setPmHandler((GenPmMaoHandler)new MaoPmStrategyForReqContext((ManagedObject)this, this.myPmAppPortal));
        this.ipInterfaceProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.checkVid(n2, vlanInfo, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        FroData froData = this.ipInterfaceProxy.create(coordinator, (Collection)arrayList);
        int n3 = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n3));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("trafficType", true, n));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("vlanRef", true, managedObject2));
        if (null != managedObject2) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        }
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("accessControlListRef", true, managedObject3));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("trafficSchedulerRef", true, managedObject4));
        if (managedObject3 != null) {
            ((Reservable)managedObject3).reserve((ManagedObject)this, coordinator);
        }
        if (managedObject4 != null) {
            ((Reservable)managedObject4).reserve((ManagedObject)this, coordinator);
        }
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n3);
        froIds.put(n3, (ManagedObject)this, coordinator);
        this.data.setRevision(9000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public IpInterfaceMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        super.setPmHandler((GenPmMaoHandler)new MaoPmStrategyForReqContext((ManagedObject)this, this.myPmAppPortal));
        this.data = moData;
        this.ipInterfaceProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(9000);
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("trafficType");
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("vlanRef");
        moDataRecoveryHelper.assertAttribute("accessControlListRef");
        moDataRecoveryHelper.assertAttribute("trafficSchedulerRef");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
        froIds.put(((IntegerAttribute)this.data.getAttribute("froId")).getValue(null), (ManagedObject)this);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.releaseReference(coordinator, "vlanRef");
        this.releaseReference(coordinator, "accessControlListRef");
        this.releaseReference(coordinator, "trafficSchedulerRef");
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException("IpInterface");
        }
        this.ipInterfaceProxy.delete(coordinator, this.getFroId(coordinator), null);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        froIds.remove(this.getFroId(coordinator), coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    private void releaseReference(Coordinator coordinator, String string) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        ManagedObject managedObject = (ManagedObject)objectArray[0];
        if (managedObject != null) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException {
        return (String[])this.getAttribute("currentPmRegister", coordinator);
    }

    public int getVid(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("vid", coordinator);
    }

    public void setVid(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("vid", new Integer(n), coordinator);
    }

    public boolean getVLan(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("vLan", coordinator);
    }

    public void setVLan(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("vLan", bl, coordinator);
    }

    public boolean getRps(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("rps", coordinator);
    }

    public void setRps(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("rps", bl, coordinator);
    }

    public int getMtu(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("mtu", coordinator);
    }

    public void setMtu(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("mtu", new Integer(n), coordinator);
    }

    public int getNetworkPrefixLength(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("networkPrefixLength", coordinator);
    }

    public String getDefaultRouter0(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("defaultRouter0", coordinator);
    }

    public void setDefaultRouter0(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("defaultRouter0", string, coordinator);
    }

    public String getDefaultRouter1(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("defaultRouter1", coordinator);
    }

    public void setDefaultRouter1(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("defaultRouter1", string, coordinator);
    }

    public String getDefaultRouter2(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("defaultRouter2", coordinator);
    }

    public void setDefaultRouter2(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("defaultRouter2", string, coordinator);
    }

    public int getDefaultRouter0State(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("defaultRouter0State", coordinator);
    }

    public int getDefaultRouter1State(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("defaultRouter1State", coordinator);
    }

    public int getDefaultRouter2State(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("defaultRouter2State", coordinator);
    }

    public int getDefaultRouterTraffic(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("defaultRouterTraffic", coordinator);
    }

    public int getDefaultRouterPingInterval(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("defaultRouterPingInterval", coordinator);
    }

    public void setDefaultRouterPingInterval(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("defaultRouterPingInterval", new Integer(n), coordinator);
    }

    public int getMaxWaitForPingReply(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maxWaitForPingReply", coordinator);
    }

    public void setMaxWaitForPingReply(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("maxWaitForPingReply", new Integer(n), coordinator);
    }

    public int getMaxNoOfFailedPings(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maxNoOfFailedPings", coordinator);
    }

    public void setMaxNoOfFailedPings(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("maxNoOfFailedPings", new Integer(n), coordinator);
    }

    public ManagedObject getVlanRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("vlanRef", coordinator);
    }

    public void setVlanRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("vlanRef", managedObject, coordinator);
    }

    public int getNoOfPingsBeforeOk(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("noOfPingsBeforeOk", coordinator);
    }

    public void setNoOfPingsBeforeOk(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("noOfPingsBeforeOk", new Integer(n), coordinator);
    }

    public int getSwitchBackTimer(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("switchBackTimer", coordinator);
    }

    public void setSwitchBackTimer(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("switchBackTimer", new Integer(n), coordinator);
    }

    public String getOwnIpAddressActive(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("ownIpAddressActive", coordinator);
    }

    public String getOwnIpAddressPassive(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("ownIpAddressPassive", coordinator);
    }

    public String getSubnet(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("subnet", coordinator);
    }

    public int getTrafficType(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("trafficType", coordinator);
    }

    public void setTrafficType(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("trafficType", new Integer(n), coordinator);
    }

    public int getLogging(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("logging", coordinator);
    }

    public void setLogging(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("logging", new Integer(n), coordinator);
    }

    public int getConfigurationMode(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("configurationMode", coordinator);
    }

    public Struct getDhcpClientIdentifier(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("dhcpClientIdentifier", coordinator);
    }

    public int getPmIfStatsIpInReceives(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfStatsIpInReceives", coordinator);
    }

    public int getPmIfStatsIpInHdrErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfStatsIpInHdrErrors", coordinator);
    }

    public int getPmNoOfFailedPingsDefaultRouter0(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmNoOfFailedPingsDefaultRouter0", coordinator);
    }

    public int getPmNoOfFailedPingsDefaultRouter1(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmNoOfFailedPingsDefaultRouter1", coordinator);
    }

    public int getPmNoOfFailedPingsDefaultRouter2(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmNoOfFailedPingsDefaultRouter2", coordinator);
    }

    public int getPmIfStatsIpAddrErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfStatsIpAddrErrors", coordinator);
    }

    public int getPmIfStatsIpInDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfStatsIpInDiscards", coordinator);
    }

    public int getPmIfStatsIpUnknownProtos(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfStatsIpUnknownProtos", coordinator);
    }

    public int getPmIfStatsIpOutRequests(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfStatsIpOutRequests", coordinator);
    }

    public int getPmIfStatsIpOutDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfStatsIpOutDiscards", coordinator);
    }

    public int getPmDot1qTpVlanPortInFrames(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmDot1qTpVlanPortInFrames", coordinator);
    }

    public int getPmDot1qTpVlanPortOutFrames(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmDot1qTpVlanPortOutFrames", coordinator);
    }

    public int getPmInDiscPolicy(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInDiscPolicy", coordinator);
    }

    public int getPmInPassedPolicy(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInPassedPolicy", coordinator);
    }

    public int getPmInEsp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInEsp", coordinator);
    }

    public long getPmIpIfStatsHCInOctets(Coordinator coordinator) throws MoAccessException {
        return ((Long)this.getAttribute("pmIpIfStatsHCInOctets", coordinator)).intValue();
    }

    public long getPmIpIfStatsHCOutOctets(Coordinator coordinator) throws MoAccessException {
        return ((Long)this.getAttribute("pmIpIfStatsHCOutOctets", coordinator)).intValue();
    }

    public long getPmIpIfStatsHCOutTransmits(Coordinator coordinator) throws MoAccessException {
        return ((Long)this.getAttribute("pmIpIfStatsHCOutTransmits", coordinator)).intValue();
    }

    public long getPmIpIfStatsHCInReceives(Coordinator coordinator) throws MoAccessException {
        return ((Long)this.getAttribute("pmIpIfStatsHCInReceives", coordinator)).intValue();
    }

    public long getPmIfStatsHCIpInMcastOctets(Coordinator coordinator) throws MoAccessException {
        return ((Long)this.getAttribute("pmIfStatsHCIpInMcastOctets", coordinator)).intValue();
    }

    public long getPmIfStatsHCIpInMcastPkts(Coordinator coordinator) throws MoAccessException {
        return ((Long)this.getAttribute("pmIfStatsHCIpInMcastPkts", coordinator)).intValue();
    }

    public long getPmIfStatsHCIpOutMcastOctets(Coordinator coordinator) throws MoAccessException {
        return ((Long)this.getAttribute("pmIfStatsHCIpOutMcastOctets", coordinator)).intValue();
    }

    public long getPmIfStatsHCIpOutMcastPkts(Coordinator coordinator) throws MoAccessException {
        return ((Long)this.getAttribute("pmIfStatsHCIpOutMcastPkts", coordinator)).intValue();
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            StringParameter stringParameter;
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("trafficType")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("trafficType")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("froId")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("defaultRouter0")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (StringParameter)map.get("defaultRouter0");
                objectArray[i] = stringParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("defaultRouter0State")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("defaultRouter0State");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("defaultRouter1")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (StringParameter)map.get("defaultRouter1");
                objectArray[i] = stringParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("defaultRouter1State")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("defaultRouter1State");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("defaultRouter2")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (StringParameter)map.get("defaultRouter2");
                objectArray[i] = stringParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("defaultRouter2State")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("defaultRouter2State");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("defaultRouterPingInterval")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("defaultRouterPingInterval");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("defaultRouterTraffic")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("defaultRouterTraffic");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxNoOfFailedPings")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("maxNoOfFailedPings");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxWaitForPingReply")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("maxWaitForPingReply");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("networkPrefixLength")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("networkPrefixLength");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("noOfPingsBeforeOk")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("noOfPingsBeforeOk");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ownIpAddressActive")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (StringParameter)map.get("ownIpAddressActive");
                objectArray[i] = stringParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ownIpAddressPassive")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (StringParameter)map.get("ownIpAddressPassive");
                objectArray[i] = stringParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("rps")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("rps");
                objectArray[i] = stringParameter.getBoolean();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("switchBackTimer")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("switchBackTimer");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vid")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("vid");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vLan")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("vLan");
                objectArray[i] = stringParameter.getBoolean();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vlanRef")) {
                stringParameter = this.data.getAttribute("vlanRef");
                if (null != stringParameter) {
                    objectArray[i] = ((ReferenceAttribute)stringParameter).getValue(coordinator);
                    continue;
                }
                objectArray[i] = null;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("subnet")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("networkPrefixLength");
                object = (StringParameter)map.get("defaultRouter0");
                IpAddress ipAddress = new IpAddress(object.getValue());
                IpAddress ipAddress2 = ipAddress.getSubnetAddress(stringParameter.getValue());
                objectArray[i] = ipAddress2.toString();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("mtu")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("mtu");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("accessControlListRef")) {
                stringParameter = this.data.getAttribute("accessControlListRef");
                if (null != stringParameter) {
                    objectArray[i] = ((ReferenceAttribute)stringParameter).getValue(coordinator);
                    continue;
                }
                objectArray[i] = null;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("logging")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("logging");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("trafficSchedulerRef")) {
                stringParameter = this.data.getAttribute("trafficSchedulerRef");
                if (null != stringParameter) {
                    objectArray[i] = ((ReferenceAttribute)stringParameter).getValue(coordinator);
                    continue;
                }
                objectArray[i] = null;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("configurationMode")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (SignedIntParameter)map.get("configurationMode");
                objectArray[i] = new Integer(stringParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("dhcpClientIdentifier")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter = (StructParameter)map.get("dhcpClientIdentifier");
                object = ((StringParameter)stringParameter.get("clientIdentifier")).getValue();
                int n = ((SignedIntParameter)stringParameter.get("clientIdentifierType")).getValue();
                objectArray[i] = StructDhcpClientIdentifier.createStruct((String)object, n);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsIpUnknownProtos")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfStatsIpUnknownProtos", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsIpOutRequests")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfStatsIpOutRequests", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsIpOutDiscards")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfStatsIpOutDiscards", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsIpInReceives")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfStatsIpInReceives", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsIpInHdrErrors")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfStatsIpInHdrErrors", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsIpInDiscards")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfStatsIpInDiscards", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsIpAddrErrors")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfStatsIpAddrErrors", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmDot1qTpVlanPortOutFrames")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmDot1qTpVlanPortOutFrames", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmDot1qTpVlanPortInFrames")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmDot1qTpVlanPortInFrames", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfFailedPingsDefaultRouter0")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmNoOfFailedPingsDefaultRouter0", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfFailedPingsDefaultRouter1")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmNoOfFailedPingsDefaultRouter1", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfFailedPingsDefaultRouter2")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmNoOfFailedPingsDefaultRouter2", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInDiscPolicy")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmInDiscPolicy", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInPassedPolicy")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmInPassedPolicy", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInEsp")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmInEsp", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsHCInOctets")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpIfStatsHCInOctets", LONG_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsHCOutOctets")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpIfStatsHCOutOctets", LONG_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsHCOutTransmits")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpIfStatsHCOutTransmits", LONG_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsHCInReceives")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpIfStatsHCInReceives", LONG_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsHCIpInMcastOctets")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfStatsHCIpInMcastOctets", LONG_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsHCIpInMcastPkts")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfStatsHCIpInMcastPkts", LONG_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsHCIpOutMcastOctets")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfStatsHCIpOutMcastOctets", LONG_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsHCIpOutMcastPkts")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIfStatsHCIpOutMcastPkts", LONG_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("currentPmRegister")) {
                objectArray[i] = pmRequestContextImpl.getCurrentPmRegister();
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpInterface");
        }
        return objectArray;
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.ipInterfaceProxy.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        Map map;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Map map2 = this.prepareSetFroAttr(coordinator);
        ManagedObject managedObject = this.getParent();
        int n = 0;
        if (managedObject.getType().equals("GigaBitEthernet")) {
            n = ((GigaBitEthernetMo)managedObject).getLinkType(coordinator);
        }
        map2.put("linkType", new SignedIntParameter("linkType", n));
        HashMap hashMap = (HashMap)((HashMap)map2).clone();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            HostIpAddress hostIpAddress;
            Object object;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpInterfaceMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "IpInterface");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"IpInterface", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("trafficType")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpInterfaceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("trafficType", "IpInterface");
                }
                MoAttributeValidator.checkEnumAttribute((String)"trafficType", (int)((Integer)objectArray[i]), (int[])EnumIpTrafficType.VALUES_ARRAY, (String)"IpInterface");
                ((IntegerAttribute)this.data.getAttribute("trafficType")).setValue((Integer)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("defaultRouterPingInterval")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpInterfaceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("defaultRouterPingInterval", "IpInterface");
                }
                int n2 = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"defaultRouterPingInterval", (int)n2, (int)3, (int)100, (String)"IpInterface");
                int n3 = (Integer)this.getAttribute("maxWaitForPingReply", coordinator);
                IpInterfaceMoImpl.checkDefRouterPingInterval(n2, n3);
                map2.put("defaultRouterPingInterval", new SignedIntParameter("defaultRouterPingInterval", n2));
                this.sendNotification("defaultRouterPingInterval", new Integer(n2), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("defaultRouter0")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpInterfaceMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("defaultRouter0", "IpInterface");
                }
                int n4 = ((SignedIntParameter)map2.get("configurationMode")).getValue();
                if (n4 == 1) {
                    throw new OperationNotAllowedException("Set defaultRouter0 when configurationMode is DHCP is not allowed.", "IpInterface");
                }
                Boolean bl2 = (Boolean)this.getAttribute("rps", coordinator);
                String string = (String)objectArray[i];
                object = this.getNetworkAddress(coordinator);
                hostIpAddress = new HostIpAddress(string, object.getNetworkPrefix());
                if (bl2.booleanValue()) {
                    throw new OperationNotAllowedException(stringArray[i] + " is only allowed to set when RPS is false", "IpInterface");
                }
                if (string.equals(DEFAULT_IP_ADDRESS)) {
                    throw new ValueOutOfRangeException("defaultRouter0", "IpInterface", "defaultRouter0 can not be set to '0.0.0.0', must have a valid ip address.");
                }
                hostIpAddress.validateIpAddrWithinSubnet(object.getNetworkPrefix(), new IpAddress(object.getSubnet()), "IpInterface");
                map2.put("defaultRouter0", new StringParameter("defaultRouter0", string));
                stringArray2 = new String[]{"defaultRouter0"};
                Object[] objectArray2 = new String[]{string};
                NotificationSender.instance().pushAVC((ManagedObject)this, stringArray2, objectArray2, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("defaultRouter1")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpInterfaceMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("defaultRouter1", "IpInterface");
                }
                int n5 = ((SignedIntParameter)map2.get("configurationMode")).getValue();
                if (n5 == 1) {
                    throw new OperationNotAllowedException("Set defaultRouter1 when configurationMode is DHCP is not allowed.", "IpInterface");
                }
                Boolean bl3 = (Boolean)this.getAttribute("rps", coordinator);
                String string = (String)objectArray[i];
                if (bl3.booleanValue()) {
                    throw new OperationNotAllowedException(stringArray[i] + " is only allowed to set when RPS is false", "IpInterface");
                }
                if (!string.equals(DEFAULT_IP_ADDRESS)) {
                    object = this.getNetworkAddress(coordinator);
                    hostIpAddress = new HostIpAddress(string, object.getNetworkPrefix());
                    hostIpAddress.validateIpAddrWithinSubnet(object.getNetworkPrefix(), new IpAddress(object.getSubnet()), "IpInterface");
                }
                map2.put("defaultRouter1", new StringParameter("defaultRouter1", string));
                this.sendNotification("defaultRouter1", string, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("defaultRouter2")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpInterfaceMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("defaultRouter2", "IpInterface");
                }
                int n6 = ((SignedIntParameter)map2.get("configurationMode")).getValue();
                if (n6 == 1) {
                    throw new OperationNotAllowedException("Set defaultRouter2 when configurationMode is DHCP is not allowed.", "IpInterface");
                }
                Boolean bl4 = (Boolean)this.getAttribute("rps", coordinator);
                String string = (String)objectArray[i];
                if (bl4.booleanValue()) {
                    throw new OperationNotAllowedException(stringArray[i] + " is only allowed to set when RPS is false", "IpInterface");
                }
                if (!string.equals(DEFAULT_IP_ADDRESS)) {
                    object = this.getNetworkAddress(coordinator);
                    hostIpAddress = new HostIpAddress(string, object.getNetworkPrefix());
                    stringArray2 = new IpAddress(object.getSubnet());
                    hostIpAddress.validateIpAddrWithinSubnet(object.getNetworkPrefix(), (IpAddress)stringArray2, "IpInterface");
                }
                map2.put("defaultRouter2", new StringParameter("defaultRouter2", string));
                this.sendNotification("defaultRouter2", string, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxNoOfFailedPings")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpInterfaceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("maxNoOfFailedPings", "IpInterface");
                }
                int n7 = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"maxNoOfFailedPings", (int)n7, (int)1, (int)10, (String)"IpInterface");
                map2.put("maxNoOfFailedPings", new SignedIntParameter("maxNoOfFailedPings", n7));
                this.sendNotification("maxNoOfFailedPings", new Integer(n7), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxWaitForPingReply")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpInterfaceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("maxWaitForPingReply", "IpInterface");
                }
                int n8 = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"maxWaitForPingReply", (int)n8, (int)3, (int)100, (String)"IpInterface");
                int n9 = (Integer)this.getAttribute("defaultRouterPingInterval", coordinator);
                IpInterfaceMoImpl.checkDefRouterPingInterval(n9, n8);
                map2.put("maxWaitForPingReply", new SignedIntParameter("maxWaitForPingReply", n8));
                this.sendNotification("maxWaitForPingReply", new Integer(n8), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("noOfPingsBeforeOk")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpInterfaceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("noOfPingsBeforeOk", "IpInterface");
                }
                int n10 = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"noOfPingsBeforeOk", (int)n10, (int)1, (int)10, (String)"IpInterface");
                map2.put("noOfPingsBeforeOk", new SignedIntParameter("noOfPingsBeforeOk", n10));
                this.sendNotification("noOfPingsBeforeOk", new Integer(n10), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("rps")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Boolean == null ? IpInterfaceMoImpl.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    throw new WrongAttributeTypeException("rps", "IpInterface");
                }
                boolean bl5 = (Boolean)objectArray[i];
                String string = ((StringParameter)map2.get("ownIpAddressActive")).getValue();
                int n11 = ((SignedIntParameter)map2.get("configurationMode")).getValue();
                if (n11 == 0 && bl5 && string.equals(DEFAULT_IP_ADDRESS)) {
                    throw new ValueOutOfRangeException("ownIpAddressActive must have a valid IP Address when rps is set to true.", "IpInterface");
                }
                map2.put("rps", new SignedIntParameter("rps", bl5));
                this.sendNotification("rps", bl5, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vlanRef")) {
                if (null != objectArray[i] && !(objectArray[i] instanceof VlanBuildIF)) {
                    throw new WrongAttributeTypeException("vlanRef", "IpInterface");
                }
                ManagedObject managedObject2 = (ManagedObject)objectArray[i];
                ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
                for (int j = 0; j < managedObjectArray.length; ++j) {
                    if (!managedObjectArray[j].getType().equalsIgnoreCase("IpInterfaceGroup") || managedObject2 == null) continue;
                    throw new IllegalAttributeValueException("VLAN_REF must be the same within the IpInterfaceGroup", "vlanRef", "IpInterface");
                }
                bl = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vid")) {
                if (stringArray[i].equalsIgnoreCase("vid") && !objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpInterfaceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("vid", "IpInterface");
                }
                int n12 = (Integer)objectArray[i];
                ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
                for (int j = 0; j < managedObjectArray.length; ++j) {
                    if (!managedObjectArray[j].getType().equalsIgnoreCase("IpInterfaceGroup") || n12 == (object = (IpInterfaceMo)((IpInterfaceGroupMo)managedObjectArray[j]).getPrimaryIpInterfaceRef(coordinator)).getVid(coordinator)) continue;
                    throw new IllegalAttributeValueException("VID must be the same within the IpInterfaceGroup", "vid", "IpInterface");
                }
                bl = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vLan")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Boolean == null ? IpInterfaceMoImpl.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    throw new WrongAttributeTypeException("vLan", "IpInterface");
                }
                boolean bl6 = (Boolean)objectArray[i];
                ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
                for (int j = 0; j < managedObjectArray.length; ++j) {
                    if (!managedObjectArray[j].getType().equalsIgnoreCase("IpInterfaceGroup") || bl6) continue;
                    throw new IllegalAttributeValueException("VLAN must be the same within the IpInterfaceGroup", "vLan", "IpInterface");
                }
                bl = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("switchBackTimer")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpInterfaceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("switchBackTimer", "IpInterface");
                }
                int n13 = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"switchBackTimer", (int)n13, (int)1, (int)3600, (String)"IpInterface");
                map2.put("switchBackTimer", new SignedIntParameter("switchBackTimer", n13));
                this.sendNotification("switchBackTimer", new Integer(n13), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("mtu")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpInterfaceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("mtu", "IpInterface");
                }
                int n14 = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"mtu", (int)n14, (int)576, (int)2018, (String)"IpInterface");
                IpInterfaceMoImpl.checkMtu(n14, this.getParent(), coordinator);
                map2.put("mtu", new SignedIntParameter("mtu", n14));
                this.sendNotification("mtu", new Integer(n14), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("logging")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpInterfaceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("logging", "IpInterface");
                }
                int n15 = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"logging", (int)n15, (int)0, (int)1, (String)"IpInterface");
                map2.put("logging", new SignedIntParameter("logging", n15));
                this.sendNotification("logging", new Integer(n15), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("accessControlListRef")) {
                ManagedObject managedObject3 = (ManagedObject)this.getAttribute("accessControlListRef", coordinator);
                boolean bl7 = false;
                if (objectArray[i] == null) {
                    if (managedObject3 != null) {
                        int n16 = 0;
                        map2.put("accessControlListRef", new UnsignedIntParameter("accessControlListRef", (long)n16));
                        ((Reservable)managedObject3).release((ManagedObject)this, coordinator);
                        ((ReferenceAttribute)this.data.getAttribute("accessControlListRef")).setValue((ManagedObject)objectArray[i]);
                        bl7 = true;
                    }
                } else {
                    if (!(objectArray[i] instanceof AccessControlListMo)) {
                        throw new WrongAttributeTypeException("accessControlListRef", "IpInterface");
                    }
                    IpInterfaceMoImpl.checkAccessControlListConfiguration((AccessControlListMo)objectArray[i], coordinator);
                    if (managedObject3 == null) {
                        int n17 = ((AccessControlListMoImpl)objectArray[i]).getFroId(coordinator);
                        map2.put("accessControlListRef", new UnsignedIntParameter("accessControlListRef", (long)n17));
                        ((Reservable)objectArray[i]).reserve((ManagedObject)this, coordinator);
                        ((ReferenceAttribute)this.data.getAttribute("accessControlListRef")).setValue((ManagedObject)objectArray[i]);
                        bl7 = true;
                    } else if (!((AccessControlListMoImpl)objectArray[i]).equals(managedObject3)) {
                        int n18 = ((AccessControlListMoImpl)objectArray[i]).getFroId(coordinator);
                        map2.put("accessControlListRef", new UnsignedIntParameter("accessControlListRef", (long)n18));
                        ((Reservable)managedObject3).release((ManagedObject)this, coordinator);
                        ((Reservable)objectArray[i]).reserve((ManagedObject)this, coordinator);
                        ((ReferenceAttribute)this.data.getAttribute("accessControlListRef")).setValue((ManagedObject)objectArray[i]);
                        bl7 = true;
                    }
                }
                if (!bl7) continue;
                this.sendNotification("accessControlListRef", objectArray[i], coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("trafficSchedulerRef")) {
                ManagedObject managedObject4 = (ManagedObject)this.getAttribute("trafficSchedulerRef", coordinator);
                boolean bl8 = false;
                if (objectArray[i] == null) {
                    if (managedObject4 != null) {
                        int n19 = 0;
                        map2.put("trafficSchedulerRef", new UnsignedIntParameter("trafficSchedulerRef", (long)n19));
                        ((Reservable)managedObject4).release((ManagedObject)this, coordinator);
                        ((ReferenceAttribute)this.data.getAttribute("trafficSchedulerRef")).setValue((ManagedObject)objectArray[i]);
                        bl8 = true;
                    }
                } else {
                    if (!(objectArray[i] instanceof TrafficSchedulerMo)) {
                        throw new WrongAttributeTypeException("trafficSchedulerRef", "IpInterface");
                    }
                    if (managedObject4 == null) {
                        int n20 = ((TrafficSchedulerMoImpl)objectArray[i]).getFroId(coordinator);
                        map2.put("trafficSchedulerRef", new UnsignedIntParameter("trafficSchedulerRef", (long)n20));
                        ((Reservable)objectArray[i]).reserve((ManagedObject)this, coordinator);
                        ((ReferenceAttribute)this.data.getAttribute("trafficSchedulerRef")).setValue((ManagedObject)objectArray[i]);
                        bl8 = true;
                    } else if (!((TrafficSchedulerMoImpl)objectArray[i]).equals(managedObject4)) {
                        int n21 = ((TrafficSchedulerMoImpl)objectArray[i]).getFroId(coordinator);
                        map2.put("trafficSchedulerRef", new UnsignedIntParameter("trafficSchedulerRef", (long)n21));
                        ((Reservable)managedObject4).release((ManagedObject)this, coordinator);
                        ((Reservable)objectArray[i]).reserve((ManagedObject)this, coordinator);
                        ((ReferenceAttribute)this.data.getAttribute("trafficSchedulerRef")).setValue((ManagedObject)objectArray[i]);
                        bl8 = true;
                    }
                }
                if (!bl8) continue;
                this.sendNotification("trafficSchedulerRef", objectArray[i], coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpInterface");
        }
        if (bl && null != (map = this.setVlanAttributes(stringArray, objectArray, coordinator))) {
            map2.putAll(map);
        }
        IpInterfaceMoImpl.checkIfIpAddressesIsUnique(this.getIpAddresses(map2));
        if (this.doesFroParametersDiffer(hashMap, (HashMap)map2)) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(map2.values());
            this.ipInterfaceProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private static void checkAccessControlListConfiguration(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        Struct struct;
        String string;
        Struct[] structArray = ((AccessControlListMo)managedObject).getAclEntries(coordinator);
        if (structArray != null && structArray.length != 0 && !Ipv4AddressValidation.isIpv4((String)(string = (String)(struct = structArray[0]).getValue("localIpAddress")))) {
            throw new IllegalAttributeValueException("IpInterface can refer to AccessControlListMO which contains Ipv4 addresses only", "IpInterface");
        }
    }

    private boolean doesFroParametersDiffer(HashMap hashMap, HashMap hashMap2) {
        if (hashMap.size() != hashMap2.size()) {
            return true;
        }
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (hashMap2.containsKey(entry)) {
                Object v = hashMap.get(entry);
                Object v2 = hashMap2.get(entry);
                if (v.toString().equals(v2.toString())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public void helpAssignIpAddress(int n, HostIpAddress hostIpAddress, HostIpAddress hostIpAddress2, HostIpAddress hostIpAddress3, HostIpAddress hostIpAddress4, IpHostLinkMo ipHostLinkMo, Coordinator coordinator) throws MoAccessException {
        Object object;
        if (hostIpAddress.equals((Object)IpAddress.getDefaultIpAddress())) {
            throw new ValueOutOfRangeException("defaultRouter0", "IpInterface", "defaultRouter0 can not be set to '0.0.0.0', must have a valid ip address.");
        }
        if (n < 8 || n > 30) {
            throw new ValueOutOfRangeException("networkPrefixLength", "IpInterface");
        }
        IpAddress ipAddress = hostIpAddress.getSubnetAddress(n);
        IpAddress ipAddress2 = new IpAddress(this.getSubnet(coordinator));
        if (n != this.getNetworkPrefixLength(coordinator) || !ipAddress.equals((Object)ipAddress2)) {
            object = this.getReservedBy(coordinator);
            if (((ManagedObject[])object).length != 1) {
                throw new OperationNotAllowedException("Change of subnet not allowed when reserved by several hosts", "IpInterface");
            }
            if (!object[0].equals(ipHostLinkMo)) {
                throw new OperationNotAllowedException("reservedByChange of subnet only allowed when reserved by the calling IpHostLink:" + ipHostLinkMo + ", current reserver = " + object[0], "IpInterface");
            }
        }
        if (this.getRps(coordinator) && hostIpAddress4.equals((Object)IpAddress.getDefaultIpAddress())) {
            throw new ValueOutOfRangeException("IpInterface", "ownIpAddressActive", "ownIpAddressActive must have a valid IP Address when rps is set to true.");
        }
        object = new ArrayList(4);
        ((ArrayList)object).add(hostIpAddress.toString());
        ((ArrayList)object).add(hostIpAddress2.toString());
        ((ArrayList)object).add(hostIpAddress3.toString());
        ((ArrayList)object).add(hostIpAddress4.toString());
        IpInterfaceMoImpl.checkIfIpAddressesIsUnique((ArrayList)object);
        if (!hostIpAddress4.equals((Object)IpAddress.getDefaultIpAddress()) && !hostIpAddress4.toString().equals(this.getOwnIpAddressActive(coordinator))) {
            IpInterfaceMoImpl.checkOwnIpAddressIsUnique(hostIpAddress4.toString(), coordinator);
        }
        IpAddress[] ipAddressArray = new IpAddress[]{hostIpAddress2, hostIpAddress3, hostIpAddress4};
        IpInterfaceMoImpl.validateIpAddresses(n, (IpAddress)hostIpAddress, ipAddressArray);
        Map map = this.prepareSetFroAttr(coordinator);
        map.put("networkPrefixLength", new SignedIntParameter("networkPrefixLength", n));
        map.put("defaultRouter0", new StringParameter("defaultRouter0", hostIpAddress.toString()));
        map.put("defaultRouter1", new StringParameter("defaultRouter1", hostIpAddress2.toString()));
        map.put("defaultRouter2", new StringParameter("defaultRouter2", hostIpAddress3.toString()));
        map.put("ownIpAddressActive", new StringParameter("ownIpAddressActive", hostIpAddress4.toString()));
        ManagedObject managedObject = this.getParent();
        int n2 = 0;
        if (managedObject.getType().equals("GigaBitEthernet")) {
            n2 = ((GigaBitEthernetMo)managedObject).getLinkType(coordinator);
        }
        map.put("linkType", new SignedIntParameter("linkType", n2));
        String[] stringArray = new String[]{"networkPrefixLength", "defaultRouter0", "defaultRouter1", "defaultRouter2", "ownIpAddressActive", "subnet"};
        Object[] objectArray = new Object[]{new Integer(n), hostIpAddress.toString(), hostIpAddress2.toString(), hostIpAddress3.toString(), hostIpAddress4.toString(), ipAddress.toString()};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(map.values());
        this.ipInterfaceProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
    }

    private Map prepareSetFroAttr(Coordinator coordinator) throws MoAccessException {
        Map map = this.ipInterfaceProxy.getAttributes(coordinator, this.getFroId(coordinator), null);
        return map;
    }

    public NetworkAddress getNetworkAddress(Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{"subnet", "networkPrefixLength"};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return new NetworkAddress((String)objectArray[0], ((Integer)objectArray[1]).intValue());
    }

    public String getType() {
        return "IpInterface";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (managedObject.getType().equals("IpAccessHostGpb")) {
            n = this.getNoOfReservers(IPACCESSHOSTGPB_CLASSNAME, coordinator);
        } else if (managedObject.getType().equals("IpAccessHostSpb")) {
            n = this.getNoOfReservers(IPACCESSHOSTSPB_CLASSNAME, coordinator);
        } else if (managedObject.getType().equals("IpAccessHostEt")) {
            n2 = this.getNoOfReservers(IPACCESSHOSTET_CLASSNAME, coordinator);
            if (this.getConfigurationMode(coordinator) == 1 && (n2 > 0 || this.getNoOfReservers(IPHOSTLINK_CLASSNAME, coordinator) > 0)) {
                throw new MoNotPossibleToReserveException("Only one IpHostLinkMo/IpAccessHostEt is allowed in DHCP IpInterface configuration.", "IpInterface");
            }
        } else if (managedObject.getType().equals("IpHostLink")) {
            n3 = this.getNoOfReservers(IPHOSTLINK_CLASSNAME, coordinator);
            if (this.getConfigurationMode(coordinator) == 1 && (n3 > 0 || this.getNoOfReservers(IPACCESSHOSTET_CLASSNAME, coordinator) > 0)) {
                throw new MoNotPossibleToReserveException("Only one IpHostLinkMo/IpAccessHostEt is allowed in DHCP IpInterface configuration.", "IpInterface");
            }
        }
        if (n >= 64) {
            throw new MaxNumberExceededException("Max number of " + managedObject.getType() + " reservers is exceeded", "IpInterface");
        }
        if (n2 >= 2) {
            throw new MaxNumberExceededException("Max number of " + managedObject.getType() + " reservers is exceeded", "IpInterface");
        }
        if (n3 >= 1) {
            throw new MaxNumberExceededException("Max number of " + managedObject.getType() + " reservers is exceeded", "IpInterface");
        }
        this.checkTotalNoOfHostConnected(coordinator);
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void checkTotalNoOfHostConnected(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = this.getParent().getParent();
        MoTypeFilter moTypeFilter = new MoTypeFilter("IpInterface");
        MoIterator moIterator = MoRepository.instance().select(managedObject, 2, (MoFilter)moTypeFilter);
        IpInterfaceMoImpl ipInterfaceMoImpl = null;
        int n = 0;
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                ipInterfaceMoImpl = (IpInterfaceMoImpl)moIterator.nextMo();
                if ((n += ipInterfaceMoImpl.getTotNoOfHostconnected(coordinator)) < 128) continue;
                throw new MaxNumberExceededException("The total number of host's connected to the ExchangeTerminal has exceeded 128", "IpInterface");
            }
        }
    }

    private int getTotNoOfHostconnected(Coordinator coordinator) throws MoAccessException {
        return this.getNoOfReservers(IPACCESSHOSTGPB_CLASSNAME, coordinator) + this.getNoOfReservers(IPACCESSHOSTSPB_CLASSNAME, coordinator) + this.getNoOfReservers(IPACCESSHOSTET_CLASSNAME, coordinator);
    }

    private int getNoOfReservers(String string, Coordinator coordinator) throws MoAccessException {
        return ReservableImpl.noOfReservers((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (String)string, (Coordinator)coordinator);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
    }

    private static void validateIpAddresses(int n, IpAddress ipAddress, IpAddress[] ipAddressArray) throws MoAccessException {
        IpAddress ipAddress2 = ipAddress.getSubnetAddress(n);
        IpAddress ipAddress3 = IpAddress.getDefaultIpAddress();
        for (int i = 0; i < ipAddressArray.length; ++i) {
            if (ipAddressArray[i].equals((Object)ipAddress3)) continue;
            ipAddressArray[i].validateIpAddrWithinSubnet(n, ipAddress2, "IpInterface");
        }
    }

    public void checkIfIpAddressInSubnet(IpAddress ipAddress, Coordinator coordinator) throws MoAccessException {
        NetworkAddress networkAddress = this.getNetworkAddress(coordinator);
        ipAddress.validateIpAddrWithinSubnet(networkAddress.getNetworkPrefix(), new IpAddress(networkAddress.getSubnet()), "IpInterface");
    }

    private static void checkDefRouterPingInterval(int n, int n2) throws MoAccessException {
        if (n < n2) {
            throw new ValueOutOfRangeException("defaultRouterPingInterval must be larger or equal to maxWaitForPingReply.", "IpInterface");
        }
    }

    private ArrayList getIpAddresses(Map map) throws MoAccessException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(((StringParameter)map.get("defaultRouter0")).getValue());
        arrayList.add(((StringParameter)map.get("defaultRouter1")).getValue());
        arrayList.add(((StringParameter)map.get("defaultRouter2")).getValue());
        arrayList.add(((StringParameter)map.get("ownIpAddressActive")).getValue());
        arrayList.add(((StringParameter)map.get("ownIpAddressPassive")).getValue());
        return arrayList;
    }

    private static void checkIfIpAddressesIsUnique(ArrayList arrayList) throws MoAccessException {
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(DEFAULT_IP_ADDRESS)) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (j == i || !stringArray[i].equals(stringArray[j])) continue;
                throw new ValueOutOfRangeException("Duplicate ip address " + stringArray[i], "IpInterface");
            }
        }
    }

    private static void checkMtu(int n, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (n > 1492) {
            if (managedObject.getType().equals("GigaBitEthernet")) {
                int n2 = (Integer)managedObject.getAttribute("frameFormat", coordinator);
                if (n2 == 1) {
                    throw new ValueOutOfRangeException("frameFormat in GigaBitEthernet is set to " + n2 + ". The value on " + "mtu" + " can not exceed " + 1492, "IpInterface");
                }
            } else {
                int n3 = (Integer)managedObject.getAttribute("frameFormat", coordinator);
                if (n3 == 1) {
                    throw new ValueOutOfRangeException("frameFormat in InternalEthernetPort is set to " + n3 + ". The value on " + "mtu" + " can not exceed " + 1492, "IpInterface");
                }
            }
        }
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl();
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(DICTIONARY);
            Iterator iterator = map.entrySet().iterator();
            Map.Entry entry = null;
            while (iterator.hasNext()) {
                IpAddress ipAddress;
                IpAddress ipAddress2;
                StringParameter stringParameter;
                entry = iterator.next();
                if (entry.getKey().equals("defaultRouter0")) {
                    stringParameter = (StringParameter)entry.getValue();
                    setRequestContextImpl.addAvcNotification("defaultRouter0", (Object)stringParameter.getValue());
                    ipAddress2 = new IpAddress(stringParameter.getValue());
                    ipAddress = ipAddress2.getSubnetAddress(this.getNetworkPrefixLength(setRequestContextImpl.getCoordinator()));
                    setRequestContextImpl.addAvcNotification("subnet", (Object)ipAddress.toString());
                    continue;
                }
                if (entry.getKey().equals("defaultRouter1")) {
                    stringParameter = (StringParameter)entry.getValue();
                    setRequestContextImpl.addAvcNotification("defaultRouter1", (Object)stringParameter.getValue());
                    continue;
                }
                if (entry.getKey().equals("defaultRouter2")) {
                    stringParameter = (StringParameter)entry.getValue();
                    setRequestContextImpl.addAvcNotification("defaultRouter2", (Object)stringParameter.getValue());
                    continue;
                }
                if (entry.getKey().equals("networkPrefixLength")) {
                    stringParameter = (SignedIntParameter)entry.getValue();
                    setRequestContextImpl.addAvcNotification("networkPrefixLength", (Object)new Integer(stringParameter.getValue()));
                    ipAddress2 = new IpAddress(this.getDefaultRouter0(setRequestContextImpl.getCoordinator()));
                    ipAddress = ipAddress2.getSubnetAddress(stringParameter.getValue());
                    setRequestContextImpl.addAvcNotification("subnet", (Object)ipAddress.toString());
                    continue;
                }
                if (entry.getKey().equals("ownIpAddressActive")) {
                    stringParameter = (StringParameter)entry.getValue();
                    setRequestContextImpl.addAvcNotification("ownIpAddressActive", (Object)stringParameter.getValue());
                    continue;
                }
                MessageLog.traceError(this.getClass(), (String)("Unknown attribute in parameterChanged(): " + entry.getKey()));
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)("Attribute tag not found. " + moAccessException.toString()));
        }
        setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
    }

    public void eventRaised(MaoFroGenericEventInd maoFroGenericEventInd) {
        try {
            Map map = maoFroGenericEventInd.getParameters(TagNameDictionaries.getDefault());
            StringParameter stringParameter = (StringParameter)map.get("additionalText");
            String string = stringParameter.getValue();
            if (maoFroGenericEventInd.getSpecificEvent() == 3) {
                AlarmManager.getReporter().reportEvent(6, (ManagedObject)this, "", string, null);
            } else {
                MessageLog.info(this.getClass(), (String)("Unknown specificEvent: " + maoFroGenericEventInd.getSpecificEvent() + " sent in signal MaoFroGenericEventInd"));
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)("Attribute tag  not in property file. " + moAccessException.toString()));
        }
    }

    public static void checkOwnIpAddressIsUnique(String string, Coordinator coordinator) throws MoAccessException {
        String string2;
        String string3;
        ManagedObject managedObject;
        MoRepository moRepository = MoRepository.instance();
        MoIterator moIterator = moRepository.lookupType("IpInterface");
        if (moIterator == null) {
            return;
        }
        while (moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            string3 = (String)managedObject.getAttribute("ownIpAddressActive", coordinator);
            string2 = (String)managedObject.getAttribute("defaultRouter0", coordinator);
            String string4 = (String)managedObject.getAttribute("defaultRouter1", coordinator);
            String string5 = (String)managedObject.getAttribute("defaultRouter2", coordinator);
            String string6 = (String)managedObject.getAttribute("ownIpAddressPassive", coordinator);
            if (!string.equals(string3) && !string.equals(string2) && !string.equals(string4) && !string.equals(string5) && !string.equals(string6)) continue;
            throw new AttrValueNotUniqueException("ownIpAddress should be Unique among all IpInterfaces. " + string, "IpInterface");
        }
        managedObject = moRepository.lookupType("EthernetLink");
        if (managedObject == null) {
            return;
        }
        while (managedObject.hasMoreElements()) {
            string3 = managedObject.nextMo();
            string2 = (String)string3.getAttribute("ipAddress", coordinator);
            if (string2 == null || !string2.equals(string)) continue;
            throw new AttrValueNotUniqueException("ownIpAddress should not be equal to ethernet address. " + string, "IpInterface");
        }
    }

    public static IpInterfaceMoImpl lookupInstance(int n, Coordinator coordinator) throws TransactionRequiredException {
        return (IpInterfaceMoImpl)froIds.get(n, coordinator);
    }

    private static VlanInfo analyzeVlanInfo(AttrList attrList, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, OperationNotAllowedException {
        VlanInfo vlanInfo = new VlanInfo(attrList, managedObject, null);
        vlanInfo.creationCheck(attrList, coordinator);
        IpInterfaceMoImpl.removeAttr("vid", attrList);
        IpInterfaceMoImpl.removeAttr("vLan", attrList);
        return vlanInfo;
    }

    private Map setVlanAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws WrongAttributeTypeException, MoAccessException, OperationNotAllowedException {
        VlanInfo vlanInfo = new VlanInfo(stringArray, objectArray, (ManagedObject)this);
        vlanInfo.setAttrCheck(coordinator);
        this.checkVid(this.getConfigurationMode(coordinator), vlanInfo, coordinator);
        vlanInfo.sendAVC(coordinator);
        vlanInfo.storeIntoMoData(this.data, coordinator);
        return vlanInfo.packVlanInfo(coordinator);
    }

    public ManagedObject getAccessControlListRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("accessControlListRef", coordinator);
    }

    public void setAccessControlListRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("accessControlListRef", managedObject, coordinator);
    }

    private static void removeAttr(String string, AttrList attrList) {
        int n = attrList.indexOf(string);
        if (-1 == n) {
            return;
        }
        attrList.removeElementAt(n);
    }

    public void setTrafficSchedulerRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("trafficSchedulerRef", managedObject, coordinator);
    }

    public ManagedObject getTrafficSchedulerRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("trafficSchedulerRef", coordinator);
    }

    public int getConnectedPiuFroId(Coordinator coordinator) throws MoAccessException {
        return PiuUtils.findPiuParentFroId((ManagedObject)this);
    }

    public int getFroType(Coordinator coordinator) throws MoAccessException {
        return Integer.parseInt("A02", 16);
    }

    private static StructParameter validateAndCreateStructParameter(String string, Struct struct, Coordinator coordinator) throws MoAccessException {
        String string2 = (String)struct.getValue("clientIdentifier");
        int n = (Integer)struct.getValue("clientIdentifierType");
        if (n == 10 && string2.trim().length() == 0) {
            throw new ValueOutOfRangeException("clientIdentifierType", "IpInterface", "When this attribute is set to MANUAL, clientIdentifier cannot be empty string");
        }
        StringParameter stringParameter = new StringParameter("clientIdentifier", string2);
        SignedIntParameter signedIntParameter = new SignedIntParameter("clientIdentifierType", n);
        StructParameter structParameter = new StructParameter(string);
        structParameter.add((Parameter)stringParameter);
        structParameter.add((Parameter)signedIntParameter);
        return structParameter;
    }
}

