/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import se.ericsson.cello.iptransport.IpSystemMo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class IpSystemMoImpl
extends ManagedObjectBase
implements IpSystemMo {
    private static final String IPSYSTEM_ID_VALUE = "1";
    private static IpSystemMoImpl instance = null;
    private StringAttribute userLabel;
    private MoData data;
    private static final int MO_DATA_REVISION_6 = 6000;
    private static final int MO_DATA_REVISION_LATEST = 6000;

    public static synchronized IpSystemMoImpl instance() {
        try {
            if (instance == null) {
                instance = new IpSystemMoImpl();
            }
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            MessageLog.traceError((Class)IpSystemMoImpl.class, (String)"Create instance of IpSystem MO failed", (Throwable)moNameAlreadyTakenException);
        }
        return instance;
    }

    synchronized void registerData() {
        if (this.data == null) {
            try {
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                Coordinator coordinator = control.getCoordinator();
                MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + coordinator.getTransactionID() + ", timeout = 3600 sec"));
                this.data = new MoData(this.getLocalDistinguishedName(), "IpSystem", true, coordinator);
                this.userLabel = new StringAttribute("userLabel", true, "");
                this.data.registerPersistentAttr((Attribute)this.userLabel);
                this.data.setRevision(6000);
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                control.getTerminator().commit();
            }
            catch (TransactionRequiredException transactionRequiredException) {
                MessageLog.traceError(this.getClass(), (String)"start of IpSystem failed", (Throwable)transactionRequiredException);
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                MessageLog.traceError(this.getClass(), (String)"start of IpSystem failed", (Throwable)transactionRolledBackException);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.traceError(this.getClass(), (String)"start of IpSystem failed", (Throwable)inactiveTransactionException);
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError(this.getClass(), (String)"start of IpSystem failed", (Throwable)moAccessException);
            }
        }
    }

    void recover(MoData moData) {
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(6000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public String getType() {
        return "IpSystem";
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"IpSystem", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    private IpSystemMoImpl() throws MoNameAlreadyTakenException {
        super(((SingletonMoFactory)MoFactoryMgr.instance().lookup("ManagedElement")).getMo(), "IpSystem", IPSYSTEM_ID_VALUE, null);
    }
}

