/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.internaltransport;

import se.ericsson.cello.equipment.SwitchModuleBuildIF;
import se.ericsson.cello.internaltransport.SwitchModuleMo;
import se.ericsson.cello.internaltransport.fropxy.SpasSwitchModuleFroCreateFroRsp;
import se.ericsson.cello.internaltransport.fropxy.SpasSwitchModuleFroDeleteFroRsp;
import se.ericsson.cello.internaltransport.fropxy.SpasSwitchModuleFroGetAttrRsp;
import se.ericsson.cello.internaltransport.fropxy.SpasSwitchModuleFroProxy;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class SwitchModuleMoImpl
extends CelloMao
implements SwitchModuleMo,
SwitchModuleBuildIF,
Reservable {
    private MoData data;
    private SequenceAttribute reservedBy;
    private IntegerAttribute switchModuleFroId;
    private StringAttribute userLabel;
    private static SpasSwitchModuleFroProxy switchModuleFroProxy = SpasSwitchModuleFroProxy.instance();
    private static final int MAX_NO_OF_SWITCH_MODULE = 32;
    private static final int MAX_SWITCH_MODULE_NUMBER = 255;
    private static final String USER_LABEL_DEFAULT = "";
    private static final String SWITCH_MODULE_FRO_ID = "switchModuleFroId";
    private static final int MO_DATA_REVISION_3_3 = 3001;
    private static final int MO_DATA_REVISION_LATEST = 3001;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        SwitchModuleMoImpl.checkTransaction(coordinator);
        SwitchModuleMoImpl.checkParent(managedObject);
        MoAttributeValidator.checkIdentity((String)"SwitchModule", (String)string);
        MoIterator moIterator = MoRepository.instance().lookupType("SwitchModule");
        if (moIterator != null && moIterator.size() >= 32) {
            throw new MaxNumberExceededException("Max number of SwitchModule's is exceeded", "SwitchModule");
        }
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"switchModuleNumber", (AttrList)attrList, (boolean)true, (int)0, (int)0, (int)255, (String)"SwitchModule");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)USER_LABEL_DEFAULT, (String)"SwitchModule", (int)128, (int)0);
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)1, (int)0, (int)2, (String)"SwitchModule");
        if (n2 == 2) {
            n2 = 0;
        }
        int n3 = SwitchModuleMoImpl.checkAndGetAdmStatePlaneA(attrList);
        int n4 = SwitchModuleMoImpl.checkAndGetAdmStatePlaneB(attrList, n3);
        SwitchModuleMoImpl.checkOtherAttributes(attrList);
        SwitchModuleMoImpl switchModuleMoImpl = new SwitchModuleMoImpl(managedObject, string2, n, n2, n3, n4, string, coordinator);
        return switchModuleMoImpl;
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
        if (managedObjectArray.length != 0) {
            MoReservedNotDeletableException moReservedNotDeletableException = new MoReservedNotDeletableException("SwitchModule");
            throw moReservedNotDeletableException;
        }
        this.deleteSwitchModuleFro(coordinator);
        switchModuleFroProxy.deregisterForNotifications(coordinator, this.switchModuleFroId.getValue(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    private SwitchModuleMoImpl(ManagedObject managedObject, String string, int n, int n2, int n3, int n4, String string2, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "SwitchModule", string2, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        int n5 = this.createSwitchModuleFro(coordinator, n, n2, n3, n4);
        this.switchModuleFroId = new IntegerAttribute(SWITCH_MODULE_FRO_ID, false, n5);
        this.data.registerPersistentAttr((Attribute)this.switchModuleFroId);
        this.reservedBy = new SequenceAttribute("reservedBy", false);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        switchModuleFroProxy.registerForNotifications(coordinator, this, this.switchModuleFroId.getValue(coordinator));
        this.data.setRevision(3001);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"SwitchModule", (MoData)this.data, (SequenceAttribute)this.reservedBy);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"SwitchModule", (MoData)this.data, (SequenceAttribute)this.reservedBy);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Attribute[] attributeArray = this.reservedBy.getValue(coordinator);
        ManagedObject[] managedObjectArray = new ManagedObject[attributeArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            managedObjectArray[i] = ((ReferenceAttribute)attributeArray[i]).getValue(coordinator);
        }
        return managedObjectArray;
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"SwitchModule", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getSwitchModuleNumber(Coordinator coordinator) throws MoAccessException {
        SpasSwitchModuleFroGetAttrRsp spasSwitchModuleFroGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return spasSwitchModuleFroGetAttrRsp.getSwitchModuleNumber();
    }

    public int getSecondSmnEvaluation(Coordinator coordinator) throws MoAccessException {
        SpasSwitchModuleFroGetAttrRsp spasSwitchModuleFroGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return spasSwitchModuleFroGetAttrRsp.getSecondSmnEvaluation();
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        SpasSwitchModuleFroGetAttrRsp spasSwitchModuleFroGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return spasSwitchModuleFroGetAttrRsp.getAdmStateSwitchModule();
    }

    public int getAdministrativeStateSwitchPlaneA(Coordinator coordinator) throws MoAccessException {
        SpasSwitchModuleFroGetAttrRsp spasSwitchModuleFroGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return spasSwitchModuleFroGetAttrRsp.getAdmStateSwitchPlaneA();
    }

    public int getAdministrativeStateSwitchPlaneB(Coordinator coordinator) throws MoAccessException {
        SpasSwitchModuleFroGetAttrRsp spasSwitchModuleFroGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return spasSwitchModuleFroGetAttrRsp.getAdmStateSwitchPlaneB();
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        SpasSwitchModuleFroGetAttrRsp spasSwitchModuleFroGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return spasSwitchModuleFroGetAttrRsp.getOpStateSwitchModule();
    }

    public int getOperationalStateSwitchPlaneA(Coordinator coordinator) throws MoAccessException {
        SpasSwitchModuleFroGetAttrRsp spasSwitchModuleFroGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return spasSwitchModuleFroGetAttrRsp.getOpStateSwitchPlaneA();
    }

    public int getOperationalStateSwitchPlaneB(Coordinator coordinator) throws MoAccessException {
        SpasSwitchModuleFroGetAttrRsp spasSwitchModuleFroGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return spasSwitchModuleFroGetAttrRsp.getOpStateSwitchPlaneB();
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        SpasSwitchModuleFroGetAttrRsp spasSwitchModuleFroGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return AvailConverter.convert((int)spasSwitchModuleFroGetAttrRsp.getAvailStatSwitchModule());
    }

    public int getAvailabilityStatusSwitchPlaneA(Coordinator coordinator) throws MoAccessException {
        SpasSwitchModuleFroGetAttrRsp spasSwitchModuleFroGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return AvailConverter.convert((int)spasSwitchModuleFroGetAttrRsp.getAvailStatSwitchPlaneA());
    }

    public int getAvailabilityStatusSwitchPlaneB(Coordinator coordinator) throws MoAccessException {
        SpasSwitchModuleFroGetAttrRsp spasSwitchModuleFroGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return AvailConverter.convert((int)spasSwitchModuleFroGetAttrRsp.getAvailStatSwitchPlaneB());
    }

    public int getActiveSwitchPlane(Coordinator coordinator) throws MoAccessException {
        SpasSwitchModuleFroGetAttrRsp spasSwitchModuleFroGetAttrRsp = this.retrieveFroAttributes(coordinator);
        return spasSwitchModuleFroGetAttrRsp.getActiveSwitchPlane();
    }

    private void setAdmStateAll(int n, int n2, int n3, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        switchModuleFroProxy.sendSetAdmStateReq(coordinator.getTransactionID(), this.switchModuleFroId.getValue(coordinator), n, n2, n3);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        if (n != 0 && n != 1 && n != 2) {
            throw new ValueOutOfRangeException("SwitchModule", "administrativeState");
        }
        if (n == 2) {
            n = 0;
        }
        int n2 = this.getAdministrativeStateSwitchPlaneA(coordinator);
        int n3 = this.getAdministrativeStateSwitchPlaneB(coordinator);
        this.setAdmStateAll(n, n2, n3, coordinator);
        String[] stringArray = new String[]{"administrativeState"};
        Object[] objectArray = new Object[]{new Integer(n)};
        SwitchModuleMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public void setAdministrativeStateSwitchPlaneA(int n, Coordinator coordinator) throws MoAccessException {
        if (n != 0 && n != 1 && n != 2) {
            throw new ValueOutOfRangeException("SwitchModule", "administrativeStateSwitchPlaneA");
        }
        if (n == 2) {
            n = 0;
        }
        int n2 = this.getAdministrativeState(coordinator);
        int n3 = this.getAdministrativeStateSwitchPlaneB(coordinator);
        this.setAdmStateAll(n2, n, n3, coordinator);
        String[] stringArray = new String[]{"administrativeStateSwitchPlaneA"};
        Object[] objectArray = new Object[]{new Integer(n)};
        SwitchModuleMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public void setAdministrativeStateSwitchPlaneB(int n, Coordinator coordinator) throws MoAccessException {
        if (n != 0 && n != 1 && n != 2) {
            throw new ValueOutOfRangeException("SwitchModule", "administrativeStateSwitchPlaneA");
        }
        if (n == 2) {
            n = 0;
        }
        int n2 = this.getAdministrativeState(coordinator);
        int n3 = this.getAdministrativeStateSwitchPlaneA(coordinator);
        this.setAdmStateAll(n2, n3, n, coordinator);
        String[] stringArray = new String[]{"administrativeStateSwitchPlaneB"};
        Object[] objectArray = new Object[]{new Integer(n)};
        SwitchModuleMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public int getSwitchModuleFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.switchModuleFroId.getValue(coordinator);
    }

    public String getType() {
        return "SwitchModule";
    }

    public SwitchModuleMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3001);
        moDataRecoveryHelper.assertAttribute("userLabel");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(SWITCH_MODULE_FRO_ID);
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.switchModuleFroId = (IntegerAttribute)moData.getAttribute(SWITCH_MODULE_FRO_ID);
        this.reservedBy = (SequenceAttribute)moData.getAttribute("reservedBy");
        switchModuleFroProxy.registerForNotifications(null, this, this.switchModuleFroId.getValue(null));
    }

    private int createSwitchModuleFro(Coordinator coordinator, int n, int n2, int n3, int n4) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SpasSwitchModuleFroCreateFroRsp spasSwitchModuleFroCreateFroRsp = switchModuleFroProxy.sendCreateFroReq(coordinator.getTransactionID(), n, n2, n3, n4);
        if (spasSwitchModuleFroCreateFroRsp == null) {
            FroNotAccessibleException froNotAccessibleException = new FroNotAccessibleException("SwitchModule", "SRI_SERVICE");
            throw froNotAccessibleException;
        }
        int n5 = spasSwitchModuleFroCreateFroRsp.getResult();
        if (n5 != 1) {
            FroRequestFailedException froRequestFailedException = new FroRequestFailedException("SwitchModule", "SRI_SERVICE", "CreateFroReq: " + switchModuleFroProxy.getResultMsg(spasSwitchModuleFroCreateFroRsp.getResult()), spasSwitchModuleFroCreateFroRsp.getResult());
            throw froRequestFailedException;
        }
        return spasSwitchModuleFroCreateFroRsp.getFroId();
    }

    private void deleteSwitchModuleFro(Coordinator coordinator) throws MoAccessException {
        SpasSwitchModuleFroDeleteFroRsp spasSwitchModuleFroDeleteFroRsp = switchModuleFroProxy.sendDeleteFroReq(coordinator.getTransactionID(), this.switchModuleFroId.getValue(coordinator));
        if (spasSwitchModuleFroDeleteFroRsp == null) {
            throw new FroNotAccessibleException("SwitchModule", "SRI_SERVICE");
        }
        int n = spasSwitchModuleFroDeleteFroRsp.getResult();
        if (n != 1) {
            throw new FroRequestFailedException("SwitchModule", "SRI_SERVICE", "DeleteFroReq: " + switchModuleFroProxy.getResultMsg(spasSwitchModuleFroDeleteFroRsp.getResult()), spasSwitchModuleFroDeleteFroRsp.getResult());
        }
    }

    private SpasSwitchModuleFroGetAttrRsp retrieveFroAttributes(Coordinator coordinator) throws MoAccessException {
        int n = coordinator == null ? 0 : coordinator.getTransactionID();
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SpasSwitchModuleFroGetAttrRsp spasSwitchModuleFroGetAttrRsp = switchModuleFroProxy.sendGetAttrReq(n, this.switchModuleFroId.getValue(coordinator));
        if (spasSwitchModuleFroGetAttrRsp == null) {
            FroNotAccessibleException froNotAccessibleException = new FroNotAccessibleException("SwitchModule", "SRI_SERVICE");
            throw froNotAccessibleException;
        }
        int n2 = spasSwitchModuleFroGetAttrRsp.getResult();
        if (n2 != 1) {
            throw new FroRequestFailedException("SwitchModule", "SRI_SERVICE", "GetAttrReq: " + switchModuleFroProxy.getResultMsg(spasSwitchModuleFroGetAttrRsp.getResult()), spasSwitchModuleFroGetAttrRsp.getResult());
        }
        return spasSwitchModuleFroGetAttrRsp;
    }

    private static void checkTransaction(Coordinator coordinator) throws TransactionRequiredException {
        if (coordinator == null) {
            throw new TransactionRequiredException();
        }
    }

    private static void checkParent(ManagedObject managedObject) throws IllegalParentException {
        if (!managedObject.getType().equals("SwitchFabric")) {
            throw new IllegalParentException("SwitchModule");
        }
    }

    private static void checkOtherAttributes(AttrList attrList) throws NoSuchAttributeException {
        int n = attrList.size();
        if (n != 0) {
            throw new NoSuchAttributeException(attrList.getName(0), "SwitchModule");
        }
    }

    private static int checkAndGetAdmStatePlaneA(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("administrativeStateSwitchPlaneA");
        if (n == -1) {
            return 1;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("administrativeStateSwitchPlaneA", "SwitchModule");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new ValueOutOfRangeException("SwitchModule", "administrativeStateSwitchPlaneA");
        }
        if (n2 == 2) {
            n2 = 0;
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static int checkAndGetAdmStatePlaneB(AttrList attrList, int n) throws MoAccessException {
        int n2 = attrList.indexOf("administrativeStateSwitchPlaneB");
        if (n2 == -1) {
            return 1;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("administrativeStateSwitchPlaneB", "SwitchModule");
        }
        int n3 = (Integer)attrList.getValue(n2);
        if (n3 != 0 && n3 != 1 && n3 != 2) {
            throw new ValueOutOfRangeException("SwitchModule", "administrativeStateSwitchPlaneB");
        }
        if (n == 0 && n3 == 0) {
            throw new ValueOutOfRangeException("SwitchModule", "administrativeStateSwitchPlaneB");
        }
        if (n3 == 2) {
            n3 = 0;
        }
        attrList.removeElementAt(n2);
        return n3;
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        NotificationSender notificationSender = NotificationSender.instance();
        notificationSender.pushAVC(managedObject, stringArray, objectArray, coordinator);
    }
}

