/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configirpimpl;

import BasicConfig.MORef;
import BasicConfig.MOidpair;
import BasicConfig.MOidpairKind;
import BasicConfig.Session;
import CosNaming.NameComponent;
import se.ericsson.cello.configirpimpl.ConfigExtendedImpl;
import se.ericsson.cello.configirpimpl.EasyNaming;
import se.ericsson.cello.configirpimpl.MoTxCollector;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.Mib;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.transaction.Coordinator;

public class MoRefMgr {
    private static Mib theMib = null;

    private MoRefMgr() {
    }

    public static MORef createMoRef(ManagedObject managedObject) {
        if (managedObject == null) {
            return new MORef(0L, null, "");
        }
        return new MORef(managedObject.getId().intValue(), ConfigExtendedImpl.instance().getBasicConfigRef(), managedObject.getType());
    }

    public static void storeMoCoordinator(String string, Coordinator coordinator) {
        MoTxCollector.storeMOAndCoordinator(string, coordinator);
    }

    public static boolean isRefNull(MOidpair mOidpair) {
        MOidpairKind mOidpairKind = mOidpair.discriminator();
        if (mOidpairKind == null) {
            return true;
        }
        if (mOidpairKind == MOidpairKind.RefType) {
            return MoRefMgr.isRefNull(mOidpair.ref());
        }
        if (mOidpairKind == MOidpairKind.DNType) {
            return mOidpair.name().length == 0;
        }
        Assert.cppAssert((boolean)false, (String)("discr = " + mOidpairKind));
        return false;
    }

    public static boolean isRefNull(MORef mORef) {
        return mORef.oid == 0L;
    }

    public static MOidpair createMoIdPair(ManagedObject managedObject) {
        MOidpair mOidpair = new MOidpair();
        if (managedObject != null) {
            mOidpair.name(EasyNaming.str2name(managedObject.getFullDistinguishedName()));
        } else {
            mOidpair.name(EasyNaming.str2name(""));
        }
        return mOidpair;
    }

    private static Mib getMib() {
        if (theMib == null) {
            theMib = MibMgr.instance().getMib();
            Assert.cppAssert((Object)theMib, (String)"Mib not found");
        }
        return theMib;
    }

    public static ManagedObject lookup(NameComponent[] nameComponentArray) throws MoNotFoundException {
        String string = EasyNaming.name2str(nameComponentArray);
        return MoRefMgr.lookup(string);
    }

    public static ManagedObject lookup(String string) throws MoNotFoundException {
        String string2 = MoRefMgr.getMib().getMibPrefix();
        String string3 = string.startsWith(string2) && !string2.equals("") ? string.substring(string2.length() + 1) : string;
        ManagedObject managedObject = MoRepository.instance().lookup(string3);
        if (managedObject == null || managedObject.isRemoved()) {
            throw new MoNotFoundException(string);
        }
        return managedObject;
    }

    public static ManagedObject lookup(MOidpair mOidpair, Coordinator coordinator, Session session) throws MoNotFoundException {
        MOidpairKind mOidpairKind = mOidpair.discriminator();
        ManagedObject managedObject = MoRefMgr.lookup(mOidpair);
        if (MoRefMgr.isRefNull(mOidpair)) {
            return null;
        }
        if (!(managedObject.isCreated() || session != null && MoTxCollector.checkMoInTransaction(managedObject, coordinator))) {
            throw new MoNotFoundException(((Object)managedObject).toString(), "MO is created but not yet commited in another transaction.");
        }
        return MoRefMgr.lookupType(mOidpair, mOidpairKind);
    }

    public static ManagedObject lookup(MOidpair mOidpair) throws MoNotFoundException {
        MOidpairKind mOidpairKind = mOidpair.discriminator();
        if (MoRefMgr.isRefNull(mOidpair)) {
            return null;
        }
        return MoRefMgr.lookupType(mOidpair, mOidpairKind);
    }

    public static ManagedObject lookup(MORef mORef) throws MoNotFoundException {
        if (MoRefMgr.isRefNull(mORef)) {
            return null;
        }
        ManagedObject managedObject = MoRepository.instance().lookup((int)mORef.oid);
        if (managedObject == null) {
            throw new MoNotFoundException("MORef: id =  " + mORef.oid + " type = " + mORef.type);
        }
        if (managedObject.isRemoved()) {
            throw new MoNotFoundException("MORef: id =  " + mORef.oid + " type = " + mORef.type + " is removed.");
        }
        return managedObject;
    }

    public static ManagedObject lookup(MORef mORef, Coordinator coordinator, Session session) throws MoNotFoundException {
        if (MoRefMgr.isRefNull(mORef)) {
            return null;
        }
        ManagedObject managedObject = MoRepository.instance().lookup((int)mORef.oid);
        if (managedObject == null) {
            throw new MoNotFoundException("MORef: id =  " + mORef.oid + " type = " + mORef.type);
        }
        if (managedObject.isRemoved()) {
            throw new MoNotFoundException("MORef: id =  " + mORef.oid + " type = " + mORef.type + " is removed.");
        }
        if (!(managedObject.isCreated() || session != null && MoTxCollector.checkMoInTransaction(managedObject, coordinator))) {
            throw new MoNotFoundException(((Object)managedObject).toString(), "MO is created but not yet commited in another transaction.");
        }
        return managedObject;
    }

    private static ManagedObject lookupType(MOidpair mOidpair, MOidpairKind mOidpairKind) throws MoNotFoundException {
        if (mOidpairKind == MOidpairKind.RefType) {
            return MoRefMgr.lookup(mOidpair.ref());
        }
        if (mOidpairKind == MOidpairKind.DNType) {
            return MoRefMgr.lookup(mOidpair.name());
        }
        throw new MoNotFoundException("null");
    }

    static String moidpairToString(MOidpair mOidpair) {
        if (MoRefMgr.isRefNull(mOidpair)) {
            return "null";
        }
        MOidpairKind mOidpairKind = mOidpair.discriminator();
        if (mOidpairKind == MOidpairKind.RefType) {
            return "MORef: id =  " + mOidpair.ref().oid + " type = " + mOidpair.ref().type;
        }
        return EasyNaming.name2str(mOidpair.name());
    }
}

