/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.csfilter;

import BasicConfig.NotAccepted;
import BasicConfig.NotDefined;
import se.ericsson.cello.csfilter.Compare;
import se.ericsson.cello.moframework.FilterSyntaxException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;

public class FilterPredicate {
    private static final int NULL_PREDICATE = 0;
    public static final int AND = 1;
    public static final int OR = 2;
    public static final int NOT = 3;
    public static final int EQUAL = 4;
    public static final int NOT_EQUAL = 5;
    public static final int LESS_THAN = 6;
    public static final int LESS_THAN_OR_EQUAL = 7;
    public static final int GREATER_THAN = 8;
    public static final int GREATER_THAN_OR_EQUAL = 9;
    private static final int BOOLEAN = 1;
    private static final int NUMBER = 2;
    private static final int STRING = 3;
    private int operator = 0;
    private FilterPredicate left = null;
    private FilterPredicate right = null;
    private String attributeName = null;
    private int attributeType = 0;
    private String stringValue = null;
    private Double numberValue = null;
    private Boolean booleanValue = null;
    Compare Comparator = new Compare();

    public FilterPredicate() {
        this.operator = 0;
    }

    public FilterPredicate(FilterPredicate filterPredicate, int n, FilterPredicate filterPredicate2) {
        this.left = filterPredicate;
        this.operator = n;
        this.right = filterPredicate2;
    }

    public FilterPredicate(String string, int n, Object object) {
        this.attributeName = string;
        this.operator = n;
        if (object instanceof String) {
            if (object.toString().equalsIgnoreCase("false") || object.toString().equalsIgnoreCase("true")) {
                this.attributeType = 1;
                this.booleanValue = Boolean.valueOf(object.toString());
            } else {
                this.attributeType = 3;
                this.stringValue = (String)object;
            }
        } else if (object instanceof Boolean) {
            this.attributeType = 1;
            this.booleanValue = (Boolean)object;
        } else if (object instanceof Double) {
            this.attributeType = 2;
            this.numberValue = (Double)object;
        }
    }

    public boolean match(String string, ManagedObject managedObject, Coordinator coordinator) throws NotAccepted, NotDefined, FilterSyntaxException {
        if (string != null && !string.trim().equals("") && !string.equalsIgnoreCase(managedObject.getType())) {
            return false;
        }
        switch (this.operator) {
            case 0: {
                return true;
            }
            case 1: {
                return this.left.match(string, managedObject, coordinator) && this.right.match(string, managedObject, coordinator);
            }
            case 2: {
                return this.left.match(string, managedObject, coordinator) || this.right.match(string, managedObject, coordinator);
            }
            case 3: {
                return !this.left.match(string, managedObject, coordinator);
            }
        }
        int[] nArray = null;
        try {
            switch (this.attributeType) {
                case 3: {
                    nArray = this.Comparator.compareTo(managedObject.getAttribute(this.attributeName, coordinator), (Object)this.stringValue);
                    break;
                }
                case 1: {
                    nArray = this.Comparator.compareTo(managedObject.getAttribute(this.attributeName, coordinator), (Object)this.booleanValue);
                    break;
                }
                case 2: {
                    nArray = this.Comparator.compareTo(managedObject.getAttribute(this.attributeName, coordinator), (Object)this.numberValue);
                }
            }
        }
        catch (NoSuchAttributeException noSuchAttributeException) {
            return false;
        }
        catch (MoAccessException moAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FilterSyntaxException(illegalArgumentException.toString());
        }
        if (nArray.length == 0) {
            return false;
        }
        switch (this.operator) {
            case 4: {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != 0) continue;
                    return true;
                }
                break;
            }
            case 5: {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 0) continue;
                    return true;
                }
                break;
            }
            case 6: {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] >= 0) continue;
                    return true;
                }
                break;
            }
            case 7: {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] > 0) continue;
                    return true;
                }
                break;
            }
            case 8: {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] <= 0) continue;
                    return true;
                }
                break;
            }
            case 9: {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] < 0) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }
}

