/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.csnotification;

import java.util.Iterator;
import se.ericsson.cello.moframework.csnotifications.CSMosiSubscriber;
import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriberMgr;
import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriberMgrFactory;
import se.ericsson.cello.moframework.csnotifications.NotificationElement;
import se.ericsson.cello.moframework.csnotifications.TopologyAndAVCSubscription;
import se.ericsson.cello.support.debug.MessageLog;

public class MosiNotificationReporter {
    static MosiNotificationReporter theOneAndOnly;
    static /* synthetic */ Class class$se$ericsson$cello$csnotification$MosiNotificationReporter;

    public static MosiNotificationReporter instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new MosiNotificationReporter();
        }
        return theOneAndOnly;
    }

    private MosiNotificationReporter() {
    }

    public synchronized void mibPrefixValueChanged(String string) {
        NotificationWorker notificationWorker = new NotificationWorker(1);
        notificationWorker.setMibPrefix(string);
        new Thread(notificationWorker).start();
    }

    public synchronized void orbRestartInitiated() {
        NotificationWorker notificationWorker = new NotificationWorker(2);
        new Thread(notificationWorker).start();
    }

    public synchronized void avcTopologyChange(NotificationElement notificationElement) {
        CSNotificationSubscriberMgr cSNotificationSubscriberMgr = CSNotificationSubscriberMgrFactory.createCSNotificationSubscriberMgr();
        Iterator iterator = cSNotificationSubscriberMgr.getTopologyAndAVCChangeSubscribers().iterator();
        while (iterator.hasNext()) {
            TopologyAndAVCSubscription topologyAndAVCSubscription = (TopologyAndAVCSubscription)iterator.next();
            topologyAndAVCSubscription.avcTopologyChange(notificationElement);
        }
    }

    private class NotificationWorker
    implements Runnable {
        private int notificationType = 0;
        private String mibPrefix = "";
        public static final int MIBPREFIX = 1;
        public static final int ORBRESTART = 2;

        protected NotificationWorker(int n) {
            this.notificationType = n;
        }

        public void run() {
            switch (this.notificationType) {
                case 1: {
                    this.sendMOSIMibprefixNotifications();
                    break;
                }
                case 2: {
                    this.sendOrbRestartNotifications();
                    break;
                }
            }
        }

        private void sendMOSIMibprefixNotifications() {
            CSNotificationSubscriberMgr cSNotificationSubscriberMgr = CSNotificationSubscriberMgrFactory.createCSNotificationSubscriberMgr();
            if (cSNotificationSubscriberMgr.getMibPrefixSubscribers().size() > 0) {
                Iterator iterator = cSNotificationSubscriberMgr.getMibPrefixSubscribers().iterator();
                while (iterator.hasNext()) {
                    CSMosiSubscriber cSMosiSubscriber = (CSMosiSubscriber)iterator.next();
                    cSMosiSubscriber.mibPrefixValueChanged(this.mibPrefix);
                }
            } else {
                MessageLog.info((Class)(class$se$ericsson$cello$csnotification$MosiNotificationReporter == null ? (class$se$ericsson$cello$csnotification$MosiNotificationReporter = MosiNotificationReporter.class$("se.ericsson.cello.csnotification.MosiNotificationReporter")) : class$se$ericsson$cello$csnotification$MosiNotificationReporter), (String)"mibPrefixValueChanged: no subscriber, notification will not be sent.");
            }
        }

        private void sendOrbRestartNotifications() {
            CSNotificationSubscriberMgr cSNotificationSubscriberMgr = CSNotificationSubscriberMgrFactory.createCSNotificationSubscriberMgr();
            if (cSNotificationSubscriberMgr.getOrbRestartSubscribers().size() > 0) {
                Iterator iterator = cSNotificationSubscriberMgr.getOrbRestartSubscribers().iterator();
                while (iterator.hasNext()) {
                    CSMosiSubscriber cSMosiSubscriber = (CSMosiSubscriber)iterator.next();
                    cSMosiSubscriber.orbRestartInitiated();
                }
            } else {
                MessageLog.info((Class)(class$se$ericsson$cello$csnotification$MosiNotificationReporter == null ? (class$se$ericsson$cello$csnotification$MosiNotificationReporter = MosiNotificationReporter.class$("se.ericsson.cello.csnotification.MosiNotificationReporter")) : class$se$ericsson$cello$csnotification$MosiNotificationReporter), (String)"orbRestartNotification: no subscriber, notification will not be sent.");
            }
        }

        public void setMibPrefix(String string) {
            this.mibPrefix = string;
        }
    }
}

