/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework;

import java.io.Serializable;
import se.ericsson.cello.moframework.StringRepository;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public abstract class Attribute
implements Serializable {
    static final long serialVersionUID = 1L;
    private String myName;
    protected int myNotificationType;

    protected Attribute(String string, boolean bl) {
        this.myName = StringRepository.instance().assignString(string);
        this.myNotificationType = bl ? 1 : 0;
    }

    protected Attribute(String string, char c) {
        this.myName = string.equals("null") ? null : StringRepository.instance().assignString(string);
        this.myNotificationType = c == 'T' ? 1 : 0;
    }

    public final String getName() {
        return this.myName;
    }

    public int getNotificationType() {
        return this.myNotificationType;
    }

    public void setNotificationType(int n) {
        if (this.myNotificationType == 0) {
            return;
        }
        switch (n) {
            case 1: {
                this.myNotificationType = n;
                break;
            }
            default: {
                MessageLog.trace((int)5, this.getClass(), (String)("This notification type is not supported: " + n));
            }
        }
    }

    public boolean isAVCNotifier() {
        return this.myNotificationType != 0;
    }

    abstract void startTransaction();

    abstract void rollback();

    abstract void commit();

    abstract String buildString();

    abstract String buildValueString();

    abstract Object getValueAsObject(Coordinator var1);

    Object getBackUpValueAsObject(Coordinator coordinator) {
        return null;
    }

    boolean equal(Attribute attribute, Coordinator coordinator) {
        boolean bl = false;
        if (this.buildString().equalsIgnoreCase(attribute.buildString())) {
            bl = true;
        }
        return bl;
    }

    abstract boolean isModified();

    public static class NotificationType {
        public static final int NONE = 0;
        public static final int ATTRIBUTE_VALUE_CHANGED = 1;
        public static final int SEQENCE_DELTA_NOTIFICATION = 3;
    }
}

