/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework;

import java.io.Serializable;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.recovery.AttributeLookUp;
import se.ericsson.cello.recovery.AttributeLookupFactory;
import se.ericsson.cello.transaction.Coordinator;

public class BooleanAttribute
extends Attribute
implements Serializable {
    static final long serialVersionUID = 2571041969554567398L;
    private transient boolean myBackup;
    private boolean myValue;
    private transient boolean myIsTransactionActive = false;

    public BooleanAttribute(String string, boolean bl, boolean bl2) {
        super(string, bl);
        this.myValue = bl2;
    }

    public BooleanAttribute(String string, String string2) {
        super(string, string2.charAt(1));
        this.myValue = Boolean.valueOf(string2.substring(2));
    }

    public synchronized boolean getValue(Coordinator coordinator) {
        if (coordinator == null) {
            if (this.myIsTransactionActive) {
                return this.myBackup;
            }
            return this.myValue;
        }
        return this.myValue;
    }

    public synchronized void setValue(boolean bl) {
        this.myValue = bl;
    }

    public synchronized void setValue(Boolean bl) {
        this.myValue = bl;
    }

    synchronized void rollback() {
        this.myValue = this.myBackup;
        this.myIsTransactionActive = false;
    }

    synchronized void commit() {
        this.myIsTransactionActive = false;
    }

    synchronized void startTransaction() {
        this.myBackup = this.myValue;
        this.myIsTransactionActive = true;
    }

    Object getValueAsObject(Coordinator coordinator) {
        return this.getValue(coordinator);
    }

    Object getBackUpValueAsObject(Coordinator coordinator) {
        return this.myBackup;
    }

    boolean isModified() {
        return this.myValue != this.myBackup;
    }

    public String buildString() {
        AttributeLookUp attributeLookUp = AttributeLookupFactory.instance();
        String string = this.getName();
        if (!string.equalsIgnoreCase("")) {
            string = "" + attributeLookUp.lookup(string);
        }
        return string + this.buildValueString();
    }

    public String buildValueString() {
        String string = "";
        string = this.getNotificationType() != 0 ? "T" : "F";
        return "^b" + string + this.myValue;
    }
}

