/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework;

import java.io.Serializable;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Vector;
import se.ericsson.cello.configirpimpl.MoRefMgr;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FloatAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoPermissionException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.SequenceDiffInfo;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.StringRepository;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.stringhandlers.MoDataStringHandler;
import se.ericsson.cello.mopersistence.MoCompressedLDNStorage;
import se.ericsson.cello.persistence.DbAccessException;
import se.ericsson.cello.recovery.AttributeLookUp;
import se.ericsson.cello.recovery.AttributeLookupFactory;
import se.ericsson.cello.recovery.MoTypeLookup;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.transaction.Status;
import se.ericsson.cello.vls.VLS;
import se.ericsson.cello.vls.VLSException;

public class MoData
implements Serializable {
    public static final AccessType READ_ACCESS = new AccessType();
    public static final AccessType WRITE_ACCESS = new AccessType();
    private Vector persistentAttributes = null;
    private transient Vector transientAttributes = null;
    private String moType;
    private String moName;
    private transient Coordinator currentTransaction = null;
    private String currentThread = "";
    private boolean isPersistent;
    private transient boolean isModified = false;
    private int revision;
    private int primaryKey;
    private static int clLastPrimaryKey = 0;
    private static int[] clPrimaryKeyLock = new int[0];
    static final long serialVersionUID = 1L;
    private static final String REP_ID = "IDL:ConfigExtended/ConfigurationExtended:1.0";
    private static final String METHOD = "basic_set_MO";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoData(String string, String string2, boolean bl, Coordinator coordinator) throws TransactionRequiredException {
        this.isPersistent = bl;
        this.moType = string2;
        this.moName = string;
        Object object = clPrimaryKeyLock;
        synchronized (clPrimaryKeyLock) {
            this.primaryKey = ++clLastPrimaryKey;
            // ** MonitorExit[var5_5 /* !! */ ] (shouldn't be in output)
            if (bl) {
                this.persistentAttributes = new Vector();
                if (coordinator == null || coordinator.getStatus() != Status.ACTIVE) {
                    throw new TransactionRequiredException();
                }
                try {
                    object = (Object)MoCompressedLDNStorage.instance();
                    object.createRow(coordinator.getTransactionID(), this.primaryKey);
                }
                catch (DbAccessException dbAccessException) {
                    Assert.cppAssert((boolean)false, (String)("MoData() could not get database :" + (Object)((Object)dbAccessException)));
                }
            }
            if (coordinator != null) {
                MoRefMgr.storeMoCoordinator(string, coordinator);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoData(String string) {
        try {
            Object object;
            MoTypeLookup moTypeLookup = MoTypeLookup.instance();
            AttributeLookUp attributeLookUp = AttributeLookupFactory.instance();
            StringRepository.instance();
            MoDataStringHandler moDataStringHandler = new MoDataStringHandler(string);
            this.moType = moTypeLookup.lookup(Integer.parseInt(moDataStringHandler.nextSubstring()));
            this.revision = Integer.parseInt(moDataStringHandler.nextSubstring());
            this.moName = moTypeLookup.convertToLDN(moDataStringHandler.nextSubstring());
            this.primaryKey = Integer.parseInt(moDataStringHandler.nextSubstring());
            this.isPersistent = true;
            this.persistentAttributes = new Vector();
            String string2 = null;
            String string3 = moDataStringHandler.nextSubstring();
            while (string3 != null && !string3.equals("")) {
                string2 = StringRepository.fixString(attributeLookUp.lookup(Integer.parseInt(string3)));
                object = StringRepository.fixString(moDataStringHandler.nextSubstring());
                char c = ((String)object).charAt(0);
                if (c == 's') {
                    this.registerPersistentAttr(new StringAttribute(string2, (String)object));
                } else if (c == 'i') {
                    this.registerPersistentAttr(new IntegerAttribute(string2, (String)object));
                } else if (c == 'l') {
                    this.registerPersistentAttr(new LongAttribute(string2, (String)object));
                } else if (c == 'b') {
                    this.registerPersistentAttr(new BooleanAttribute(string2, (String)object));
                } else if (c == 'f') {
                    this.registerPersistentAttr(new FloatAttribute(string2, (String)object));
                } else if (c == 'r') {
                    this.registerPersistentAttr(new ReferenceAttribute(string2, (String)object));
                } else if (c == 'q') {
                    this.registerPersistentAttr(new SequenceAttribute(string2, (String)object));
                } else if (c == 't') {
                    this.registerPersistentAttr(new StructAttribute(string2, (String)object));
                }
                string3 = StringRepository.fixString(moDataStringHandler.nextSubstring());
            }
            object = clPrimaryKeyLock;
            synchronized (clPrimaryKeyLock) {
                if (this.primaryKey > clLastPrimaryKey) {
                    clLastPrimaryKey = this.primaryKey;
                }
                // ** MonitorExit[var7_8] (shouldn't be in output)
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (string == null || string.length() == 0) {
                MessageLog.info(this.getClass(), (String)" Corrupted Mo data : NULL");
            } else {
                MessageLog.info(this.getClass(), (String)(" Corrupted Mo data :" + string));
            }
            throw illegalArgumentException;
        }
        {
            return;
        }
    }

    public Attribute getAttribute(String string) {
        Attribute attribute;
        Enumeration enumeration;
        if (this.transientAttributes != null) {
            enumeration = this.transientAttributes.elements();
            while (enumeration.hasMoreElements()) {
                attribute = (Attribute)enumeration.nextElement();
                if (!attribute.getName().equals(string)) continue;
                return attribute;
            }
        }
        if (this.persistentAttributes != null) {
            enumeration = this.persistentAttributes.elements();
            while (enumeration.hasMoreElements()) {
                attribute = (Attribute)enumeration.nextElement();
                if (!attribute.getName().equals(string)) continue;
                return attribute;
            }
        }
        return null;
    }

    public Enumeration getAllPersistentAttributes() {
        if (this.persistentAttributes != null) {
            Enumeration enumeration = this.persistentAttributes.elements();
            return enumeration;
        }
        return null;
    }

    public String getLocalDistinguishedName() {
        return this.moName;
    }

    public String getMoTypeName() {
        return this.moType;
    }

    public void registerTransientAttr(Attribute attribute) {
        Assert.cppAssert((this.getAttribute(attribute.getName()) == null ? 1 : 0) != 0, (String)("MoData.registerTransientAttr() Attribute already  registered, attrname :" + attribute.getName()));
        if (this.transientAttributes == null) {
            this.transientAttributes = new Vector();
        }
        this.transientAttributes.addElement(attribute);
    }

    public void registerPersistentAttr(Attribute attribute) {
        Assert.cppAssert((this.getAttribute(attribute.getName()) == null ? 1 : 0) != 0, (String)("MoData.registerPersistentAttr() Attribute already  registered, attrname :" + attribute.getName()));
        Assert.cppAssert((boolean)this.isPersistent, (String)"MoData.registerAttribute() Only transient attributescan be added since this object is transient");
        this.persistentAttributes.addElement(attribute);
    }

    public void deregisterAttribute(Attribute attribute) {
        Assert.cppAssert((Object)this.getAttribute(attribute.getName()), (String)"MoData.deregisterAttribute No such attribute registered");
        if (this.transientAttributes != null) {
            this.transientAttributes.removeElement(attribute);
        }
        if (this.persistentAttributes != null) {
            this.persistentAttributes.removeElement(attribute);
        }
    }

    public void deregisterAttribute(String string) {
        Attribute attribute = this.getAttribute(string);
        if (attribute != null) {
            this.deregisterAttribute(attribute);
        }
    }

    private synchronized void commit() {
        Enumeration enumeration;
        Assert.cppAssert((this.currentTransaction != null ? 1 : 0) != 0);
        if (this.transientAttributes != null) {
            enumeration = this.transientAttributes.elements();
            while (enumeration.hasMoreElements()) {
                ((Attribute)enumeration.nextElement()).commit();
            }
        }
        if (this.persistentAttributes != null) {
            enumeration = this.persistentAttributes.elements();
            while (enumeration.hasMoreElements()) {
                ((Attribute)enumeration.nextElement()).commit();
            }
        }
        this.currentTransaction = null;
        this.currentThread = "";
        this.notifyAll();
    }

    private synchronized boolean prepare() {
        Object object;
        Object object2;
        Assert.cppAssert((Object)this.currentTransaction, (String)"prepare, no tx active");
        if (this.isPersistent && this.isModified) {
            try {
                object2 = this.buildString();
                object = MoCompressedLDNStorage.instance();
                object.updateRow(this.currentTransaction.getTransactionID(), this.primaryKey, (String)object2);
            }
            catch (DbAccessException dbAccessException) {
                Assert.cppAssert((boolean)false, (String)("Modata.prepare exception :" + (Object)((Object)dbAccessException)));
                return false;
            }
        }
        object2 = NotificationSender.instance();
        object = MoRepository.instance().lookup(this.moName);
        this.reportChangedAttributesToAVCCollector((NotificationSender)object2, (ManagedObject)object);
        return true;
    }

    private void reportChangedAttributesToAVCCollector(NotificationSender notificationSender, ManagedObject managedObject) {
        Object object;
        int n;
        Object object2;
        Enumeration enumeration;
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        if (this.transientAttributes != null) {
            enumeration = this.transientAttributes.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (Attribute)enumeration.nextElement();
                if (!((Attribute)object2).isModified()) continue;
                if (((Attribute)object2).getNotificationType() == 1) {
                    vector.addElement(object2);
                    continue;
                }
                if (((Attribute)object2).getNotificationType() == 3) {
                    vector2.addElement(object2);
                    continue;
                }
                if (((Attribute)object2).getNotificationType() != 0) continue;
            }
        }
        if (this.persistentAttributes != null) {
            enumeration = this.persistentAttributes.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (Attribute)enumeration.nextElement();
                if (!((Attribute)object2).isModified()) continue;
                if (((Attribute)object2).getNotificationType() == 1) {
                    vector.addElement(object2);
                    continue;
                }
                if (((Attribute)object2).getNotificationType() == 3) {
                    vector2.addElement(object2);
                    continue;
                }
                if (((Attribute)object2).getNotificationType() != 0) continue;
            }
        }
        int n2 = vector.size();
        object2 = new String[n2];
        Object[] objectArray = new Object[n2];
        if (n2 > 0) {
            for (n = 0; n < n2; ++n) {
                object = (Attribute)vector.elementAt(n);
                object2[n] = ((Attribute)object).getName();
                objectArray[n] = ((Attribute)object).getValueAsObject(this.currentTransaction);
            }
            MessageLog.trace((int)5, this.getClass(), (String)("Reporting " + n2 + " changed attributes for " + managedObject));
            notificationSender.pushAVC(managedObject, (String[])object2, objectArray, this.currentTransaction);
        }
        n = vector2.size();
        object = new String[n];
        SequenceDiffInfo[] sequenceDiffInfoArray = new SequenceDiffInfo[n];
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                SequenceAttribute sequenceAttribute = (SequenceAttribute)vector2.get(i);
                object[i] = sequenceAttribute.getName();
                sequenceDiffInfoArray[i] = sequenceAttribute.getSequenceDiffInfo(this.currentTransaction);
            }
            MessageLog.trace((int)5, this.getClass(), (String)("Reporting " + n + " changed SequenceDeltaNotification attributes for " + managedObject));
            notificationSender.pushSequenceDeltaNotification(managedObject, (String[])object, sequenceDiffInfoArray, this.currentTransaction);
        }
    }

    String buildString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(this.getMoDataAttributes());
        this.persistentAttributes.trimToSize();
        Enumeration enumeration = this.persistentAttributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            stringBuffer.append(attribute.buildString() + "^");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.buildString();
    }

    private String getMoDataAttributes() {
        MoTypeLookup moTypeLookup = MoTypeLookup.instance();
        return moTypeLookup.lookup(this.moType) + "^" + String.valueOf(this.revision) + "^" + moTypeLookup.convertToShortLDNFormat(this.moName) + "^" + String.valueOf(this.primaryKey) + "^";
    }

    private synchronized void rollback() {
        Attribute attribute;
        Enumeration enumeration;
        Assert.cppAssert((Object)this.currentTransaction, (String)"rollback, no tx active");
        if (this.transientAttributes != null) {
            enumeration = this.transientAttributes.elements();
            while (enumeration.hasMoreElements()) {
                attribute = (Attribute)enumeration.nextElement();
                attribute.rollback();
            }
        }
        if (this.persistentAttributes != null) {
            enumeration = this.persistentAttributes.elements();
            while (enumeration.hasMoreElements()) {
                attribute = (Attribute)enumeration.nextElement();
                attribute.rollback();
            }
        }
        this.currentTransaction = null;
        this.currentThread = "";
        this.notifyAll();
    }

    public void delete(Coordinator coordinator) throws TransactionRequiredException {
        if (this.isPersistent) {
            if (coordinator == null || coordinator.getStatus() != Status.ACTIVE) {
                throw new TransactionRequiredException();
            }
            try {
                MoCompressedLDNStorage moCompressedLDNStorage = MoCompressedLDNStorage.instance();
                moCompressedLDNStorage.deleteRow(coordinator.getTransactionID(), this.primaryKey);
                this.isModified = false;
            }
            catch (DbAccessException dbAccessException) {
                MessageLog.traceError(this.getClass(), (String)"DB Access exception: ", (Throwable)dbAccessException);
                Assert.cppAssert((boolean)false, (String)("MoData.delete exception :" + (Object)((Object)dbAccessException)));
            }
        }
    }

    public synchronized void handleTransaction(Coordinator coordinator, AccessType accessType) throws TransactionRequiredException, NoPermissionException {
        if (coordinator == null) {
            if (accessType == READ_ACCESS) {
                return;
            }
            throw new TransactionRequiredException();
        }
        if (coordinator.getStatus() != Status.ACTIVE) {
            throw new TransactionRequiredException();
        }
        if (this.currentTransaction == null || !this.currentTransaction.isSameTransaction(coordinator)) {
            try {
                if (this.currentTransaction != null) {
                    MessageLog.trace((int)5, this.getClass(), (String)("Trying to access modata of MO " + this.moName + " within tx " + coordinator.getTransactionID() + ", but this modata is locked by tx " + this.currentTransaction.getTransactionID() + ". Locking thread: " + this.currentThread));
                }
                while (this.currentTransaction != null) {
                    this.wait(1000L);
                }
                this.startTransaction(coordinator);
            }
            catch (InterruptedException interruptedException) {
                Assert.cppAssert((boolean)false, (String)("MoData Unexpected Exception: " + interruptedException));
            }
        }
        if (accessType == WRITE_ACCESS) {
            this.performAccessControl();
            this.isModified = true;
        }
    }

    public synchronized void handleTransactionNonBlocking(Coordinator coordinator, AccessType accessType) throws ResourceLockedException, TransactionRequiredException, NoPermissionException {
        if (coordinator == null) {
            if (accessType == READ_ACCESS) {
                return;
            }
            throw new TransactionRequiredException();
        }
        if (coordinator.getStatus() != Status.ACTIVE) {
            throw new TransactionRequiredException();
        }
        if (this.currentTransaction == null) {
            this.startTransaction(coordinator);
        } else if (!this.currentTransaction.isSameTransaction(coordinator)) {
            throw new ResourceLockedException(this.moName);
        }
        if (accessType == WRITE_ACCESS) {
            this.performAccessControl();
            this.isModified = true;
        }
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int n) {
        this.revision = n;
    }

    private void startTransaction(Coordinator coordinator) throws TransactionRequiredException {
        Attribute attribute;
        Enumeration enumeration;
        Assert.cppAssert((this.currentTransaction == null ? 1 : 0) != 0, (String)"Already started");
        try {
            coordinator.registerResource((Resource)new MoDataTxResource(this));
            NotificationSender.instance().registerCollector(coordinator);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            throw new TransactionRequiredException();
        }
        this.currentTransaction = coordinator;
        this.currentThread = Thread.currentThread().getName();
        this.isModified = false;
        if (this.transientAttributes != null) {
            enumeration = this.transientAttributes.elements();
            while (enumeration.hasMoreElements()) {
                attribute = (Attribute)enumeration.nextElement();
                attribute.startTransaction();
            }
        }
        if (this.persistentAttributes != null) {
            enumeration = this.persistentAttributes.elements();
            while (enumeration.hasMoreElements()) {
                attribute = (Attribute)enumeration.nextElement();
                attribute.startTransaction();
            }
        }
    }

    private void performAccessControl() throws NoPermissionException {
        if (CelloOrb.instance().securityActivated()) {
            String string = null;
            String string2 = null;
            Principal principal = CelloOrb.instance().getCurrent().getActingPrincipal();
            if (principal == null) {
                MessageLog.info(this.getClass(), (String)"No acting principal");
                throw new NoPermissionException("No acting principal");
            }
            if (((Object)principal).equals(CelloOrb.instance().getCurrent().getLocalPrincipal())) {
                return;
            }
            try {
                string = CelloOrb.instance().getCurrent().getUniqueID(principal);
                if (string == null) {
                    string2 = principal.getName();
                    if (string2 == null) {
                        MessageLog.info(this.getClass(), (String)"Both userName and userDN are null");
                        throw new NoPermissionException("Both userName and userDN are null");
                    }
                    if (!VLS.instance().isAuthorized(null, string2, REP_ID, METHOD)) {
                        throw new NoPermissionException("Access denied");
                    }
                } else if (!VLS.instance().isAuthorized(string, null, REP_ID, METHOD)) {
                    throw new NoPermissionException("Access denied");
                }
            }
            catch (VLSException vLSException) {
                throw new NoPermissionException(vLSException.toString());
            }
        }
    }

    private static class MoDataTxResource
    implements Resource {
        private MoData delegate;

        public MoDataTxResource(MoData moData) {
            this.delegate = moData;
        }

        public void commit() {
            this.delegate.commit();
        }

        public boolean prepare() {
            return this.delegate.prepare();
        }

        public void rollback() {
            this.delegate.rollback();
        }
    }

    public static class AccessType {
        AccessType() {
        }
    }
}

