/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import se.ericsson.cello.moframework.ContextAwareMoFactory;
import se.ericsson.cello.moframework.MaoContextImpl;
import se.ericsson.cello.moframework.MoFactory;

public class MoFactoryMgr {
    private final Hashtable factories = new Hashtable();
    static MoFactoryMgr theOneAndOnly;
    private static final String UNIVERSAL_FACTORY_CLASS_NAME = "se.ericsson.cello.oms.UniversalMoFactory";

    public static MoFactoryMgr instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new MoFactoryMgr();
        }
        return theOneAndOnly;
    }

    private MoFactoryMgr() {
    }

    public void register(MoFactory moFactory, String string) {
        this.factories.put(string, moFactory);
        if (moFactory instanceof ContextAwareMoFactory) {
            ((ContextAwareMoFactory)moFactory).setMaoContext(MaoContextImpl.instance());
        }
    }

    public void deregister(String string) {
        this.factories.remove(string);
    }

    public MoFactory lookup(String string) {
        MoFactory moFactory = (MoFactory)this.factories.get(string);
        if (moFactory == null && System.getProperty("javasim") == null) {
            moFactory = this.constructUniversalFactory(string);
        }
        return moFactory;
    }

    private MoFactory constructUniversalFactory(String string) {
        try {
            Class<?> clazz = Class.forName(UNIVERSAL_FACTORY_CLASS_NAME);
            Class[] classArray = new Class[]{String.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{string};
            return (MoFactory)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

