/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.notification;

import java.util.ArrayList;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyComm.SequencePushConsumer;
import org.threegppsa5.NotificationIRPSystem.DetachException;
import org.threegppsa5.NotificationIRPSystem.InvalidParameter;
import se.ericsson.cello.notification.BlockingQueue;
import se.ericsson.cello.notification.NotificationIRPImpl;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;

class NotificationCommunicator
implements Runnable {
    private static final int MAX_QUEUE_SIZE = 50;
    private static final int TOTAL_TIME_TO_RETRY = 300;
    private static final int TIME_INTERVAL_BETWEEN_TRIES = 10000;
    private static final int MAX_NUMBER_OF_RETRIES = 30;
    private static final int CONVERT_TO_MILLISECONDS = 60000;
    private static ArrayList liveAlarmThreads = new ArrayList();
    private BlockingQueue myQueue = new BlockingQueue(50);
    private SequencePushConsumer myConsumer;
    private Watchdog myWatchdog;
    private long mySubscriptionId;
    private boolean deleted;
    private Thread thread;

    NotificationCommunicator(SequencePushConsumer sequencePushConsumer, long l, int n) {
        this.mySubscriptionId = l;
        if (n > 0) {
            this.myWatchdog = new Watchdog(this, n);
            Thread thread = new Thread((Runnable)this.myWatchdog, "FM_SubWatch_" + this.mySubscriptionId);
            thread.start();
        }
        this.myConsumer = sequencePushConsumer;
    }

    void start() {
        this.thread = new Thread((Runnable)this, "FM_NotComm_" + this.mySubscriptionId);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            NotificationCommunicator.registerCommunicator();
            while (!this.deleted) {
                try {
                    if (!this.myQueue.isFull()) {
                        Object object = this.myQueue.dequeue();
                        if (object instanceof StructuredEvent) {
                            StructuredEvent[] structuredEventArray = new StructuredEvent[]{(StructuredEvent)object};
                            this.notifySubscriber(structuredEventArray);
                            continue;
                        }
                        MessageLog.traceError(this.getClass(), (String)("Dequeued a non StructuredEvent: " + object), null);
                        continue;
                    }
                    this.removeSubscription();
                    MessageLog.info(this.getClass(), (String)("Subscription " + this.mySubscriptionId + " removed due to full queue"));
                }
                catch (BlockingQueue.ClosedException closedException) {
                    MessageLog.trace((int)5, this.getClass(), (String)("Subscription " + this.mySubscriptionId + " removed"));
                }
                catch (RuntimeException runtimeException) {
                    this.removeSubscription();
                    MessageLog.traceError(this.getClass(), (String)"run: ", (Throwable)runtimeException);
                }
                catch (Error error) {
                    this.removeSubscription();
                    MessageLog.traceError(this.getClass(), (String)"run: ", (Throwable)error);
                }
            }
        }
        finally {
            this.myConsumer._release();
            NotificationCommunicator.deregisterCommunicator();
        }
    }

    private static synchronized void registerCommunicator() {
        liveAlarmThreads.add(Thread.currentThread());
    }

    private static synchronized void deregisterCommunicator() {
        liveAlarmThreads.remove(Thread.currentThread());
    }

    public static int getNumberOfActiveCommunicators() {
        return liveAlarmThreads.size();
    }

    void notifySubscriber(StructuredEvent[] structuredEventArray) {
        int n = 0;
        boolean bl = true;
        while (bl && !this.deleted && !this.myQueue.isFull()) {
            try {
                this.myConsumer.push_structured_events(structuredEventArray);
                bl = false;
            }
            catch (NO_PERMISSION nO_PERMISSION) {
                this.removeSubscription();
                bl = false;
                MessageLog.info(this.getClass(), (String)("Notification could not be sent - subscription " + this.mySubscriptionId + " is removed: " + (Object)((Object)nO_PERMISSION)));
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                this.removeSubscription();
                bl = false;
                MessageLog.info(this.getClass(), (String)("Notification could not be sent - subscription " + this.mySubscriptionId + " is removed: " + (Object)((Object)oBJECT_NOT_EXIST)));
            }
            catch (Disconnected disconnected) {
                this.removeSubscription();
                bl = false;
                MessageLog.info(this.getClass(), (String)("Notification could not be sent - subscription " + this.mySubscriptionId + " is removed: " + (Object)((Object)disconnected)));
            }
            catch (SystemException systemException) {
                if (n < 30) {
                    ++n;
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                this.removeSubscription();
                bl = false;
                MessageLog.info(this.getClass(), (String)("Subscription " + this.mySubscriptionId + " removed due to lost contact to the subscriber"));
            }
        }
    }

    private void removeSubscription() {
        try {
            NotificationIRPImpl.instance().detach(this.myConsumer, new Long(this.mySubscriptionId).toString());
        }
        catch (DetachException detachException) {
            MessageLog.traceError(this.getClass(), (String)"Could not perform detach!", (Throwable)((Object)detachException));
        }
        catch (InvalidParameter invalidParameter) {
            MessageLog.traceError(this.getClass(), (String)"Could not perform detach!", (Throwable)((Object)invalidParameter));
        }
    }

    void enqueue(StructuredEvent structuredEvent) {
        try {
            if (!this.myQueue.enqueue(structuredEvent)) {
                MessageLog.info(this.getClass(), (String)" not possible to add alarm to the queue, removing subscription");
                this.removeSubscription();
                this.stopSubscription();
            }
        }
        catch (BlockingQueue.ClosedException closedException) {
            // empty catch block
        }
    }

    void restartTimer() {
        if (this.myWatchdog != null) {
            this.myWatchdog.restartTimer();
        }
    }

    void stopSubscription() {
        this.deleted = true;
        this.myQueue.close();
        if (this.myWatchdog != null) {
            this.myWatchdog.kill();
        }
    }

    private static class Watchdog
    implements Runnable {
        private NotificationCommunicator myNotCom;
        private int timeout;
        private boolean clearedByActor;

        Watchdog(NotificationCommunicator notificationCommunicator, int n) {
            this.myNotCom = notificationCommunicator;
            this.timeout = n * 60000;
            this.clearedByActor = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                boolean bl = false;
                while (!bl) {
                    Watchdog watchdog = this;
                    synchronized (watchdog) {
                        this.clearedByActor = false;
                        try {
                            this.wait(this.timeout);
                        }
                        catch (InterruptedException interruptedException) {
                            Assert.cppAssert((boolean)false, (String)("Watchdog unexpected exception :" + interruptedException));
                        }
                    }
                    if (this.clearedByActor) continue;
                    this.myNotCom.removeSubscription();
                    this.myNotCom = null;
                    bl = true;
                }
            }
            catch (RuntimeException runtimeException) {
                MessageLog.traceError(this.getClass(), (String)"run: ", (Throwable)runtimeException);
            }
            catch (Error error) {
                MessageLog.traceError(this.getClass(), (String)"run: ", (Throwable)error);
            }
        }

        synchronized void restartTimer() {
            this.clearedByActor = true;
            this.notifyAll();
        }

        synchronized void kill() {
            this.clearedByActor = false;
            this.notifyAll();
            MessageLog.trace((int)5, this.getClass(), (String)"Subscription removed, killing FM_SubscriptionWatchdogThread");
        }
    }
}

