/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.oms;

import java.util.StringTokenizer;
import se.ericsson.cello.oms.ORBRestartManager;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.security.cipher.CipherListener;
import se.ericsson.security.cipher.CipherMgr;
import se.ericsson.security.cipher.CipherMgrFactory;

public class CipherSubscriber
implements CipherListener {
    private String oldEnabledCiphers = "";
    private String newEnabledCiphers = "";
    private CipherMgr cipherMgr = null;
    private String supportedCiphers = "";
    private static CipherSubscriber instance = new CipherSubscriber();
    private static final int TRACE_GROUP = 5;

    public static CipherSubscriber getInstance() {
        return instance;
    }

    public String getEnabledCiphers(String string) {
        if (this.cipherMgr != null) {
            this.supportedCiphers = string;
            String string2 = this.cipherMgr.getEnabledCiphers();
            this.areEnabledCiphersChanged(string2);
        } else {
            MessageLog.info(this.getClass(), (String)"CipherMgr is not created. Not able to send GetReq.");
        }
        return this.newEnabledCiphers;
    }

    public void sendIpomCsucjiTlsSubscribeReq(String string) {
        this.supportedCiphers = string;
        if (this.cipherMgr != null) {
            this.cipherMgr.sendIpomCsucjiTlsSubscribeReq(string);
        } else {
            MessageLog.info(this.getClass(), (String)"CipherMgr is not created. Not able to send SubscribeReq.");
        }
    }

    private boolean areEnabledCiphersChanged(String string) {
        boolean bl = false;
        if ((string.equals("DEFAULT") || string.equals("")) && (this.oldEnabledCiphers.equals("DEFAULT") || this.oldEnabledCiphers.equals(""))) {
            this.oldEnabledCiphers = "DEFAULT";
            this.newEnabledCiphers = "DEFAULT";
            MessageLog.trace((int)5, this.getClass(), (String)"Received DEFAULT. Nothing changed. Supported Ciphers should be used.");
        } else if (string.equals("DEFAULT")) {
            this.newEnabledCiphers = "DEFAULT";
            MessageLog.trace((int)5, this.getClass(), (String)"Received DEFAULT. Changed. Supported Ciphers should be used.");
        } else if (!this.areEnabledSubsetOfSupportedCiphers(string, this.supportedCiphers)) {
            MessageLog.info(this.getClass(), (String)("Received Enabled Ciphers: " + string + " are not in subset of Supported Ciphers: " + this.supportedCiphers + ". Old Ciphers should be unchanged: " + this.newEnabledCiphers + "."));
        } else {
            this.newEnabledCiphers = string;
        }
        if (!this.newEnabledCiphers.equals(this.oldEnabledCiphers)) {
            bl = true;
        }
        this.oldEnabledCiphers = this.newEnabledCiphers;
        return bl;
    }

    private boolean areEnabledSubsetOfSupportedCiphers(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            boolean bl = false;
            String string3 = stringTokenizer.nextToken();
            while (stringTokenizer2.hasMoreTokens()) {
                String string4 = stringTokenizer2.nextToken();
                MessageLog.trace((int)5, this.getClass(), (String)("Comparing enabledCipher: " + string3 + " with supportedCipher: " + string4 + "."));
                if (!string3.equals(string4)) continue;
                MessageLog.trace((int)5, this.getClass(), (String)("enabledCipher: " + string3 + " found in supportedCiphers: " + string2 + "."));
                bl = true;
                break;
            }
            if (!bl) {
                MessageLog.trace((int)5, this.getClass(), (String)("enabledCipher: " + string3 + " NOT found in supportedCiphers: " + string2 + "."));
                return false;
            }
            bl = false;
        }
        return true;
    }

    public void init() {
        this.cipherMgr = CipherMgrFactory.createCipherMgr();
        this.cipherMgr.registerSubscriber((CipherListener)this);
    }

    public void notifyCipherChanged(String string) {
        MessageLog.trace((int)5, this.getClass(), (String)"notifyCipherChanged");
        boolean bl = this.areEnabledCiphersChanged(string);
        boolean bl2 = CelloOrb.instance().securityActivated();
        MessageLog.trace((int)5, this.getClass(), (String)("Security activated: " + bl2 + ". Enabled ciphers changed: " + bl + "."));
        if (bl2 && bl) {
            MessageLog.info(this.getClass(), (String)"Security Activated and enabled ciphers changed, ORB will be restarted.");
            ORBRestartManager.instance().restartORB();
        }
    }

    private CipherSubscriber() {
    }
}

