/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.oms;

import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.configirpimpl.SessionImpl;
import se.ericsson.cello.configirpimpl.SessionManager;
import se.ericsson.cello.moframework.MosiNotificationSender;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.debug.Util;

public class ORBRestartManager {
    private static ORBRestartManager instance = new ORBRestartManager();
    private static final int TRACE_GROUP = 5;
    private boolean restartAllowed = false;
    private boolean orbRestartRequested = false;

    public static ORBRestartManager instance() {
        return instance;
    }

    public void restartORB() {
        this.orbRestartRequested = true;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ORBRestartManager.this.startRestartOrbThread();
            }
        });
        thread.setName("OrbRestartThread");
        thread.start();
    }

    private synchronized void startRestartOrbThread() {
        while (!this.isRestartAllowed()) {
            try {
                MessageLog.info(this.getClass(), (String)"Restart is not allowed due to ongoing intialization/restart. Waiting");
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setRestartAllowed(false);
        this.orbRestartRequested = false;
        MessageLog.trace((int)5, this.getClass(), (String)"Restarting ORB");
        List list = SessionManager.instance().getActiveSessions();
        Iterator iterator = list.iterator();
        SessionImpl sessionImpl = null;
        String string = "";
        try {
            while (iterator.hasNext()) {
                sessionImpl = (SessionImpl)iterator.next();
                string = sessionImpl.get_session_id();
                MessageLog.info(this.getClass(), (String)("Calling end() for session:  " + sessionImpl + " with id " + string + " since ORB will be restarted."));
                sessionImpl.end();
            }
        }
        catch (Throwable throwable) {
            MessageLog.info(this.getClass(), (String)("Failed to end session with id " + string + " due to " + Util.stack2string((Throwable)throwable)));
        }
        MosiNotificationSender.orbRestartInitiated();
        MessageLog.trace((int)5, this.getClass(), (String)"Stopping NameServer");
        CelloOrb.instance().stopNameServer();
        try {
            MessageLog.trace((int)5, this.getClass(), (String)"Shutdown ORB");
            CelloOrb.instance().getOrb().shutdown(true);
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)"Failed shutdown ORB ", (Throwable)exception);
            Assert.cppAssert(null, (String)"Failed to shutdown ORB ");
        }
    }

    private ORBRestartManager() {
    }

    public synchronized void setRestartAllowed(boolean bl) {
        this.restartAllowed = bl;
        if (bl) {
            this.notify();
        }
    }

    public boolean isRestartAllowed() {
        return this.restartAllowed;
    }

    public boolean isOrbRestartRequested() {
        return this.orbRestartRequested;
    }
}

