/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.oms;

import se.ericsson.cello.oms.ORBRestartManager;
import se.ericsson.cello.seclev.SecurityEvent;
import se.ericsson.cello.seclev.SecurityEventListener;
import se.ericsson.cello.seclev.SecurityEventMgr;
import se.ericsson.cello.seclev.SecurityEventMgrFactory;
import se.ericsson.cello.support.debug.MessageLog;

public class SecurityEventSubscriber
implements SecurityEventListener {
    private static SecurityEventSubscriber mySingleton = new SecurityEventSubscriber();
    private static final int TRACE_GROUP = 5;

    public static SecurityEventSubscriber getInstance() {
        return mySingleton;
    }

    public void init() {
        SecurityEventMgr securityEventMgr = SecurityEventMgrFactory.getSecurityEventMgr();
        securityEventMgr.registerSubscriber((SecurityEventListener)this);
    }

    public void notifySecurityEvent(SecurityEvent securityEvent) {
        int n = securityEvent.getOldSeclevel();
        int n2 = securityEvent.getNewSeclevel();
        String string = securityEvent.getOldSeclevelAsString();
        String string2 = securityEvent.getNewSeclevelAsString();
        boolean bl = securityEvent.getNewNodecreds();
        MessageLog.trace((int)5, this.getClass(), (String)("Security event notification received. Old sec level: " + string + " (int value: " + n + ")" + ", new sec level: " + string2 + " (int value: " + n2 + ")" + ", new node creds: " + bl + ", telnetFtpSecure: " + securityEvent.getTelnetFtpSecure() + ", targetMonitorSecure: " + securityEvent.getTargetMonitorSecure() + ", debugServerSecure: " + securityEvent.getDebugServerSecure() + ", fileTransferClientSecure: " + securityEvent.getFileTransferClientSecure()));
        if (n == 1 && n2 != 1 || n != 1 && n != 2 && (n2 == 1 || n2 == 2)) {
            MessageLog.info(this.getClass(), (String)("Security level changed from " + string + " (int value: " + n + ") to " + string2 + " (int value: " + n2 + "), ORB will be restarted"));
            ORBRestartManager.instance().restartORB();
        } else if (bl) {
            MessageLog.info(this.getClass(), (String)"New node credentials configured, ORB will be restarted");
            ORBRestartManager.instance().restartORB();
        }
    }

    private SecurityEventSubscriber() {
    }
}

