/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.pms.generic.CounterCalculator;
import se.ericsson.cello.pms.generic.Measurement;
import se.ericsson.cello.pms.generic.ObjectRepository;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.PmsContext;
import se.ericsson.cello.support.debug.MessageLog;

class ActiveCounterCalculator {
    private PmsContext pmsContext;
    private List activeMeasurements = new Vector();
    private Hashtable helpers = new Hashtable();
    private Hashtable moTypes = new Hashtable();

    ActiveCounterCalculator(PmsContext pmsContext) {
        this.pmsContext = pmsContext;
    }

    void registerCounterCalculator(String[] stringArray, CounterCalculator counterCalculator) {
        HashSet<String> hashSet = (HashSet<String>)this.helpers.get(counterCalculator);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
            this.moTypes.put(stringArray[i], counterCalculator);
        }
        this.helpers.put(counterCalculator, hashSet);
    }

    void deregisterCounterCalculator(CounterCalculator counterCalculator) {
        HashSet hashSet = (HashSet)this.helpers.get(counterCalculator);
        if (hashSet != null) {
            String[] stringArray = this.toArray(hashSet);
            for (int i = 0; i < stringArray.length; ++i) {
                this.moTypes.remove(stringArray[i]);
            }
        }
        this.helpers.remove(counterCalculator);
    }

    boolean acceptActivation(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray) {
        int n = this.getNoOfCountersForObservations(observationClassArray, observationObjectArray);
        int n2 = this.getNoOfActiveCounters();
        MessageLog.trace((int)8, this.getClass(), (String)("check accept activation: noOfActiveCtrs = " + n2 + ", noOfCtrsToActivate = " + n));
        return n2 + n <= this.pmsContext.getMaxNoOfCounters();
    }

    boolean isMaxLimitExceeded() {
        return this.getNoOfActiveCounters() > this.pmsContext.getMaxNoOfCounters();
    }

    void addMeasurement(Measurement measurement) {
        this.activeMeasurements.add(measurement);
    }

    void removeMeasurement(Measurement measurement) {
        this.activeMeasurements.remove(measurement);
    }

    private ObservationClass[] getObservations(ObservationClass[] observationClassArray, CounterCalculator counterCalculator) {
        Vector<ObservationClass> vector = new Vector<ObservationClass>();
        for (int i = 0; i < observationClassArray.length; ++i) {
            String string = observationClassArray[i].object_class_name;
            if (counterCalculator == null) {
                if (this.moTypes.containsKey(string)) continue;
                vector.add(observationClassArray[i]);
                continue;
            }
            String[] stringArray = this.toArray((HashSet)this.helpers.get(counterCalculator));
            if (stringArray == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!string.equals(stringArray[j])) continue;
                MessageLog.trace((int)8, this.getClass(), (String)("getObservations: will call registered counter calculator (helper) for motype " + stringArray[j]));
                vector.add(observationClassArray[i]);
            }
        }
        if (vector.size() == 0) {
            return new ObservationClass[0];
        }
        Object[] objectArray = new ObservationClass[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private ObservationObject[] getObservations(ObservationObject[] observationObjectArray, CounterCalculator counterCalculator) {
        Vector<ObservationObject> vector = new Vector<ObservationObject>();
        block0: for (int i = 0; i < observationObjectArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < observationObjectArray[i].instance_list.length; ++j) {
                String string = observationObjectArray[i].instance_list[j];
                ManagedObject managedObject = MoRepository.instance().lookup(string);
                if (managedObject != null) {
                    String string2 = managedObject.getType();
                    if (counterCalculator == null) {
                        if (!this.moTypes.containsKey(string2)) {
                            vector.add(observationObjectArray[i]);
                            bl = true;
                        }
                    } else {
                        String[] stringArray = this.toArray((HashSet)this.helpers.get(counterCalculator));
                        if (stringArray != null) {
                            int n = 0;
                            while (!bl && n < stringArray.length) {
                                if (!string2.equals(stringArray[n++])) continue;
                                vector.add(observationObjectArray[i]);
                                bl = true;
                            }
                        }
                    }
                }
                if (bl) continue block0;
            }
        }
        if (vector.size() == 0) {
            return new ObservationObject[0];
        }
        Object[] objectArray = new ObservationObject[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    int getNoOfActiveCounters() {
        Object object;
        int n = 0;
        Enumeration enumeration = this.helpers.keys();
        while (enumeration.hasMoreElements()) {
            object = (CounterCalculator)enumeration.nextElement();
            n += object.calculate();
        }
        for (int i = 0; i < this.activeMeasurements.size(); ++i) {
            object = (Measurement)this.activeMeasurements.get(i);
            int n2 = this.calculate(this.getObservations(object.getObservationClassList(), null), this.getObservations(object.getObservationObjectList(), null));
            n += n2;
        }
        return n;
    }

    int getNoOfCountersForObservations(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray) {
        int n = 0;
        n = this.calculate(this.getObservations(observationClassArray, null), this.getObservations(observationObjectArray, null));
        Enumeration enumeration = this.helpers.keys();
        while (enumeration.hasMoreElements()) {
            CounterCalculator counterCalculator = (CounterCalculator)enumeration.nextElement();
            ObservationClass[] observationClassArray2 = this.getObservations(observationClassArray, counterCalculator);
            ObservationObject[] observationObjectArray2 = this.getObservations(observationObjectArray, counterCalculator);
            if (observationClassArray2.length == 0 && observationObjectArray2.length == 0) continue;
            int n2 = counterCalculator.calculate(observationClassArray2, observationObjectArray2);
            MessageLog.trace((int)8, this.getClass(), (String)("getNoOfCountersForObservations: number of counters for helper " + counterCalculator.getClass() + ": " + n2));
            n += n2;
        }
        return n;
    }

    private int calculate(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray) {
        Object object;
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < observationClassArray.length; ++n2) {
            String string = observationClassArray[n2].object_class_name;
            n = ObjectRepository.instance().convertToNoOfCounterElements(observationClassArray[n2].class_attribute_list);
            object = MoRepository.instance().lookupType(string);
            if (object == null) continue;
            MessageLog.trace((int)8, this.getClass(), (String)("no of MO instances of type " + string + " = " + object.size()));
            n3 += n * object.size();
        }
        for (n2 = 0; n2 < observationObjectArray.length; ++n2) {
            int n4 = ObjectRepository.instance().convertToNoOfCounterElements(observationObjectArray[n2].instance_attribute_list);
            for (n = 0; n < observationObjectArray[n2].instance_list.length; ++n) {
                object = observationObjectArray[n2].instance_list[n];
                ManagedObject managedObject = MoRepository.instance().lookup((String)object);
                if (managedObject == null) continue;
                n3 += n4;
            }
        }
        return n3;
    }

    private String[] toArray(Collection collection) {
        String[] stringArray = collection.toArray(new String[collection.size()]);
        return stringArray;
    }
}

