/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.util.Vector;
import se.ericsson.cello.pms.generic.BasicScanner;
import se.ericsson.cello.pms.generic.DataConsumer;
import se.ericsson.cello.pms.generic.GranularityAndAttributeActivationException;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.Interruptable;
import se.ericsson.cello.pms.generic.Measurable;
import se.ericsson.cello.pms.generic.MeasuredData;
import se.ericsson.cello.pms.generic.ObservedClass;
import se.ericsson.cello.pms.generic.ObservedObject;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.pms.generic.Persistent;
import se.ericsson.cello.pms.generic.ScannerInterrupter;
import se.ericsson.cello.pms.generic.TimeOutException;
import se.ericsson.cello.pms.generic.TransactionHelper;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.Resource;

class CounterBasedScanner
extends BasicScanner
implements Resource,
Interruptable {
    private Measurable[] measurables;
    private boolean txDelete = false;
    private PerformanceMonitoringState txState;
    private PerformanceMonitoringState txStateBackup;
    private boolean scanIsTerminated = true;
    private ScannerInterrupter interrupter;
    private Persistent persistent;
    private boolean configHasChanged;

    CounterBasedScanner(ObservedClass[] observedClassArray, ObservedObject[] observedObjectArray, GranularityPeriod granularityPeriod, PerformanceMonitoringState performanceMonitoringState, DataConsumer dataConsumer, String string, Coordinator coordinator, ScannerInterrupter scannerInterrupter, Persistent persistent) {
        super(granularityPeriod, performanceMonitoringState, dataConsumer, string, coordinator);
        int n;
        this.measurables = new Measurable[observedClassArray.length + observedObjectArray.length];
        int n2 = 0;
        for (n = 0; n < observedClassArray.length; ++n) {
            this.measurables[n2++] = observedClassArray[n];
        }
        for (n = 0; n < observedObjectArray.length; ++n) {
            this.measurables[n2++] = observedObjectArray[n];
        }
        TransactionHelper.registerResource(coordinator, this);
        this.txState = performanceMonitoringState;
        this.interrupter = scannerInterrupter;
        this.persistent = persistent;
    }

    public void scan() {
        try {
            this.scanCounters();
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"scanCounters()", (Throwable)runtimeException);
        }
    }

    public void setScannerState(PerformanceMonitoringState performanceMonitoringState, Coordinator coordinator) throws OverloadException, GranularityAndAttributeActivationException {
        super.setScannerState(performanceMonitoringState, coordinator);
        TransactionHelper.registerResource(coordinator, this);
        this.txState = performanceMonitoringState;
    }

    public void delete(Coordinator coordinator) {
        super.delete(coordinator);
        TransactionHelper.registerResource(coordinator, this);
        this.txDelete = true;
        this.txStateBackup = this.txState;
        this.txState = PerformanceMonitoringState.SUSPENDED;
    }

    public void commit() {
        if (this.txDelete) {
            this.measurables = null;
            this.txDelete = false;
        }
        this.terminateIfNeeded(this.txState);
        this.enableInterruption(this.txState);
    }

    public boolean prepare() {
        return true;
    }

    public void rollback() {
        if (this.txDelete) {
            this.txDelete = false;
            this.txState = this.txStateBackup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeasuredData[] interrupt() {
        if (this.scanIsTerminated) {
            return null;
        }
        MessageLog.trace((int)8, this.getClass(), (String)("Scanner<" + this.name + ">: get buffered data continues"));
        this.scanIsTerminated = true;
        Vector<MeasuredData> vector = new Vector<MeasuredData>();
        Object[] objectArray = this;
        synchronized (this) {
            for (int i = 0; i < this.measurables.length; ++i) {
                if (!this.measurables[i].isMeasured()) continue;
                MeasuredData measuredData = this.measurables[i].result();
                vector.addElement(measuredData);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            objectArray = null;
            if (vector.size() != 0) {
                MessageLog.trace((int)8, this.getClass(), (String)("Scanner<" + this.name + ">: buffered data exists"));
                objectArray = new MeasuredData[vector.size()];
                vector.copyInto(objectArray);
            }
            return objectArray;
        }
    }

    boolean isTerminated() {
        return this.scanIsTerminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanCounters() {
        this.scanIsTerminated = false;
        long l = this.scanDeadline();
        try {
            this.bePolite();
            this.initiate();
            try {
                boolean bl;
                do {
                    bl = true;
                    CounterBasedScanner counterBasedScanner = this;
                    synchronized (counterBasedScanner) {
                        if (this.measurables != null) {
                            for (int i = 0; i < this.measurables.length; ++i) {
                                if (!this.measurables[i].measure(null, this)) {
                                    bl = false;
                                }
                                if (!this.scanIsTerminated) continue;
                                MessageLog.info(this.getClass(), (String)"Scanning interrupted.");
                                break;
                            }
                            if (this.configHasChanged) {
                                this.persistent.update();
                                this.configHasChanged = false;
                                MessageLog.info(this.getClass(), (String)"The scanner configuration has been updated on the persistent storage.");
                            }
                        }
                    }
                    this.bePolite();
                } while (!this.scanIsTerminated && !bl && this.waitForNextScan(l));
            }
            catch (TimeOutException timeOutException) {
                MessageLog.traceError(this.getClass(), (String)("Counterbased scanner " + this.name + " could not complete meaurement within granularity " + "period (" + this.granularityPeriod.inSeconds() + " seconds)"), (Throwable)timeOutException);
            }
            if (!this.scanIsTerminated) {
                this.pushMeasuredData();
                this.scanIsTerminated = true;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                Thread.sleep(this.minimumDelayForScanning());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            throw throwable;
        }
        try {
            Thread.sleep(this.minimumDelayForScanning());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
    }

    public void setConfigHasChanged() {
        this.configHasChanged = true;
    }

    private void pushMeasuredData() {
        MeasuredData[] measuredDataArray = new MeasuredData[this.measurables.length];
        for (int i = 0; i < this.measurables.length; ++i) {
            measuredDataArray[i] = this.measurables[i].result();
        }
        this.destination.push(measuredDataArray, this.getSeqNo());
    }

    private void initiate() {
        if (this.measurables != null) {
            for (int i = 0; i < this.measurables.length; ++i) {
                this.measurables[i].clear();
            }
        } else {
            MessageLog.trace((int)8, this.getClass(), (String)"Attempting to initiate a deleted scanner. Ignoring");
        }
    }

    private void bePolite() {
        try {
            Thread.yield();
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private long scanDeadline() {
        return System.currentTimeMillis() + 300000L;
    }

    private boolean waitForNextScan(long l) throws TimeOutException {
        this.sleep(l);
        return true;
    }

    private void sleep(long l) throws TimeOutException {
        long l2 = 60000L;
        if (l2 + System.currentTimeMillis() > l) {
            throw new TimeOutException();
        }
        try {
            Thread.sleep(l2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private int minimumDelayForScanning() {
        int n = this.granularityPeriod.inSeconds() * 5 / 100;
        if (n < 5) {
            n = 5;
        }
        if (n > 900) {
            n = 900;
        }
        return n * 1000;
    }

    private void enableInterruption(PerformanceMonitoringState performanceMonitoringState) {
        if (performanceMonitoringState.value() == 0) {
            this.interrupter.add(this);
        } else {
            this.interrupter.remove(this);
        }
    }

    private void terminateIfNeeded(PerformanceMonitoringState performanceMonitoringState) {
        if (performanceMonitoringState.value() == 1) {
            this.scanIsTerminated = true;
        }
    }
}

