/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.pms.generic.DiskCleaner;
import se.ericsson.cello.pms.generic.Formatter;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.MeasuredData;
import se.ericsson.cello.pms.generic.PerformanceMgmntService;
import se.ericsson.cello.pms.generic.PmsContext;
import se.ericsson.cello.pms.generic.Time;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.support.thread.CelloGZIPOutputStream;

public class PmStorage
implements Formatter {
    private static HashMap storageHandlers = new HashMap();
    private static final int TRACE_GROUP = 8;
    private String senderType = "";
    private String vendorName = "";
    private static final String FILE_FORMAT_VERSION = "32.401 V6.2";
    private static final String UTF8 = "UTF-8";
    private static PmsContext pmsContext;
    private GranularityPeriod rop = null;
    private static final int STOP = 1;
    Map fileWorkers;
    private Map dataQueues;
    static /* synthetic */ Class class$java$lang$Integer;

    static synchronized PmStorage storageHandler(GranularityPeriod granularityPeriod, PmsContext pmsContext) {
        PmStorage pmStorage = (PmStorage)storageHandlers.get(granularityPeriod);
        if (pmStorage == null) {
            pmStorage = new PmStorage(granularityPeriod);
            storageHandlers.put(granularityPeriod, pmStorage);
        }
        PmStorage.pmsContext = pmsContext;
        return pmStorage;
    }

    public synchronized void storeMeasuredData(MeasuredData[] measuredDataArray, int n) {
        if (measuredDataArray != null) {
            int n2 = this.translateSeqNo(n);
            this.startFileWorkerThread(n2);
            BlockingQueue blockingQueue = this.getBlockingQueue(n2);
            if (blockingQueue != null) {
                blockingQueue.enqueue((Object)measuredDataArray);
            } else {
                MessageLog.traceError(this.getClass(), (String)("Can not find blocking queue for sequence number " + n + ".Data will not be stored."));
            }
        }
    }

    public void endFile(int n) {
        MessageLog.trace((int)8, this.getClass(), (String)("Complete file for seq no " + n));
        int n2 = this.translateSeqNo(n);
        this.initStopFileWorkerThread(n2);
    }

    private PmStorage(GranularityPeriod granularityPeriod) {
        this.rop = granularityPeriod;
        if (this.rop.equals(GranularityPeriod.MINUTES_5)) {
            this.fileWorkers = new HashMap(12);
            this.dataQueues = new HashMap(12);
        } else if (this.rop.equals(GranularityPeriod.MINUTES_15)) {
            this.fileWorkers = new HashMap(4);
            this.dataQueues = new HashMap(4);
        } else {
            this.fileWorkers = new HashMap(1);
            this.dataQueues = new HashMap(1);
        }
    }

    private void emptyQueue(int n) {
        BlockingQueue blockingQueue = null;
        try {
            blockingQueue = this.getBlockingQueue(n);
            if (blockingQueue != null) {
                blockingQueue.clear();
            } else {
                MessageLog.traceError(this.getClass(), (String)("emptyQueue(): Can not find blocking queue for sequence number " + n));
            }
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)exception);
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)error);
        }
    }

    private static boolean assureDirectory(String string) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return file.mkdirs();
        }
        return true;
    }

    private String getPath() {
        return pmsContext.getPerformanceDataPath();
    }

    private Calendar convertToBeginningOfPeriod(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (this.rop.equals(GranularityPeriod.MINUTES_5)) {
            int n = calendar.get(12);
            n = n - n % 5 - 5;
            calendar.set(12, n);
        } else if (this.rop.equals(GranularityPeriod.MINUTES_15)) {
            int n = calendar.get(12);
            n = n - n % 15 - 15;
            calendar.set(12, n);
        } else if (this.rop.equals(GranularityPeriod.HOURS_1)) {
            calendar.set(12, 0);
            calendar.add(10, -1);
        }
        return calendar;
    }

    private void printHeader(PrintWriter printWriter, String string) {
        printWriter.write("<?xml version=\"1.0\"?>\n");
        printWriter.write("<?xml-stylesheet type=\"text/xsl\" href=\"MeasDataCollection.xsl\"?>\n");
        printWriter.write("<!DOCTYPE mdc SYSTEM \"MeasDataCollection.dtd\">\n");
        printWriter.write("<mdc xmlns:HTML=\"http://www.w3.org/TR/REC-xml\">\n");
        printWriter.write("<mfh>\n");
        printWriter.write("<ffv>32.401 V6.2</ffv>\n");
        printWriter.write("<sn>" + this.senderName() + "</sn>\n");
        printWriter.write("<st>" + this.senderType + "</st>\n");
        printWriter.write("<vn>" + this.vendorName + "</vn>\n");
        printWriter.write("<cbt>" + string + "Z" + "</cbt>\n");
        printWriter.write("</mfh>\n");
        printWriter.flush();
    }

    private void printMeasuredData(PrintWriter printWriter, MeasuredData[] measuredDataArray, String string) {
        for (int i = 0; i < measuredDataArray.length; ++i) {
            if (measuredDataArray[i] != null) {
                measuredDataArray[i].printXml(printWriter, string, this.rop);
                Thread.yield();
            }
            printWriter.flush();
        }
    }

    private void pushMeasuredData(MeasuredData[] measuredDataArray, String string) {
        for (int i = 0; i < measuredDataArray.length; ++i) {
            if (measuredDataArray[i] == null) continue;
            measuredDataArray[i].pushXml(string, this.rop);
            Thread.yield();
        }
    }

    private void printFooter(PrintWriter printWriter, String string) {
        printWriter.write("<mff><ts>" + string + "Z" + "</ts></mff>\n");
        printWriter.write("</mdc>\n");
        printWriter.flush();
    }

    private PrintWriter getPrintWriter(boolean bl, boolean bl2, String string) {
        try {
            BufferedWriter bufferedWriter = null;
            bufferedWriter = bl2 ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, bl), UTF8)) : new BufferedWriter(new OutputStreamWriter((OutputStream)new CelloGZIPOutputStream((OutputStream)new FileOutputStream(string, bl)), UTF8));
            return new PrintWriter(bufferedWriter);
        }
        catch (IOException iOException) {
            MessageLog.traceError(this.getClass(), (String)"Unexpected file error", (Throwable)iOException);
            return null;
        }
    }

    private void renameFile(String string, String string2) {
        File file = new File(string);
        if (!file.renameTo(new File(string2))) {
            MessageLog.info(this.getClass(), (String)"Temporary file could not be renamed.");
            if (!file.delete()) {
                MessageLog.info(this.getClass(), (String)"Temporary file could not be deleted.");
            }
        }
    }

    private String createFileName(Date date) {
        StringBuffer stringBuffer = new StringBuffer();
        Time time = Time.instance();
        String string = "A";
        String string2 = time.yyyyMMddTime(date);
        String string3 = time.HHmmTime(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, this.rop.inSeconds());
        String string4 = time.HHmmTime(calendar.getTime());
        String string5 = ":1";
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append(".");
        stringBuffer.append(string3);
        stringBuffer.append("-");
        stringBuffer.append(string4);
        stringBuffer.append(string5);
        stringBuffer.append(".xml");
        return stringBuffer.toString();
    }

    private String senderName() {
        if (MibMgr.instance().getMib() == null) {
            return "";
        }
        return MibMgr.instance().getMib().getMibPrefix();
    }

    private String getEndOfPeriodTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, this.rop.inSeconds());
        String string = Time.instance().yyyyMMddTime(calendar.getTime());
        String string2 = Time.instance().HHmmTime(calendar.getTime());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append("00");
        return stringBuffer.toString();
    }

    private String getStartOfPeriodTime(Date date) {
        String string = Time.instance().yyyyMMddTime(date);
        String string2 = Time.instance().HHmmTime(date);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append("00");
        return stringBuffer.toString();
    }

    private void startFileWorkerThread(int n) {
        Thread thread = (Thread)this.fileWorkers.get(new Integer(n));
        if (thread == null) {
            thread = new Thread((Runnable)new FileWorker(n), "Oms_pms_file" + this.rop.inSeconds() + "_seqNo_" + n);
            MessageLog.trace((int)8, this.getClass(), (String)("Starting File Worker Thread: " + thread.getName()));
            this.fileWorkers.put(new Integer(n), thread);
            this.dataQueues.put(new Integer(n), new BlockingQueue());
            thread.start();
        }
    }

    private int translateSeqNo(int n) {
        if (this.rop.equals(GranularityPeriod.MINUTES_5)) {
            return n;
        }
        if (this.rop.equals(GranularityPeriod.MINUTES_15)) {
            if (n == 12 || n <= 2) {
                return 12;
            }
            if (n >= 3 && n <= 5) {
                return 3;
            }
            if (n >= 6 && n <= 8) {
                return 6;
            }
            return 9;
        }
        return 12;
    }

    private void initStopFileWorkerThread(int n) {
        Thread thread = (Thread)this.fileWorkers.get(new Integer(n));
        if (thread != null && thread.isAlive()) {
            BlockingQueue blockingQueue = this.getBlockingQueue(n);
            if (blockingQueue != null) {
                blockingQueue.enqueue((Object)new Integer(1));
            } else {
                MessageLog.traceError(this.getClass(), (String)("Can not find blocking queue for sequence number " + n + ". File can not be finished."));
            }
            this.fileWorkers.remove(new Integer(n));
            MessageLog.trace((int)8, this.getClass(), (String)"Removed thread reference from fileworker map");
            MessageLog.trace((int)8, this.getClass(), (String)("Sending stop request to file worker thread: " + thread.getName()));
        }
    }

    private BlockingQueue getBlockingQueue(int n) {
        return (BlockingQueue)this.dataQueues.get(new Integer(n));
    }

    private class FileWorker
    implements Runnable {
        private int seqNo = 0;
        private String tmpFilePath;
        private String filePath;
        private boolean notGZip = true;
        private Date periodBeginTime;
        private String startOfPeriodTime;
        private String endOfPeriodTime;

        public FileWorker(int n) {
            this.seqNo = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            boolean bl = false;
            if (PerformanceMgmntService.getHighCapacityPMEnabled() == 0) {
                long l4;
                if (!PmStorage.assureDirectory(PmStorage.this.getPath())) {
                    MessageLog.info(this.getClass(), (String)"Unexpected file error: the performance data path does not exist and cannot be created.");
                    PmStorage.this.emptyQueue(this.seqNo);
                    return;
                }
                this.init();
                PrintWriter printWriter = PmStorage.this.getPrintWriter(true, this.notGZip, this.tmpFilePath);
                MessageLog.trace((int)8, this.getClass(), (String)("Starting work for " + this.filePath));
                long l = System.currentTimeMillis();
                long l2 = 0L;
                long l3 = 0L;
                int n = 0;
                if (printWriter == null) return;
                PmStorage.this.printHeader(printWriter, this.startOfPeriodTime);
                if (printWriter.checkError()) {
                    bl = true;
                    MessageLog.traceError(this.getClass(), (String)"Unexpected error in PrintHeader : Data can not be written to file");
                }
                while (!bl) {
                    Object var19_19;
                    try {
                        block18: {
                            try {
                                BlockingQueue blockingQueue = PmStorage.this.getBlockingQueue(this.seqNo);
                                if (blockingQueue != null) {
                                    long l5 = System.currentTimeMillis();
                                    Object object = blockingQueue.dequeue();
                                    ++n;
                                    long l6 = System.currentTimeMillis();
                                    l2 += l6 - l5;
                                    if (object instanceof MeasuredData[]) {
                                        PmStorage.this.printMeasuredData(printWriter, (MeasuredData[])object, this.endOfPeriodTime);
                                        break block18;
                                    }
                                    if (!object.getClass().equals(class$java$lang$Integer == null ? PmStorage.class$("java.lang.Integer") : class$java$lang$Integer)) break block18;
                                    l4 = l6 - l5;
                                    l3 = l2 - l4;
                                    bl = true;
                                    break block18;
                                }
                                MessageLog.traceError(this.getClass(), (String)("Can not find blocking queue for sequence number " + this.seqNo + ".Data will not be written to file."));
                            }
                            catch (Exception exception) {
                                bl = true;
                                MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)exception);
                                var19_19 = null;
                                if (!printWriter.checkError()) continue;
                                bl = true;
                                MessageLog.traceError(this.getClass(), (String)"Unexpected error in PrintWriter : Data can not be written to file");
                                continue;
                            }
                            catch (Error error) {
                                bl = true;
                                MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)error);
                                var19_19 = null;
                                if (!printWriter.checkError()) continue;
                                bl = true;
                                MessageLog.traceError(this.getClass(), (String)"Unexpected error in PrintWriter : Data can not be written to file");
                                continue;
                            }
                        }
                        var19_19 = null;
                        if (!printWriter.checkError()) continue;
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        var19_19 = null;
                        if (!printWriter.checkError()) throw throwable;
                        bl = true;
                        MessageLog.traceError(this.getClass(), (String)"Unexpected error in PrintWriter : Data can not be written to file");
                        throw throwable;
                    }
                    MessageLog.traceError(this.getClass(), (String)"Unexpected error in PrintWriter : Data can not be written to file");
                }
                PmStorage.this.printFooter(printWriter, this.endOfPeriodTime);
                if (printWriter.checkError()) {
                    MessageLog.traceError(this.getClass(), (String)"Unexpected error in PrintFooter : Data can not be written to file");
                }
                printWriter.close();
                PmStorage.this.renameFile(this.tmpFilePath, this.filePath);
                long l7 = System.currentTimeMillis();
                l4 = l7 - l - l2;
                MessageLog.trace((int)8, this.getClass(), (String)("Time (ms) spent waiting for data and stop signal: " + l2));
                MessageLog.trace((int)8, this.getClass(), (String)("Total time waiting for data: " + l3));
                MessageLog.trace((int)8, this.getClass(), (String)("Time (ms) spent on writing rop file: " + l4));
                MessageLog.trace((int)8, this.getClass(), (String)("Data was pushed " + n + " times"));
                MessageLog.trace((int)8, this.getClass(), (String)("Finished work for " + this.filePath));
                return;
            }
            this.periodBeginTime = PmStorage.this.convertToBeginningOfPeriod(Time.instance().getDate()).getTime();
            this.endOfPeriodTime = PmStorage.this.getEndOfPeriodTime(this.periodBeginTime);
            while (!bl) {
                try {
                    BlockingQueue blockingQueue = PmStorage.this.getBlockingQueue(this.seqNo);
                    if (blockingQueue != null) {
                        Object object = blockingQueue.dequeue();
                        if (object instanceof MeasuredData[]) {
                            PmStorage.this.pushMeasuredData((MeasuredData[])object, this.endOfPeriodTime);
                            continue;
                        }
                        if (!object.getClass().equals(class$java$lang$Integer == null ? PmStorage.class$("java.lang.Integer") : class$java$lang$Integer)) continue;
                        bl = true;
                        continue;
                    }
                    MessageLog.traceError(this.getClass(), (String)("Can not find blocking queue for sequence number " + this.seqNo + ".Data will not be written to file."));
                }
                catch (Exception exception) {
                    bl = true;
                    MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)exception);
                }
                catch (Error error) {
                    bl = true;
                    MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)error);
                }
            }
        }

        private void init() {
            this.periodBeginTime = PmStorage.this.convertToBeginningOfPeriod(Time.instance().getDate()).getTime();
            this.filePath = PmStorage.this.getPath() + PmStorage.this.createFileName(this.periodBeginTime);
            DiskCleaner.instance().clean();
            this.startOfPeriodTime = PmStorage.this.getStartOfPeriodTime(this.periodBeginTime);
            this.endOfPeriodTime = PmStorage.this.getEndOfPeriodTime(this.periodBeginTime);
            this.notGZip = Boolean.getBoolean("se.ericsson.cello.PMdataNotCompressed");
            if (!this.notGZip) {
                this.filePath = this.filePath + ".gz";
            }
            this.tmpFilePath = this.filePath + ".tmp";
            File file = new File(this.tmpFilePath);
            if (file.exists() && !file.delete()) {
                MessageLog.info(this.getClass(), (String)("Temporary file with file name " + this.tmpFilePath + " already exists and cannot be deleted"));
            }
        }
    }
}

