/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import se.ericsson.cello.pms.generic.BasicScannerFactory;
import se.ericsson.cello.pms.generic.GranularityAndAttributeActivationException;
import se.ericsson.cello.pms.generic.GranularityPeriodNotSupportedException;
import se.ericsson.cello.pms.generic.InvalidGranularityPeriodException;
import se.ericsson.cello.pms.generic.InvalidObservationClassException;
import se.ericsson.cello.pms.generic.InvalidObservationObjectListException;
import se.ericsson.cello.pms.generic.InvalidPerformanceMonitoringTypeException;
import se.ericsson.cello.pms.generic.MonitoringTaskInfo;
import se.ericsson.cello.pms.generic.MonitoringTaskMgr;
import se.ericsson.cello.pms.generic.NoSuchIdException;
import se.ericsson.cello.pms.generic.NumberOfCountersExceededException;
import se.ericsson.cello.pms.generic.NumberOfMonitorsExceededException;
import se.ericsson.cello.pms.generic.ObjectRepository;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.ParameterNotAcceptedException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringFactory;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.pms.generic.PmLoadControl;
import se.ericsson.cello.pms.generic.PmRecoveryHandler;
import se.ericsson.cello.pms.generic.PmStateListener;
import se.ericsson.cello.pms.generic.PmsPortal;
import se.ericsson.cello.pms.generic.ProcessingErrorException;
import se.ericsson.cello.pms.generic.ScannerId;
import se.ericsson.cello.pms.generic.ScannerRepository;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;

public class PmsPortalImpl {
    private static PmsPortal theInstance = null;

    public static PmsPortal getPortal() {
        return theInstance;
    }

    public static void setPortal(PmsPortal pmsPortal) {
        theInstance = pmsPortal;
    }

    PmsPortalImpl(PmLoadControl pmLoadControl) {
        PmsPortalImpl.setTheInstance(new Servant(pmLoadControl));
    }

    private static void setTheInstance(Servant servant) {
        theInstance = servant;
    }

    private static class Servant
    implements PmsPortal {
        private PmLoadControl pmLoadControl;
        private Boolean isRecoveryDelayed;

        Servant(PmLoadControl pmLoadControl) {
            this.pmLoadControl = pmLoadControl;
            this.isRecoveryDelayed = false;
        }

        public synchronized void registerCounterTypes(String string, String[] stringArray, BasicScannerFactory basicScannerFactory) {
            ObjectRepository.instance().registerCounterTypes(string, stringArray, basicScannerFactory);
        }

        public synchronized void registerCounterTypes(String string, String[] stringArray, int[] nArray, BasicScannerFactory basicScannerFactory) {
            ObjectRepository.instance().registerCounterTypes(string, stringArray, nArray, basicScannerFactory);
        }

        public synchronized void deregisterCounterTypes(String string, BasicScannerFactory basicScannerFactory) {
            ObjectRepository.instance().deregisterObjects(string, basicScannerFactory);
        }

        public synchronized void deregisterCounterTypes(BasicScannerFactory basicScannerFactory) {
            ObjectRepository.instance().deregisterObjects(basicScannerFactory);
        }

        public synchronized boolean registerScanner(Object object, ScannerId scannerId) {
            return ScannerRepository.instance().register(object, scannerId);
        }

        public synchronized void deregisterScanner(ScannerId scannerId) {
            ScannerRepository.instance().deregister(scannerId);
        }

        public void addPmStateListener(PmStateListener pmStateListener) {
            PmRecoveryHandler.instance().addPmStateListener(pmStateListener);
        }

        public void removePmStateListener(PmStateListener pmStateListener) {
            PmRecoveryHandler.instance().removePmStateListener(pmStateListener);
        }

        public PmLoadControl getLoadControl() {
            return this.pmLoadControl;
        }

        public int createPerformanceMonitoring(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray, int n, String string, PerformanceMonitoringState performanceMonitoringState) throws InvalidObservationClassException, InvalidObservationObjectListException, InvalidGranularityPeriodException, NumberOfCountersExceededException, NumberOfMonitorsExceededException, OverloadException, GranularityPeriodNotSupportedException, GranularityAndAttributeActivationException, ParameterNotAcceptedException, ProcessingErrorException {
            return PerformanceMonitoringFactory.instance().createPerformanceMonitoring(observationClassArray, observationObjectArray, n, string, performanceMonitoringState);
        }

        public void deletePerformanceMonitoring(int n) throws NoSuchIdException, ProcessingErrorException, InvalidPerformanceMonitoringTypeException {
            PerformanceMonitoringFactory.instance().deletePerformanceMonitoring(n);
        }

        public MonitoringTaskInfo lookupPerformanceMonitoring(int n) throws NoSuchIdException {
            MonitoringTaskInfo monitoringTaskInfo = null;
            try {
                monitoringTaskInfo = PerformanceMonitoringFactory.instance().lookupPerformanceMonitoring(n);
            }
            catch (ProcessingErrorException processingErrorException) {
                throw new RuntimeException();
            }
            return monitoringTaskInfo;
        }

        public MonitoringTaskInfo[] listPerformanceMonitorings() {
            return PerformanceMonitoringFactory.instance().listPerformanceMonitorings();
        }

        public boolean isSystemSuspended() {
            return MonitoringTaskMgr.instance().isSystemSuspended();
        }

        public void resumePerformanceMonitorings() throws OverloadException, GranularityAndAttributeActivationException, InactiveTransactionException, TransactionRolledBackException {
            MonitoringTaskMgr.instance().setSystemSuspended(false);
        }

        public void suspendPerformanceMonitorings() throws OverloadException, GranularityAndAttributeActivationException, InactiveTransactionException, TransactionRolledBackException {
            MonitoringTaskMgr.instance().setSystemSuspended(true);
        }

        public void setDelayedRecovery(Boolean bl) {
            this.isRecoveryDelayed = bl;
        }

        public Boolean isRecoveryDelayed() {
            return this.isRecoveryDelayed;
        }
    }
}

