/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.Interruptable;
import se.ericsson.cello.pms.generic.MeasuredData;
import se.ericsson.cello.pms.generic.ScannerInterrupter;
import se.ericsson.cello.support.debug.MessageLog;

class ScannerInterrupterImpl
implements ScannerInterrupter {
    private static final int SYNC_WAIT_TIME = 200;
    private static HashMap interrupters = new HashMap();
    private List scanners = new LinkedList();

    static ScannerInterrupter interrupter(GranularityPeriod granularityPeriod) {
        ScannerInterrupter scannerInterrupter = (ScannerInterrupter)interrupters.get(granularityPeriod);
        if (scannerInterrupter == null) {
            scannerInterrupter = new ScannerInterrupterImpl();
            interrupters.put(granularityPeriod, scannerInterrupter);
        }
        return scannerInterrupter;
    }

    public synchronized void add(Interruptable interruptable) {
        if (!this.scanners.contains(interruptable)) {
            this.scanners.add(interruptable);
        }
    }

    public synchronized void remove(Interruptable interruptable) {
        this.scanners.remove(interruptable);
    }

    public synchronized MeasuredData[] getMeasuredData() {
        Vector<MeasuredData> vector = new Vector<MeasuredData>();
        MessageLog.trace((int)8, this.getClass(), (String)("no of scanners to interrupt = " + this.scanners.size()));
        for (int i = 0; i < this.scanners.size(); ++i) {
            Thread.yield();
            MeasuredData[] measuredDataArray = ((Interruptable)this.scanners.get(i)).interrupt();
            if (measuredDataArray == null) continue;
            for (int j = 0; j < measuredDataArray.length; ++j) {
                vector.add(measuredDataArray[j]);
            }
        }
        if (vector.size() > 0) {
            Object[] objectArray = new MeasuredData[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    private ScannerInterrupterImpl() {
    }
}

