/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.recovery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import se.ericsson.cello.moframework.stringhandlers.MoDataStringHandler;
import se.ericsson.cello.moframework.stringhandlers.SequenceStringHandler;
import se.ericsson.cello.moframework.stringhandlers.StructStringHandler;
import se.ericsson.cello.mopersistence.MoAttributeStorage;
import se.ericsson.cello.persistence.DbAccessException;
import se.ericsson.cello.persistence.DbStringWrapper;
import se.ericsson.cello.recovery.MoRecoveryHandler;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;

public class ModataR2ToR3Converter {
    private static final String MODATA_R3 = "modata_r3";
    private static final String SEQUENCE_SEPARATOR = "|";
    private static final String MODATA_SEPARATOR = "^";
    private static final char STRUCT_SEPARATOR = '\u00a4';
    private static final char SEQUENCE = 'q';
    private static final char STRUCT = 't';
    private static final int CREATE_CHUNK_SIZE = 5;
    private String[] data;
    private String[] converted;
    private HashMap attrValueKey;
    private ArrayList attributeNames;
    private int keyCounter = 0;

    public ModataR2ToR3Converter(String[] stringArray) {
        this.data = stringArray;
        this.attrValueKey = new HashMap();
        this.attributeNames = new ArrayList();
    }

    public void prepare() {
        for (int i = 0; i < this.data.length; ++i) {
            String[] stringArray = this.getAttributeNames(this.data[i]);
            for (int j = 0; j < stringArray.length; ++j) {
                if (this.attrValueKey.containsKey(stringArray[j])) continue;
                this.attrValueKey.put(stringArray[j], new Integer(this.keyCounter));
                this.attributeNames.add(stringArray[j]);
                ++this.keyCounter;
            }
        }
    }

    public void convert() {
        this.converted = new String[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            this.converted[i] = this.convert(this.data[i], i);
        }
    }

    public void store() {
        this.createMoAttributeNameTable();
        this.createMoDataR3Table();
    }

    private void createMoDataR3Table() {
        try {
            DbStringWrapper dbStringWrapper = new DbStringWrapper(MODATA_R3);
            for (int i = 0; i < this.converted.length; i += 5) {
                int n = i + 5 > this.converted.length ? this.converted.length - 1 : i + 5 - 1;
                Control control = MoRecoveryHandler.startTransaction();
                for (int j = i; j <= n; ++j) {
                    dbStringWrapper.createRow(control.getCoordinator().getTransactionID(), j, this.converted[j]);
                }
                control.getTerminator().commit();
            }
        }
        catch (DbAccessException dbAccessException) {
            Assert.cppAssert((boolean)false, (String)(ModataR2ToR3Converter.class.getName() + ": " + (Object)((Object)dbAccessException)));
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            Assert.cppAssert((boolean)false, (String)(ModataR2ToR3Converter.class.getName() + ": " + (Object)((Object)transactionRolledBackException)));
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            Assert.cppAssert((boolean)false, (String)(ModataR2ToR3Converter.class.getName() + ": " + (Object)((Object)inactiveTransactionException)));
        }
    }

    private void createMoAttributeNameTable() {
        try {
            MoAttributeStorage moAttributeStorage = MoAttributeStorage.instance();
            Iterator iterator = this.attributeNames.iterator();
            int n = 0;
            Control control = MoRecoveryHandler.startTransaction();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                moAttributeStorage.createRow(control.getCoordinator().getTransactionID(), n, string);
                ++n;
            }
            control.getTerminator().commit();
        }
        catch (DbAccessException dbAccessException) {
            Assert.cppAssert((boolean)false, (String)(ModataR2ToR3Converter.class.getName() + ": " + (Object)((Object)dbAccessException)));
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            Assert.cppAssert((boolean)false, (String)(ModataR2ToR3Converter.class.getName() + ": " + (Object)((Object)transactionRolledBackException)));
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            Assert.cppAssert((boolean)false, (String)(ModataR2ToR3Converter.class.getName() + ": " + (Object)((Object)inactiveTransactionException)));
        }
    }

    String[] getAttributeNames(String string) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        MoDataStringHandler moDataStringHandler = new MoDataStringHandler(string);
        moDataStringHandler.nextSubstring();
        moDataStringHandler.nextSubstring();
        moDataStringHandler.nextSubstring();
        moDataStringHandler.nextSubstring();
        while ((string2 = moDataStringHandler.nextSubstring()) != null && !string2.equalsIgnoreCase("")) {
            int n;
            String[] stringArray;
            arrayList.add(string2);
            String string3 = moDataStringHandler.nextSubstring();
            if (string3.charAt(0) == 't') {
                stringArray = this.getAttributeNamesForStruct(string3);
                for (n = 0; n < stringArray.length; ++n) {
                    arrayList.add(stringArray[n]);
                }
                continue;
            }
            if (string3.charAt(0) != 'q') continue;
            stringArray = this.getAttributeNamesForSequence(string3);
            for (n = 0; n < stringArray.length; ++n) {
                arrayList.add(stringArray[n]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    String[] getAttributeNamesForStruct(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StructStringHandler structStringHandler = new StructStringHandler(string.substring(2));
        int n = Integer.parseInt(structStringHandler.nextSubstring());
        for (int i = 0; i < n; ++i) {
            String string2 = structStringHandler.nextSubstring();
            String string3 = structStringHandler.nextSubstring();
            char c = string3.charAt(0);
            arrayList.add(string2);
            if (c != 'q') continue;
            String[] stringArray = this.getAttributeNamesForSequence(string3);
            for (int j = 0; j < stringArray.length; ++j) {
                arrayList.add(stringArray[j]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    String[] getAttributeNamesForSequence(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SequenceStringHandler sequenceStringHandler = new SequenceStringHandler(string.substring(2));
        int n = Integer.parseInt(sequenceStringHandler.nextSubstring());
        for (int i = 0; i < n; ++i) {
            sequenceStringHandler.nextSubstring();
            String string2 = sequenceStringHandler.nextSubstring();
            char c = string2.charAt(0);
            if (c != 't') continue;
            String[] stringArray = this.getAttributeNamesForStruct(string2);
            for (int j = 0; j < stringArray.length; ++j) {
                arrayList.add(stringArray[j]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    String convert(String string, int n) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        MoDataStringHandler moDataStringHandler = new MoDataStringHandler(string);
        stringBuffer.append(moDataStringHandler.nextSubstring());
        stringBuffer.append(MODATA_SEPARATOR);
        stringBuffer.append(moDataStringHandler.nextSubstring());
        stringBuffer.append(MODATA_SEPARATOR);
        stringBuffer.append(moDataStringHandler.nextSubstring());
        stringBuffer.append(MODATA_SEPARATOR);
        stringBuffer.append(n);
        stringBuffer.append(MODATA_SEPARATOR);
        moDataStringHandler.nextSubstring();
        while ((string2 = moDataStringHandler.nextSubstring()) != null && !string2.equalsIgnoreCase("")) {
            String string3 = moDataStringHandler.nextSubstring();
            char c = string3.charAt(0);
            if (c == 't') {
                string3 = this.convertStructData(string3);
            } else if (c == 'q') {
                string3 = this.convertSequenceData(string3);
            }
            int n2 = (Integer)this.attrValueKey.get(string2);
            stringBuffer.append(n2);
            stringBuffer.append(MODATA_SEPARATOR);
            stringBuffer.append(string3);
            stringBuffer.append(MODATA_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    private String convertSequenceData(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, 2));
        SequenceStringHandler sequenceStringHandler = new SequenceStringHandler(string.substring(2));
        int n = Integer.parseInt(sequenceStringHandler.nextSubstring());
        stringBuffer.append(n);
        stringBuffer.append(SEQUENCE_SEPARATOR);
        for (int i = 0; i < n; ++i) {
            sequenceStringHandler.nextSubstring();
            stringBuffer.append(SEQUENCE_SEPARATOR);
            String string2 = sequenceStringHandler.nextSubstring();
            char c = string2.charAt(0);
            if (c == 't') {
                string2 = this.convertStructData(string2);
            }
            stringBuffer.append(string2);
            stringBuffer.append(SEQUENCE_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    private String convertStructData(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, 3));
        StructStringHandler structStringHandler = new StructStringHandler(string.substring(2));
        int n = Integer.parseInt(structStringHandler.nextSubstring());
        for (int i = 0; i < n; ++i) {
            String string2 = structStringHandler.nextSubstring();
            stringBuffer.append('\u00a4');
            stringBuffer.append((Integer)this.attrValueKey.get(string2));
            stringBuffer.append('\u00a4');
            String string3 = structStringHandler.nextSubstring();
            char c = string3.charAt(0);
            if (c == 'q') {
                string3 = this.convertSequenceData(string3);
            }
            stringBuffer.append(string3);
        }
        stringBuffer.append('\u00a4');
        return stringBuffer.toString();
    }
}

