/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.recovery;

import se.ericsson.cello.faultmanagement.notification.Notification;
import se.ericsson.cello.faultmanagement.notification.OAMRecoveryEvent;
import se.ericsson.cello.support.debug.MessageLog;

public final class ProgressIndicator {
    private int totalMOs;
    private int retrievedMOs;
    private int recoveredMOs;
    private Notification notification;
    private EventTimer timer;
    private static final int EVENT_INTERVAL = 60000;
    private static final String OAM_RECOVERY_EVENTS = "se.ericsson.cello.OAMRecoveryProgressEvents";
    private static final int TRACE_GROUP = 8;
    private static final int PROGRESS_AFTER_INIT = 5;
    private static final int RETRIEVE_PERCENTAGE = 55;
    private static final int RECOVERY_PERCENTAGE = 30;
    private static final int PROGRESS_AFTER_MO_RETRIEVE = 60;
    private static ProgressIndicator theInstance = new ProgressIndicator();

    public static ProgressIndicator instance() {
        return theInstance;
    }

    public void start() {
        if (Boolean.getBoolean(OAM_RECOVERY_EVENTS)) {
            this.notification = new OAMRecoveryEvent();
            this.notification.setAdditionalText(this.getProgress() + "%");
            this.notification.send();
            MessageLog.trace((int)8, this.getClass(), (String)this.notification.getAdditionalText());
            this.timer = new EventTimer(60000);
            Thread thread = new Thread((Runnable)this.timer, "Oms_OAM_Recovery_Notifier");
            thread.start();
        }
    }

    public void stop() {
        if (Boolean.getBoolean(OAM_RECOVERY_EVENTS)) {
            this.notification.setAdditionalText(this.getProgress() + "%");
            this.notification.send();
            MessageLog.trace((int)8, this.getClass(), (String)this.notification.getAdditionalText());
            if (this.timer != null) {
                this.notification = null;
                this.timer.stop();
                this.timer = null;
            }
        }
    }

    public void setTotalMOs(int n) {
        this.totalMOs = n;
    }

    public void incRetrievedMOs() {
        ++this.retrievedMOs;
    }

    public void incRecoveredMOs() {
        ++this.recoveredMOs;
    }

    private ProgressIndicator() {
    }

    private int getProgress() {
        if (this.totalMOs == 0) {
            return 5;
        }
        int n = this.retrievedMOs != this.totalMOs ? 5 + Math.round((float)this.retrievedMOs / (float)this.totalMOs * 55.0f) : 60 + Math.round((float)this.recoveredMOs / (float)this.totalMOs * 30.0f);
        return n;
    }

    private class EventTimer
    implements Runnable {
        private int timeout;
        private boolean terminate;

        EventTimer(int n) {
            this.timeout = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.terminate) {
                try {
                    EventTimer eventTimer = this;
                    synchronized (eventTimer) {
                        try {
                            this.wait(this.timeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (ProgressIndicator.this.notification == null) continue;
                    ProgressIndicator.this.notification.setAdditionalText(ProgressIndicator.this.getProgress() + "%");
                    ProgressIndicator.this.notification.send();
                    MessageLog.trace((int)8, this.getClass(), (String)ProgressIndicator.this.notification.getAdditionalText());
                }
                catch (Exception exception) {
                    MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)exception);
                    this.terminate = true;
                }
                catch (Error error) {
                    MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)error);
                    this.terminate = true;
                }
            }
        }

        synchronized void stop() {
            this.terminate = true;
        }
    }
}

