/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.corba;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import se.ericsson.cello.oms.NodeIpAddressSubscriber;
import se.ericsson.cello.oms.Oms;
import se.ericsson.cello.support.debug.MessageLog;

public class IpAddressHelper {
    private static IpAddressHelper instance = new IpAddressHelper();

    public static IpAddressHelper instance() {
        return instance;
    }

    private IpAddressHelper() {
    }

    public String getIpv4Address() {
        return NodeIpAddressSubscriber.getInstance().getIpv4Address();
    }

    public String getIpv6Address() {
        return NodeIpAddressSubscriber.getInstance().getIpv6Address();
    }

    public static boolean isIPv6(String string) {
        try {
            string = string.substring(0, string.lastIndexOf(":"));
            if (InetAddress.getByName(string) instanceof Inet4Address) {
                return false;
            }
        }
        catch (UnknownHostException unknownHostException) {
            MessageLog.trace((int)5, (Class)Oms.class, (String)("Address: " + string + " is not an known host."));
            return false;
        }
        return true;
    }
}

