/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.servloc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import se.ericsson.cello.support.servloc.ServiceHasNoInterfaceException;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;

class TransactionalServiceMgr
implements ServiceRepository {
    private Map services = new HashMap();

    TransactionalServiceMgr() {
    }

    public synchronized void addService(Object object, Class clazz, Coordinator coordinator) throws ServiceHasNoInterfaceException {
        String string = clazz.getName();
        this.checkService(object, clazz);
        HashSet<Object> hashSet = (HashSet<Object>)this.services.get(string);
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
        }
        hashSet.add(object);
        try {
            if (coordinator != null) {
                coordinator.registerResource((Resource)new RollbackHandler(true, object, clazz));
            }
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            // empty catch block
        }
        this.services.put(string, hashSet);
    }

    public synchronized void removeService(Object object, Class clazz, Coordinator coordinator) {
        String string = clazz.getName();
        this.checkService(object, clazz);
        Set set = (Set)this.services.get(string);
        if (set != null) {
            if (set.contains(object)) {
                set.remove(object);
                try {
                    if (coordinator != null) {
                        coordinator.registerResource((Resource)new RollbackHandler(false, object, clazz));
                    }
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    // empty catch block
                }
            }
            if (set.isEmpty()) {
                this.services.remove(string);
            }
        }
    }

    public synchronized Iterator getServices(Class clazz) {
        HashSet hashSet = new HashSet();
        Set set = (Set)this.services.get(clazz.getName());
        if (set != null) {
            hashSet.addAll(set);
        }
        return hashSet.iterator();
    }

    public Object getService(Class clazz) {
        Iterator iterator = this.getServices(clazz);
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    private void checkService(Object object, Class clazz) {
        if (!clazz.isInstance(object)) {
            throw new ServiceHasNoInterfaceException("Service " + object + " does not implement " + clazz);
        }
    }

    private class RollbackHandler
    implements Resource {
        private boolean isAddService;
        private Object service;
        private Class interfaceClass;

        RollbackHandler(boolean bl, Object object, Class clazz) {
            this.isAddService = bl;
            this.service = object;
            this.interfaceClass = clazz;
        }

        public void commit() {
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
            if (this.isAddService) {
                TransactionalServiceMgr.this.removeService(this.service, this.interfaceClass, null);
            } else {
                TransactionalServiceMgr.this.addService(this.service, this.interfaceClass, null);
            }
        }
    }
}

